/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementSpring;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.utils.VectorAlgebra;

public class ElementSpring
extends Element
implements org.opensourcephysics.display3d.core.ElementSpring {
    private double radius = 0.1;
    private int loops = -1;
    private int pointsPerLoop = -1;
    private int segments = 0;
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] points = null;
    private double[] pixel = new double[3];
    private Object3D[] objects = null;

    public ElementSpring() {
        this.getStyle().setResolution(new Resolution(8, 15, 1));
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.setElementChanged(true);
    }

    public double getRadius() {
        return this.radius;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computePoints();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D _g2, int _index) {
        Color theColor = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[_index].getDistance());
        _g2.setColor(theColor);
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.drawLine(this.aPoints[_index], this.bPoints[_index], this.aPoints[_index + 1], this.bPoints[_index + 1]);
    }

    void drawQuickly(Graphics2D _g2) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computePoints();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.setColor(this.getRealStyle().getLineColor());
        _g2.drawPolyline(this.aPoints, this.bPoints, this.segments + 1);
    }

    void getExtrema(double[] min, double[] max) {
        min[0] = 0.0;
        max[0] = 1.0;
        min[1] = 0.0;
        max[1] = 1.0;
        min[2] = 0.0;
        max[2] = 1.0;
        this.sizeAndToSpaceFrame(min);
        this.sizeAndToSpaceFrame(max);
    }

    void projectPoints() {
        for (int i = 0; i < this.segments; ++i) {
            this.getPanel().project(this.points[i], this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.objects[i].setDistance(this.pixel[2]);
        }
        this.getPanel().project(this.points[this.segments], this.pixel);
        this.aPoints[this.segments] = (int)this.pixel[0];
        this.bPoints[this.segments] = (int)this.pixel[1];
        this.setNeedToProject(false);
    }

    private void computePoints() {
        int theLoops = this.loops;
        int thePPL = this.pointsPerLoop;
        org.opensourcephysics.display3d.core.Resolution res = this.getRealStyle().getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    theLoops = Math.max(res.getN1(), 0);
                    thePPL = Math.max(res.getN2(), 1);
                }
            }
        }
        if (theLoops != this.loops || thePPL != this.pointsPerLoop) {
            this.loops = theLoops;
            this.pointsPerLoop = thePPL;
            this.segments = this.loops * this.pointsPerLoop + 3;
            this.points = new double[this.segments + 1][3];
            this.aPoints = new int[this.segments + 1];
            this.bPoints = new int[this.segments + 1];
            this.objects = new Object3D[this.segments];
            for (int i = 0; i < this.segments; ++i) {
                this.objects[i] = new Object3D(this, i);
            }
        }
        double[] size = new double[]{this.getSizeX(), this.getSizeY(), this.getSizeZ()};
        double[] u1 = VectorAlgebra.normalTo(size);
        double[] u2 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(size, u1));
        double delta = Math.PI * 2 / (double)this.pointsPerLoop;
        int pre = this.pointsPerLoop / 2;
        for (int i = 0; i <= this.segments; ++i) {
            int k = i < pre ? 0 : (i < this.pointsPerLoop ? i - pre : (i > this.segments - pre ? 0 : (i > this.segments - this.pointsPerLoop ? this.segments - i - pre : pre)));
            double angle = (double)i * delta;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            this.points[i][0] = (double)i * this.getSizeX() / (double)this.segments + (double)k * this.radius * (cos * u1[0] + sin * u2[0]) / (double)pre;
            this.points[i][1] = (double)i * this.getSizeY() / (double)this.segments + (double)k * this.radius * (cos * u1[1] + sin * u2[1]) / (double)pre;
            this.points[i][2] = (double)i * this.getSizeZ() / (double)this.segments + (double)k * this.radius * (cos * u1[2] + sin * u2[2]) / (double)pre;
            this.toSpaceFrame(this.points[i]);
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementSpring.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementSpring();
        }
    }
}

