/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.GroupVariable;
import org.opensourcephysics.ejs.control.MethodWithOneParameter;
import org.opensourcephysics.ejs.control.NeedsUpdate;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlDialog;
import org.opensourcephysics.ejs.control.swing.ControlFrame;
import org.opensourcephysics.ejs.control.swing.ControlWindow;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class GroupControl {
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_SET_AND_GET = 1;
    public static final int DEBUG_ELEMENTS = 2;
    public static final int DEBUG_CONTROL = 4;
    public static final int DEBUG_CONTROL_VERBOSE = 8;
    public static final int DEBUG_DRAWING = 16;
    public static final int DEBUG_DRAWING_VERBOSE = 32;
    public static final int DEBUG_SYSTEM = 64;
    public static final int DEBUG_SYSTEM_VERBOSE = 128;
    public static final int DEBUG_ALL = 255;
    private int debugLevel = 0;
    private String debugPrefix = "";
    protected String replaceOwnerName = null;
    private Frame ownerFrame = null;
    protected Frame replaceOwnerFrame = null;
    private Vector prefixList = new Vector();
    private Simulation mySimulation = null;
    private Hashtable targetTable = new Hashtable();
    private Hashtable elementTable = new Hashtable();
    Hashtable variableTable = new Hashtable();
    private Vector elementList = new Vector();
    private Vector updateList = new Vector();
    GroupVariable methodTriggerVariable = null;
    private BooleanValue booleanValue = new BooleanValue(false);
    private IntegerValue integerValue = new IntegerValue(0);
    private DoubleValue doubleValue = new DoubleValue(0.0);
    private StringValue stringValue = new StringValue("");
    private ObjectValue objectValue = new ObjectValue(null);
    static /* synthetic */ Class class$java$lang$Object;

    public GroupControl() {
        this.debugPrefix = this.getClass().getName();
        int index = this.debugPrefix.lastIndexOf(".");
        if (index >= 0) {
            this.debugPrefix = this.debugPrefix.substring(index + 1);
        }
        this.appendPrefixPath("org.opensourcephysics.ejs.control.swing.Control");
        this.appendPrefixPath("org.opensourcephysics.ejs.control.drawables.Control");
        this.appendPrefixPath("org.opensourcephysics.ejs.control.displayejs.Control");
        this.setValue("_expr_", new BooleanValue(false));
        this.methodTriggerVariable = (GroupVariable)this.variableTable.get("_expr_");
    }

    public GroupControl(Object _target) {
        this();
        this.addTarget("_default_", _target);
        if (_target instanceof Simulation) {
            this.setSimulation((Simulation)_target);
        }
    }

    public GroupControl(Object _simulation, String _replaceName, Frame _replaceOwnerFrame) {
        this(_simulation);
        this.replaceOwnerFrame(_replaceName, _replaceOwnerFrame);
    }

    public void setOwnerFrame(Frame _frame) {
        this.ownerFrame = _frame;
    }

    public Frame getOwnerFrame() {
        return this.ownerFrame;
    }

    public void replaceOwnerFrame(String _replaceName, Frame _replaceOwnerFrame) {
        this.replaceOwnerName = _replaceName;
        this.replaceOwnerFrame = _replaceOwnerFrame;
    }

    public String getReplaceOwnerName() {
        return this.replaceOwnerName;
    }

    public Frame getReplaceOwnerFrame() {
        return this.replaceOwnerFrame;
    }

    public void clearPrefixPath() {
        this.prefixList.clear();
    }

    public void appendPrefixPath(String _prefix) {
        this.prefixList.add(_prefix);
    }

    public Vector getDefaultPrefixList() {
        return this.prefixList;
    }

    public void setSimulation(Simulation _sim) {
        this.mySimulation = _sim;
    }

    public Simulation getSimulation() {
        return this.mySimulation;
    }

    public void setDebugLevel(int _level) {
        this.debugLevel = _level;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public Object getTarget(String _name) {
        return this.targetTable.get(_name);
    }

    public void addTarget(String _name, Object _target) {
        this.targetTable.put(_name, _target);
    }

    public void removeTarget(String _name) {
        this.targetTable.remove(_name);
    }

    public void setValue(String _name, Value _value) {
        GroupVariable variable = (GroupVariable)this.variableTable.get(_name);
        if (variable == null) {
            variable = new GroupVariable(_name, _value);
            this.variableTable.put(_name, variable);
        } else {
            variable.setValue(_value);
            variable.propagateValue(null);
        }
    }

    public Value getValue(String _name) {
        GroupVariable variable = (GroupVariable)this.variableTable.get(_name);
        if (variable == null) {
            return null;
        }
        return variable.getValue();
    }

    public GroupVariable registerVariable(String _name, ControlElement _element, int _index, Value _value) {
        if (_name == null) {
            return null;
        }
        GroupVariable variable = (GroupVariable)this.variableTable.get(_name);
        if (variable == null) {
            variable = new GroupVariable(_name, _value);
            this.variableTable.put(_name, variable);
            if ((this.debugLevel & 1) > 0) {
                System.out.print("   Created new variable <" + _name + "> with value = <" + _value + "> ...");
            }
        }
        if ((this.debugLevel & 1) > 0) {
            System.out.println("   Variable <" + _name + "> registered for element <" + _element + ">");
        }
        variable.addElementListener(_element, _index);
        variable.propagateValue(null);
        return variable;
    }

    public boolean isVariableRegistered(String _name) {
        if (_name == null) {
            return false;
        }
        return this.variableTable.get(_name) != null;
    }

    public void variableChanged(GroupVariable _variable, ControlElement _element, Value _value) {
        if (_variable == null) {
            return;
        }
        _variable.setValue(_value);
        _variable.propagateValue(_element);
        _variable.invokeListeners(_element);
    }

    public void addListener(String _name, String _method) {
        this.addListener(_name, _method, null);
    }

    public void addListener(String _name, String _method, Object _anObject) {
        GroupVariable variable;
        Object target;
        if ((this.debugLevel & 1) > 0) {
            System.out.print(this.debugPrefix + ": Adding listener for variable <" + _name + "> to <" + _method + "> ...");
        }
        if (_name == null) {
            return;
        }
        String[] parts = MethodWithOneParameter.splitMethodName(_method);
        if (parts == null) {
            System.err.println(this.getClass().getName() + " : Error! Listener <" + _method + "> not assigned");
            return;
        }
        if (parts[0] == null) {
            parts[0] = "_default_";
        }
        if ((target = this.getTarget(parts[0])) == null) {
            System.err.println(this.getClass().getName() + " : Error! Target <" + parts[0] + "> not assigned");
            return;
        }
        if ((this.debugLevel & 1) > 0) {
            System.out.print(this.debugPrefix + ": Target <" + parts[0] + "> found. Method is <" + _method + "> ...");
        }
        if ((variable = (GroupVariable)this.variableTable.get(_name)) == null) {
            variable = new GroupVariable(_name, this.doubleValue);
            this.variableTable.put(_name, variable);
            if ((this.debugLevel & 1) > 0) {
                System.out.print("   Created new variable <" + _name + "> for listener <" + _method + "> ...");
            }
        }
        if (parts[2] == null) {
            variable.addListener(target, parts[1] + "()", _anObject);
        } else {
            variable.addListener(target, parts[1] + "(" + parts[2] + ")", _anObject);
        }
    }

    public void rename(ControlElement _element, String _name) {
        String oldName = _element.getProperty("name");
        if (oldName != null) {
            this.elementTable.remove(oldName);
        }
        if (_name != null) {
            this.elementTable.put(_name, _element);
        }
    }

    public final ControlElement addNamed(String _type, String _name) {
        String propertyList = "name=" + _name;
        if (this.replaceOwnerName == null || !this.replaceOwnerName.equals(_name)) {
            return this.addObject(null, _type, propertyList);
        }
        if (_type.endsWith("ControlFrame") || _type.endsWith("ControlDrawingFrame")) {
            this.setOwnerFrame(this.replaceOwnerFrame);
            return this.addObject(null, "org.opensourcephysics.ejs.control.swing.ControlPanel", propertyList);
        }
        return this.addObject(null, _type, propertyList);
    }

    public final ControlElement add(String _type) {
        return this.addObject(null, _type, null);
    }

    public final ControlElement add(String _type, String _propertyList) {
        return this.addObject(null, _type, _propertyList);
    }

    public final ControlElement addObject(Object _object, String _type) {
        return this.addObject(_object, _type, null);
    }

    public ControlElement addObject(Object _object, String _type, String _propertyList) {
        ControlElement element = null;
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + " Adding element of type <" + _type + "> with properties <" + _propertyList + ">");
            if (_object != null) {
                System.err.println(this.getClass().getName() + " using element " + _object);
            }
        }
        if (_type.indexOf(".") < 0) {
            Enumeration e = this.prefixList.elements();
            while (e.hasMoreElements() && element == null) {
                element = this.instantiateClass(_object, (String)e.nextElement() + _type, false);
            }
        }
        if (element == null) {
            element = this.instantiateClass(_object, _type, true);
        }
        if (element == null) {
            return null;
        }
        if (element instanceof ControlFrame) {
            this.setOwnerFrame((Frame)((ControlFrame)element).getComponent());
        }
        if (element instanceof ControlDialog && this.ownerFrame != null) {
            ((JDialog)((ControlDialog)element).getComponent()).dispose();
            ((ControlDialog)element).replaceVisual(this.ownerFrame);
        }
        element.setGroup(this);
        this.elementList.add(element);
        if (element instanceof NeedsUpdate) {
            this.updateList.add(element);
        }
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + " Setting properties to <" + _propertyList + ">");
        }
        if (_propertyList != null) {
            element.setProperties(_propertyList);
        }
        if (element instanceof ControlWindow && element.getProperty("visible") == null) {
            element.setProperty("visible", "true");
        }
        return element;
    }

    private ControlElement instantiateClass(Object _object, String _classname, boolean _verbose) {
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + ": Trying to instantiate element of class " + _classname);
            if (_object != null) {
                System.err.println(this.getClass().getName() + " using element " + _object);
            }
        }
        try {
            Class<?> aClass = Class.forName(_classname);
            Class[] c = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = GroupControl.class$("java.lang.Object")) : class$java$lang$Object};
            Object[] o = new Object[]{_object};
            Constructor<?> constructor = aClass.getDeclaredConstructor(c);
            return (ControlElement)constructor.newInstance(o);
        }
        catch (Exception _exc) {
            if (_verbose) {
                _exc.printStackTrace();
                return null;
            }
            try {
                Class<?> aClass = Class.forName(_classname);
                return (ControlElement)aClass.newInstance();
            }
            catch (Exception _exc2) {
                if (_verbose) {
                    _exc2.printStackTrace();
                }
                return null;
            }
        }
    }

    public ControlElement getElement(String _name) {
        if (_name == null) {
            return null;
        }
        ControlElement element = (ControlElement)this.elementTable.get(_name);
        if (element == null) {
            return null;
        }
        return element;
    }

    public ControlElement getControl(String _name) {
        return this.getElement(_name);
    }

    public Component getVisual(String _name) {
        ControlElement element = this.getElement(_name);
        if (element == null) {
            return null;
        }
        return element.getVisual();
    }

    public Component getComponent(String _name) {
        ControlElement element = this.getElement(_name);
        if (element == null) {
            return null;
        }
        return element.getComponent();
    }

    public Container getContainer(String _name) {
        ControlElement element = this.getElement(_name);
        if (element instanceof ControlContainer) {
            return ((ControlContainer)element).getContainer();
        }
        return null;
    }

    public void destroy(String _name) {
        this.destroy(this.getElement(_name), true);
    }

    public void destroy(ControlElement _element) {
        this.destroy(_element, true);
    }

    public void reset() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).reset();
        }
    }

    public void initialize() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).initialize();
        }
    }

    public void update() {
        this.methodTriggerVariable.propagateValue(null);
        Enumeration e = this.updateList.elements();
        while (e.hasMoreElements()) {
            ((NeedsUpdate)e.nextElement()).update();
        }
    }

    public void setActive(boolean _active) {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).setActive(_active);
        }
    }

    public void clearVariables() {
        this.variableTable.clear();
    }

    public void clear() {
        ControlElement element;
        this.variableTable.clear();
        this.setOwnerFrame(null);
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            element = (ControlElement)e.nextElement();
            String parent = element.getProperty("parent");
            if (parent != null) continue;
            this.destroy(element, false);
        }
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + " Warning!: All element were destroyed!");
            System.err.println("  List of remaining elements follows: ");
            e = this.elementList.elements();
            while (e.hasMoreElements()) {
                element = (ControlElement)e.nextElement();
                System.err.println("    " + element.toString() + "(class is " + element.getClass().getName() + ")");
            }
        }
    }

    private void destroy(ControlElement _element, boolean _informMyParent) {
        if (_element == null) {
            return;
        }
        if (_informMyParent) {
            ControlElement parent = this.getElement(_element.getProperty("parent"));
            if (parent != null) {
                if (parent instanceof ControlContainer) {
                    ((ControlContainer)parent).remove(_element);
                }
            } else {
                Container cont = _element.getComponent().getParent();
                if (cont != null) {
                    cont.remove(_element.getComponent());
                    cont.validate();
                    cont.repaint();
                }
            }
        }
        _element.variablePropertiesClear();
        String name = _element.getProperty("name");
        if (name != null) {
            this.elementTable.remove(name);
        }
        this.elementList.remove(_element);
        if (_element instanceof NeedsUpdate) {
            this.updateList.remove(_element);
        }
        if (_element instanceof ControlContainer) {
            Enumeration e = ((ControlContainer)_element).getChildren().elements();
            while (e.hasMoreElements()) {
                ControlElement child = (ControlElement)e.nextElement();
                this.destroy(child, false);
            }
        }
        if (_element instanceof ControlWindow) {
            ((ControlWindow)_element).dispose();
        }
    }

    public Container getTopLevelAncestor(String _name) {
        if (_name != null) {
            ControlElement element = this.getElement(_name);
            Component comp = element.getComponent();
            if (comp instanceof JComponent) {
                return ((JComponent)comp).getTopLevelAncestor();
            }
        } else {
            Enumeration e = this.elementList.elements();
            while (e.hasMoreElements()) {
                ControlElement element = (ControlElement)e.nextElement();
                Component comp = element.getComponent();
                if (!(comp instanceof Window)) continue;
                return (Window)comp;
            }
        }
        return null;
    }

    public void setValue(String _name, boolean _value) {
        this.booleanValue.value = _value;
        this.setValue(_name, this.booleanValue);
    }

    public void setValue(String _name, int _value) {
        this.integerValue.value = _value;
        this.setValue(_name, this.integerValue);
    }

    public void setValue(String _name, double _value) {
        this.doubleValue.value = _value;
        this.setValue(_name, this.doubleValue);
    }

    public void setValue(String _name, String _value) {
        this.stringValue.value = _value;
        this.setValue(_name, this.stringValue);
    }

    public void setValue(String _name, Object _value) {
        if (_value instanceof String) {
            this.setValue(_name, (String)_value);
        } else {
            this.objectValue.value = _value;
            this.setValue(_name, this.objectValue);
        }
    }

    public boolean getBoolean(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return false;
        }
        return value.getBoolean();
    }

    public int getInt(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return 0;
        }
        return value.getInteger();
    }

    public double getDouble(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return 0.0;
        }
        return value.getDouble();
    }

    public String getString(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return "";
        }
        return value.getString();
    }

    public Object getObject(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return null;
        }
        return value.getObject();
    }

    public static XML.ObjectLoader getLoader() {
        return new GroupControlLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class GroupControlLoader
    implements XML.ObjectLoader {
        GroupControlLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            GroupControl groupcontrol = (GroupControl)obj;
            Hashtable table = groupcontrol.variableTable;
            Iterator it = table.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (name.startsWith("_")) continue;
                control.setValue(name, groupcontrol.getString(name));
            }
        }

        public Object createObject(XMLControl control) {
            return new GroupControl(null);
        }

        public Object loadObject(XMLControl control, Object obj) {
            GroupControl groupcontrol = (GroupControl)obj;
            Hashtable table = groupcontrol.variableTable;
            Iterator it = table.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (control.getString(name) != null) {
                    groupcontrol.setValue(name, control.getString(name));
                    continue;
                }
                if (control.getObject(name) == null) continue;
                groupcontrol.setValue(name, control.getObject(name).toString());
            }
            return obj;
        }
    }
}

