/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlBar
extends ControlSwingElement {
    private static final int RESOLUTION = 100000;
    protected JProgressBar bar;
    private double scale;
    private double minimum = 0.0;
    private double maximum = 1.0;
    private double variable = 0.0;
    private DecimalFormat format;
    private static ArrayList infoList = null;

    public ControlBar(Object _visual) {
        super(_visual);
    }

    protected Component createVisual(Object _visual) {
        if (_visual instanceof JProgressBar) {
            this.bar = (JProgressBar)_visual;
        } else {
            this.bar = new JProgressBar(0);
            this.bar.setBorderPainted(true);
            this.bar.setStringPainted(false);
        }
        this.bar.setMinimum(0);
        this.bar.setMaximum(100000);
        this.minimum = 0.0;
        this.maximum = 1.0;
        this.variable = this.bar.getValue();
        this.scale = 100000.0 * (this.maximum - this.minimum);
        this.format = null;
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        return this.bar;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("format");
            infoList.add("orientation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "int|double";
        }
        if (_property.equals("minimum")) {
            return "int|double";
        }
        if (_property.equals("maximum")) {
            return "int|double";
        }
        if (_property.equals("format")) {
            return "Format|Object TRANSLATABLE";
        }
        if (_property.equals("orientation")) {
            return "Orientation|int";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setValue(_value.getDouble());
                break;
            }
            case 1: {
                this.setMinimum(_value.getDouble());
                break;
            }
            case 2: {
                this.setMaximum(_value.getDouble());
                break;
            }
            case 3: {
                DecimalFormat newFormat = _value.getObject() instanceof DecimalFormat ? (DecimalFormat)_value.getObject() : null;
                if (this.format == newFormat) {
                    return;
                }
                this.format = newFormat;
                if (this.format != null) {
                    this.bar.setString(this.format.format(this.variable));
                    this.bar.setStringPainted(true);
                    break;
                }
                this.bar.setStringPainted(false);
                break;
            }
            case 4: {
                if (this.bar.getOrientation() == _value.getInteger()) break;
                this.bar.setOrientation(_value.getInteger());
                break;
            }
            default: {
                super.setValue(_index - 5, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.setMinimum(0.0);
                break;
            }
            case 2: {
                this.setMaximum(1.0);
                break;
            }
            case 3: {
                this.format = null;
                this.bar.setStringPainted(false);
                break;
            }
            case 4: {
                this.bar.setOrientation(0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 5);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(_index - 5);
    }

    private void setValue(double val) {
        if (val == this.variable) {
            return;
        }
        this.variable = val;
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        if (this.format != null) {
            this.bar.setString(this.format.format(this.variable));
        }
    }

    private void setMinimum(double val) {
        if (val == this.minimum) {
            return;
        }
        this.minimum = val;
        if (this.minimum >= this.maximum) {
            this.maximum = this.minimum + 1.0;
        }
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        if (this.format != null) {
            this.bar.setString(this.format.format(this.variable));
        }
    }

    private void setMaximum(double val) {
        if (val == this.maximum) {
            return;
        }
        this.maximum = val;
        if (this.minimum >= this.maximum) {
            this.minimum = this.maximum - 1.0;
        }
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        if (this.format != null) {
            this.bar.setString(this.format.format(this.variable));
        }
    }
}

