/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.opensourcephysics.ejs.control.swing.ControlWindow;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlFrame
extends ControlWindow {
    private static final int NAME = 7;
    protected JFrame frame;
    private static ArrayList infoList = null;

    public ControlFrame(Object _visual) {
        super(_visual);
    }

    protected Component createVisual(Object _visual) {
        this.startingup = true;
        if (_visual instanceof JFrame) {
            this.frame = (JFrame)_visual;
        } else {
            this.frame = new JFrame();
            this.frame.getContentPane().setLayout(new BorderLayout());
        }
        this.frame.setDefaultCloseOperation(1);
        this.internalValue = new BooleanValue(true);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ControlFrame.this.internalValue.value = false;
                ControlFrame.this.variableChanged(11, ControlFrame.this.internalValue);
                if (ControlFrame.this.frame.getDefaultCloseOperation() == 3) {
                    ControlFrame.this.invokeActions();
                }
            }
        });
        return this.frame.getContentPane();
    }

    public Component getComponent() {
        return this.frame;
    }

    public Container getContainer() {
        return this.frame.getContentPane();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("exit");
            infoList.add("onExit");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("resizable")) {
            return "boolean BASIC";
        }
        if (_property.equals("exit")) {
            return "boolean CONSTANT HIDDEN";
        }
        if (_property.equals("onExit")) {
            return "Action CONSTANT HIDDEN";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.frame.setTitle(_value.getString() + " " + ejsWindow);
                    break;
                }
                this.frame.setTitle(_value.getString());
                break;
            }
            case 1: {
                this.frame.setResizable(_value.getBoolean());
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                if (_value.getBoolean()) {
                    this.frame.setDefaultCloseOperation(3);
                    break;
                }
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                this.addAction(0, _value.getString());
                break;
            }
            case 7: {
                super.setValue(3, _value);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                String replacement = this.getGroup().getReplaceOwnerName();
                if (replacement != null && replacement.equals(_value.getString())) {
                    this.getGroup().setOwnerFrame(this.getGroup().getReplaceOwnerFrame());
                    break;
                }
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setValue(_index - 4, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.frame.setTitle(ejsWindow);
                    break;
                }
                this.frame.setTitle("");
                break;
            }
            case 1: {
                this.frame.setResizable(true);
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                break;
            }
            case 7: {
                super.setDefaultValue(3);
                if (this.getGroup() != null && this.getGroup().getOwnerFrame() == this.getComponent()) {
                    this.getGroup().setOwnerFrame(this.frame);
                }
            }
            default: {
                super.setDefaultValue(_index - 4);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(_index - 4);
    }
}

