/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import org.opensourcephysics.ejs.control.swing.ControlCheckBox;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSound
extends ControlCheckBox {
    static final int VARIABLE = 5;
    private AudioClip clip = null;
    private String audioFile = null;
    private boolean playing = false;
    private static ArrayList infoList = null;

    public ControlSound(Object _visual) {
        super(_visual);
        this.checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _e) {
                if (ControlSound.this.checkbox.isSelected()) {
                    ControlSound.this.play();
                } else {
                    ControlSound.this.stop();
                }
            }
        });
    }

    public void setAudioClip(String _codebase, String _audioFile) {
        if (_audioFile == null) {
            this.stop();
            this.clip = null;
            return;
        }
        try {
            String prefix = "";
            if (_codebase == null) {
                prefix = "file:";
            } else {
                prefix = _codebase.toString();
                if (prefix.startsWith("file:")) {
                    prefix = "file:///" + prefix.substring(6);
                }
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
            }
            String filename = prefix + _audioFile;
            URL url = new URL(filename);
            this.clip = Applet.newAudioClip(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.clip = null;
        }
    }

    public void destroy() {
        if (this.clip != null) {
            this.clip.stop();
        }
        this.clip = null;
        super.destroy();
    }

    public void play() {
        if (this.clip == null) {
            return;
        }
        this.clip.loop();
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("audiofile");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("audiofile")) {
            return "File|String";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setAudioFile(_value.getString());
                break;
            }
            case 5: {
                if (_value.getBoolean() != this.playing) {
                    this.playing = _value.getBoolean();
                    if (this.playing) {
                        this.play();
                    } else {
                        this.stop();
                    }
                }
                super.setValue(4, _value);
                break;
            }
            default: {
                super.setValue(_index - 1, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.setAudioClip(null, null);
                this.audioFile = null;
                break;
            }
            default: {
                super.setDefaultValue(_index - 1);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return null;
            }
        }
        return super.getValue(_index - 1);
    }

    private void setAudioFile(String _audio) {
        if (this.audioFile != null && this.audioFile.equals(_audio)) {
            return;
        }
        this.audioFile = _audio;
        if (this.getProperty("_ejs_codebase") != null) {
            this.setAudioClip(this.getProperty("_ejs_codebase"), _audio);
        } else if (this.getSimulation() != null && this.getSimulation().getCodebase() != null) {
            this.setAudioClip(this.getSimulation().getCodebase().toString(), _audio);
        } else {
            this.setAudioClip(null, _audio);
        }
    }
}

