/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.Utils;
import org.opensourcephysics.ejs.control.swing.ConstantParser;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlWindow;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlSwingElement
extends ControlElement {
    public static final int NAME = 0;
    public static final int POSITION = 1;
    public static final int PARENT = 2;
    public static final int ENABLED = 3;
    public static final int VISIBLE = 4;
    public static final int SIZE = 5;
    public static final int FOREGROUND = 6;
    public static final int BACKGROUND = 7;
    public static final int FONT = 8;
    public static final int TOOLTIP = 9;
    public static final int ACTION_PRESS = 10;
    public static final int ACTION_ON = 20;
    public static final int ACTION_OFF = 21;
    private static ArrayList myInfoList = null;
    protected Component myVisual;
    private Color myDefaultBkgd = null;
    private Color myDefaultFrgd = null;
    private Font myDefaultFont = null;
    private Dimension mySize = null;

    public ControlSwingElement(Object _visual) {
        super(_visual);
        this.myVisual = this.createVisual(_visual);
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        if (this.myVisual instanceof JComponent) {
            this.mySize = ((JComponent)this.myVisual).getPreferredSize();
        }
    }

    protected abstract Component createVisual(Object var1);

    public final Component getVisual() {
        return this.myVisual;
    }

    public Component getComponent() {
        return this.myVisual;
    }

    public ArrayList getPropertyList() {
        if (myInfoList == null) {
            myInfoList = new ArrayList();
            myInfoList.add("name");
            myInfoList.add("position");
            myInfoList.add("parent");
            myInfoList.add("enabled");
            myInfoList.add("visible");
            myInfoList.add("size");
            myInfoList.add("foreground");
            myInfoList.add("background");
            myInfoList.add("font");
            myInfoList.add("tooltip");
        }
        return myInfoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("name")) {
            return "String         CONSTANT HIDDEN";
        }
        if (_property.equals("position")) {
            return "Position       CONSTANT PREVIOUS HIDDEN ";
        }
        if (_property.equals("parent")) {
            return "ControlElement CONSTANT HIDDEN";
        }
        if (_property.equals("enabled")) {
            return "boolean          BASIC HIDDEN";
        }
        if (_property.equals("visible")) {
            return "boolean          BASIC HIDDEN";
        }
        if (_property.equals("size")) {
            return "Dimension|Object BASIC";
        }
        if (_property.equals("foreground")) {
            return "Color|Object     BASIC";
        }
        if (_property.equals("background")) {
            return "Color|Object     BASIC";
        }
        if (_property.equals("font")) {
            return "Font|Object      BASIC";
        }
        if (_property.equals("tooltip")) {
            return "String           BASIC TRANSLATABLE";
        }
        return null;
    }

    public Value parseConstant(String _propertyType, String _value) {
        Value constantValue;
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("Alignment") >= 0 && (constantValue = ConstantParser.alignmentConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Dimension") >= 0 && (constantValue = ConstantParser.dimensionConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Layout") >= 0 && (constantValue = ConstantParser.layoutConstant(((ControlContainer)this).getContainer(), _value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Orientation") >= 0 && (constantValue = ConstantParser.orientationConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Placement") >= 0 && (constantValue = ConstantParser.placementConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Point") >= 0 && (constantValue = ConstantParser.pointConstant(_value)) != null) {
            return constantValue;
        }
        return super.parseConstant(_propertyType, _value);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                super.setValue(0, _value);
                this.getComponent().setName(_value.toString());
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null && parent instanceof ControlContainer) {
                    ((ControlContainer)parent).remove(this);
                }
                this.myPropertiesTable.put("position", _value.toString());
                if (parent == null || !(parent instanceof ControlContainer)) break;
                ((ControlContainer)parent).add(this);
                break;
            }
            case 2: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null && parent instanceof ControlContainer) {
                    ((ControlContainer)parent).remove(this);
                }
                if ((parent = this.myGroup.getElement(_value.toString())) == null) {
                    if (this instanceof ControlWindow) break;
                    System.err.println(this.getClass().getName() + " : Error! Parent <" + _value + "> not found for " + this.toString());
                    break;
                }
                if (parent instanceof ControlContainer) {
                    ((ControlContainer)parent).add(this);
                    break;
                }
                System.err.println(this.getClass().getName() + " : Error! Parent <" + _value + "> is not a ControlContainer");
                break;
            }
            case 3: {
                this.getVisual().setEnabled(_value.getBoolean());
                break;
            }
            case 4: {
                this.getVisual().setVisible(_value.getBoolean());
                break;
            }
            case 5: {
                ControlElement parentElement;
                if (!(this.getComponent() instanceof JComponent)) break;
                Dimension size = (Dimension)_value.getObject();
                if (size.width == this.mySize.width && size.height == this.mySize.height) {
                    return;
                }
                this.mySize = size;
                ((JComponent)this.getComponent()).setPreferredSize(this.mySize);
                if (this instanceof ControlContainer) {
                    ((ControlContainer)this).getContainer().validate();
                }
                if ((parentElement = this.myGroup.getElement(this.getProperty("parent"))) == null) break;
                ((ControlContainer)parentElement).adjustSize();
                break;
            }
            case 6: {
                if (!(_value.getObject() instanceof Color)) break;
                this.getVisual().setForeground((Color)_value.getObject());
                break;
            }
            case 7: {
                if (!(_value.getObject() instanceof Color)) break;
                this.getVisual().setBackground((Color)_value.getObject());
                break;
            }
            case 8: {
                if (!(_value.getObject() instanceof Font)) break;
                this.getVisual().setFont((Font)_value.getObject());
                break;
            }
            case 9: {
                if (!(this.getVisual() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(_value.toString());
                break;
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null && parent instanceof ControlContainer) {
                    ((ControlContainer)parent).remove(this);
                }
                this.myPropertiesTable.remove("position");
                if (parent == null || !(parent instanceof ControlContainer)) break;
                ((ControlContainer)parent).add(this);
                break;
            }
            case 2: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent == null || !(parent instanceof ControlContainer)) break;
                ((ControlContainer)parent).remove(this);
                break;
            }
            case 3: {
                this.getVisual().setEnabled(true);
                break;
            }
            case 4: {
                this.getVisual().setVisible(true);
                break;
            }
            case 5: {
                ControlElement parentElement;
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getComponent()).setPreferredSize(null);
                if (this instanceof ControlContainer) {
                    ((ControlContainer)this).getContainer().validate();
                }
                if ((parentElement = this.myGroup.getElement(this.getProperty("parent"))) == null) break;
                ((ControlContainer)parentElement).adjustSize();
                break;
            }
            case 6: {
                this.getVisual().setForeground(this.myDefaultFrgd);
                break;
            }
            case 7: {
                this.getVisual().setBackground(this.myDefaultBkgd);
                break;
            }
            case 8: {
                this.getVisual().setFont(this.myDefaultFont);
                break;
            }
            case 9: {
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(null);
                break;
            }
        }
    }

    public Value getValue(int _index) {
        return null;
    }

    protected ImageIcon getIcon(String _iconFile) {
        ImageIcon icon = this.getProperty("_ejs_codebase") != null ? Utils.icon(this.getProperty("_ejs_codebase"), _iconFile) : (this.getSimulation() != null && this.getSimulation().getCodebase() != null ? Utils.icon(this.getSimulation().getCodebase().toString(), _iconFile) : Utils.icon(null, _iconFile));
        return icon;
    }
}

