/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JTextField;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlTextField
extends ControlSwingElement {
    private static final int VARIABLE = 0;
    private static final int BACKGROUND = 11;
    protected JTextField textfield;
    private StringValue internalValue;
    private boolean defaultValueSet;
    private String defaultValue;
    private Color defaultColor;
    private Color editingColor;
    private Color errorColor;
    private static ArrayList infoList = null;

    public ControlTextField(Object _visual) {
        super(_visual);
    }

    protected Component createVisual(Object _visual) {
        if (_visual instanceof JTextField) {
            this.textfield = (JTextField)_visual;
        } else {
            this.textfield = new JTextField();
            this.textfield.setText("");
        }
        this.defaultValue = this.textfield.getText();
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(String _value) {
        if (this.internalValue.value.equals(_value)) {
            return;
        }
        this.internalValue.value = _value;
        this.textfield.setText(this.internalValue.value);
        this.setColor(this.defaultColor);
    }

    private void setInternalValue(String _value) {
        this.internalValue.value = _value;
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (_property.equals("value")) {
            return "String CONSTANT";
        }
        if (_property.equals("editable")) {
            return "boolean";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setTheValue(_value.getString());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = _value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.textfield.setEditable(_value.getBoolean());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 11: {
                super.setValue(7, _value);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setValue(_index - 4, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 11: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setDefaultValue(_index - 4);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(_index - 4);
    }

    private void setColor(Color aColor) {
        if (this.textfield.isEditable()) {
            this.getVisual().setBackground(aColor);
        }
    }

    private void decideColors(Color aColor) {
        if (aColor == null) {
            return;
        }
        this.defaultColor = aColor;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent _e) {
            this.processKeyEvent(_e, 0);
        }

        public void keyReleased(KeyEvent _e) {
            this.processKeyEvent(_e, 1);
        }

        public void keyTyped(KeyEvent _e) {
            this.processKeyEvent(_e, 2);
        }

        private void processKeyEvent(KeyEvent _e, int _n) {
            if (!ControlTextField.this.textfield.isEditable()) {
                return;
            }
            if (_e.getKeyChar() != '\n') {
                ControlTextField.this.setColor(ControlTextField.this.editingColor);
            }
            if (_e.getKeyCode() == 27) {
                ControlTextField.this.setValue(0, ControlTextField.this.internalValue);
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent _e) {
            ControlTextField.this.setInternalValue(ControlTextField.this.textfield.getText());
            ControlTextField.this.setColor(ControlTextField.this.defaultColor);
        }
    }
}

