/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.StringTokenizer;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.value.ParserSuryono;
import org.opensourcephysics.ejs.control.value.Value;

public class ExpressionValue
extends Value {
    private String expression;
    private GroupControl group;
    private ParserSuryono parser;
    private String[] vars;
    private boolean isArray;
    private ParserSuryono[] arrayParser;
    private String[][] arrayVars;
    private double[] arrayValues;

    public ExpressionValue(String _expression, GroupControl _group) {
        this.group = _group;
        this.expression = new String(_expression.trim());
        this.processExpression();
    }

    public boolean getBoolean() {
        return this.getDouble() != 0.0;
    }

    public int getInteger() {
        return (int)this.getDouble();
    }

    public double getDouble() {
        int n = this.vars.length;
        for (int i = 0; i < n; ++i) {
            this.parser.setVariable(i, this.group.getDouble(this.vars[i]));
        }
        return this.parser.evaluate();
    }

    public String getString() {
        return String.valueOf(this.getDouble());
    }

    public Object getObject() {
        if (this.isArray) {
            int m = this.arrayVars.length;
            for (int k = 0; k < m; ++k) {
                int n = this.arrayVars[k].length;
                for (int i = 0; i < n; ++i) {
                    this.arrayParser[k].setVariable(i, this.group.getDouble(this.arrayVars[k][i]));
                }
                this.arrayValues[k] = this.arrayParser[k].evaluate();
            }
            return this.arrayValues;
        }
        return null;
    }

    public void setExpression(String _expression) {
        this.expression = new String(_expression.trim());
        this.processExpression();
    }

    public void copyValue(Value _source) {
        this.expression = _source instanceof ExpressionValue ? new String(((ExpressionValue)_source).expression) : new String(_source.getString());
        this.processExpression();
    }

    public Value cloneValue() {
        return new ExpressionValue(this.expression, this.group);
    }

    private void processExpression() {
        if (this.expression.startsWith("{") && this.expression.endsWith("}")) {
            String text = this.expression.substring(1, this.expression.length() - 1);
            StringTokenizer tkn = new StringTokenizer(text, ",");
            int dim = tkn.countTokens();
            this.arrayParser = new ParserSuryono[dim];
            this.arrayVars = new String[dim][];
            this.arrayValues = new double[dim];
            this.isArray = true;
            int k = 0;
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken();
                this.arrayVars[k] = ParserSuryono.getVariableList(token);
                this.arrayParser[k] = new ParserSuryono(this.arrayVars[k].length);
                int n = this.arrayVars[k].length;
                for (int i = 0; i < n; ++i) {
                    this.arrayParser[k].defineVariable(i, this.arrayVars[k][i]);
                }
                this.arrayParser[k].define(token);
                this.arrayParser[k].parse();
                ++k;
            }
        } else {
            this.vars = ParserSuryono.getVariableList(this.expression);
            this.parser = new ParserSuryono(this.vars.length);
            int n = this.vars.length;
            for (int i = 0; i < n; ++i) {
                this.parser.defineVariable(i, this.vars[i]);
            }
            this.parser.define(this.expression);
            this.parser.parse();
            this.isArray = false;
        }
    }
}

