/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.display2d.SiteLattice;

public class LatticeFrame
extends DrawingFrame {
    JMenuItem cellItem;
    JMenuItem siteItem;
    protected ByteLattice lattice = new CellLattice(4, 4);
    MouseInputAdapter mouseAdapter;
    int[] editValues = new int[2];
    int dragV;

    public LatticeFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.setTitle(frameTitle);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.lattice);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public void setShowGridLines(boolean showGridLines) {
        this.lattice.setShowGridLines(showGridLines);
    }

    public LatticeFrame(String frameTitle) {
        super(new InteractivePanel());
        this.setTitle(frameTitle);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.lattice);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public void showLegend() {
        this.lattice.showLegend();
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        ButtonGroup menubarGroup = new ButtonGroup();
        this.cellItem = new JRadioButtonMenuItem("Cell Lattice");
        menubarGroup.add(this.cellItem);
        this.cellItem.setSelected(true);
        ActionListener tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LatticeFrame.this.convertToCellLattice();
            }
        };
        this.cellItem.addActionListener(tableListener);
        menu.add(this.cellItem);
        this.siteItem = new JRadioButtonMenuItem("Site Lattice");
        menubarGroup.add(this.siteItem);
        tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LatticeFrame.this.convertToSiteLattice();
            }
        };
        this.siteItem.addActionListener(tableListener);
        menu.add(this.siteItem);
    }

    public void convertToSiteLattice() {
        if (this.lattice instanceof CellLattice) {
            this.drawingPanel.removeDrawable(this.lattice);
            this.lattice = ((CellLattice)this.lattice).createSiteLattice();
            this.drawingPanel.addDrawable(this.lattice);
            this.siteItem.setSelected(true);
            this.drawingPanel.repaint();
        }
    }

    public void convertToCellLattice() {
        if (this.lattice instanceof SiteLattice) {
            this.drawingPanel.removeDrawable(this.lattice);
            this.lattice = ((SiteLattice)this.lattice).createCellLattice();
            this.drawingPanel.addDrawable(this.lattice);
            this.cellItem.setSelected(true);
            this.drawingPanel.repaint();
        }
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.lattice);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.lattice);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.lattice);
        return list;
    }

    public void clearData() {
        this.lattice.setBlock(0, 0, new byte[this.lattice.getNx()][this.lattice.getNy()]);
        this.drawingPanel.invalidateImage();
    }

    public void setAll(byte[][] val) {
        if (this.lattice.getNx() != val.length || this.lattice.getNy() != val[0].length) {
            this.lattice.resizeLattice(val.length, val[0].length);
        }
        this.lattice.setBlock(0, 0, val);
        this.drawingPanel.invalidateImage();
    }

    public void setAll(byte[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(val);
        this.lattice.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void randomize() {
        this.lattice.randomize();
    }

    public void resizeLattice(int nx, int ny) {
        this.lattice.resizeLattice(nx, ny);
    }

    public void setIndexedColor(int index, Color color) {
        this.lattice.setIndexedColor(index, color);
    }

    public void setAtIndex(int i, int v) {
        int Nx = this.lattice.getNx();
        this.setValue(i % Nx, i / Nx, v);
    }

    public void setValue(int ix, int iy, int v) {
        this.lattice.setValue(ix, iy, (byte)v);
    }

    public void setAll(int[] val, int nx, double xmin, double xmax, double ymin, double ymax) {
        if (val.length % nx != 0) {
            throw new IllegalArgumentException("Number of values in lattice (nx*ny) must match number of values.");
        }
        this.resizeLattice(nx, val.length / nx);
        this.setAll(val);
        this.lattice.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setAll(int[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.setAtIndex(i, v[i]);
        }
    }

    public int getAtIndex(int i) {
        int Nx = this.lattice.getNx();
        return this.getValue(i % Nx, i / Nx);
    }

    public int getValue(int ix, int iy) {
        return this.lattice.getValue(ix, iy);
    }

    public int[] getAll() {
        int N = this.lattice.getNx() * this.lattice.getNy();
        int[] ret = new int[N];
        for (int i = 0; i < N; ++i) {
            ret[i] = this.getAtIndex(i);
        }
        return ret;
    }

    public void setToggleOnClick(boolean enable, int v1, int v2) {
        this.editValues = new int[]{v1, v2};
        if (enable) {
            this.drawingPanel.addMouseListener(this.getMouseAdapter());
            this.drawingPanel.addMouseMotionListener(this.getMouseAdapter());
        } else {
            this.drawingPanel.removeMouseListener(this.getMouseAdapter());
            this.drawingPanel.removeMouseMotionListener(this.getMouseAdapter());
        }
    }

    void mouse(MouseEvent e, boolean pressed) {
        double y;
        if (e.getButton() == 3) {
            return;
        }
        double x = this.drawingPanel.pixToX(e.getX());
        int i = this.indexFromPoint(x, y = this.drawingPanel.pixToY(e.getY()));
        if (i == -1) {
            return;
        }
        if (pressed) {
            this.dragV = this.editValues[0];
            int len = this.editValues.length;
            for (int j = 0; j < len; ++j) {
                if (this.getAtIndex(i) != this.editValues[j]) continue;
                this.dragV = this.editValues[(j + 1) % len];
            }
        }
        if (this.getAtIndex(i) != this.dragV) {
            this.setAtIndex(i, this.dragV);
            this.drawingPanel.render();
        }
    }

    public int indexFromPoint(double x, double y) {
        return this.lattice.indexFromPoint(x, y);
    }

    synchronized MouseInputAdapter getMouseAdapter() {
        if (this.mouseAdapter == null) {
            return new MouseInputAdapter(){

                public void mousePressed(MouseEvent e) {
                    LatticeFrame.this.mouse(e, true);
                }

                public void mouseDragged(MouseEvent e) {
                    LatticeFrame.this.mouse(e, false);
                }
            };
        }
        return this.mouseAdapter;
    }
}

