/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.dialogs.LogAxesInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;

public class PlotFrame
extends DrawingFrame {
    protected DatasetManager datasetManager = new DatasetManager();
    protected DataTable dataTable = new DataTable();
    protected DataTableFrame tableFrame;
    static /* synthetic */ Class class$org$opensourcephysics$display$DatasetManager;

    public PlotFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.setTitle(frameTitle);
        this.drawingPanel.addDrawable(this.datasetManager);
        this.datasetManager.setXPointsLinked(true);
        this.dataTable.add(this.datasetManager);
        this.setAnimated(true);
        this.setAutoclear(true);
        this.addMenuItems();
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        JMenuItem scaleItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotFrame.this.scale();
            }
        };
        scaleItem.addActionListener(actionListener);
        menu.add(scaleItem);
        JMenuItem logItem = new JMenuItem(DisplayRes.getString("DrawingFrame.LogAxes_menu_item"));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotFrame.this.logAxes();
            }
        };
        logItem.addActionListener(actionListener);
        menu.add(logItem);
        menu.addSeparator();
        JMenuItem tableItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        tableItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotFrame.this.showDataTable(true);
            }
        };
        tableItem.addActionListener(actionListener);
        menu.add(tableItem);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem item = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            item.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().add(item);
        }
    }

    public void setLogScaleX(boolean log) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScaleX(log);
        }
    }

    public void setLogScaleY(boolean log) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScaleY(log);
        }
    }

    protected void scale() {
        ScaleInspector plotInspector = new ScaleInspector(this.drawingPanel);
        plotInspector.setLocationRelativeTo(this.drawingPanel);
        plotInspector.updateDisplay();
        ((Component)plotInspector).setVisible(true);
    }

    protected void logAxes() {
        if (!(this.drawingPanel instanceof PlottingPanel)) {
            return;
        }
        LogAxesInspector logAxesInspector = new LogAxesInspector((PlottingPanel)this.drawingPanel);
        logAxesInspector.setLocationRelativeTo(this.drawingPanel);
        logAxesInspector.updateDisplay();
        ((Component)logAxesInspector).setVisible(true);
    }

    public void append(int datasetIndex, double x, double y) {
        this.datasetManager.append(datasetIndex, x, y);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(int datasetIndex, double x, double y, double delx, double dely) {
        this.datasetManager.append(datasetIndex, x, y, delx, dely);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(int datasetIndex, double[] xpoints, double[] ypoints) {
        this.datasetManager.append(datasetIndex, xpoints, ypoints);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(int datasetIndex, double[] xpoints, double[] ypoints, double[] delx, double[] dely) {
        this.datasetManager.append(datasetIndex, xpoints, ypoints, delx, dely);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void setConnected(boolean connected) {
        this.datasetManager.setConnected(connected);
    }

    public void setCustomMarker(int datasetIndex, Shape marker) {
        this.datasetManager.setCustomMarker(datasetIndex, marker);
    }

    public void setMarkerShape(int datasetIndex, int markerShape) {
        this.datasetManager.setMarkerShape(datasetIndex, markerShape);
    }

    public void setMarkerSize(int datasetIndex, int markerSize) {
        this.datasetManager.setMarkerSize(datasetIndex, markerSize);
    }

    public void setMarkerColor(int datasetIndex, Color color) {
        this.datasetManager.setMarkerColor(datasetIndex, color);
    }

    public void setLineColor(int datasetIndex, Color color) {
        this.datasetManager.setLineColor(datasetIndex, color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.drawingPanel != null) {
            this.drawingPanel.setBackground(color);
        }
    }

    public void setMarkerColor(int datasetIndex, Color fillColor, Color edgeColor) {
        this.datasetManager.setMarkerColor(datasetIndex, fillColor, edgeColor);
    }

    public void setConnected(int datasetIndex, boolean connected) {
        this.datasetManager.setConnected(datasetIndex, connected);
    }

    public void setXPointsLinked(boolean linked) {
        this.datasetManager.setXPointsLinked(linked);
    }

    public void setXYColumnNames(int datasetIndex, String xColumnName, String yColumnName, String datasetName) {
        this.datasetManager.setXYColumnNames(datasetIndex, xColumnName, yColumnName, datasetName);
    }

    public void setXYColumnNames(int datasetIndex, String xColumnName, String yColumnName) {
        this.datasetManager.setXYColumnNames(datasetIndex, xColumnName, yColumnName);
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.dataTable.setMaximumFractionDigits(maximumFractionDigits);
    }

    public void setMaximumFractionDigits(String columnName, int maximumFractionDigits) {
        this.dataTable.setMaximumFractionDigits(columnName, maximumFractionDigits);
    }

    public void setRowNumberVisible(boolean vis) {
        this.dataTable.setRowNumberVisible(vis);
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.datasetManager);
    }

    public Dataset getDataset(int index) {
        return this.datasetManager.getDataset(index);
    }

    public DatasetManager getDatasetManager() {
        return this.datasetManager;
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.datasetManager);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.datasetManager);
        return list;
    }

    public void clearData() {
        this.datasetManager.clear();
        this.dataTable.refreshTable();
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(this.getTitle() + " Data", this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new PlotFrameLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class PlotFrameLoader
    extends DrawingFrame.DrawingFrameLoader {
        protected PlotFrameLoader() {
        }

        public Object createObject(XMLControl control) {
            PlotFrame frame = new PlotFrame("x", "y", "Plot Frame");
            return frame;
        }

        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            PlotFrame frame = (PlotFrame)obj;
            ArrayList list = frame.getObjectOfClass(class$org$opensourcephysics$display$DatasetManager == null ? (class$org$opensourcephysics$display$DatasetManager = PlotFrame.class$("org.opensourcephysics.display.DatasetManager")) : class$org$opensourcephysics$display$DatasetManager);
            if (list.size() > 0) {
                frame.datasetManager = (DatasetManager)list.get(0);
                frame.dataTable.clear();
                frame.dataTable.add(frame.datasetManager);
            }
            return obj;
        }
    }
}

