/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Polynomial;

public class Chebyshev {
    static final ArrayList chebyshevTList = new ArrayList();
    static final ArrayList chebyshevUList = new ArrayList();

    private Chebyshev() {
    }

    public static synchronized Polynomial getPolynomialT(int n) {
        if (n < chebyshevTList.size()) {
            return (Polynomial)chebyshevTList.get(n);
        }
        Polynomial part1 = new Polynomial(new double[]{0.0, 2.0});
        Polynomial p = part1.multiply(Chebyshev.getPolynomialT(n - 1)).subtract(Chebyshev.getPolynomialT(n - 2));
        chebyshevTList.add(p);
        return p;
    }

    public static synchronized Polynomial getPolynomialU(int n) {
        if (n < chebyshevUList.size()) {
            return (Polynomial)chebyshevUList.get(n);
        }
        Polynomial part1 = new Polynomial(new double[]{0.0, 2.0});
        Polynomial p = part1.multiply(Chebyshev.getPolynomialU(n - 1)).subtract(Chebyshev.getPolynomialU(n - 2));
        chebyshevUList.add(p);
        return p;
    }

    static {
        Polynomial p = new Polynomial(new double[]{1.0});
        chebyshevTList.add(p);
        chebyshevUList.add(p);
        p = new Polynomial(new double[]{0.0, 1.0});
        chebyshevTList.add(p);
        p = new Polynomial(new double[]{0.0, 2.0});
        chebyshevUList.add(p);
    }
}

