/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODESolverException;

public class DormandPrince45
implements ODEAdaptiveSolver {
    int error_code = 0;
    static final double[][] a = new double[][]{{0.2}, {0.075, 0.225}, {0.3, -0.9, 1.2}, {0.3100137174211248, -0.9259259259259259, 1.2071330589849107, 0.07544581618655692}, {-0.6703703703703704, 2.5, -0.8956228956228957, -3.3703703703703702, 3.4363636363636365}};
    static final double[] b5 = new double[]{0.08796296296296297, 0.0, 0.481000481000481, -0.5787037037037037, 0.9204545454545454, 0.08928571428571429};
    static final double[] er = new double[]{-0.030555555555555555, 0.0, 0.15873015873015872, -0.7638888888888888, 0.675, -0.039285714285714285};
    static final int numStages = 6;
    private volatile double stepSize = 0.01;
    private int numEqn = 0;
    private double[] temp_state;
    private double[][] k;
    private double truncErr;
    private ODE ode;
    protected double tol = 1.0E-6;
    protected boolean enableExceptions = false;

    public DormandPrince45(ODE _ode) {
        this.ode = _ode;
        this.initialize(this.stepSize);
    }

    public void initialize(double _stepSize) {
        this.stepSize = _stepSize;
        double[] state = this.ode.getState();
        if (state == null) {
            return;
        }
        if (this.numEqn != state.length) {
            this.numEqn = state.length;
            this.temp_state = new double[this.numEqn];
            this.k = new double[6][this.numEqn];
        }
    }

    public double step() {
        int s;
        this.error_code = 0;
        int iterations = 10;
        double currentStep = this.stepSize;
        double error = 0.0;
        double[] state = this.ode.getState();
        this.ode.getRate(state, this.k[0]);
        do {
            double fac;
            --iterations;
            currentStep = this.stepSize;
            for (int s2 = 1; s2 < 6; ++s2) {
                for (int i = 0; i < this.numEqn; ++i) {
                    this.temp_state[i] = state[i];
                    for (int j = 0; j < s2; ++j) {
                        this.temp_state[i] = this.temp_state[i] + this.stepSize * a[s2 - 1][j] * this.k[j][i];
                    }
                }
                this.ode.getRate(this.temp_state, this.k[s2]);
            }
            error = 0.0;
            for (int i = 0; i < this.numEqn; ++i) {
                this.truncErr = 0.0;
                for (s = 0; s < 6; ++s) {
                    this.truncErr += this.stepSize * er[s] * this.k[s][i];
                }
                error = Math.max(error, Math.abs(this.truncErr));
            }
            if (error <= (double)1.4E-45f) {
                error = this.tol / 100000.0;
            }
            if (error > this.tol) {
                double fac2 = 0.9 * Math.pow(error / this.tol, -0.25);
                this.stepSize *= Math.max(fac2, 0.1);
                continue;
            }
            if (!(error < this.tol / 10.0) || !((fac = 0.9 * Math.pow(error / this.tol, -0.2)) > 1.0)) continue;
            this.stepSize *= Math.min(fac, 10.0);
        } while (error > this.tol && iterations > 0);
        for (int i = 0; i < this.numEqn; ++i) {
            for (s = 0; s < 6; ++s) {
                int n = i;
                state[n] = state[n] + currentStep * b5[s] * this.k[s][i];
            }
        }
        if (iterations == 0) {
            this.error_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException("DormanPrince45 ODE solver did not converge.");
            }
        }
        return currentStep;
    }

    public void enableRuntimeExpecptions(boolean enable) {
        this.enableExceptions = enable;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setTolerance(double _tol) {
        this.tol = Math.abs(_tol);
    }

    public double getTolerance() {
        return this.tol;
    }

    public int getErrorCode() {
        return this.error_code;
    }
}

