/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class EulerRichardson
extends AbstractODESolver {
    private double[] rate;
    private double[] midstate;

    public EulerRichardson(ODE ode) {
        super(ode);
    }

    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate = new double[this.numEqn];
        this.midstate = new double[this.numEqn];
    }

    public double step() {
        int i;
        double[] state = this.ode.getState();
        this.ode.getRate(state, this.rate);
        double dt2 = this.stepSize / 2.0;
        for (i = 0; i < this.numEqn; ++i) {
            this.midstate[i] = state[i] + this.rate[i] * dt2;
        }
        this.ode.getRate(this.midstate, this.rate);
        for (i = 0; i < this.numEqn; ++i) {
            state[i] = state[i] + this.stepSize * this.rate[i];
        }
        return this.stepSize;
    }
}

