/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.FFT;

public class FFT2D {
    static final double PI2 = Math.PI * 2;
    int nrows;
    int ncols;
    FFT rowFFT;
    FFT colFFT;
    double[] acol;
    double[] ccol;

    public FFT2D(int nrows, int ncols) {
        if (nrows <= 0 || ncols <= 0) {
            throw new IllegalArgumentException("The array dimensions >=0 : " + nrows + "," + ncols);
        }
        this.nrows = nrows;
        this.ncols = ncols;
        this.acol = new double[2 * nrows];
        if (nrows % 2 == 1) {
            this.ccol = new double[2 * nrows];
        }
        this.rowFFT = new FFT(ncols);
        this.colFFT = nrows == ncols ? this.rowFFT : new FFT(nrows);
    }

    protected void checkData(double[] data, int rowspan) {
        if (rowspan < 2 * this.ncols) {
            throw new IllegalArgumentException("The row span " + rowspan + "is shorter than the row length " + 2 * this.ncols);
        }
        if (this.nrows * rowspan > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + rowspan + " data.length=" + data.length);
        }
    }

    public void transform(double[] data) {
        this.transform_internal(data, 2 * this.ncols);
    }

    void transform_internal(double[] data, int rowspan) {
        this.checkData(data, rowspan);
        for (int i = 0; i < this.nrows; ++i) {
            this.rowFFT.transform_internal(data, i * rowspan, 2, -1);
        }
        for (int j = 0; j < this.ncols; ++j) {
            this.colFFT.transform_internal(data, 2 * j, rowspan, -1);
        }
    }

    public void backtransform(double[] data) {
        this.backtransform_internal(data, 2 * this.ncols);
    }

    void backtransform_internal(double[] data, int rowspan) {
        this.checkData(data, rowspan);
        for (int j = 0; j < this.ncols; ++j) {
            this.colFFT.transform_internal(data, 2 * j, rowspan, 1);
        }
        for (int i = 0; i < this.nrows; ++i) {
            this.rowFFT.transform_internal(data, i * rowspan, 2, 1);
        }
    }

    public void inverse(double[] data) {
        this.inverse_internal(data, 2 * this.ncols);
    }

    void inverse_internal(double[] data, int rowspan) {
        this.backtransform_internal(data, rowspan);
        double norm = 1.0 / ((double)this.nrows * (double)this.ncols);
        int i = 0;
        while (i < this.nrows) {
            int n = i++;
            data[n] = data[n] * norm;
        }
    }

    double[] getNaturalFreq(double delta, int n) {
        double[] freq = new double[n];
        double f = -0.5 / delta;
        double df = -2.0 * f / (double)(n - n % 2);
        for (int i = 0; i < n; ++i) {
            freq[i] = f;
            f += df;
        }
        return freq;
    }

    public double getFreqMin(double min, double max, int n) {
        return (double)(-(n / 2)) / (max - min);
    }

    public double getFreqMax(double min, double max, int n) {
        return (double)((n + 1) / 2 - 1) / (max - min);
    }

    public double[] getNaturalModes(int n) {
        double[] bins = new double[n];
        double w = -(n - n % 2) / 2;
        for (int i = 0; i < n; ++i) {
            bins[i] = w;
            w += 1.0;
        }
        return bins;
    }

    public double[] getWrappedModes(int n) {
        double[] bins = new double[n];
        for (int i = 0; i < n; ++i) {
            bins[i] = i < (n + 1) / 2 ? (double)i : (double)(i - n);
        }
        return bins;
    }

    public double[] getWrappedOmegaX(double xmin, double xmax) {
        return this.getWrappedFreq((xmax - xmin) / (double)(this.nrows - this.nrows % 2) / (Math.PI * 2), this.nrows);
    }

    public double[] getWrappedOmegaY(double ymin, double ymax) {
        return this.getWrappedFreq((ymax - ymin) / (double)(this.ncols - this.ncols % 2) / (Math.PI * 2), this.ncols);
    }

    public double[] getWrappedFreq(double delta, int n) {
        double[] freq = new double[n];
        double f = -0.5 / delta;
        double df = -2.0 * f / (double)(n - n % 2);
        for (int i = 0; i < n; ++i) {
            freq[i] = i < (n + 1) / 2 ? (double)i * df : (double)(i - n) * df;
        }
        return freq;
    }

    public double[] getNaturalFreqX(double delta) {
        return this.getNaturalFreq(delta, this.nrows);
    }

    public double[] getNaturalFreqX(double xmin, double xmax) {
        return this.getNaturalFreq((xmax - xmin) / (double)(this.nrows - this.nrows % 2), this.nrows);
    }

    public double[] getNaturalOmegaX(double delta) {
        return this.getNaturalFreq(delta / (Math.PI * 2), this.nrows);
    }

    public double[] getNaturalOmegaX(double xmin, double xmax) {
        return this.getNaturalFreq((xmax - xmin) / (double)(this.nrows - this.nrows % 2) / (Math.PI * 2), this.nrows);
    }

    public double[] getNaturalFreqY(double delta) {
        return this.getNaturalFreq(delta, this.ncols);
    }

    public double[] getNaturalFreqY(double ymin, double ymax) {
        return this.getNaturalFreq((ymax - ymin) / (double)(this.ncols - this.ncols % 2), this.ncols);
    }

    public double[] getNaturalOmegaY(double delta) {
        return this.getNaturalFreq(delta / (Math.PI * 2), this.ncols);
    }

    public double[] getNaturalOmegaY(double ymin, double ymax) {
        return this.getNaturalFreq((ymax - ymin) / (double)(this.ncols - this.ncols % 2) / (Math.PI * 2), this.ncols);
    }

    public void toNaturalOrder(double[] data) {
        int i;
        if (this.ccol != null) {
            System.arraycopy(data, this.ncols / 2 * this.acol.length, this.ccol, 0, this.ccol.length);
        }
        for (i = 0; i < this.ncols / 2; ++i) {
            int offset = i * this.acol.length;
            System.arraycopy(data, offset, this.acol, 0, this.acol.length);
            System.arraycopy(data, (this.ncols / 2 + i + this.ncols % 2) * this.acol.length, data, offset, this.acol.length);
            System.arraycopy(this.acol, 0, data, (this.ncols / 2 + i) * this.acol.length, this.acol.length);
        }
        if (this.ccol != null) {
            System.arraycopy(this.ccol, 0, data, data.length - this.ccol.length, this.ccol.length);
        }
        for (i = 0; i < this.ncols; ++i) {
            int n = this.acol.length / 2;
            int offset = i * this.acol.length;
            System.arraycopy(data, offset, this.acol, 0, this.acol.length);
            System.arraycopy(this.acol, n + n % 2, data, offset, n - n % 2);
            System.arraycopy(this.acol, 0, data, offset + n - n % 2, n + n % 2);
        }
        double norm = 1.0 / ((double)this.nrows * (double)this.ncols);
        int i2 = 0;
        int n = data.length;
        while (i2 < n) {
            int n2 = i2++;
            data[n2] = data[n2] * norm;
        }
    }
}

