/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Heun3
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private double[] rate3;
    private double[] estimated_state;

    public Heun3(ODE ode) {
        super(ode);
    }

    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rate3 = new double[this.numEqn];
        this.estimated_state = new double[this.numEqn];
    }

    public double step() {
        int i;
        double[] state = this.ode.getState();
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(state, this.rate1);
        for (i = 0; i < this.numEqn; ++i) {
            this.estimated_state[i] = state[i] + this.stepSize * this.rate1[i] / 3.0;
        }
        this.ode.getRate(this.estimated_state, this.rate2);
        for (i = 0; i < this.numEqn; ++i) {
            this.estimated_state[i] = state[i] + 2.0 * this.stepSize * this.rate2[i] / 3.0;
        }
        this.ode.getRate(this.estimated_state, this.rate3);
        for (i = 0; i < this.numEqn; ++i) {
            state[i] = state[i] + this.stepSize * (this.rate1[i] + 3.0 * this.rate3[i]) / 4.0;
        }
        return this.stepSize;
    }
}

