/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class IntegerArray {
    public static int NumberFormatError = 1;
    public static int ArrayIndexOutOfBoundsError = 2;
    protected int[] array;
    protected String defaultString;
    protected int[] defaultArray;
    protected int errorcode = 0;

    public IntegerArray(int n) {
        this.array = new int[n];
        this.defaultArray = this.array;
    }

    public IntegerArray(int[] array) {
        this.defaultArray = (int[])array.clone();
        this.array = this.defaultArray;
    }

    public IntegerArray(String str) throws NumberFormatException {
        this.array = this.toInteger(str);
        this.defaultString = str;
        this.defaultArray = this.array;
    }

    public String getDefault() {
        return this.defaultString;
    }

    public String toString() {
        if (this.errorcode > 0) {
            return this.defaultString;
        }
        String str = "{";
        int n = this.array.length;
        for (int i = 0; i < n; ++i) {
            str = str + Integer.toString(this.array[i]);
            if (i >= n - 1) continue;
            str = str + ", ";
        }
        str = str + "}";
        return str;
    }

    public int getError() {
        return this.errorcode;
    }

    public int[] getArray(String str) {
        this.set(str);
        return this.array;
    }

    public int[] getArray() {
        return this.array;
    }

    public boolean set(String str) {
        this.errorcode = 0;
        try {
            this.array = this.toInteger(str);
        }
        catch (NumberFormatException ex) {
            this.errorcode = NumberFormatError;
            this.array = this.toInteger(this.defaultString);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            this.array = this.toInteger(this.defaultString);
            return false;
        }
        return true;
    }

    public void setDefaultArray(int[] array) {
        this.defaultArray = (int[])array.clone();
        this.array = this.defaultArray;
    }

    protected int[] toInteger(String str) throws ArrayIndexOutOfBoundsException {
        int[] array = null;
        int start = str.indexOf("{") + 1;
        int end = str.indexOf("}");
        if (end - start <= 0) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            return this.defaultArray;
        }
        String[] s = str.substring(start, end).split(",");
        if (this.array != null && this.array.length != s.length) {
            throw new ArrayIndexOutOfBoundsException("Array length cannot be changed in DoubleArray. " + str);
        }
        array = new int[s.length];
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            try {
                array[i] = Integer.parseInt(s[i].trim());
                continue;
            }
            catch (NumberFormatException ex) {
                array[i] = 0;
                this.errorcode = NumberFormatError;
            }
        }
        return array;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            IntegerArray array = (IntegerArray)obj;
            control.setValue("data", array.getArray());
        }

        public Object createObject(XMLControl control) {
            return new IntegerArray((int[])control.getObject("data"));
        }

        public Object loadObject(XMLControl control, Object obj) {
            IntegerArray dataArray = (IntegerArray)obj;
            int[] data = (int[])control.getObject("data");
            dataArray.array = data;
            dataArray.defaultArray = data;
            return obj;
        }
    }
}

