/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Derivative;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.NumericMethodException;
import org.opensourcephysics.numerics.Util;

public class Root {
    static final int MAX_ITERATIONS = 15;

    private Root() {
    }

    public static double[] quadraticReal(double a, double b, double c) {
        double[] roots = new double[2];
        double q = -0.5 * (b + (b < 0.0 ? -1.0 : 1.0) * Math.sqrt(b * b - 4.0 * a * c));
        roots[0] = q / a;
        roots[1] = c / q;
        return roots;
    }

    public static double[][] quadratic(double a, double b, double c) {
        double[][] roots = new double[2][2];
        double disc = b * b - 4.0 * a * c;
        if (disc < 0.0) {
            double d = -b / 2.0 / a;
            roots[0][0] = d;
            roots[1][0] = d;
            double[] dArray = roots[1];
            double d2 = Math.sqrt(-disc) / 2.0 / a;
            roots[0][1] = d2;
            dArray[1] = dArray[1] - d2;
            return roots;
        }
        double q = -0.5 * (b + (b < 0.0 ? -1.0 : 1.0) * Math.sqrt(disc));
        roots[0][0] = q / a;
        roots[1][0] = c / q;
        return roots;
    }

    public static double[][] cubic(double a, double b, double c, double d) {
        double[][] roots = new double[3][2];
        double B = c / a;
        double A = b / a;
        double A2 = A * A;
        double Q = (3.0 * B - A2) / 9.0;
        double C = d / a;
        double R = (9.0 * A * B - 27.0 * C - 2.0 * A * A2) / 54.0;
        double D = Q * Q * Q + R * R;
        if (D == 0.0) {
            double S = R < 0.0 ? -Math.pow(-R, 0.3333333333333333) : Math.pow(R, 0.3333333333333333);
            roots[0][0] = -A / 3.0 + 2.0 * S;
            double d2 = -A / 3.0 - S;
            roots[1][0] = d2;
            roots[2][0] = d2;
        } else if (D > 0.0) {
            double S = R + (D = Math.sqrt(D)) < 0.0 ? -Math.pow(-R - D, 0.3333333333333333) : Math.pow(R + D, 0.3333333333333333);
            double T = R - D < 0.0 ? -Math.pow(-R + D, 0.3333333333333333) : Math.pow(R - D, 0.3333333333333333);
            roots[0][0] = -A / 3.0 + S + T;
            double d3 = -A / 3.0 - (S + T) / 2.0;
            roots[1][0] = d3;
            roots[2][0] = d3;
            double[] dArray = roots[2];
            double d4 = Math.sqrt(3.0) * (S - T) / 2.0;
            roots[1][1] = d4;
            dArray[1] = dArray[1] - d4;
        } else {
            Q = -Q;
            double theta = Math.acos(R / Math.sqrt(Q * Q * Q)) / 3.0;
            Q = 2.0 * Math.sqrt(Q);
            roots[0][0] = Q * Math.cos(theta) - (A /= 3.0);
            roots[1][0] = Q * Math.cos(theta + 2.0943951023931953) - A;
            roots[2][0] = Q * Math.cos(theta + 4.1887902047863905) - A;
        }
        return roots;
    }

    public static double newton(Function f, double x, double tol) {
        for (int count = 0; count < 15; ++count) {
            double xold = x;
            double df = 0.0;
            try {
                df = Derivative.romberg(f, x, Math.max(0.001, 0.001 * Math.abs(x)), tol / 10.0);
            }
            catch (NumericMethodException ex) {
                return Double.NaN;
            }
            x -= f.evaluate(x) / df;
            if (!(Util.relativePrecision(Math.abs(x - xold), x) < tol)) continue;
            return x;
        }
        return Double.NaN;
    }

    public static double newton(Function f, Function df, double x, double tol) {
        for (int count = 0; count < 15; ++count) {
            double xold = x;
            if (!(Util.relativePrecision(Math.abs((x -= f.evaluate(x) / df.evaluate(x)) - xold), x) < tol)) continue;
            return x;
        }
        return Double.NaN;
    }

    public static double bisection(Function f, double x1, double x2, double tol) {
        double y2;
        int maxCount = (int)(Math.log(Math.abs(x2 - x1) / tol) / Math.log(2.0));
        maxCount = Math.max(15, maxCount) + 2;
        double y1 = f.evaluate(x1);
        if (y1 * (y2 = f.evaluate(x2)) > 0.0) {
            return Double.NaN;
        }
        for (int count = 0; count < maxCount; ++count) {
            double x = (x1 + x2) / 2.0;
            double y = f.evaluate(x);
            if (Util.relativePrecision(Math.abs(x1 - x2), x) < tol) {
                return x;
            }
            if (y * y1 > 0.0) {
                x1 = x;
                y1 = y;
                continue;
            }
            x2 = x;
            y2 = y;
        }
        return Double.NaN;
    }
}

