/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.JOptionPane;

public class Diagnostics {
    static final String NEWLINE = System.getProperty("line.separator", "\n");

    public static void aboutJava() {
        String version = System.getProperty("java.vm.version", "unknown version");
        String vendor = System.getProperty("java.vendor");
        String aboutString = "Java version " + version + NEWLINE + vendor;
        JOptionPane.showMessageDialog(null, aboutString, "About Java", 1);
    }

    public static void aboutQTJava() {
        String extdir = System.getProperty("java.ext.dirs");
        String slash = System.getProperty("file.separator", "/");
        File extfile = new File(extdir + slash + "QTJava.zip");
        if (extfile.exists()) {
            boolean failed = false;
            try {
                Class<?> type = Class.forName("quicktime.util.QTBuild");
                Method method = type.getMethod("info", null);
                String version = (String)method.invoke(null, (Object[])null);
                version = version.substring(version.indexOf(":") + 1, version.indexOf("]"));
                String aboutString = "QTJava version " + version;
                JOptionPane.showMessageDialog(null, aboutString, "About QuickTime for Java", 1);
            }
            catch (Exception ex) {
                failed = true;
            }
            catch (Error err) {
                failed = true;
            }
            if (failed) {
                JOptionPane.showMessageDialog(null, "QuickTime for Java is installed but not operating correctly.", "About QuickTime for Java", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "QuickTime for Java was not found in " + extdir + "." + NEWLINE + "The installer can be downloaded from http://www.apple.com/quicktime/download/standalone.html.", "About QuickTime for Java", 2);
        }
    }

    public static void aboutJava3D() {
        String extdir = System.getProperty("java.ext.dirs");
        String slash = System.getProperty("file.separator", "/");
        File extfile = new File(extdir + slash + "j3dcore.jar");
        if (extfile.exists()) {
            boolean failed = false;
            try {
                Class<?> type = Class.forName("javax.media.j3d.VirtualUniverse");
                Method method = type.getMethod("getProperties", null);
                Map props = (Map)method.invoke(null, (Object[])null);
                String version = (String)props.get("j3d.version");
                String vendor = (String)props.get("j3d.vendor");
                String aboutString = "Java 3D version " + version + NEWLINE + vendor;
                JOptionPane.showMessageDialog(null, aboutString, "About Java 3D", 1);
            }
            catch (Exception ex) {
                failed = true;
            }
            catch (Error err) {
                failed = true;
            }
            if (failed) {
                JOptionPane.showMessageDialog(null, "Java 3D is installed but not operating correctly.", "About Java 3D", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Java 3D was not found in " + extdir + "." + NEWLINE + "The installer can be downloaded from https://java3d.dev.java.net/binary-builds.html.", "About Java 3D", 2);
        }
    }

    public static void aboutJOGL() {
        String extdir = System.getProperty("java.ext.dirs");
        String slash = System.getProperty("file.separator", "/");
        File extfile = new File(extdir + slash + "jogl.jar");
        if (extfile.exists()) {
            boolean failed = false;
            try {
                Class<?> type = Class.forName("javax.media.opengl.glu.GLU");
                Field field = type.getField("versionString");
                String version = (String)field.get(null);
                String aboutString = "JOGL version " + version;
                JOptionPane.showMessageDialog(null, aboutString, "About JOGL", 1);
            }
            catch (Exception ex) {
                failed = true;
            }
            catch (Error err) {
                failed = true;
            }
            if (failed) {
                JOptionPane.showMessageDialog(null, "JOGL is installed but not operating correctly.", "About JOGL", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "JOGL was not found in " + extdir + "." + NEWLINE + "The required jar file \"jogl.jar\" can be downloaded from https://jogl.dev.java.net/.", "About JOGL", 2);
        }
    }
}

