/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;
import org.opensourcephysics.tools.ExportGnuplotFormat;
import org.opensourcephysics.tools.ExportXMLFormat;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;

public class ExportTool
implements Tool,
PropertyChangeListener {
    static ExportTool TOOL;
    static JFileChooser fc;
    static String exportExtension;
    static Hashtable formats;
    JCheckBox[] checkBoxes;
    String exportName = "default";
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;
    static /* synthetic */ Class class$org$opensourcephysics$display2d$GridData;

    public ExportTool() {
        fc.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        FileFilter filter = fc.getFileFilter();
        if (filter == null) {
            return;
        }
        ExportFormat ef = (ExportFormat)formats.get(filter.getDescription());
        if (ef == null || exportExtension.equals(ef.extension())) {
            return;
        }
        exportExtension = ef.extension();
        fc.setSelectedFile(new File(this.exportName + '.' + exportExtension));
    }

    void buildAccessory(List data) {
        this.checkBoxes = new JCheckBox[data.size()];
        JPanel checkPanel = new JPanel(new GridLayout(0, 1));
        for (int i = 0; i < data.size(); ++i) {
            String s = "Unknown" + i;
            Color c = Color.BLACK;
            Object o = data.get(i);
            if (o instanceof Dataset) {
                Dataset d = (Dataset)o;
                s = "Dataset" + i;
                c = d.getFillColor();
            } else if (o instanceof GridData) {
                s = "GridData" + i;
            }
            this.checkBoxes[i] = new JCheckBox(s);
            this.checkBoxes[i].setSelected(true);
            this.checkBoxes[i].setForeground(c);
            this.checkBoxes[i].setBackground(Color.WHITE);
            checkPanel.add(this.checkBoxes[i]);
        }
        JScrollPane scrollPane = new JScrollPane(checkPanel);
        scrollPane.getViewport().setBackground(Color.WHITE);
        JPanel p = new JPanel(new BorderLayout());
        if (data.size() == 0) {
            p.add((Component)new JLabel("No Data"), "North");
        } else {
            p.add((Component)new JLabel("Exportable Data"), "North");
        }
        p.add((Component)scrollPane, "Center");
        p.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        fc.setAccessory(p);
    }

    static void setChooserFormats() {
        fc.resetChoosableFileFilters();
        fc.setAcceptAllFileFilterUsed(false);
        Enumeration e = formats.keys();
        while (e.hasMoreElements()) {
            final String desc = (String)e.nextElement();
            fc.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return true;
                }

                public String getDescription() {
                    return desc;
                }
            });
        }
    }

    List getDataObjects(XMLControlElement control) {
        List ret = control.getObjects(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = ExportTool.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
        ret.addAll(control.getObjects(class$org$opensourcephysics$display2d$GridData == null ? (class$org$opensourcephysics$display2d$GridData = ExportTool.class$("org.opensourcephysics.display2d.GridData")) : class$org$opensourcephysics$display2d$GridData));
        return ret;
    }

    List filterDataObjects(List data) {
        Vector ret = new Vector();
        for (int i = 0; i < data.size(); ++i) {
            if (!this.checkBoxes[i].isSelected()) continue;
            ret.add(data.get(i));
        }
        return ret;
    }

    public static void registerFormat(ExportFormat format) {
        formats.put(format.description(), format);
    }

    public void send(Job job, Tool replyTo) throws RemoteException {
        XMLControlElement control = new XMLControlElement();
        try {
            control.readXML(job.getXML());
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        OSPLog.finest(control.toXML());
        List data = this.getDataObjects(control);
        this.buildAccessory(data);
        fc.setSelectedFile(new File(this.exportName + '.' + exportExtension));
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            int selected;
            File file = fc.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, "Replace existing " + file.getName() + "?", "Replace File", 1)) != 0) {
                return;
            }
            String description = fc.getFileFilter().getDescription();
            ((ExportFormat)formats.get(description)).export(file, this.filterDataObjects(data));
            if (file.getName().endsWith(exportExtension)) {
                this.exportName = file.getName().substring(0, file.getName().length() - 1 - exportExtension.length());
            }
        }
    }

    public static ExportTool getTool() {
        if (TOOL == null) {
            TOOL = new ExportTool();
            Toolbox.addTool("ExportTool", TOOL);
        }
        return TOOL;
    }

    static {
        exportExtension = "txt";
        formats = new Hashtable();
        ExportTool.registerFormat(new ExportGnuplotFormat());
        ExportTool.registerFormat(new ExportXMLFormat());
        Object oldFilesOfTypeLabelText = UIManager.put("FileChooser.filesOfTypeLabelText", "File Format:");
        fc = new JFileChooser(OSPFrame.chooserDir);
        UIManager.put("FileChooser.filesOfTypeLabelText", oldFilesOfTypeLabelText);
        fc.setDialogType(1);
        fc.setDialogTitle("Export Data");
        fc.setApproveButtonText("Export");
        ExportTool.setChooserFormats();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

