/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class JobManager {
    Tool localTool;
    Map replies = new HashMap();
    Map objects = new HashMap();

    public JobManager(Tool tool) {
        this.localTool = tool;
    }

    public void log(Job job, Tool tool) {
        if (tool == null) {
            return;
        }
        HashSet<Tool> tools = (HashSet<Tool>)this.replies.get(job);
        if (tools == null) {
            tools = new HashSet<Tool>();
            this.replies.put(job, tools);
        }
        tools.add(tool);
    }

    public void associate(Job job, Object obj) {
        if (obj == null) {
            return;
        }
        HashSet<Object> tags = (HashSet<Object>)this.objects.get(job);
        if (tags == null) {
            tags = new HashSet<Object>();
            this.objects.put(job, tags);
        }
        tags.add(obj);
    }

    public Job[] getJobs(Object obj) {
        ArrayList jobs = new ArrayList();
        Iterator it = this.objects.keySet().iterator();
        while (it.hasNext()) {
            Object job = it.next();
            Collection tags = (Collection)this.objects.get(job);
            if (tags == null) {
                return null;
            }
            if (!tags.contains(obj)) continue;
            jobs.add(job);
        }
        return jobs.toArray(new Job[0]);
    }

    public Object[] getObjects(Job job) {
        Collection tags = (Collection)this.objects.get(job);
        if (tags == null) {
            return new Object[0];
        }
        return tags.toArray(new Object[0]);
    }

    public void sendReplies(Object obj) {
        Job[] jobs = this.getJobs(obj);
        XMLControlElement control = new XMLControlElement(obj);
        String xml = control.toXML();
        for (int i = 0; i < jobs.length; ++i) {
            try {
                jobs[i].setXML(xml);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
            this.sendReplies(jobs[i]);
        }
    }

    public void sendReplies(Job job) {
        Collection tools = (Collection)this.replies.get(job);
        if (tools == null) {
            return;
        }
        Iterator it = tools.iterator();
        try {
            while (it.hasNext()) {
                Tool tool = (Tool)it.next();
                tool.send(job, this.localTool);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }
}

