/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LaunchableClassMap;

public class LaunchClassChooser
extends JDialog {
    private static Pattern pattern;
    private static Matcher matcher;
    private static Map classMaps;
    private JTextField searchField;
    private String defaultSearch;
    private String currentSearch;
    private JScrollPane scroller;
    private JList choices;
    private LaunchableClassMap classMap;
    private boolean applyChanges;
    private JButton okButton;

    public LaunchClassChooser(Component owner) {
        super(JOptionPane.getFrameForComponent(owner), true);
        this.currentSearch = this.defaultSearch = "";
        this.applyChanges = false;
        this.setTitle(LaunchRes.getString("ClassChooser.Frame.Title"));
        JLabel textLabel = new JLabel(LaunchRes.getString("ClassChooser.Search.Label") + " ");
        this.okButton = new JButton(LaunchRes.getString("ClassChooser.Button.Accept"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchClassChooser.this.applyChanges = true;
                ((Component)LaunchClassChooser.this).setVisible(false);
            }
        });
        JButton cancelButton = new JButton(LaunchRes.getString("ClassChooser.Button.Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)LaunchClassChooser.this).setVisible(false);
            }
        });
        this.searchField = new JTextField(this.defaultSearch);
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                Object obj = LaunchClassChooser.this.choices.getSelectedValue();
                LaunchClassChooser.this.search();
                LaunchClassChooser.this.choices.setSelectedValue(obj, true);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 0));
        headerPane.add(textLabel);
        headerPane.add(Box.createHorizontalGlue());
        headerPane.add(this.searchField);
        headerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JPanel scrollPane = new JPanel(new BorderLayout());
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.okButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)headerPane, "North");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.scroller = new JScrollPane();
        this.scroller.setPreferredSize(new Dimension(400, 300));
        scrollPane.add((Component)this.scroller, "Center");
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(x, y);
    }

    public boolean setPath(String path) {
        String[] jarNames = LaunchClassChooser.parsePath(path, true);
        this.classMap = null;
        if (jarNames == null || jarNames.length == 0) {
            return false;
        }
        String key = "";
        for (int i = 0; i < jarNames.length; ++i) {
            if (!key.equals("")) {
                key = key + ";";
            }
            key = key + jarNames[i];
        }
        this.classMap = (LaunchableClassMap)classMaps.get(key);
        if (this.classMap == null) {
            this.classMap = new LaunchableClassMap(jarNames);
            classMaps.put(key, this.classMap);
        }
        return true;
    }

    public boolean isLoaded(String path) {
        if (this.classMap == null) {
            return false;
        }
        String[] jarNames = LaunchClassChooser.parsePath(path, true);
        for (int i = 0; i < jarNames.length; ++i) {
            if (this.classMap.includesJar(jarNames[i])) continue;
            return false;
        }
        return true;
    }

    public boolean chooseClassFor(LaunchNode node) {
        this.search();
        this.choices.setSelectedValue(node.launchClassName, true);
        this.applyChanges = false;
        ((Component)this).setVisible(true);
        if (!this.applyChanges) {
            return false;
        }
        Object obj = this.choices.getSelectedValue();
        if (obj == null) {
            return false;
        }
        String className = obj.toString();
        node.launchClass = (Class)this.classMap.get(className);
        node.launchClassName = className;
        return true;
    }

    public Class getClass(String className) {
        if (this.classMap == null) {
            return null;
        }
        return this.classMap.getClass(className);
    }

    public static Class getClass(String classPath, String className) {
        if (classPath == null || className == null) {
            return null;
        }
        String[] jarNames = LaunchClassChooser.parsePath(classPath, true);
        LaunchableClassMap classMap = LaunchClassChooser.getClassMap(jarNames);
        return classMap.getClass(className);
    }

    public static ClassLoader getClassLoader(String classPath) {
        if (classPath == null || classPath.equals("")) {
            return null;
        }
        String[] jarNames = LaunchClassChooser.parsePath(classPath, true);
        LaunchableClassMap classMap = LaunchClassChooser.getClassMap(jarNames);
        return classMap.classLoader;
    }

    private static LaunchableClassMap getClassMap(String[] jarNames) {
        String key = "";
        for (int i = 0; i < jarNames.length; ++i) {
            if (!key.equals("")) {
                key = key + ";";
            }
            key = key + jarNames[i];
        }
        LaunchableClassMap classMap = (LaunchableClassMap)classMaps.get(key);
        if (classMap == null) {
            classMap = new LaunchableClassMap(jarNames);
            classMaps.put(key, classMap);
        }
        return classMap;
    }

    private void search() {
        if (this.classMap == null) {
            return;
        }
        this.classMap.loadAllLaunchables();
        if (this.search(this.searchField.getText())) {
            this.currentSearch = this.searchField.getText();
            this.searchField.setBackground(Color.white);
        } else {
            JOptionPane.showMessageDialog(this, LaunchRes.getString("Dialog.InvalidRegex.Message") + " \"" + this.searchField.getText() + "\"", LaunchRes.getString("Dialog.InvalidRegex.Title"), 2);
            this.searchField.setText(this.currentSearch);
        }
    }

    private boolean search(String regex) {
        regex = regex.toLowerCase();
        this.okButton.setEnabled(false);
        try {
            pattern = Pattern.compile(regex);
        }
        catch (Exception ex) {
            return false;
        }
        ArrayList<String> matches = new ArrayList<String>();
        Iterator it = this.classMap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            matcher = pattern.matcher(name.toLowerCase());
            if (!matcher.find()) continue;
            matches.add(name);
        }
        Object[] results = matches.toArray();
        this.choices = new JList<Object>(results);
        this.choices.setSelectionMode(0);
        this.choices.setFont(this.searchField.getFont());
        this.choices.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JList theList = (JList)e.getSource();
                LaunchClassChooser.this.okButton.setEnabled(!theList.isSelectionEmpty());
            }
        });
        this.choices.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JList theList = (JList)e.getSource();
                if (e.getClickCount() == 2 && !theList.isSelectionEmpty()) {
                    LaunchClassChooser.this.okButton.doClick();
                }
            }
        });
        this.scroller.getViewport().setView(this.choices);
        return true;
    }

    static String[] parsePath(String path, boolean jarsOnly) {
        ArrayList<String> tokens = new ArrayList<String>();
        String next = path;
        int i = path.indexOf(";");
        if (i != -1) {
            next = path.substring(0, i);
            path = path.substring(i + 1);
        } else {
            path = "";
        }
        while (!next.equals("")) {
            next = next.trim();
            if (!jarsOnly || next.endsWith(".jar")) {
                tokens.add(next);
            }
            if ((i = path.indexOf(";")) == -1) {
                next = path;
                path = "";
                continue;
            }
            next = path.substring(0, i);
            path = path.substring(i + 1);
        }
        return tokens.toArray(new String[0]);
    }

    static {
        classMaps = new TreeMap();
    }
}

