/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.OSPParameters;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchNode
extends DefaultMutableTreeNode {
    static final Level DEFAULT_LOG_LEVEL = ConsoleLevel.OUT_CONSOLE;
    Object launchObj;
    String classPath;
    String launchClassName;
    Class launchClass;
    String[] args = new String[]{""};
    boolean showLog = false;
    boolean clearLog = false;
    Level logLevel = DEFAULT_LOG_LEVEL;
    boolean singleVM = false;
    boolean singleVMOff = false;
    boolean hiddenWhenRoot = false;
    boolean buttonView = false;
    boolean singleton = false;
    boolean singleApp = false;
    boolean singleAppOff = false;
    boolean webStart = false;
    boolean hiddenInLauncher = false;
    String name = "";
    String description = "";
    String tooltip = "";
    String xsetName = "";
    String author = "";
    String keywords = "";
    String comment = "";
    String urlName;
    URL url;
    private String fileName;
    Collection processes = new HashSet();
    Collection frames = new HashSet();
    Collection actions = new HashSet();
    Map threads = new HashMap();
    int launchCount = 0;
    LaunchPanel launchPanel;
    boolean selfContained;
    boolean parentSelfContained;
    boolean previewing;
    boolean saveHiddenNodes;
    List jars = new ArrayList();
    static /* synthetic */ Class class$org$opensourcephysics$tools$LaunchNode;

    public LaunchNode(String name) {
        this.setUserObject(this);
        if (name != null) {
            this.name = name;
        }
    }

    public void threadRunning(boolean starting) {
        this.launchCount += starting ? 1 : -1;
        this.launchCount = Math.max(0, this.launchCount);
        if (this.launchPanel != null) {
            this.launchPanel.repaint();
        }
    }

    public void launch() {
        this.launch(null);
    }

    public void launch(LaunchPanel tab) {
        if (!this.isLeaf()) {
            return;
        }
        this.launchPanel = tab;
        OSPParameters.launchingInSingleVM = this.isSingleVM();
        Launcher.singleAppMode = this.isSingleApp();
        Launcher.classPath = this.getClassPath();
        if (this.isShowLog() && this.isSingleVM()) {
            OSPLog.setLevel(this.getLogLevel());
            OSPLog log = OSPLog.getOSPLog();
            if (this.isClearLog()) {
                log.clear();
            }
            log.setVisible(true);
        }
        this.setMinimumArgLength(1);
        String arg0 = this.args[0];
        if (this.getLaunchClass() != null) {
            if (arg0.equals("this")) {
                Object launchObj = this.getLaunchObject();
                if (launchObj != null) {
                    XMLControlElement control = new XMLControlElement(launchObj);
                    this.args[0] = control.toXML();
                } else {
                    this.args[0] = "";
                }
            }
            if (this.args[0].equals("") && this.args.length == 1) {
                Launcher.launch(this.getLaunchClass(), null, this);
            } else {
                Launcher.launch(this.getLaunchClass(), this.args, this);
            }
        }
        this.args[0] = arg0;
    }

    public LaunchNode getOwner() {
        if (this.fileName != null) {
            return this;
        }
        if (this.getParent() != null) {
            return ((LaunchNode)this.getParent()).getOwner();
        }
        return null;
    }

    public LaunchNode[] getAllOwnedNodes() {
        ArrayList<LaunchNode> nodes = new ArrayList<LaunchNode>();
        Enumeration<TreeNode> e = this.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode next = (LaunchNode)e.nextElement();
            if (next.fileName == null || next == this) continue;
            nodes.add(next);
        }
        return nodes.toArray(new LaunchNode[0]);
    }

    public LaunchNode[] getChildOwnedNodes() {
        ArrayList<LaunchNode> nodes = new ArrayList<LaunchNode>();
        LaunchNode[] owned = this.getAllOwnedNodes();
        LaunchNode owner = this.getOwner();
        for (int i = 0; i < owned.length; ++i) {
            LaunchNode next = ((LaunchNode)owned[i].getParent()).getOwner();
            if (next != owner) continue;
            nodes.add(owned[i]);
        }
        return nodes.toArray(new LaunchNode[0]);
    }

    public String toString() {
        if (this.name != null && !this.name.equals("")) {
            return this.name;
        }
        if (this.launchClassName != null) {
            return XML.getExtension(this.launchClassName);
        }
        if (!this.args[0].equals("")) {
            String name = this.args[0];
            name = XML.getName(name);
            return XML.stripExtension(name);
        }
        return "";
    }

    public String getID() {
        return String.valueOf(this.hashCode());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setArgs(String[] args) {
        if (args != null && args.length > 0 && args[0] != null) {
            this.args = args;
        }
    }

    public String getClassPath() {
        String path = "";
        if (this.classPath != null) {
            path = path + this.classPath;
        }
        LaunchNode node = this;
        while (!node.isRoot()) {
            node = (LaunchNode)node.getParent();
            if (node.classPath == null) continue;
            if (!path.equals("")) {
                path = path + ";";
            }
            path = path + node.classPath;
        }
        if (!path.equals("")) {
            this.jars.clear();
            String next = path;
            int i = path.indexOf(";");
            if (i == -1) {
                i = path.indexOf(":");
            }
            if (i != -1) {
                next = path.substring(0, i);
                path = path.substring(i + 1);
            } else {
                path = "";
            }
            while (!next.equals("")) {
                if (!this.jars.contains(next = next.trim())) {
                    this.jars.add(next);
                }
                if ((i = path.indexOf(";")) == -1) {
                    i = path.indexOf(":");
                }
                if (i == -1) {
                    next = path;
                    path = "";
                    continue;
                }
                next = path.substring(0, i);
                path = path.substring(i + 1);
            }
            Iterator it = this.jars.iterator();
            while (it.hasNext()) {
                if (!path.equals("")) {
                    path = path + ";";
                }
                path = path + it.next();
            }
        }
        if (ResourceLoader.launchJarName != null && path.indexOf(ResourceLoader.launchJarName) == -1) {
            if (!path.equals("")) {
                path = path + ";";
            }
            path = path + ResourceLoader.launchJarName;
        }
        return path;
    }

    public void setClassPath(String jarNames) {
        if (jarNames == null || jarNames.equals("")) {
            this.classPath = null;
            return;
        }
        while (jarNames.startsWith(":") || jarNames.startsWith(";")) {
            jarNames = jarNames.substring(1);
        }
        while (jarNames.endsWith(":") || jarNames.endsWith(";")) {
            jarNames = jarNames.substring(0, jarNames.length() - 1);
        }
        String s = jarNames;
        int i = jarNames.indexOf(";;");
        if (i == -1) {
            i = jarNames.indexOf("::");
        }
        if (i == -1) {
            i = jarNames.indexOf(":;");
        }
        if (i == -1) {
            i = jarNames.indexOf(";:");
        }
        while (i > -1) {
            s = jarNames = jarNames.substring(0, i + 1) + s.substring(i + 2);
            i = jarNames.indexOf(";;");
            if (i == -1) {
                i = jarNames.indexOf("::");
            }
            if (i == -1) {
                i = jarNames.indexOf(":;");
            }
            if (i != -1) continue;
            i = jarNames.indexOf(";:");
        }
        this.classPath = jarNames;
    }

    public boolean setLaunchClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.launchClassName == className && this.launchClass != null) {
            return false;
        }
        OSPLog.finest(LaunchRes.getString("Log.Message.SetLaunchClass") + " " + className);
        this.launchClassName = className;
        this.launchClass = LaunchClassChooser.getClass(this.getClassPath(), className);
        return this.launchClass != null;
    }

    public Class getLaunchClass() {
        if (this.launchClass == null && this.launchClassName != null && !this.launchClassName.equals("")) {
            this.setLaunchClass(this.launchClassName);
        }
        return this.launchClass;
    }

    public Object getLaunchObject() {
        if (this.launchObj != null) {
            return this.launchObj;
        }
        if (this.isRoot()) {
            return null;
        }
        LaunchNode node = (LaunchNode)this.getParent();
        return node.getLaunchObject();
    }

    public void setLaunchObject(Object obj) {
        this.launchObj = obj;
    }

    public URL setURL(String path) {
        if (path == null || path.equals("")) {
            this.urlName = null;
            this.url = null;
            return null;
        }
        this.urlName = path;
        OSPLog.finest(LaunchRes.getString("Log.Message.SetURLPath") + " " + path);
        Resource res = ResourceLoader.getResource(path);
        if (res != null && res.getURL() != null) {
            try {
                return this.setURL(res.getURL());
            }
            catch (Exception ex) {
                OSPLog.info(LaunchRes.getString("Log.Message.NotFound") + " " + path);
            }
        }
        this.url = null;
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathString() {
        TreeNode[] nodes = this.getPath();
        LaunchNode next = (LaunchNode)nodes[0];
        StringBuffer path = new StringBuffer(next.name);
        for (int i = 1; i < nodes.length; ++i) {
            next = (LaunchNode)nodes[i];
            path.append("/" + next.name);
        }
        return path.toString();
    }

    public String setFileName(String path) {
        this.fileName = path == null ? null : XML.getPathRelativeTo(path, Launcher.tabSetBasePath);
        return this.fileName;
    }

    public boolean isParentSelfContained() {
        if (this.parentSelfContained) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isSelfContained();
    }

    public boolean isSelfContained() {
        return this.selfContained || this.isParentSelfContained();
    }

    public boolean isPreviewing() {
        if (this.previewing) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode node = (LaunchNode)this.getParent();
        return node.isPreviewing();
    }

    public boolean isSavingHiddenNodes() {
        if (this.saveHiddenNodes) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode node = (LaunchNode)this.getParent();
        return node.isSavingHiddenNodes();
    }

    public void setSelfContained(boolean selfContained) {
        this.selfContained = selfContained;
    }

    public boolean isSingleVM() {
        if (this.singleVM || this.webStart) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return this.singleVMOff ? false : parent.isSingleVM();
    }

    public void setSingleVM(boolean singleVM) {
        this.singleVM = singleVM;
    }

    public boolean isShowLog() {
        if (this.showLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isShowLog();
    }

    public void setShowLog(boolean show) {
        this.showLog = show;
    }

    public boolean isClearLog() {
        if (this.clearLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isClearLog();
    }

    public void setClearLog(boolean clear) {
        this.clearLog = clear;
    }

    public Level getLogLevel() {
        Level parentLevel;
        if (this.isRoot()) {
            return this.logLevel;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        if (parent.isShowLog() && (parentLevel = parent.getLogLevel()).intValue() < this.logLevel.intValue()) {
            return parentLevel;
        }
        return this.logLevel;
    }

    public void setLogLevel(Level level) {
        if (level != null) {
            this.logLevel = level;
        }
    }

    public boolean isSingleApp() {
        if (this.singleApp) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return this.singleAppOff ? false : parent.isSingleApp();
    }

    public void setSingleApp(boolean singleApp) {
        this.singleApp = singleApp;
    }

    public void setHiddenWhenRoot(boolean hide) {
        this.hiddenWhenRoot = hide;
    }

    public boolean isButtonView() {
        if (this.buttonView) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isButtonView();
    }

    public void setButtonView(boolean buttonView) {
        LaunchNode root = (LaunchNode)this.getRoot();
        root.buttonView = buttonView;
    }

    public boolean isSingleton() {
        if (this.singleton) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isSingleton();
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isHiddenInLauncher() {
        if (this.hiddenInLauncher) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.isHiddenInLauncher();
    }

    public void setHiddenInLauncher(boolean hide) {
        this.hiddenInLauncher = hide;
    }

    public String getAuthor() {
        if (!this.author.equals("")) {
            return this.author;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode parent = (LaunchNode)this.getParent();
        return parent.getAuthor();
    }

    public Resource getResource() {
        if (this.fileName == null) {
            return null;
        }
        String path = XML.getResolvedPath(this.fileName, Launcher.tabSetBasePath);
        return ResourceLoader.getResource(path);
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    public File getFile() {
        if (this.exists()) {
            return this.getResource().getFile();
        }
        return null;
    }

    public boolean matches(LaunchNode node) {
        if (node == null) {
            return false;
        }
        boolean match = this.showLog == node.showLog && this.clearLog == node.clearLog && this.singleton == node.singleton && this.singleVM == node.singleVM && this.hiddenWhenRoot == node.hiddenWhenRoot && this.name.equals(node.name) && this.description.equals(node.description) && this.args[0].equals(node.args[0]) && (this.fileName == null && node.fileName == null || this.fileName != null && this.fileName.equals(node.fileName)) && (this.getLaunchClass() == null && node.getLaunchClass() == null || this.getLaunchClass() != null && this.getLaunchClass().equals(node.getLaunchClass())) && (this.classPath == null && node.classPath == null || this.classPath != null && this.classPath.equals(node.classPath));
        return match;
    }

    public LaunchNode getChildNode(String childFileName) {
        Enumeration<TreeNode> e = this.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode next = (LaunchNode)e.nextElement();
            if (!childFileName.equals(next.fileName)) continue;
            return next;
        }
        return null;
    }

    public void addMenuItemsTo(JComponent menu) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            JMenuItem item;
            LaunchNode child = (LaunchNode)e.nextElement();
            if (child.isLeaf()) {
                item = new JMenuItem(child.toString());
                menu.add(item);
                item.setToolTipText(child.tooltip);
                item.setActionCommand(child.getID());
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String id = e.getActionCommand();
                        LaunchNode root = (LaunchNode)LaunchNode.this.getRoot();
                        Enumeration<TreeNode> e2 = root.postorderEnumeration();
                        while (e2.hasMoreElements()) {
                            LaunchNode node = (LaunchNode)e2.nextElement();
                            if (!node.getID().equals(id)) continue;
                            node.launch();
                            break;
                        }
                    }
                });
                continue;
            }
            item = new JMenu(child.toString());
            menu.add(item);
            child.addMenuItemsTo(item);
        }
    }

    public void addTerminateAction(Action action) {
        this.actions.add(action);
        ++this.launchCount;
    }

    public void removeTerminateAction(Action action) {
        this.actions.remove(action);
        this.launchCount = Math.max(0, --this.launchCount);
    }

    public void terminate(Action action) {
        if (this.actions.contains(action)) {
            this.removeTerminateAction(action);
            if (this.launchPanel != null) {
                this.launchPanel.repaint();
            }
        }
    }

    public void terminateAll() {
        Iterator<Object> it = this.processes.iterator();
        while (it.hasNext()) {
            Process proc = (Process)it.next();
            proc.destroy();
        }
        it = this.frames.iterator();
        while (it.hasNext()) {
            Frame frame = (Frame)it.next();
            WindowListener[] listeners = frame.getWindowListeners();
            for (int j = 0; j < listeners.length; ++j) {
                if (!(listeners[j] instanceof Launcher.FrameCloser)) continue;
                frame.removeWindowListener(listeners[j]);
            }
            frame.dispose();
        }
        it = this.threads.values().iterator();
        while (it.hasNext()) {
            Thread thread = (Thread)it.next();
            if (thread == null) continue;
            thread.interrupt();
        }
        HashSet allActions = new HashSet(this.actions);
        Iterator it2 = allActions.iterator();
        while (it2.hasNext()) {
            Action action = (Action)it2.next();
            if (action == null) continue;
            action.actionPerformed(null);
        }
        this.processes.clear();
        this.frames.clear();
        this.threads.clear();
        this.actions.clear();
        this.launchCount = 0;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private URL setURL(URL url) throws Exception {
        InputStream in = url.openStream();
        in.close();
        OSPLog.finer(LaunchRes.getString("Log.Message.URL") + " " + url);
        this.url = url;
        return url;
    }

    protected void setMinimumArgLength(int n) {
        if ((n = Math.max(n, 1)) == this.args.length) {
            return;
        }
        if (n > this.args.length) {
            String[] newArgs = new String[n];
            for (int i = 0; i < n; ++i) {
                newArgs[i] = i < this.args.length ? this.args[i] : "";
            }
            this.setArgs(newArgs);
        } else {
            while (this.args.length > n && this.args[this.args.length - 1].equals("")) {
                String[] newArgs = new String[this.args.length - 1];
                for (int i = 0; i < newArgs.length; ++i) {
                    newArgs[i] = this.args[i];
                }
                this.setArgs(newArgs);
            }
        }
    }

    protected void removeThread(Runnable runner) {
        this.threads.remove(runner);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            LaunchNode node = (LaunchNode)obj;
            node.setMinimumArgLength(1);
            if (!node.name.equals("")) {
                control.setValue("name", node.name);
            }
            if (!node.description.equals("")) {
                control.setValue("description", node.description);
            }
            if (!node.tooltip.equals("")) {
                control.setValue("tooltip", node.tooltip);
            }
            if (!node.xsetName.equals("")) {
                control.setValue("launchset", node.xsetName);
            }
            if (node.urlName != null) {
                control.setValue("url", node.urlName);
            }
            if (node.getLaunchClass() != null) {
                control.setValue("launch_class", node.getLaunchClass().getName());
            } else if (node.launchClassName != null) {
                control.setValue("launch_class", node.launchClassName);
            }
            if (!node.args[0].equals("") || node.args.length > 1) {
                control.setValue("launch_args", node.args);
            }
            if (node.classPath != null && !node.classPath.equals("")) {
                control.setValue("classpath", node.classPath);
            }
            if (node.hiddenWhenRoot) {
                control.setValue("root_hidden", true);
            }
            if (node.buttonView) {
                control.setValue("button_view", true);
            }
            if (node.singleton) {
                control.setValue("singleton", true);
            }
            if (node.singleVM) {
                control.setValue("single_vm", true);
            }
            if (node.singleVMOff) {
                control.setValue("single_vm_off", true);
            }
            if (node.showLog) {
                control.setValue("show_log", true);
            }
            if (node.logLevel != DEFAULT_LOG_LEVEL) {
                control.setValue("log_level", node.logLevel.getName());
            }
            if (node.clearLog) {
                control.setValue("clear_log", true);
            }
            if (node.singleApp) {
                control.setValue("single_app", true);
            }
            if (node.singleAppOff) {
                control.setValue("single_app_off", true);
            }
            if (node.hiddenInLauncher) {
                control.setValue("hidden_in_launcher", true);
            }
            if (!node.author.equals("")) {
                control.setValue("author", node.author);
            }
            if (!node.keywords.equals("")) {
                control.setValue("keywords", node.keywords);
            }
            if (!node.comment.equals("")) {
                control.setValue("comment", node.comment);
            }
            if (node.children != null) {
                ArrayList<Object> children = new ArrayList<Object>();
                Enumeration<TreeNode> e = node.children();
                boolean saveAll = node.isSavingHiddenNodes();
                while (e.hasMoreElements()) {
                    LaunchNode child = (LaunchNode)e.nextElement();
                    if (!saveAll && child.isHiddenInLauncher()) continue;
                    if (node.isPreviewing()) {
                        children.add(child);
                        continue;
                    }
                    if (child.fileName != null && !node.isSelfContained()) {
                        children.add(child.fileName);
                        continue;
                    }
                    child.fileName = null;
                    child.setSelfContained(false);
                    children.add(child);
                }
                if (children.size() > 0) {
                    control.setValue("child_nodes", children);
                }
            }
        }

        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            return new LaunchNode(name);
        }

        public Object loadObject(XMLControl control, Object obj) {
            ArrayList children;
            String comment;
            String keywords;
            String author;
            String[] args;
            String xsetName;
            String tooltip;
            String description;
            LaunchNode node = (LaunchNode)obj;
            String name = control.getString("name");
            if (name != null) {
                node.name = name;
            }
            if ((description = control.getString("description")) != null) {
                node.description = description;
            }
            if ((tooltip = control.getString("tooltip")) != null) {
                node.tooltip = tooltip;
            }
            if ((xsetName = control.getString("launchset")) != null) {
                node.xsetName = xsetName;
            }
            node.setURL(control.getString("url"));
            node.setClassPath(control.getString("classpath"));
            String className = control.getString("launch_class");
            if (className != null) {
                node.launchClassName = className;
            }
            if ((args = (String[])control.getObject("launch_args")) != null) {
                node.setArgs(args);
            }
            node.hiddenWhenRoot = control.getBoolean("root_hidden");
            node.buttonView = control.getBoolean("button_view");
            node.singleton = control.getBoolean("singleton");
            node.singleVM = control.getBoolean("single_vm");
            node.singleVMOff = control.getBoolean("single_vm_off");
            node.showLog = control.getBoolean("show_log");
            node.clearLog = control.getBoolean("clear_log");
            node.singleApp = control.getBoolean("single_app");
            node.singleAppOff = control.getBoolean("single_app_off");
            node.hiddenInLauncher = control.getBoolean("hidden_in_launcher");
            Level level = OSPLog.parseLevel(control.getString("log_level"));
            if (level != null) {
                node.logLevel = level;
            }
            if ((author = control.getString("author")) != null) {
                node.author = author;
            }
            if ((keywords = control.getString("keywords")) != null) {
                node.keywords = keywords;
            }
            if ((comment = control.getString("comment")) != null) {
                node.comment = comment;
            }
            if ((name = control.getString("filename")) != null) {
                node.setFileName(name);
            }
            if ((children = (ArrayList)control.getObject("child_nodes")) != null) {
                node.removeAllChildren();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    Class type;
                    LaunchNode root;
                    Object next = it.next();
                    if (next instanceof LaunchNode) {
                        LaunchNode child = (LaunchNode)next;
                        node.add(child);
                        child.setLaunchClass(child.launchClassName);
                        continue;
                    }
                    if (!(next instanceof String)) continue;
                    String fileName = (String)next;
                    String path = XML.getResolvedPath(fileName, Launcher.tabSetBasePath);
                    ResourceLoader.addSearchPath(Launcher.resourcesPath);
                    ResourceLoader.addSearchPath(Launcher.tabSetBasePath);
                    XMLControlElement childControl = new XMLControlElement();
                    String absolutePath = childControl.read(path);
                    if (childControl.failedToRead()) {
                        JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.InvalidXML.Message") + " \"" + fileName + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
                    }
                    if ((root = (LaunchNode)node.getRoot()).getChildNode(fileName) != null || fileName.equals(root.fileName)) continue;
                    if (!(class$org$opensourcephysics$tools$LaunchNode == null ? LaunchNode.class$("org.opensourcephysics.tools.LaunchNode") : class$org$opensourcephysics$tools$LaunchNode).isAssignableFrom(type = childControl.getObjectClass())) continue;
                    LaunchNode child = new LaunchNode(LaunchRes.getString("NewNode.Name"));
                    child.setFileName(fileName);
                    OSPLog.finest(LaunchRes.getString("Log.Message.Loading") + ": " + absolutePath);
                    node.add(child);
                    childControl.loadObject(child);
                }
            }
            return node;
        }
    }
}

