/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.tools.ToolsRes;

class LaunchRes {
    static Locale locale = Locale.getDefault();
    static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", locale);
    static Object resObj = new LaunchRes();
    static PropertyChangeSupport support = new SwingPropertyChangeSupport(resObj);

    private LaunchRes() {
    }

    static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException ex) {
            return "!" + key + "!";
        }
    }

    public static void setLocale(Locale loc) {
        if (locale == loc) {
            return;
        }
        Locale prev = locale;
        locale = loc;
        res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", locale);
        support.firePropertyChange("locale", prev, locale);
        ToolsRes.setLocale(loc);
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property.equals("locale")) {
            support.addPropertyChangeListener(property, listener);
        }
    }

    public static void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        support.removePropertyChangeListener(property, listener);
    }
}

