/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.swing.ImageIcon;
import org.opensourcephysics.controls.XML;

public class Resource {
    protected static String encoding = "UTF-8";
    private URL url;
    private File file;
    private boolean isAnImage = true;
    private ImageIcon icon;
    private String string;
    private AudioClip clip;
    private BufferedImage image;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$ImageIcon;

    public Resource(URL url) {
        this.url = url;
    }

    public Resource(File file) {
        this.file = file;
    }

    public String getAbsolutePath() {
        if (this.getFile() != null) {
            try {
                return XML.forwardSlash(this.getFile().getCanonicalPath());
            }
            catch (IOException ex) {
                return this.getFile().getAbsolutePath();
            }
        }
        if (this.getURL() != null) {
            URL url = this.getURL();
            String path = url.getPath();
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (path.startsWith("/") && path.indexOf(":") > -1) {
                path = path.substring(1);
            }
            int i = path.indexOf("%20");
            while (i > -1) {
                String s = path.substring(0, i);
                path = s + " " + path.substring(i + 3);
                i = path.indexOf("%20");
            }
            return path;
        }
        return null;
    }

    public URL getURL() {
        if (this.url == null && this.file != null) {
            String path = this.getAbsolutePath();
            try {
                this.url = path.startsWith("/") ? new URL("file:" + path) : new URL("file:/" + path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public Object getObject(Class type) {
        if ((class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = Resource.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon).equals(type)) {
            return this.getIcon();
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = Resource.class$("java.lang.String")) : class$java$lang$String).equals(type)) {
            return this.getString();
        }
        return null;
    }

    public InputStream openInputStream() {
        if (this.getFile() != null) {
            try {
                return new FileInputStream(this.getFile());
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        if (this.getURL() != null) {
            try {
                return this.getURL().openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public BufferedReader openReader() {
        Charset charset = Charset.forName(encoding);
        InputStream stream = this.openInputStream();
        if (stream == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(stream, charset));
    }

    public ImageIcon getIcon() {
        if (this.icon == null && this.isAnImage) {
            this.icon = new ImageIcon(this.getURL());
            if (this.icon.getIconWidth() < 1) {
                this.icon = null;
                this.isAnImage = false;
            }
        }
        return this.icon;
    }

    public Image getImage() {
        ImageIcon icon = this.getIcon();
        if (icon != null) {
            return icon.getImage();
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        if (this.image == null && this.isAnImage) {
            Image im = this.getImage();
            if (im == null) {
                this.isAnImage = false;
            } else {
                this.image = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
                Graphics2D g2 = this.image.createGraphics();
                g2.drawImage(im, 0, 0, null);
            }
        }
        return this.image;
    }

    public String getString() {
        if (this.string == null) {
            StringBuffer buffer = new StringBuffer();
            try {
                BufferedReader in = new BufferedReader(this.openReader());
                String line = in.readLine();
                while (line != null) {
                    buffer.append(line + XML.NEW_LINE);
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.string = buffer.toString();
        }
        return this.string;
    }

    public AudioClip getAudioClip() {
        if (this.clip == null && this.getURL() != null) {
            this.clip = Applet.newAudioClip(this.getURL());
        }
        return this.clip;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

