/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.Resource;

public class ResourceLoader {
    protected static ArrayList searchPaths = new ArrayList();
    protected static int maxPaths = 20;
    protected static Hashtable resources = new Hashtable();
    protected static boolean cacheEnabled = false;
    protected static Map zipLoaders = new TreeMap();
    protected static URLClassLoader xsetZipLoader;
    protected static String launchJarName;
    protected static String launchJarPath;
    static /* synthetic */ Class class$org$opensourcephysics$tools$Resource;

    private ResourceLoader() {
    }

    public static Resource getResource(String name) {
        return ResourceLoader.getResource(name, class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource);
    }

    public static Resource getResource(String name, Class type) {
        if (name == null || name.equals("")) {
            return null;
        }
        Resource res = ResourceLoader.findResource(name, type);
        if (res != null) {
            return res;
        }
        StringBuffer err = new StringBuffer("Not found: " + name);
        err.append(" [searched " + name);
        Iterator it = ((AbstractList)searchPaths).iterator();
        while (it.hasNext()) {
            String path = ResourceLoader.getPath((String)it.next(), name);
            res = ResourceLoader.findResource(path, type);
            if (res != null) {
                return res;
            }
            err.append(";" + path);
        }
        err.append("]");
        OSPLog.fine(err.toString());
        return null;
    }

    public static Resource getResource(String basePath, String name) {
        return ResourceLoader.getResource(basePath, name, class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource);
    }

    public static Resource getResource(String basePath, String name, Class type) {
        if (basePath == null) {
            return ResourceLoader.getResource(name, type);
        }
        String path = ResourceLoader.getPath(basePath, name);
        Resource res = ResourceLoader.findResource(path, type);
        if (res != null) {
            return res;
        }
        if (basePath.startsWith("/") || basePath.indexOf(":/") > -1) {
            return null;
        }
        StringBuffer err = new StringBuffer("Not found: " + path);
        err.append(" [searched " + path);
        if (OSPFrame.applet != null) {
            String docBase = OSPFrame.applet.getDocumentBase().toExternalForm();
            path = ResourceLoader.getPath(ResourceLoader.getPath(docBase = XML.getDirectoryPath(docBase) + "/", basePath), name);
            res = ResourceLoader.findResource(path, type);
            if (res != null) {
                return res;
            }
            err.append(";" + path);
            String codeBase = OSPFrame.applet.getCodeBase().toExternalForm();
            if (!codeBase.equals(docBase)) {
                path = ResourceLoader.getPath(ResourceLoader.getPath(codeBase, basePath), name);
                res = ResourceLoader.findResource(path, type);
                if (res != null) {
                    return res;
                }
                err.append(";" + path);
            }
        }
        Iterator it = ((AbstractList)searchPaths).iterator();
        while (it.hasNext()) {
            path = ResourceLoader.getPath(ResourceLoader.getPath((String)it.next(), basePath), name);
            res = ResourceLoader.findResource(path, type);
            if (res != null) {
                return res;
            }
            err.append(";" + path);
        }
        err.append("]");
        OSPLog.fine(err.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String base) {
        if (base == null || base.equals("") || maxPaths < 1) {
            return;
        }
        ArrayList arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(base)) {
                ((AbstractCollection)searchPaths).remove(base);
            } else {
                OSPLog.fine("Added path: " + base);
            }
            searchPaths.add(0, base);
            while (searchPaths.size() > Math.max(maxPaths, 0)) {
                base = (String)searchPaths.get(searchPaths.size() - 1);
                OSPLog.fine("Removed path: " + base);
                ((AbstractCollection)searchPaths).remove(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String base) {
        if (base == null || base.equals("")) {
            return;
        }
        ArrayList arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(base)) {
                OSPLog.fine("Removed path: " + base);
                ((AbstractCollection)searchPaths).remove(base);
            }
        }
    }

    public static void setCacheEnabled(boolean enabled) {
        cacheEnabled = enabled;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    public static InputStream openInputStream(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.openInputStream();
    }

    public static Reader openReader(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.openReader();
    }

    public static String getString(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getString();
    }

    public static ImageIcon getIcon(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getIcon();
    }

    public static Image getImage(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getImage();
    }

    public static BufferedImage getBufferedImage(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getBufferedImage();
    }

    public static AudioClip getAudioClip(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getAudioClip();
    }

    public static String getLaunchJarPath() {
        return launchJarPath;
    }

    private static Resource createFileResource(String path) {
        if (OSPFrame.applet != null) {
            return null;
        }
        if (path.indexOf(".zip") > -1 || path.indexOf(".jar") > -1) {
            return null;
        }
        File file = new File(path);
        try {
            if (file.exists() && file.canRead()) {
                Resource res = new Resource(file);
                if (path.endsWith("xset")) {
                    xsetZipLoader = null;
                }
                OSPLog.fine("File: " + XML.forwardSlash(res.getAbsolutePath()));
                return res;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return null;
    }

    private static Resource createURLResource(String path) {
        if (path.indexOf(".zip") > -1 || path.indexOf(".jar") > -1) {
            return null;
        }
        Resource res = null;
        if (path.indexOf(":/") > -1) {
            try {
                URL url = new URL(path);
                res = ResourceLoader.createResource(url);
            }
            catch (Exception ex) {}
        } else if (OSPFrame.applet != null && !path.startsWith("/")) {
            URL docBase = OSPFrame.applet.getDocumentBase();
            try {
                URL url = new URL(docBase, path);
                res = ResourceLoader.createResource(url);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (res == null) {
                URL codeBase = OSPFrame.applet.getCodeBase();
                String s = XML.getDirectoryPath(docBase.toExternalForm()) + "/";
                if (!codeBase.toExternalForm().equals(s)) {
                    try {
                        URL url = new URL(codeBase, path);
                        res = ResourceLoader.createResource(url);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        if (res != null) {
            if (path.endsWith(".xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("URL: " + XML.forwardSlash(res.getAbsolutePath()));
        }
        return res;
    }

    private static Resource createZipResource(String path) {
        URL classURL;
        URL[] urls;
        String base = null;
        String fileName = path;
        int i = path.indexOf("zip!/");
        if (i == -1) {
            i = path.indexOf("jar!/");
        }
        if (i > -1) {
            base = path.substring(0, i + 3);
            fileName = path.substring(i + 5);
        }
        if (base == null) {
            if (path.endsWith(".zip") || path.endsWith(".jar")) {
                String name = XML.stripExtension(XML.getName(path));
                base = path;
                fileName = name + ".xset";
            } else if (path.endsWith(".xset")) {
                base = path.substring(0, path.length() - 4) + "zip";
            }
        }
        URLClassLoader zipLoader = null;
        URL url = null;
        if (base != null) {
            zipLoader = (URLClassLoader)zipLoaders.get(base);
            if (zipLoader != null) {
                url = zipLoader.findResource(fileName);
            } else {
                try {
                    urls = new URL[]{new URL("file", null, base)};
                    zipLoader = new URLClassLoader(urls);
                    url = zipLoader.findResource(fileName);
                    if (url == null && (classURL = (class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource).getResource("/" + base)) != null) {
                        urls = new URL[]{classURL};
                        zipLoader = new URLClassLoader(urls);
                        url = zipLoader.findResource(fileName);
                    }
                    if (url != null) {
                        zipLoaders.put(base, zipLoader);
                    }
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
        }
        if (url == null && xsetZipLoader != null) {
            url = xsetZipLoader.findResource(fileName);
        }
        if (url == null && launchJarPath != null) {
            zipLoader = (URLClassLoader)zipLoaders.get(launchJarPath);
            if (zipLoader != null) {
                url = zipLoader.findResource(fileName);
            } else {
                try {
                    urls = new URL[]{new URL("file", null, launchJarPath)};
                    zipLoader = new URLClassLoader(urls);
                    url = zipLoader.findResource(fileName);
                    if (url == null && (classURL = (class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource).getResource("/" + launchJarPath)) != null) {
                        urls = new URL[]{classURL};
                        zipLoader = new URLClassLoader(urls);
                        url = zipLoader.findResource(fileName);
                    }
                    if (url != null) {
                        zipLoaders.put(launchJarPath, zipLoader);
                    }
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
        }
        if (url != null) {
            try {
                Resource res = ResourceLoader.createResource(url);
                if (res == null || res.getAbsolutePath().indexOf(path) == -1) {
                    return null;
                }
                if (fileName.endsWith("xset")) {
                    xsetZipLoader = zipLoader;
                }
                OSPLog.fine("Zip: " + XML.forwardSlash(res.getAbsolutePath()));
                return res;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private static Resource createClassResource(String name, Class type) {
        URL url;
        if (name.indexOf(":/") != -1) {
            return null;
        }
        String fullName = name;
        int i = name.indexOf("jar!/");
        if (i != -1) {
            name = name.substring(i + 5);
        }
        Resource res = null;
        try {
            url = type.getResource("/" + name);
            res = ResourceLoader.createResource(url);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (res == null) {
            try {
                url = type.getResource(name);
                res = ResourceLoader.createResource(url);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (res != null) {
            int n;
            String path = XML.forwardSlash(res.getAbsolutePath());
            if (path.indexOf("/jre") > -1 && path.indexOf("/lib") > -1) {
                return null;
            }
            if (path.indexOf(fullName) == -1) {
                return null;
            }
            if (name.endsWith("xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("Class resource: " + path);
            if (launchJarName == null && (n = path.indexOf(".jar!")) > -1) {
                path = path.substring(0, n + 4);
                launchJarName = path.substring(path.lastIndexOf("/") + 1);
                launchJarPath = path;
            }
        }
        return res;
    }

    private static Resource createResource(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        InputStream stream = url.openStream();
        if (stream.read() == -1) {
            return null;
        }
        stream.close();
        return new Resource(url);
    }

    private static Resource findResource(String path, Class type) {
        if (type == null) {
            type = class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource;
        }
        Resource res = null;
        if (cacheEnabled && (res = (Resource)resources.get(path)) != null) {
            OSPLog.finest("Found in cache: " + path);
            return res;
        }
        res = ResourceLoader.createFileResource(path);
        if (res != null || (res = ResourceLoader.createURLResource(path)) != null || (res = ResourceLoader.createZipResource(path)) != null || (res = ResourceLoader.createClassResource(path, type)) != null) {
            if (cacheEnabled) {
                resources.put(path, res);
            }
            return res;
        }
        return null;
    }

    private static Resource findResource_WC(String path, Class type) {
        Resource res = null;
        if (cacheEnabled && (res = (Resource)resources.get(path)) != null) {
            OSPLog.finest("Found in cache: " + path);
            return res;
        }
        try {
            res = ResourceLoader.createFileResource(path);
            if (res != null || (res = ResourceLoader.createURLResource(path)) != null || (res = ResourceLoader.createZipResource(path)) != null || (res = ResourceLoader.createClassResource(path, type)) != null) {
                if (cacheEnabled) {
                    resources.put(path, res);
                }
                return res;
            }
        }
        catch (AccessControlException ex) {
            try {
                URL url = type.getResource(path);
                return ResourceLoader.createResource(url);
            }
            catch (IOException ex1) {
                OSPLog.fine("Resource not found in" + path);
                return null;
            }
        }
        return null;
    }

    private static String getPath(String base, String name) {
        if (base == null) {
            base = "";
        }
        if (base.endsWith(".jar") || base.endsWith(".zip")) {
            base = base + "!";
        }
        String path = XML.getResolvedPath(name, base);
        if (System.getProperty("os.name").indexOf("Mac") > -1 && path.startsWith("file:/") && !path.startsWith("file:///")) {
            path = path.substring(6);
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = "file:///" + path;
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

