/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;

public class VideoCaptureTool
implements Tool {
    private VideoCaptureTool mediaCap;

    public VideoCaptureTool() {
    }

    protected VideoCaptureTool(boolean ignored) {
    }

    public boolean addFrame(BufferedImage image) {
        if (this.mediaCap != null) {
            return this.mediaCap.addFrame(image);
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (this.mediaCap == null) {
            try {
                Class<?> mediaClass = Class.forName("org.opensourcephysics.media.core.VideoGrabber");
                this.mediaCap = (VideoCaptureTool)mediaClass.newInstance();
            }
            catch (Exception ex) {
                OSPLog.info(ex.getMessage());
            }
        }
        if (this.mediaCap != null) {
            this.mediaCap.setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.mediaCap != null && this.mediaCap.isVisible();
    }

    public boolean canCapture() {
        return this.mediaCap != null;
    }

    public void send(Job job, Tool replyTo) throws RemoteException {
        BufferedImage image;
        if (job == null) {
            return;
        }
        XMLControlElement control = new XMLControlElement(job.getXML());
        String path = control.getString("imagepath");
        if (path != null && (image = ResourceLoader.getBufferedImage(path)) != null) {
            this.addFrame(image);
        }
    }
}

