function cm = get_fret_cm(denat,fmin,fmax)

cm = zeros(256,3);

% length of range of possible values
fret_range = fmax-fmin;

startfret = round((denat(end)-fmin)/fret_range*256);
endfret = round((denat(1)-fmin)/fret_range*256);

cmjet = jet(256);

cm(startfret+1:endfret,:) = resample(cmjet,endfret-startfret,256);

% fill rest of colormap
for j=1:startfret+1
    cm(j,:) = cmjet(1,:);
end;
for j=endfret+1:256
    cm(j,:) = cmjet(end,:);
end;

cm(cm>1)=1;
cm(cm<0)=0;
