function plot_x_kwtest(x,d)

set(gcf,'Color','white');hold all;
set(gca,'LineWidth',3);
set(gca,'FontSize',16);
set(gca,'TickLength',[0.03 0.05]);
set(gcf,'PaperPositionMode','auto')

y = [];
id = unique([d.id]);
for i=1:length(id)
    y(i).x = [];
end;
    
for i=1:length(x)
    y(d(i).id).x = [y(d(i).id).x, x(i)];
    y(d(i).id).i = i;
end;

for i=1:length(y)
    xm(i)=mean(y(i).x);
    xe(i)=std(y(i).x);
end;

for i=1:length(y)
    dd = (0.105*2)/(length(y(i).x)-1);
    plot(i-1-(-0.105:dd:0.105),y(i).x,d(y(i).i).linespec,'Color',[0 0 0],'LineWidth',1,'MarkerFaceColor',d(y(i).i).idclr,'MarkerSize',12);
    line([i-1-0.5 i-0.5],[xm(i) xm(i)],'Color',d(y(i).i).idclr,'LineWidth',2);
end;

[~,~,stats] = kruskalwallis(reshape(x,[8 3]),[],'off');
[results,~] = multcompare(stats,'CType','bonferroni','display','off');
pvals = results(:,end);


mx=1.8*max([y.x]);
axis([-0.5 2.5 0 1.2*mx]);
d1=mx/6;
line([0 2],[5*d1 5*d1],'Color',[0 0 0]);
line([0 0],[5*d1 4.8*d1],'Color',[0 0 0]);
line([2 2],[5*d1 4.8*d1],'Color',[0 0 0]);

line([1 2],[4.5*d1 4.5*d1],'Color',[0 0 0]);
line([1 1],[4.5*d1 4.3*d1],'Color',[0 0 0]);
line([2 2],[4.5*d1 4.3*d1],'Color',[0 0 0]);

line([0 1],[4*d1 4*d1],'Color',[0 0 0]);
line([0 0],[4*d1 3.8*d1],'Color',[0 0 0]);
line([1 1],[4*d1 3.8*d1],'Color',[0 0 0]);

if(pvals(1)<0.001) %1-2
    text(0.28,4.1*d1,'***','FontSize',18);
elseif(pvals(1)<0.01)
    text(0.36,4.1*d1,'**','FontSize',18);
elseif(pvals(1)<0.05)
    text(0.42,4.1*d1,'*','FontSize',18);
else
    text(0.3,4.2*d1,'n.s.','FontSize',12);
end;

if(pvals(2)<0.001) %1-3
    text(0.78,5.1*d1,'***','FontSize',18);
elseif(pvals(2)<0.01)
    text(0.86,5.1*d1,'**','FontSize',18);
elseif(pvals(2)<0.05)
    text(1.02,5.1*d1,'*','FontSize',18);
else
    text(0.8,5.2*d1,'n.s.','FontSize',12);
end;

if(pvals(3)<0.001) %2-3
    text(1.28,4.6*d1,'***','FontSize',18);
elseif(pvals(3)<0.01)
    text(1.36,4.6*d1,'**','FontSize',18);
elseif(pvals(3)<0.05)
    text(1.42,4.6*d1,'*','FontSize',18);
else
    text(1.3,4.7*d1,'n.s.','FontSize',12);
end;
