/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.algorithm;

import genomeviewer.algorithm.ContigLocation;
import java.awt.Color;

public class Contig {
    private String name;
    private int start;
    private int end;
    private byte strand;
    private Color color;
    private String ortholog;
    private String annotation;
    private String description;
    private int red;
    private int green;
    private int blue;
    private int identity = 0;

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStrand() {
        return this.strand;
    }

    public int getIdentity() {
        return this.identity;
    }

    public String getName() {
        return this.name;
    }

    public String getOrtholog() {
        return this.ortholog;
    }

    public void setOrtholog(String ortholog) {
        this.ortholog = ortholog;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getDescription() {
        return this.description;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newColor) {
        this.color = newColor;
    }

    public void setColor(int r, int g, int b) {
        this.color = new Color(r, g, b);
    }

    public void setIdentity(int identity) {
        this.identity = identity;
    }

    public void setIdentity(float identity) {
        this.identity = (int)identity;
    }

    public Contig() {
        System.out.println("This is contig class, please assign the name, location and annotation file!");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Contig(String name, String location, String annotation, String description) {
        this(name, location, annotation, description, "");
    }

    public Contig(String name, String location, String annotation, String description, String ortholog) {
        this.name = name;
        this.ortholog = ortholog;
        this.annotation = annotation;
        this.description = description;
        ContigLocation p = new ContigLocation(location);
        this.start = p.getStart();
        this.end = p.getEnd();
        this.strand = p.getStrand();
        do {
            this.red = (int)Math.round(235.0 * Math.random());
            this.green = (int)Math.round(255.0 * Math.random());
            this.blue = (int)Math.round(255.0 * Math.random());
        } while (this.red + this.green + this.blue > 720);
        this.color = new Color(this.red, this.green, this.blue);
    }

    public static void main(String[] args) {
        Contig contig = new Contig();
    }

    private void jbInit() throws Exception {
    }
}

