/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.algorithm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContigLocation {
    private Pattern p = Pattern.compile("^(\\w+):\\[(\\d+)\\,(\\d+)]$");
    private Pattern p2 = Pattern.compile("^(\\w+):(\\d+)\\,(\\d+)\\D");
    private int start;
    private int end;
    private byte strand;

    public ContigLocation() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public byte getStrand() {
        return this.strand;
    }

    public ContigLocation(String Location2) {
        boolean rs2;
        String location = Location2.replaceAll("<|>", "");
        Matcher m = this.p.matcher(location.replaceAll("\\s", ""));
        boolean rs = m.find();
        if (!rs && !(rs2 = (m = this.p2.matcher(location.replaceAll("\\s", ""))).find())) {
            System.err.println("err in finding in location at =(" + location.replaceAll("\\s", "") + ")");
            return;
        }
        if (m.groupCount() != 3) {
            System.err.println("error in location parsing!");
            return;
        }
        this.strand = m.group(1).equalsIgnoreCase("POSITIVE") ? (byte)1 : (byte)-1;
        this.start = Integer.parseInt(m.group(2));
        this.end = Integer.parseInt(m.group(3));
    }

    public static void main(String[] args) {
        ContigLocation location = new ContigLocation("Negative:[123,456]");
        System.out.println(location.getStart() + ".." + location.getEnd() + "  Strand:" + location.getStrand());
    }

    private void jbInit() throws Exception {
    }
}

