/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.algorithm;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOTools;

public class GenomeToProteome {
    private String fileFormat = "genbank";
    private String filePosition = "";
    private SequenceIterator iter;
    private int total = 0;
    private HashMap hashS = new HashMap();
    private List n = new ArrayList();
    private String tag = "locus_tag";

    public GenomeToProteome() {
    }

    public void setFilePosition(String filePosition) {
        this.filePosition = filePosition;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public GenomeToProteome(String filePosition, String fileFormat, String tag) {
        this.fileFormat = fileFormat;
        this.filePosition = filePosition;
        this.tag = tag;
        this.algorithm();
    }

    public void algorithm() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.filePosition));
            if (this.fileFormat.equalsIgnoreCase("genbank")) {
                this.iter = SeqIOTools.readGenbank(br);
            }
            if (this.fileFormat.equalsIgnoreCase("embl")) {
                this.iter = SeqIOTools.readEmbl(br);
            }
            if (this.fileFormat.equalsIgnoreCase("genbankxml")) {
                this.iter = SeqIOTools.readGenbankXml(br);
            }
            if (this.fileFormat.equalsIgnoreCase("swissprot")) {
                this.iter = SeqIOTools.readSwissprot(br);
            }
        }
        catch (Exception e) {
            System.out.println("error in parsing the file!");
        }
        while (this.iter.hasNext()) {
            try {
                Sequence seq = this.iter.nextSequence();
                Annotation anno = seq.getAnnotation();
                Iterator i = anno.keys().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                }
                i = seq.features();
                HashMap hash = new HashMap();
                while (i.hasNext()) {
                    hash.clear();
                    StrandedFeature theFeature = (StrandedFeature)i.next();
                    Annotation FeatureAnno = theFeature.getAnnotation();
                    Iterator j = FeatureAnno.keys().iterator();
                    while (j.hasNext()) {
                        Object key = j.next();
                        hash.put(key, FeatureAnno.getProperty(key).toString());
                    }
                    this.recordContent(hash, this.tag);
                }
                Collections.sort(this.n);
            }
            catch (Exception e) {
                System.out.println("err in process!");
            }
        }
    }

    public boolean writeToFile(String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            PrintWriter pw = new PrintWriter(fw);
            for (int q = 0; q < this.n.size(); ++q) {
                ++this.total;
                pw.println(">" + this.n.get(q).toString());
                pw.println(this.hashS.get(this.n.get(q).toString()).toString());
            }
            pw.close();
            fw.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    void recordContent(HashMap hash, String tag) {
        if (!hash.containsKey("translation")) {
            return;
        }
        if (!hash.containsKey("locus_tag") && !hash.containsKey("gene")) {
            return;
        }
        Iterator it = hash.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String cid = ((String)hash.get(id)).replaceAll("'", "");
            if (cid.equalsIgnoreCase("null")) {
                hash.put(id, "");
                continue;
            }
            hash.put(id, cid);
        }
        String annotation = "";
        if (hash.containsKey("product")) {
            annotation = hash.get("product").toString();
        } else if (hash.containsKey("function")) {
            annotation = hash.get("function").toString();
        } else if (hash.containsKey("note")) {
            annotation = hash.get("note").toString();
        }
        String title = "";
        title = hash.containsKey(tag) ? hash.get(tag).toString() : (tag.equals("locus_tag") ? hash.get("gene").toString() : hash.get("locus_tag").toString());
        title = title + "|" + annotation;
        this.hashS.put(title, hash.get("translation").toString());
        this.n.add(title);
    }

    public static void main(String[] args) {
        GenomeToProteome genometoproteome = new GenomeToProteome();
    }
}

