/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.algorithm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LinearRegression {
    private int enrich = 2;
    private Color c = Color.BLUE;
    private Color rc = Color.RED;
    private int ratio = 2000;
    private int px;
    private int py;
    private JSlider jsli1;
    private VisualPanel p;
    private float ax;
    private float ay;
    private float a;
    private float b;
    private ArrayList po;
    private long sx = 0L;
    private long sy = 0L;
    private int n = 0;

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public LinearRegression() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LinearRegression(ArrayList po) {
        this.po = po;
        this.n = po.size() / 2;
        this.calculation();
    }

    void calculation() {
        for (int i = 0; i < this.po.size(); i += 2) {
            this.sx += (long)((Integer)this.po.get(i)).intValue();
            this.sy += (long)((Integer)this.po.get(i + 1)).intValue();
        }
        this.ax = this.sx / (long)this.n;
        this.ay = this.sy / (long)this.n;
        float fu = 0.0f;
        float fd = 0.0f;
        for (int i = 0; i < this.po.size(); i += 2) {
            int qx = (Integer)this.po.get(i);
            int qy = (Integer)this.po.get(i + 1);
            fu += ((float)qx - this.ax) * ((float)qy - this.ay);
            fd += ((float)qx - this.ax) * ((float)qx - this.ax);
        }
        this.b = fu / fd;
        this.a = this.ay - this.b * this.ax;
    }

    public void visualization(JFrame jfFather) {
        JFrame f = new JFrame();
        this.p = new VisualPanel();
        JScrollPane jsp = new JScrollPane(this.p);
        jsp.setBorder(BorderFactory.createTitledBorder("regression line visualization"));
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createTitledBorder("Zoom In/Out"));
        this.jsli1 = new JSlider(0, 1000, 10000, 3000);
        this.jsli1.setPaintTicks(true);
        this.jsli1.setMajorTickSpacing(2000);
        this.jsli1.setMinorTickSpacing(1000);
        this.jsli1.setPaintLabels(true);
        this.jsli1.setPaintTrack(true);
        this.jsli1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LinearRegression.this.ratio = LinearRegression.this.jsli1.getValue();
                LinearRegression.this.p.repaint();
            }
        });
        jp.add(this.jsli1);
        f.getContentPane().add((Component)jsp, "Center");
        f.getContentPane().add((Component)jp, "North");
        f.pack();
        f.setSize(new Dimension(600, 600));
        f.setPreferredSize(new Dimension(600, 600));
        Dimension fSize = f.getPreferredSize();
        Dimension frmSize = jfFather.getSize();
        Point loc = jfFather.getLocation();
        f.setLocation((frmSize.width - fSize.width) / 2 + loc.x, (frmSize.height - fSize.height) / 2 + loc.y);
        f.setVisible(true);
        f.repaint();
    }

    public static void main(String[] args) {
        LinearRegression linearregression = new LinearRegression();
    }

    private void jbInit() throws Exception {
    }

    class VisualPanel
    extends JPanel {
        VisualPanel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            for (int i = 0; i < LinearRegression.this.po.size(); i += 2) {
                LinearRegression.this.px = (Integer)LinearRegression.this.po.get(i);
                LinearRegression.this.py = (Integer)LinearRegression.this.po.get(i + 1);
                Rectangle rt = new Rectangle(LinearRegression.this.px / LinearRegression.this.ratio, LinearRegression.this.py / LinearRegression.this.ratio, LinearRegression.this.enrich, LinearRegression.this.enrich);
                g2.setPaint(LinearRegression.this.c);
                g2.fill(rt);
            }
            g2.setPaint(LinearRegression.this.rc);
            g2.drawLine(0, (int)LinearRegression.this.a / LinearRegression.this.ratio, LinearRegression.this.px / LinearRegression.this.ratio, (int)(LinearRegression.this.a + LinearRegression.this.b * (float)LinearRegression.this.px) / LinearRegression.this.ratio);
            g2.drawLine(1, (int)LinearRegression.this.a / LinearRegression.this.ratio, 1 + LinearRegression.this.px / LinearRegression.this.ratio, (int)(LinearRegression.this.a + LinearRegression.this.b * (float)LinearRegression.this.px) / LinearRegression.this.ratio);
            g2.drawLine(0, 1 + (int)LinearRegression.this.a / LinearRegression.this.ratio, LinearRegression.this.px / LinearRegression.this.ratio, 1 + (int)(LinearRegression.this.a + LinearRegression.this.b * (float)LinearRegression.this.px) / LinearRegression.this.ratio);
            g2.drawString("y = " + LinearRegression.this.a + " + " + LinearRegression.this.b + " x ", 25, 15);
            this.setPreferredSize(new Dimension(LinearRegression.this.px / LinearRegression.this.ratio + 5, LinearRegression.this.py / LinearRegression.this.ratio + 5));
            this.setSize(new Dimension(LinearRegression.this.px / LinearRegression.this.ratio + 5, LinearRegression.this.py / LinearRegression.this.ratio + 5));
        }
    }
}

