/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.io;

import genomeviewer.algorithm.Contig;
import genomeviewer.io.dbInterface;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ToDB
implements dbInterface {
    private Connection conn;

    public ToDB() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            return;
        }
    }

    public boolean connect() {
        this.conn = null;
        try {
            Class.forName("org.hsqldb.jdbcDriver").newInstance();
            this.conn = DriverManager.getConnection("jdbc:hsqldb:file:db/dbA", "sa", "");
            return true;
        }
        catch (Exception e) {
            System.err.println("can not connect to the server,please check your configuration. If it is the first time to run this program on your computer, a data mirror or input sequences are required first.");
            return false;
        }
    }

    public boolean close() {
        if (this.conn != null) {
            try {
                this.conn.close();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public ArrayList readContig(String commandLine) {
        ArrayList<Contig> s = new ArrayList<Contig>(6000);
        try {
            Statement select = this.conn.createStatement();
            ResultSet result = select.executeQuery(commandLine);
            while (result.next()) {
                Contig co = new Contig(result.getString(2), result.getString(3), result.getString(4), result.getString(7), result.getString(5));
                s.add(co);
            }
        }
        catch (SQLException e) {
            System.out.println("can not read out contig data from database");
            return null;
        }
        return s;
    }

    public String select(String commandLine) {
        String re = null;
        try {
            Statement select = this.conn.createStatement();
            ResultSet result = select.executeQuery(commandLine);
            while (result.next()) {
                re = result.getString(1);
            }
        }
        catch (SQLException e) {
            System.out.println("can not read out contig data from database");
            return null;
        }
        return re;
    }

    public boolean execute2database(String commandLine) {
        String line = commandLine;
        try {
            Statement stat = this.conn.createStatement();
            int count = stat.executeUpdate(line);
        }
        catch (SQLException ex) {
            while (ex != null) {
                ex.printStackTrace();
                ex = ex.getNextException();
            }
        }
        return true;
    }

    public boolean write2database(HashMap hash, String species, String working) {
        Iterator it = hash.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String cid = ((String)hash.get(id)).replaceAll("'", "");
            if (cid.equalsIgnoreCase("null")) {
                hash.put(id, "");
                continue;
            }
            hash.put(id, cid);
        }
        if (!hash.containsKey("locus_tag") && hash.containsKey("gene")) {
            hash.put("locus_tag", hash.get("gene"));
        }
        String annotation = "";
        if (hash.containsKey("product")) {
            annotation = annotation + hash.get("product").toString();
        }
        if (hash.containsKey("note") && !hash.get("note").toString().equalsIgnoreCase(hash.get("locus_tag").toString()) && annotation.toLowerCase().indexOf(hash.get("note").toString().toLowerCase()) == -1) {
            annotation = annotation + " | " + hash.get("note").toString();
        }
        if (hash.containsKey("function")) {
            annotation = annotation + " | " + hash.get("function").toString();
        }
        String description = annotation;
        annotation = "";
        if (hash.containsKey("product")) {
            annotation = hash.get("product").toString();
        } else if (hash.containsKey("function")) {
            annotation = hash.get("function").toString();
        } else if (hash.containsKey("note")) {
            annotation = hash.get("note").toString();
        }
        String line = "INSERT INTO `" + working + "` (`species`,`locus_tag`,`location`,`annotation`,`ortholog`,`possible_ortholog`,`description`) " + "VALUES ('" + species + "','" + hash.get("locus_tag") + "','" + hash.get("location") + "','" + annotation + "','','','" + description + "')";
        if ("org.hsqldb.jdbcDriver".equals("org.hsqldb.jdbcDriver")) {
            line = "INSERT INTO " + working + " (species,locus_tag,location,annotation,ortholog,possible_ortholog,description) " + "VALUES ('" + species + "','" + hash.get("locus_tag") + "','" + hash.get("location") + "','" + annotation + "','','','" + description + "')";
        }
        try {
            Statement stat = this.conn.createStatement();
            int count = stat.executeUpdate(line);
        }
        catch (SQLException ex) {
            return false;
        }
        return true;
    }

    public void emptyTable(String working) {
        block3: {
            String line = "";
            try {
                line = "DROP TABLE IF EXISTS " + working;
                Statement stat = this.conn.createStatement();
                int count = stat.executeUpdate(line);
                line = "CREATE TABLE `" + working + "` (" + "`species` VARCHAR( 64 ) NOT NULL ,`locus_tag` VARCHAR( 64 ) NOT NULL default ''," + "`location` VARCHAR( 63 ) NOT NULL , `annotation` TEXT NOT NULL default ''," + "`ortholog` VARCHAR( 255 ) NOT NULL ,`possible_ortholog` VARCHAR( 255 ) NOT NULL," + " `description` TEXT NOT NULL default '',PRIMARY KEY (`locus_tag`)" + ") ENGINE = MYISAM DEFAULT CHARSET = latin1;";
                if ("org.hsqldb.jdbcDriver".equals("org.hsqldb.jdbcDriver")) {
                    line = "CREATE TABLE " + working + " (" + "species VARCHAR( 64 ) NOT NULL ,locus_tag VARCHAR( 64 ) NOT NULL ," + "location VARCHAR( 63 ) NOT NULL , annotation VARCHAR(512) NOT NULL," + "ortholog VARCHAR( 255 ) NOT NULL ,possible_ortholog VARCHAR( 255 ) NOT NULL," + " description VARCHAR(512) NOT NULL ,PRIMARY KEY (locus_tag)" + ");";
                }
                stat = this.conn.createStatement();
                count = stat.executeUpdate(line);
            }
            catch (SQLException ex) {
                if (ex == null) break block3;
                System.err.print("err in writting into database!");
                return;
            }
        }
    }

    public boolean dumpDB(String working, String filename) {
        String dumpscript = "";
        try {
            FileWriter fw = new FileWriter(filename);
            PrintWriter out = new PrintWriter(fw);
            Statement select = this.conn.createStatement();
            ResultSet result = select.executeQuery("select * from " + working);
            while (result.next()) {
                dumpscript = "INSERT INTO " + working + " VALUES('" + result.getString(1) + "','" + result.getString(2) + "','" + result.getString(3) + "','" + result.getString(4) + "','" + result.getString(5) + "','" + result.getString(6) + "','" + result.getString(7) + "')\n";
                out.print(dumpscript);
            }
            out.close();
            fw.close();
        }
        catch (SQLException e) {
            System.out.println("err in writing the dump file!");
            return false;
        }
        catch (IOException e) {
            System.out.println("err in writing the dump file!");
            return false;
        }
        return true;
    }

    public boolean restoreDB(String filename) {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String record = new String();
            while ((record = br.readLine()) != null) {
                Statement stat = this.conn.createStatement();
                int count = stat.executeUpdate(record);
            }
            br.close();
            fr.close();
        }
        catch (Exception e) {
            System.out.println("err in restoring the dump file!");
            return false;
        }
        return true;
    }

    private void jbInit() throws Exception {
    }
}

