/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.readfile.io;

import genomeviewer.io.ToDB;
import genomeviewer.io.dbInterface;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOTools;

public class GenomeDataHousing
implements dbInterface {
    private String organism;
    HashMap hash = new HashMap();
    int Total = 0;
    private SequenceIterator iter;

    public String getOrganism() {
        return this.organism;
    }

    public GenomeDataHousing() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public GenomeDataHousing(String fileposition, String species, String fileformat) {
        this(fileposition, species, fileformat, false);
    }

    public GenomeDataHousing(String fileposition, String species) {
        this(fileposition, species, "genbank", false);
    }

    public GenomeDataHousing(String fileposition, String species, String fileformat, boolean emptySwitch) {
        try {
            ToDB t;
            BufferedReader br = new BufferedReader(new FileReader(fileposition));
            if (fileformat.equalsIgnoreCase("genbank")) {
                this.iter = SeqIOTools.readGenbank(br);
            }
            if (fileformat.equalsIgnoreCase("embl")) {
                this.iter = SeqIOTools.readEmbl(br);
            }
            if (fileformat.equalsIgnoreCase("genbankxml")) {
                this.iter = SeqIOTools.readGenbankXml(br);
            }
            if (fileformat.equalsIgnoreCase("swissprot")) {
                this.iter = SeqIOTools.readSwissprot(br);
            }
            if (!(t = new ToDB()).connect()) {
                System.err.println("err in connecting DB, please check JRE and hsqldb.jar properly installed");
                return;
            }
            if (emptySwitch) {
                t.emptyTable("working");
            }
            while (this.iter.hasNext()) {
                Sequence seq = this.iter.nextSequence();
                Annotation anno = seq.getAnnotation();
                if (anno.containsProperty("SOURCE")) {
                    System.out.println("SOURCE:" + anno.getProperty("SOURCE"));
                    this.organism = anno.getProperty("SOURCE").toString();
                } else if (anno.containsProperty("OS")) {
                    System.out.println("OS:" + anno.getProperty("OS"));
                    this.organism = anno.getProperty("OS").toString();
                }
                Iterator i = seq.features();
                while (i.hasNext()) {
                    StrandedFeature theFeature = (StrandedFeature)i.next();
                    Annotation FeatureAnno = theFeature.getAnnotation();
                    if (!FeatureAnno.containsProperty("translation") || !theFeature.getType().equalsIgnoreCase("CDS")) continue;
                    ++this.Total;
                    this.hash.clear();
                    this.hash.put("type", theFeature.getType().toString());
                    this.hash.put("location", theFeature.getStrand().toString() + ":" + theFeature.getLocation().toString());
                    Iterator j = FeatureAnno.keys().iterator();
                    while (j.hasNext()) {
                        Object key = j.next();
                        this.hash.put(key, FeatureAnno.getProperty(key).toString());
                    }
                    t.write2database(this.hash, species, "working");
                }
            }
            t.close();
            System.out.println("======================" + this.Total + "=====================");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new GenomeDataHousing("/home/binf027/data/lmo/lmo.genome.2004_11_23.genbank", "lmo", "genbank", true);
    }

    private void jbInit() throws Exception {
    }
}

