/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.readfile.io;

import genomeviewer.io.ToDB;
import genomeviewer.readfile.io.BlastResultParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SWBlastResultParser
implements BlastResultParser {
    private int Threshold_Coverage = 75;
    private int Threshold_Identity = 30;
    Pattern p0 = Pattern.compile("^Query=\\s*([^|]+)\\|(.*)$");
    Pattern p1 = Pattern.compile("\\s*\\((\\d+)\\sletters\\)$");
    Pattern p2 = Pattern.compile("^>([^|]+)\\|(.*)$");
    Pattern p3 = Pattern.compile("^\\s+Length\\s=\\s(\\d+)$");
    Pattern p4 = Pattern.compile("^\\sScore\\s=\\s(\\d+)\\s.*Expect\\s=\\s(.+),.*$");
    Pattern p5 = Pattern.compile("^\\sIdentities\\s=\\s(\\d+)/(\\d+)\\s\\((\\d+)%\\)");
    private String queryID;
    private String queryDefi;
    private int queryLen;
    private int hitLen;
    private String hitID;
    private String hitDefi;
    private int identity;
    private int alnLen;
    private boolean ssflag = false;
    private int total = 0;
    private ToDB resultDB;

    public SWBlastResultParser() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SWBlastResultParser(String fn) {
        this(fn, false);
    }

    public SWBlastResultParser(String fn, int Thres_Cover, int Thres_Ident) {
        this(fn, false, Thres_Cover, Thres_Ident);
    }

    public SWBlastResultParser(String fn, boolean emptyFlag) {
        this.updateWorkingTable(fn, emptyFlag);
    }

    public SWBlastResultParser(String fn, boolean emptyFlag, int Thres_Cover, int Thres_Ident) {
        this.Threshold_Coverage = Thres_Cover;
        this.Threshold_Identity = Thres_Ident;
        this.updateWorkingTable(fn, emptyFlag);
    }

    public boolean updateWorkingTable(String fn, boolean emptyFlag) {
        if (emptyFlag) {
            this.resultDB = new ToDB();
            if (!this.resultDB.connect()) {
                System.out.println("err in connecting");
                return false;
            }
            String line = "UPDATE working SET ortholog= '', possible_ortholog='';";
            this.resultDB.execute2database(line);
            this.resultDB.close();
        }
        this.BlastResultParser_operation(fn);
        return true;
    }

    public void BlastResultParser_operation(String fn) {
        try {
            String line;
            this.resultDB = new ToDB();
            if (!this.resultDB.connect()) {
                System.out.println("err in connecting");
                return;
            }
            FileReader fr = new FileReader(fn);
            BufferedReader fin = new BufferedReader(fr);
            int i = 0;
            while ((line = fin.readLine()) != null) {
                ++i;
                this.parse(line);
            }
            this.parse("Query= end001|will finish the parsing");
            fin.close();
            fr.close();
            this.resultDB.close();
        }
        catch (IOException e) {
            System.out.println("Uh oh, got an IOException error! the file does not exist!\n" + e);
        }
    }

    void parse(String line) {
        Matcher m0 = this.p0.matcher(line);
        boolean rs = m0.find();
        if (rs) {
            ++this.total;
            this.queryID = m0.group(1);
            if (this.ssflag) {
                this.report_strainSpecific(this.queryID);
            }
            this.ssflag = true;
            return;
        }
        Matcher m1 = this.p1.matcher(line);
        rs = m1.find();
        if (rs) {
            this.queryLen = Integer.parseInt(m1.group(1));
            return;
        }
        Matcher m2 = this.p2.matcher(line);
        rs = m2.find();
        if (rs) {
            this.hitID = m2.group(1);
            return;
        }
        Matcher m3 = this.p3.matcher(line);
        rs = m3.find();
        if (rs) {
            this.hitLen = Integer.parseInt(m3.group(1));
            return;
        }
        Matcher m5 = this.p5.matcher(line);
        rs = m5.find();
        if (rs) {
            this.identity = Integer.parseInt(m5.group(3));
            this.alnLen = Integer.parseInt(m5.group(2));
            int coverageQ = 100 - Math.abs(100 - this.alnLen * 100 / this.queryLen);
            int coverageH = 100 - Math.abs(100 - this.alnLen * 100 / this.hitLen);
            if (this.identity >= this.Threshold_Identity && coverageQ >= this.Threshold_Coverage && coverageH >= this.Threshold_Coverage) {
                if (this.ssflag) {
                    this.report_orthologs(this.queryID, this.hitID);
                } else {
                    this.report_weakOrthologs(this.queryID, this.hitID);
                }
                this.ssflag = false;
            }
            return;
        }
    }

    void report_orthologs(String ss1, String ss2) {
        String reselect = "SELECT ortholog FROM working WHERE locus_tag='" + ss1 + "'";
        String result = this.resultDB.select(reselect);
        if (result == null) {
            System.out.println("Your alignment file is not prefectly in consistence with the sequence file,here the annotation of " + ss1 + " is omitted, so that the program can continue ");
            return;
        }
        if (result.indexOf(ss2) == -1) {
            ss2 = result + (result.equals("") ? "" : "|") + ss2;
            String line = "UPDATE working SET ortholog = '" + ss2 + "' WHERE locus_tag = '" + ss1 + "'";
            this.resultDB.execute2database(line);
        }
    }

    void report_weakOrthologs(String ss1, String ss2) {
        String reselect = "SELECT possible_ortholog FROM working WHERE locus_tag='" + ss1 + "'";
        String result = this.resultDB.select(reselect);
        if (result == null) {
            System.out.println("Your alignment file is not in consistence with your sequence file,here, the annotation of " + ss1 + " is omitted, so that the program can continue\n");
            return;
        }
        if (result.indexOf(ss2) == -1) {
            ss2 = result + (result.equals("") ? "" : "|") + ss2;
            String line = "UPDATE working SET possible_ortholog= '" + ss2 + "' WHERE locus_tag = '" + ss1 + "'";
            this.resultDB.execute2database(line);
        }
    }

    void report_strainSpecific(String s1) {
    }

    public static void main(String[] args) {
        new SWBlastResultParser("/home/binf027/jbproject/GenomeViewer/lmolwe.report", true);
    }

    private void jbInit() throws Exception {
    }
}

