/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.readfile.ui;

import genomeviewer.algorithm.GenomeToProteome;
import genomeviewer.readfile.ui.GenomeToProteomeUI_jButtonCovert_actionAdapter;
import genomeviewer.readfile.ui.GenomeToProteomeUI_jButtonFile1_actionAdapter;
import genomeviewer.readfile.ui.GenomeToProteomeUI_jButtonFile2_actionAdapter;
import genomeviewer.readfile.ui.GenomeToProteomeUI_jButtonReset_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class GenomeToProteomeUI
extends JPanel {
    private String[] fileFormats = new String[]{"Genbank", "Embl", "GenbankXML", "SwissProt"};
    private String fileformat = "Genbank";
    private String thisPath = ".";
    private File file1;
    private File file2;
    private JFrame thisFrame = new JFrame();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelRichSeq = new JLabel();
    JTextField jTextFieldRichSeq = new JTextField();
    JButton jButtonFile1 = new JButton();
    JLabel jLabelInFormat = new JLabel();
    JComboBox jComboBoxFileFormat = new JComboBox<String>(this.fileFormats);
    JPanel jPanelOut = new JPanel();
    JLabel jLabelProteome = new JLabel();
    JTextField jTextFieldFile2 = new JTextField();
    JButton jButtonFile2 = new JButton();
    JPanel jPanelPreview = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("Preview");
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabelTag = new JLabel();
    JTextField jTextFieldTag = new JTextField();
    JButton jButtonCovert = new JButton();
    JButton jButtonReset = new JButton();
    JScrollPane jsp = new JScrollPane();

    public GenomeToProteomeUI(JFrame thisFrame) {
        this.thisFrame = thisFrame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setMinimumSize(new Dimension(10, 50));
        this.jPanel1.setPreferredSize(new Dimension(10, 50));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Rich-format Sequence Input"));
        this.jLabelRichSeq.setText("RichSeq");
        this.jTextFieldRichSeq.setMinimumSize(new Dimension(150, 19));
        this.jTextFieldRichSeq.setPreferredSize(new Dimension(150, 19));
        this.jTextFieldRichSeq.setEditable(false);
        this.jTextFieldRichSeq.setText("");
        this.jButtonFile1.setPreferredSize(new Dimension(56, 20));
        this.jButtonFile1.setText("File");
        this.jButtonFile1.addActionListener(new GenomeToProteomeUI_jButtonFile1_actionAdapter(this));
        this.jLabelInFormat.setText("in Format");
        this.jComboBoxFileFormat.setMinimumSize(new Dimension(92, 20));
        this.jComboBoxFileFormat.setPreferredSize(new Dimension(92, 20));
        this.jComboBoxFileFormat.setToolTipText("Specify the input file format");
        this.jPanelOut.setBorder(BorderFactory.createTitledBorder("Proteome Sequence File (output)"));
        this.jPanelOut.setMinimumSize(new Dimension(560, 100));
        this.jPanelOut.setPreferredSize(new Dimension(560, 100));
        this.jPanelOut.setLayout(this.gridBagLayout2);
        this.jLabelProteome.setText("Proteome File");
        this.jTextFieldFile2.setMinimumSize(new Dimension(150, 19));
        this.jTextFieldFile2.setPreferredSize(new Dimension(150, 19));
        this.jTextFieldFile2.setEditable(false);
        this.jTextFieldFile2.setText("");
        this.jButtonFile2.setMinimumSize(new Dimension(56, 20));
        this.jButtonFile2.setPreferredSize(new Dimension(56, 20));
        this.jButtonFile2.setText("File");
        this.jButtonFile2.addActionListener(new GenomeToProteomeUI_jButtonFile2_actionAdapter(this));
        this.jPanelPreview.setBorder(this.titledBorder1);
        this.jLabelTag.setMaximumSize(new Dimension(85, 15));
        this.jLabelTag.setMinimumSize(new Dimension(85, 15));
        this.jLabelTag.setPreferredSize(new Dimension(85, 15));
        this.jLabelTag.setText("Specified Tag");
        this.jTextFieldTag.setMinimumSize(new Dimension(57, 19));
        this.jTextFieldTag.setText("locus_tag");
        this.jButtonCovert.setMinimumSize(new Dimension(83, 20));
        this.jButtonCovert.setPreferredSize(new Dimension(83, 20));
        this.jButtonCovert.setText("Convert");
        this.jButtonCovert.addActionListener(new GenomeToProteomeUI_jButtonCovert_actionAdapter(this));
        this.jButtonReset.setMaximumSize(new Dimension(88, 20));
        this.jButtonReset.setMinimumSize(new Dimension(88, 20));
        this.jButtonReset.setPreferredSize(new Dimension(88, 20));
        this.jButtonReset.setText("Reset");
        this.jButtonReset.addActionListener(new GenomeToProteomeUI_jButtonReset_actionAdapter(this));
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jTextFieldRichSeq, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonFile1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabelRichSeq, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.jPanel1.add((Component)this.jLabelInFormat, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.jPanel1.add((Component)this.jComboBoxFileFormat, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanelOut, "South");
        this.add((Component)this.jPanelPreview, "Center");
        this.jPanelOut.add((Component)this.jLabelTag, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.jPanelOut.add((Component)this.jButtonFile2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.jPanelOut.add((Component)this.jTextFieldFile2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelOut.add((Component)this.jLabelProteome, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.jPanelOut.add((Component)this.jTextFieldTag, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelOut.add((Component)this.jButtonCovert, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanelOut.add((Component)this.jButtonReset, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void jButtonFile1_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showOpenDialog(fc);
        if (result == 0) {
            this.file1 = fc.getSelectedFile();
            String fileName1 = this.file1.getName();
            this.thisPath = this.file1.getPath();
            this.jTextFieldRichSeq.setText(fileName1);
            this.showPreview(this.file1);
        }
    }

    boolean showPreview(File file1) {
        String content = "";
        try {
            FileReader fr = new FileReader(file1);
            BufferedReader br = new BufferedReader(fr);
            String line = new String();
            for (int l = 0; (line = br.readLine()) != null && l < 80; ++l) {
                content = content + line + "\n";
            }
            br.close();
            fr.close();
        }
        catch (Exception e) {
            System.out.println("err in reading the file");
            return false;
        }
        JEditorPane jep = new JEditorPane();
        jep.setText(content);
        this.jsp.setViewportView(jep);
        this.jsp.setPreferredSize(new Dimension(600, 280));
        this.jsp.setSize(new Dimension(600, 280));
        this.jPanelPreview.add(this.jsp);
        this.thisFrame.setSize(new Dimension(640, 500));
        this.thisFrame.repaint();
        return true;
    }

    public void jButtonFile2_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showSaveDialog(fc);
        if (result == 0) {
            this.file2 = fc.getSelectedFile();
            String fileName2 = this.file2.getName();
            this.thisPath = this.file2.getPath();
            this.jTextFieldFile2.setText(fileName2);
        }
    }

    public void jButtonReset_actionPerformed(ActionEvent e) {
        this.jTextFieldFile2.setText("");
        this.jTextFieldRichSeq.setText("");
        this.file1 = null;
        this.file2 = null;
        this.jComboBoxFileFormat.setSelectedIndex(0);
        this.jTextFieldTag.setText("locus_tag");
        this.repaint();
    }

    public void jButtonCovert_actionPerformed(ActionEvent e) {
        this.fileformat = this.fileFormats[this.jComboBoxFileFormat.getSelectedIndex()];
        if (this.file1 == null || this.file2 == null) {
            JOptionPane.showMessageDialog(this, "Specify filename first please");
            return;
        }
        GenomeToProteome gtopo = new GenomeToProteome(this.file1.getPath(), this.fileformat, this.jTextFieldTag.getText());
        if (!gtopo.writeToFile(this.file2.getPath())) {
            JOptionPane.showMessageDialog(this, "Error in operation!");
        } else {
            JOptionPane.showMessageDialog(this, "Operation completed!");
        }
    }
}

