/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.readfile.ui;

import genomeviewer.readfile.io.GenomeDataHousing;
import genomeviewer.readfile.io.SWBlastResultParser;
import genomeviewer.readfile.ui.OpenFrame_jBuFile1_actionAdapter;
import genomeviewer.readfile.ui.OpenFrame_jBuFile2_actionAdapter;
import genomeviewer.readfile.ui.OpenFrame_jBuFile3_actionAdapter;
import genomeviewer.readfile.ui.OpenFrame_jBuFile4_actionAdapter;
import genomeviewer.readfile.ui.OpenFrame_jBuOK_actionAdapter;
import genomeviewer.readfile.ui.ReadFileUI_jSliderCoverage_changeAdapter;
import genomeviewer.readfile.ui.ReadFileUI_jSliderIdentity_changeAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class ReadFileUI
extends JFrame
implements Runnable {
    private String org1 = "lmo";
    private String org2 = "lwe";
    private int pr = 0;
    private String thisPath = ".";
    private File file1;
    private File file2;
    private File file3;
    private File file4;
    private String[] fileFormats = new String[]{"Genbank", "Embl", "GenbankXML", "SwissProt"};
    private String fileformat = "genbank";
    BorderLayout borderLayout1 = new BorderLayout();
    JTextField jTextField1 = new JTextField();
    JTextField jTextField2 = new JTextField();
    JTextField jTextField3 = new JTextField();
    JTextField jTextField4 = new JTextField();
    JButton jBuFile1 = new JButton();
    JButton jBuFile2 = new JButton();
    JButton jBuFile3 = new JButton();
    JButton jBuFile4 = new JButton();
    JButton jBuOK = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    DefaultComboBoxModel jComboBox_fileformat_mode = new DefaultComboBoxModel<String>(this.fileFormats);
    JComboBox jComboBox_fileformat = new JComboBox(this.jComboBox_fileformat_mode);
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanelControl = new JPanel();
    JSlider jSliderCoverage = new JSlider();
    JLabel jLabelThresholdCoverage = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabelCoverageValue = new JLabel();
    JLabel jLabelThresholdIdentity = new JLabel();
    JLabel jLabelIdentityValue = new JLabel();
    JSlider jSliderIdentity = new JSlider();
    private JButton jb1;
    private JButton jb2;
    private JButton jb3;

    public File getFile1() {
        return this.file1;
    }

    public File getFile2() {
        return this.file2;
    }

    public File getFile3() {
        return this.file3;
    }

    public File getFile4() {
        return this.file4;
    }

    public String getFileFormat() {
        return this.fileformat;
    }

    public ReadFileUI(JButton jButtonDotAnalysis, JButton jBu_Compare, JButton jButtonReport) {
        try {
            this.jb1 = jButtonDotAnalysis;
            this.jb2 = jBu_Compare;
            this.jb3 = jButtonReport;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run() {
        int thres_coverage = this.jSliderCoverage.getValue();
        int thres_identity = this.jSliderIdentity.getValue();
        this.fileformat = (String)this.jComboBox_fileformat_mode.getSelectedItem();
        JFrame jf2 = new JFrame();
        jf2.setPreferredSize(new Dimension(300, 60));
        jf2.setSize(300, 60);
        jf2.setTitle("Progress...");
        JProgressBar jProgressBar1 = new JProgressBar();
        jProgressBar1.setIndeterminate(true);
        jProgressBar1.setOpaque(true);
        jProgressBar1.setStringPainted(true);
        jProgressBar1.setString("Data processing...");
        jf2.getContentPane().add(jProgressBar1);
        Dimension dlgSize = jf2.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        jf2.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        jf2.setVisible(true);
        this.jb1.setEnabled(false);
        this.jb2.setEnabled(false);
        this.jb3.setEnabled(false);
        new GenomeDataHousing(this.file1.getPath(), this.org1, this.fileformat, true);
        new GenomeDataHousing(this.file2.getPath(), this.org2, this.fileformat);
        new SWBlastResultParser(this.file3.getPath(), true, thres_coverage, thres_identity);
        new SWBlastResultParser(this.file4.getPath(), thres_coverage, thres_identity);
        this.jb1.setEnabled(true);
        jf2.setVisible(false);
        jf2.dispose();
        JOptionPane.showMessageDialog(this, "Please perform a Dot analysis first");
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jTextField1.setEditable(false);
        this.jTextField1.setText("");
        this.jTextField2.setEditable(false);
        this.jTextField2.setText("");
        this.jTextField3.setEditable(false);
        this.jTextField3.setText("");
        this.jTextField4.setEditable(false);
        this.jTextField4.setText("");
        this.jBuFile1.setBorder(BorderFactory.createEtchedBorder());
        this.jBuFile1.setText("File1");
        this.jBuFile1.addActionListener(new OpenFrame_jBuFile1_actionAdapter(this));
        this.jBuFile2.setBorder(BorderFactory.createEtchedBorder());
        this.jBuFile2.setText("File2");
        this.jBuFile2.addActionListener(new OpenFrame_jBuFile2_actionAdapter(this));
        this.jBuFile3.setBorder(BorderFactory.createEtchedBorder());
        this.jBuFile3.setText("BlastResult1");
        this.jBuFile3.addActionListener(new OpenFrame_jBuFile3_actionAdapter(this));
        this.jBuFile4.setBorder(BorderFactory.createEtchedBorder());
        this.jBuFile4.setText("BlastResult2");
        this.jBuFile4.addActionListener(new OpenFrame_jBuFile4_actionAdapter(this));
        this.jBuOK.setForeground(Color.blue);
        this.jBuOK.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jBuOK.setText("Let'GO!");
        this.jBuOK.addActionListener(new OpenFrame_jBuOK_actionAdapter(this));
        this.jLabel1.setText("Please upload your sequence files in format =");
        this.jLabel2.setText("Please upload the Blast result files");
        this.jComboBox_fileformat.setBackground(new Color(204, 204, 214));
        this.jComboBox_fileformat.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBox_fileformat.setPreferredSize(new Dimension(88, 20));
        this.jComboBox_fileformat.setToolTipText("assign the file format please");
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Sequence Import"));
        this.jPanelControl.setBorder(BorderFactory.createTitledBorder("Threshold"));
        this.jPanelControl.setPreferredSize(new Dimension(369, 80));
        this.jPanelControl.setLayout(this.gridBagLayout2);
        this.jPanel2.setPreferredSize(new Dimension(360, 160));
        this.jSliderCoverage.setValue(75);
        this.jSliderCoverage.addChangeListener(new ReadFileUI_jSliderCoverage_changeAdapter(this));
        this.jSliderCoverage.setMajorTickSpacing(10);
        this.jSliderCoverage.setMinorTickSpacing(5);
        this.jSliderCoverage.setPaintTicks(true);
        this.jSliderCoverage.setMinimumSize(new Dimension(200, 27));
        this.jSliderCoverage.setPreferredSize(new Dimension(200, 20));
        this.jSliderCoverage.setToolTipText("Change the ortholog threshold of coverage percent");
        this.jLabelThresholdCoverage.setToolTipText("");
        this.jLabelThresholdCoverage.setText("Coverage");
        this.jLabelCoverageValue.setText("75-125%");
        this.jLabelThresholdIdentity.setText("Identity");
        this.jLabelIdentityValue.setText("30%");
        this.jSliderIdentity.setMinimumSize(new Dimension(200, 16));
        this.jSliderIdentity.setToolTipText("Change the threhold of identity rate");
        this.jSliderIdentity.setValue(30);
        this.jSliderIdentity.addChangeListener(new ReadFileUI_jSliderIdentity_changeAdapter(this));
        this.setResizable(false);
        this.jPanel2.add((Component)this.jComboBox_fileformat, new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jTextField2, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jTextField1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jTextField3, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jBuFile3, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jTextField4, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jBuFile4, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 35, 10));
        this.jPanel2.add((Component)this.jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 58), 0, 10));
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jBuFile1, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 50, 0));
        this.jPanel2.add((Component)this.jBuFile2, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 50, 0));
        this.getContentPane().add((Component)this.jPanelControl, "South");
        this.jPanelControl.add((Component)this.jSliderCoverage, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelControl.add((Component)this.jLabelIdentityValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelControl.add((Component)this.jSliderIdentity, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelControl.add((Component)this.jLabelCoverageValue, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 7, 0), 0, 0));
        this.jPanelControl.add((Component)this.jBuOK, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 0, 10), 0, 0));
        this.jPanelControl.add((Component)this.jLabelThresholdIdentity, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelControl.add((Component)this.jLabelThresholdCoverage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 0, 8, 5), 0, 0));
        this.setSize(new Dimension(460, 290));
        this.setPreferredSize(new Dimension(369, 290));
    }

    public static void main(String[] args) {
        ReadFileUI frame1 = new ReadFileUI(null, null, null);
        frame1.setVisible(true);
    }

    public void jBuFile1_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showOpenDialog(fc);
        if (result == 0) {
            this.file1 = fc.getSelectedFile();
            String fileName1 = this.file1.getName();
            this.thisPath = this.file1.getPath();
            this.jTextField1.setText(fileName1);
        }
    }

    public void jBuFile2_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showOpenDialog(fc);
        if (result == 0) {
            this.file2 = fc.getSelectedFile();
            String fileName2 = this.file2.getName();
            this.thisPath = this.file2.getPath();
            this.jTextField2.setText(fileName2);
        }
    }

    public void jBuFile3_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showOpenDialog(fc);
        if (result == 0) {
            this.file3 = fc.getSelectedFile();
            String fileName3 = this.file3.getName();
            this.thisPath = this.file3.getPath();
            this.jTextField3.setText(fileName3);
        }
    }

    public void jBuFile4_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showOpenDialog(fc);
        if (result == 0) {
            this.file4 = fc.getSelectedFile();
            String fileName4 = this.file4.getName();
            this.thisPath = this.file4.getPath();
            this.jTextField4.setText(fileName4);
        }
    }

    public void jBuOK_actionPerformed(ActionEvent e) {
        int result1 = JOptionPane.showConfirmDialog(this, "Are you sure to input these files now?", "Confirm", 0, 3);
        if (result1 == 1) {
            return;
        }
        Thread at = new Thread(this);
        at.start();
        this.setVisible(false);
    }

    public void jSliderCoverage_stateChanged(ChangeEvent e) {
        int v = this.jSliderCoverage.getValue();
        this.jLabelCoverageValue.setText(v + "-" + (200 - v) + "%");
    }

    public void jSliderIdentity_stateChanged(ChangeEvent e) {
        int v = this.jSliderIdentity.getValue();
        this.jLabelIdentityValue.setText(v + "%");
    }
}

