/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.ui;

import java.util.Hashtable;
import java.util.Stack;
import java.util.regex.Pattern;

public class Annotation_Filter {
    Stack Nstack = new Stack();
    Stack Sstack = new Stack();
    String c = "";
    String test_string = "";

    public Annotation_Filter(String test_string, String filter) {
        this.test_string = test_string;
        this.c = filter;
        this.Nstack.clear();
        this.Sstack.clear();
    }

    public boolean get_result() {
        this.c = this.c + " OR <false>";
        String[] word = this.c.split(" ");
        if (word.length == 2) {
            return true;
        }
        if (word.length == 3) {
            return this.detect(word[0]);
        }
        Hashtable<String, Integer> calchar = new Hashtable<String, Integer>();
        calchar.put("AND", new Integer(1));
        calchar.put("NOT", new Integer(2));
        calchar.put("OR", new Integer(0));
        for (int i = 0; i < word.length; ++i) {
            String thisword = word[i].trim();
            if (thisword.equals("")) continue;
            if (!calchar.containsKey(thisword.toUpperCase())) {
                this.Nstack.add(thisword);
                continue;
            }
            thisword = thisword.toUpperCase();
            if (this.Sstack.isEmpty()) {
                this.Sstack.push(thisword);
                continue;
            }
            int thisSymbolP = (Integer)calchar.get(thisword);
            while (!this.Sstack.isEmpty() && (Integer)calchar.get(this.Sstack.lastElement().toString()) >= thisSymbolP) {
                String oldName1;
                String oldSymbol = this.Sstack.pop().toString();
                if (oldSymbol.equals("NOT")) {
                    oldName1 = this.Nstack.pop().toString();
                    this.Nstack.push(this.evaluate(oldSymbol, oldName1, ""));
                    continue;
                }
                oldName1 = this.Nstack.pop().toString();
                String oldName2 = this.Nstack.pop().toString();
                this.Nstack.push(this.evaluate(oldSymbol, oldName1, oldName2));
            }
            this.Sstack.push(thisword);
        }
        return this.Nstack.get(0).toString().equals("<true>");
    }

    private String evaluate(String Symbol, String Value1, String Value2) {
        if (Symbol.equals("OR") && (this.detect(Value1) || this.detect(Value2))) {
            return "<true>";
        }
        if (Symbol.equals("AND") && this.detect(Value1) && this.detect(Value2)) {
            return "<true>";
        }
        if (Symbol.equals("NOT") && !this.detect(Value1)) {
            return "<true>";
        }
        return "<false>";
    }

    private boolean detect(String Value) {
        if (Value.equals("<true>")) {
            return true;
        }
        if (Value.equals("<false>")) {
            return false;
        }
        Pattern p = Pattern.compile(Value, 2);
        return p.matcher(this.test_string).find();
    }

    public static void main(String[] args) {
        Annotation_Filter test = new Annotation_Filter("kinase proteinn", "nat OR NOT teintn");
        System.out.println(test.get_result());
    }
}

