/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.ui;

import genomeviewer.ui.ECreateIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JWindow;

public class ESplash
extends JWindow
implements Runnable {
    private Thread thread = null;
    private Image logo = null;
    private Color bg_color = new Color(255, 255, 255);
    private Toolkit toolkit = this.getToolkit();
    private int image_width;
    private int image_height;

    public ESplash() {
        this.logo = new ECreateIcon().getSplashImage();
        this.loadImage(this.logo, 0);
        this.image_width = this.logo.getWidth(this);
        this.image_height = this.logo.getHeight(this);
        this.setBackground(this.bg_color);
        this.setCursor(new Cursor(3));
        this.setSize(this.image_width + 10, this.image_height + 10);
        int Xpos = (this.toolkit.getScreenSize().width - this.getSize().width) / 2;
        int Ypos = (this.toolkit.getScreenSize().height - this.getSize().height) / 2;
        this.setBounds(Xpos, Ypos, this.getSize().width, this.getSize().height);
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ESplash.this.setVisible(false);
                ESplash.this.dispose();
            }
        });
        Timer timer = new Timer();
        timer.schedule((TimerTask)new RemindTask(), 3500L);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadImage(Image image, int ID) {
        if (image != null) {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, ID);
            try {
                tracker.waitForID(ID);
            }
            catch (InterruptedException _ex) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.logo, 5, 5, this.image_width, this.image_height, this);
        g.setColor(new Color(102, 102, 150));
        g.drawString("Initializing....", 7, this.getSize().height - 72);
        g.setColor(new Color(255, 255, 255));
        g.fillRect(5, this.getSize().height - 10, 310, 7);
        g.drawRect(5, this.getSize().height - 10, 310, 7);
        g.setColor(new Color(102, 102, 150));
        for (int n = 0; n <= 310; n += 5) {
            try {
                Thread.sleep(10L);
                g.fillRect(5, this.getSize().height - 10, n, 5);
                this.setAlwaysOnTop(true);
                this.setVisible(true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.setCursor(new Cursor(3));
        this.repaint();
    }

    public void stop() {
        this.thread = null;
        this.logo = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public static void main(String[] args) {
        Thread at = new Thread(new ESplash());
        at.start();
    }

    private void jbInit() throws Exception {
    }

    class RemindTask
    extends TimerTask {
        public void run() {
            ESplash.this.setVisible(false);
            ESplash.this.dispose();
        }
    }
}

