/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.ui;

import genomeviewer.algorithm.Contig;
import genomeviewer.ui.Annotation_Filter;
import genomeviewer.ui.FilterPanel_jButtonAND_actionAdapter;
import genomeviewer.ui.FilterPanel_jButtonBack_actionAdapter;
import genomeviewer.ui.FilterPanel_jButtonNOT_actionAdapter;
import genomeviewer.ui.FilterPanel_jButtonOR_actionAdapter;
import genomeviewer.ui.FilterPanel_jButton_GO_actionAdapter;
import genomeviewer.ui.FilterPanel_jButton_Manual_actionAdapter;
import genomeviewer.ui.FilterPanel_jButton_RESET_actionAdapter;
import genomeviewer.ui.FilterPanel_jComboBox_Line_itemAdapter;
import genomeviewer.ui.FilterPanel_jTextField_Constraint_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterPanel
extends JPanel {
    private ArrayList s1 = new ArrayList();
    private ArrayList s2 = new ArrayList();
    private Stack FilterHistory = new Stack();
    private JFrame FatherFrame = new JFrame();
    JPanel jPanel_Control = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel_Result = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane_Result = new JScrollPane();
    JLabel jLabel_Constraint = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField jTextField_Constraint = new JTextField();
    JButton jButton_GO = new JButton();
    JPanel jPanel_Status = new JPanel();
    JButton jButtonAND = new JButton();
    JButton jButtonOR = new JButton();
    JButton jButtonNOT = new JButton();
    JComboBox jComboBox_Line = new JComboBox();
    RepEditorPane jep = new RepEditorPane(100);
    JLabel jLabel_Show = new JLabel();
    JLabel jLabel_Lines = new JLabel();
    JButton jButton_RESET = new JButton();
    JButton jButtonBack = new JButton();
    JButton jButton_Manual = new JButton();

    public FilterPanel(ArrayList<Contig> s1, ArrayList<Contig> s2, JFrame FatherFrame) {
        try {
            this.s1 = s1;
            this.s2 = s2;
            this.FatherFrame = FatherFrame;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel_Control.setPreferredSize(new Dimension(10, 70));
        this.jPanel_Control.setBackground(new Color(204, 204, 255));
        this.jPanel_Control.setBorder(BorderFactory.createTitledBorder("Constraint"));
        this.jPanel_Control.setLayout(this.gridBagLayout1);
        this.jPanel_Result.setLayout(this.borderLayout2);
        this.jPanel_Result.setBackground(new Color(223, 223, 255));
        this.jPanel_Result.setBorder(BorderFactory.createTitledBorder("Result"));
        this.jLabel_Constraint.setText("Filter");
        this.jTextField_Constraint.setMinimumSize(new Dimension(300, 19));
        this.jTextField_Constraint.setPreferredSize(new Dimension(300, 19));
        this.jTextField_Constraint.setToolTipText("type the constraint here, which will be applied to parse the annotation");
        this.jTextField_Constraint.setText("");
        this.jTextField_Constraint.addActionListener(new FilterPanel_jTextField_Constraint_actionAdapter(this));
        this.jButton_GO.setBackground(new Color(223, 190, 239));
        this.jButton_GO.setBorder(BorderFactory.createEtchedBorder());
        this.jButton_GO.setMinimumSize(new Dimension(68, 19));
        this.jButton_GO.setPreferredSize(new Dimension(68, 19));
        this.jButton_GO.setText("GO");
        this.jButton_GO.addActionListener(new FilterPanel_jButton_GO_actionAdapter(this));
        this.jScrollPane_Result.getViewport().setBackground(new Color(223, 223, 255));
        this.jPanel_Status.setBackground(new Color(223, 223, 255));
        this.jButtonAND.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonAND.setMinimumSize(new Dimension(62, 19));
        this.jButtonAND.setPreferredSize(new Dimension(62, 19));
        this.jButtonAND.setText("AND");
        this.jButtonAND.addActionListener(new FilterPanel_jButtonAND_actionAdapter(this));
        this.jButtonOR.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonOR.setMinimumSize(new Dimension(62, 19));
        this.jButtonOR.setPreferredSize(new Dimension(62, 19));
        this.jButtonOR.setText("OR");
        this.jButtonOR.addActionListener(new FilterPanel_jButtonOR_actionAdapter(this));
        this.jButtonNOT.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonNOT.setMinimumSize(new Dimension(62, 19));
        this.jButtonNOT.setPreferredSize(new Dimension(62, 19));
        this.jButtonNOT.setText("NOT");
        this.jButtonNOT.addActionListener(new FilterPanel_jButtonNOT_actionAdapter(this));
        this.jComboBox_Line.setMinimumSize(new Dimension(52, 19));
        this.jComboBox_Line.setPreferredSize(new Dimension(52, 19));
        this.jComboBox_Line.setEditable(true);
        this.jComboBox_Line.addItemListener(new FilterPanel_jComboBox_Line_itemAdapter(this));
        this.jLabel_Show.setText("Show ");
        this.jLabel_Lines.setText("Lines");
        this.jButton_RESET.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jButton_RESET.setMinimumSize(new Dimension(68, 19));
        this.jButton_RESET.setPreferredSize(new Dimension(68, 19));
        this.jButton_RESET.setText("Reset");
        this.jButton_RESET.addActionListener(new FilterPanel_jButton_RESET_actionAdapter(this));
        this.jButtonBack.setEnabled(false);
        this.jButtonBack.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jButtonBack.setMinimumSize(new Dimension(68, 19));
        this.jButtonBack.setPreferredSize(new Dimension(68, 19));
        this.jButtonBack.setText("Back");
        this.jButtonBack.addActionListener(new FilterPanel_jButtonBack_actionAdapter(this));
        this.jButton_Manual.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jButton_Manual.setMinimumSize(new Dimension(78, 19));
        this.jButton_Manual.setPreferredSize(new Dimension(78, 19));
        this.jButton_Manual.setMnemonic('M');
        this.jButton_Manual.setText("Manual");
        this.jButton_Manual.addActionListener(new FilterPanel_jButton_Manual_actionAdapter(this));
        this.add((Component)this.jPanel_Result, "Center");
        this.jPanel_Result.add((Component)this.jScrollPane_Result, "Center");
        this.add((Component)this.jPanel_Control, "North");
        this.add((Component)this.jPanel_Status, "South");
        this.jPanel_Control.add((Component)this.jLabel_Constraint, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel_Control.add((Component)this.jButtonBack, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jButton_Manual, new GridBagConstraints(7, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jButtonOR, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jButtonAND, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jButtonNOT, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jButton_GO, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jButton_RESET, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jTextField_Constraint, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jLabel_Show, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jComboBox_Line, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Control.add((Component)this.jLabel_Lines, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jComboBox_Line.addItem("5");
        this.jComboBox_Line.addItem("10");
        this.jComboBox_Line.addItem("20");
        this.jComboBox_Line.addItem("50");
        this.jComboBox_Line.addItem("100");
        this.jComboBox_Line.addItem("200");
        this.jComboBox_Line.addItem("500");
        this.jComboBox_Line.addItem("800");
        this.jComboBox_Line.addItem("1000");
        this.jComboBox_Line.addItem("1500");
        this.jComboBox_Line.setSelectedIndex(3);
        this.jep = new RepEditorPane(100);
        this.jep.setEditable(false);
        this.jep.setPreferredSize(new Dimension(780, 620));
        this.jScrollPane_Result.setViewportView(this.jep);
    }

    public void jButtonAND_actionPerformed(ActionEvent actionEvent) {
        if (this.jTextField_Constraint.getText().endsWith(" AND ") || this.jTextField_Constraint.getText().endsWith(" OR ") || this.jTextField_Constraint.getText().endsWith(" NOT ")) {
            return;
        }
        this.jTextField_Constraint.setText(this.jTextField_Constraint.getText() + " AND ");
    }

    public void jButtonOR_actionPerformed(ActionEvent actionEvent) {
        if (this.jTextField_Constraint.getText().endsWith(" AND ") || this.jTextField_Constraint.getText().endsWith(" OR ") || this.jTextField_Constraint.getText().endsWith(" NOT ")) {
            return;
        }
        this.jTextField_Constraint.setText(this.jTextField_Constraint.getText() + " OR ");
    }

    public void jButtonNOT_actionPerformed(ActionEvent actionEvent) {
        if (this.jTextField_Constraint.getText().endsWith(" NOT ")) {
            return;
        }
        this.jTextField_Constraint.setText(this.jTextField_Constraint.getText() + " NOT ");
    }

    public void jComboBox_Line_itemStateChanged(ItemEvent itemEvent) {
        int l = Integer.parseInt(this.jComboBox_Line.getSelectedItem().toString());
        this.jep.changeLineNumber(l);
    }

    public void jButton_GO_actionPerformed(ActionEvent actionEvent) {
        String filterStr = this.jTextField_Constraint.getText();
        this.FilterHistory.push(filterStr);
        this.jButtonBack.setEnabled(true);
        this.jep.setFilter(filterStr);
        this.jScrollPane_Result.getVerticalScrollBar().setValue(0);
        this.jScrollPane_Result.repaint();
        this.jScrollPane_Result.getVerticalScrollBar().repaint();
    }

    public void jButton_RESET_actionPerformed(ActionEvent actionEvent) {
        this.jTextField_Constraint.setText("");
    }

    public void jButtonBack_actionPerformed(ActionEvent actionEvent) {
        this.jTextField_Constraint.setText(this.FilterHistory.pop().toString());
        if (this.FilterHistory.isEmpty()) {
            this.jButtonBack.setEnabled(false);
        }
        this.jep.setFilter(this.jTextField_Constraint.getText());
        this.jep.showLineNumber(Integer.parseInt(this.jComboBox_Line.getSelectedItem().toString()));
    }

    public void jTextField_Constraint_actionPerformed(ActionEvent actionEvent) {
        this.jButton_GO_actionPerformed(actionEvent);
    }

    public void jButton_Manual_actionPerformed(ActionEvent actionEvent) {
        try {
            JFrame jf_manual = new JFrame();
            jf_manual.setTitle("Annotation Browser Manual");
            File file = new File("document/InGeno_Annotation_Browser_Manual.html");
            String str = file.getAbsolutePath();
            str = "file:" + str;
            JEditorPane jep_manual = new JEditorPane("text/html", "");
            JScrollPane jsp_manual = new JScrollPane(jep_manual);
            jep_manual.setPage(str);
            jf_manual.getContentPane().setLayout(new BorderLayout());
            jf_manual.getContentPane().add((Component)jsp_manual, "Center");
            jf_manual.pack();
            jf_manual.setPreferredSize(new Dimension(800, 600));
            Dimension dlgSize = jf_manual.getPreferredSize();
            Dimension frmSize = this.FatherFrame.getSize();
            Point loc = this.FatherFrame.getLocation();
            jf_manual.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            jf_manual.pack();
            jf_manual.setVisible(true);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Tutorial files missing", "Tutorial files or folders not existed!", 1);
        }
    }

    class RepEditorPane
    extends JEditorPane {
        private int line = 100;
        private String filter = "";

        public void setFilter(String filterStr) {
            this.filter = filterStr.trim();
            this.changeLineNumber(this.line);
        }

        public RepEditorPane(int lineno) {
            this.line = lineno;
            this.setContentType("text/html");
            this.showLineNumber(this.line);
        }

        public void changeLineNumber(int lineno) {
            this.showLineNumber(lineno);
        }

        public void showLineNumber(int lineno) {
            this.line = lineno;
            String content = "";
            if (this.getContentType().equalsIgnoreCase("text/html")) {
                Contig c1;
                int i;
                content = content + "<pre><b><font color=red>Genome1</font></b>\n";
                int t = 0;
                for (i = 0; i < FilterPanel.this.s1.size(); ++i) {
                    c1 = (Contig)FilterPanel.this.s1.get(i);
                    if (!this.test_constraint(c1.getDescription(), this.filter)) continue;
                    if (++t > lineno) break;
                    content = content + "<b>" + c1.getName() + "</b>\t" + c1.getDescription() + "\n";
                }
                if (t == 0) {
                    content = content + "no hits found in the annotation of the Genome1!";
                }
                content = content + "\n<b><font color=red>Genome2</font></b>\n";
                t = 0;
                for (i = 0; i < FilterPanel.this.s2.size(); ++i) {
                    c1 = (Contig)FilterPanel.this.s2.get(i);
                    if (!this.test_constraint(c1.getDescription(), this.filter)) continue;
                    if (++t > lineno) break;
                    content = content + "<b>" + c1.getName() + "</b>\t" + c1.getDescription() + "\n";
                }
                if (t == 0) {
                    content = content + "no hits found in the annotation of the Genome2!";
                }
                content = content + "\n</pre>";
            } else {
                Contig c1;
                int i;
                content = "Genome1\n";
                int t = 0;
                for (i = 0; i < FilterPanel.this.s1.size(); ++i) {
                    c1 = (Contig)FilterPanel.this.s1.get(i);
                    if (!this.test_constraint(c1.getDescription(), this.filter)) continue;
                    if (++t > lineno) break;
                    content = content + c1.getName() + "\t" + c1.getDescription() + "\n";
                }
                content = content + "\nGenome2\n";
                t = 0;
                for (i = 0; i < FilterPanel.this.s2.size(); ++i) {
                    c1 = (Contig)FilterPanel.this.s2.get(i);
                    if (!this.test_constraint(c1.getDescription(), this.filter)) continue;
                    if (++t > lineno) break;
                    content = content + c1.getName() + "\t" + c1.getDescription() + "\n";
                }
            }
            this.setText(content);
        }

        private boolean test_constraint(String test_string, String filter) {
            if (filter.trim().equals("")) {
                return true;
            }
            return new Annotation_Filter(test_string, filter).get_result();
        }
    }
}

