/*
 * Decompiled with CFR 0.152.
 */
package genomeviewer.ui;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import genomeviewer.algorithm.CharacterBlock;
import genomeviewer.algorithm.Contig;
import genomeviewer.algorithm.LineElement;
import genomeviewer.algorithm.LinearRegression;
import genomeviewer.algorithm.MouseSelected;
import genomeviewer.algorithm.SplitToWords;
import genomeviewer.io.ToDB;
import genomeviewer.io.dbInterface;
import genomeviewer.readfile.ui.GenomeToProteomeUI;
import genomeviewer.readfile.ui.ReadFileUI;
import genomeviewer.ui.FilterPanel;
import genomeviewer.ui.ShowLicenseInformation;
import genomeviewer.ui.jEdit;
import genomeviewer.ui.mainFrame_AboutBox;
import genomeviewer.ui.mainFrame_jBu_Compare_actionAdapter;
import genomeviewer.ui.mainFrame_jBu_dotBColor_actionAdapter;
import genomeviewer.ui.mainFrame_jBu_dotColor_actionAdapter;
import genomeviewer.ui.mainFrame_jButton1_actionAdapter;
import genomeviewer.ui.mainFrame_jButtonCharacter_actionAdapter;
import genomeviewer.ui.mainFrame_jButtonCleanData_actionAdapter;
import genomeviewer.ui.mainFrame_jButtonDotAnalysis_actionAdapter;
import genomeviewer.ui.mainFrame_jButtonReport_actionAdapter;
import genomeviewer.ui.mainFrame_jButton_CGraphics_actionAdapter;
import genomeviewer.ui.mainFrame_jButton_colorPallet_actionAdapter;
import genomeviewer.ui.mainFrame_jCheckBoxEnrich_changeAdapter;
import genomeviewer.ui.mainFrame_jMenuFileExit_ActionAdapter;
import genomeviewer.ui.mainFrame_jMenuHelpAbout_ActionAdapter;
import genomeviewer.ui.mainFrame_jMenuItem1_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItem2_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemCharacters_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemClean_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemEditor_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemGenomeEnrich_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemGtoP_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemImportData_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemMakeMirror_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemResetOptions_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemResoreMirror_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItemSavePicture_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuItem_KeywordFilter_actionAdapter;
import genomeviewer.ui.mainFrame_jMenuLicense_actionAdapter;
import genomeviewer.ui.mainFrame_jRadioButtonColor1_itemAdapter;
import genomeviewer.ui.mainFrame_jRadioButtonColor2_itemAdapter;
import genomeviewer.ui.mainFrame_jRadioButtonColor3_itemAdapter;
import genomeviewer.ui.mainFrame_jRadioButtonColor4_itemAdapter;
import genomeviewer.ui.mainFrame_jScrollBar_Cgenome1_adjustmentAdapter;
import genomeviewer.ui.mainFrame_jScrollBar_Cgenome2_adjustmentAdapter;
import genomeviewer.ui.mainFrame_jSli_DotA_Zoom_changeAdapter;
import genomeviewer.ui.mainFrame_jSli_enrich_changeAdapter;
import genomeviewer.ui.mainFrame_jSlider1_changeAdapter;
import genomeviewer.ui.mainFrame_jSlider_Compare_row2D_changeAdapter;
import genomeviewer.ui.mainFrame_jSlider_compareZoom_changeAdapter;
import genomeviewer.ui.mainFrame_jSlider_hideThres_changeAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class mainFrame
extends JFrame
implements dbInterface {
    private static mainFrame _INSTANCE = null;
    private int mode_selected = 1;
    private ArrayList s1 = null;
    private ArrayList s2 = null;
    private ArrayList characters = new ArrayList();
    private boolean sc_flag = false;
    private int genome_enrich = 1;
    private ArrayList lines = new ArrayList(3000);
    private String org1 = "lmo";
    private String org2 = "lwe";
    private int maxLen1;
    private int maxLen2;
    private int maxLen;
    private int DotARatio = 100;
    private int row1 = 50;
    private int row2 = 250;
    private Color DotColor = Color.BLACK;
    private Color DotBColor = Color.WHITE;
    private int DotenRich = 1;
    private JButton[] jBu = new JButton[7];
    private String ct = "";
    private int shiftG1 = 0;
    private int shiftG2 = 0;
    private int visual_ratio = 300;
    private float a;
    private float b;
    private Color[] colorPlan = new Color[7];
    private float threshold_colorCluster = 100.0f;
    ArrayList desList = new ArrayList();
    private HashMap hs1 = new HashMap(3000, 0.8f);
    private HashMap hs2 = new HashMap(3000, 0.8f);
    private String thisPath = ".";
    private ComparePane comparePane = new ComparePane();
    private JPanel jpDotP = new JPanel();
    private ArrayList colorDescription = new ArrayList();
    private ArrayList colorName = new ArrayList();
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton jButtonOpen = new JButton();
    JButton jButtonCleanData = new JButton();
    JButton jButtonCharacter = new JButton();
    ImageIcon image1 = new ImageIcon(mainFrame.class.getResource("img/fileopen.png"));
    ImageIcon image2 = new ImageIcon(mainFrame.class.getResource("img/cleanmemory.png"));
    ImageIcon image3 = new ImageIcon(mainFrame.class.getResource("img/character.png"));
    ImageIcon image4 = new ImageIcon(mainFrame.class.getResource("img/dotanalysis.png"));
    ImageIcon image5 = new ImageIcon(mainFrame.class.getResource("img/compare.png"));
    ImageIcon image6 = new ImageIcon(mainFrame.class.getResource("img/report.png"));
    ImageIcon image7 = new ImageIcon(mainFrame.class.getResource("img/aboutme.png"));
    ImageIcon image8 = new ImageIcon(mainFrame.class.getResource("img/genometoproteome.png"));
    ImageIcon image9 = new ImageIcon(mainFrame.class.getResource("img/makeasnapshot.png"));
    ImageIcon image10 = new ImageIcon(mainFrame.class.getResource("img/loadasnapshot.png"));
    ImageIcon image11 = new ImageIcon(mainFrame.class.getResource("img/filesavepicture.png"));
    ImageIcon image12 = new ImageIcon(mainFrame.class.getResource("img/enrich.png"));
    ImageIcon image13 = new ImageIcon(mainFrame.class.getResource("img/theme.png"));
    ImageIcon image14 = new ImageIcon(mainFrame.class.getResource("img/reset.png"));
    ImageIcon image15 = new ImageIcon(mainFrame.class.getResource("img/exit.png"));
    ImageIcon image16 = new ImageIcon(mainFrame.class.getResource("img/editor.png"));
    ImageIcon image17 = new ImageIcon(mainFrame.class.getResource("img/modesetting.png"));
    ImageIcon image18 = new ImageIcon(mainFrame.class.getResource("img/info.png"));
    JLabel statusBar = new JLabel();
    JTabbedPane jTP_viewer = new JTabbedPane();
    JPanel jP_analysis = new JPanel();
    JPanel jP_compare = new JPanel();
    JPanel jP_report = new JPanel();
    JButton jButtonDotAnalysis = new JButton();
    JPanel jPanel_DotA = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jP_DotA_Upper = new JPanel();
    JPanel jP_DotA_Unter = new JPanel();
    BorderLayout borderLayout_analysis = new BorderLayout();
    JScrollPane jSP_DotA = new JScrollPane();
    BorderLayout borderLayout4 = new BorderLayout();
    JSlider jSli_DotA_Zoom = new JSlider();
    JButton jBu_dotColor = new JButton();
    JColorChooser Dotc;
    JColorChooser DotBc;
    JButton jBu_dotBColor = new JButton();
    JSlider jSli_enrich = new JSlider();
    JLabel jLabel_Zoom = new JLabel();
    JLabel jLabel_enrich = new JLabel();
    JButton jBu_Compare = new JButton();
    BorderLayout borderLayout_compare = new BorderLayout();
    JPanel jPanel_compare_control = new JPanel();
    JPanel jPanel_compare_main = new JPanel();
    JScrollPane jSP_compare = new JScrollPane();
    BorderLayout borderLayout_comare_main = new BorderLayout();
    GridBagLayout gridBagLayout_compare_control = new GridBagLayout();
    JLabel jLabel_scroll_genome1 = new JLabel();
    JLabel jLabel_scroll_genome2 = new JLabel();
    JScrollBar jScrollBar_Cgenome1 = new JScrollBar();
    JScrollBar jScrollBar_Cgenome2 = new JScrollBar();
    JLabel jLabel_compareZoom = new JLabel();
    JSlider jSlider_compareZoom = new JSlider();
    JLabel jLabel_row2_pos = new JLabel();
    JSlider jSlider_Compare_row2D = new JSlider();
    JLabel jLabel_ColorPlan = new JLabel();
    JRadioButton jRadioButtonColor1 = new JRadioButton();
    JRadioButton jRadioButtonColor2 = new JRadioButton();
    JRadioButton jRadioButtonColor3 = new JRadioButton();
    JRadioButton jRadioButtonColor4 = new JRadioButton();
    JSlider jSlider_colorThreshold = new JSlider();
    ButtonGroup buttonGroup_colorCluster = new ButtonGroup();
    JTextField jTextField_Cthreshod = new JTextField();
    JButton jButton_colorPallet = new JButton();
    JButton jButtonReport = new JButton();
    JPanel jPanelReport = new JPanel();
    BorderLayout borderLayoutReport = new BorderLayout();
    JScrollPane jScrollPane_reportPane = new JScrollPane();
    JEditorPane jEditorPane_report = new JEditorPane();
    BorderLayout borderLayout3 = new BorderLayout();
    JButton jButton_CReset = new JButton();
    JFrame thisFrame;
    JMenuItem jMenuItemImportData = new JMenuItem();
    JMenu jMenuOptions = new JMenu();
    JMenuItem jMenuItemCharacters = new JMenuItem();
    JSlider jSlider_hideThres = new JSlider();
    JLabel jLabelHideThres = new JLabel();
    JCheckBox jCheckBoxEnrich = new JCheckBox();
    JMenuItem jMenuItemGenomeEnrich = new JMenuItem();
    JMenuItem jMenuItemResetOptions = new JMenuItem();
    JMenuItem jMenuItemMakeMirror = new JMenuItem();
    JMenuItem jMenuItemResoreMirror = new JMenuItem();
    JMenuItem jMenuItemClean = new JMenuItem();
    JMenu jMenuTools = new JMenu();
    JMenuItem jMenuItemGtoP = new JMenuItem();
    JMenu jMenuThemes = new JMenu();
    JMenu jMenuModes = new JMenu();
    JMenuItem jMenuItemSavePicture = new JMenuItem();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem_KeywordFilter = new JMenuItem();
    JMenuItem jMenuItemEditor = new JMenuItem();
    JMenuItem jMenuLicense = new JMenuItem();

    public void saveComponentToJPEG(Component c, String fileName) {
        try {
            Dimension size = c.getSize();
            BufferedImage image = new BufferedImage(size.width, size.height, 1);
            c.printAll(image.getGraphics());
            FileOutputStream bos = new FileOutputStream(fileName);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bos);
            JPEGEncodeParam jep = encoder.getDefaultJPEGEncodeParam(image);
            jep.setQuality(1.0f, false);
            encoder.encode(image);
            ((OutputStream)bos).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public mainFrame() {
        try {
            this.setDefaultCloseOperation(3);
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static mainFrame getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new mainFrame();
        }
        return _INSTANCE;
    }

    public void dowinLookAndFeel(String wlf) {
        try {
            UIManager.setLookAndFeel(wlf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exc) {
            System.out.println("error during the new theme initiation, your system does not support this theme, please try another one!");
        }
    }

    void initMenuThemes() {
        JMenuItem themeSystem = new JMenuItem("System");
        JMenuItem themeMetal = new JMenuItem("Metal");
        JMenuItem themeMotif = new JMenuItem("Motif");
        JMenuItem themeGTK = new JMenuItem("GTK");
        JMenuItem themeLiquid = new JMenuItem("Liquid");
        this.jMenuThemes.setText("Themes");
        this.jMenuThemes.setToolTipText("Change themes (LookAndFeel)");
        this.jMenuThemes.setMnemonic('T');
        this.jMenuThemes.add(themeSystem);
        this.jMenuThemes.add(themeMetal);
        this.jMenuThemes.add(themeMotif);
        this.jMenuThemes.add(themeGTK);
        this.jMenuThemes.add(themeLiquid);
        themeSystem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainFrame.this.dowinLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        });
        themeMetal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainFrame.this.dowinLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                try {
                    MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        themeGTK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainFrame.this.dowinLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
        });
        themeMotif.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainFrame.this.dowinLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            }
        });
        themeLiquid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainFrame.this.dowinLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
                try {
                    LiquidLookAndFeel.setLiquidDecorations(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JMenuItem submenu_mode1 = new JMenuItem("Regression Mode");
        submenu_mode1.setToolTipText("Mode according to the distance to the regression line, which is suitable for two close related genomes");
        JMenuItem submenu_mode2 = new JMenuItem("Absolute Mode");
        submenu_mode2.setToolTipText("Mode according to the absolute distance between orthologoues, which is suitable for distantly related genomes");
        this.jMenuModes.setText("Modes");
        this.jMenuModes.setToolTipText("Change modes");
        this.jMenuModes.setMnemonic('M');
        this.jMenuModes.add(submenu_mode1);
        this.jMenuModes.add(submenu_mode2);
        submenu_mode1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainFrame.this.mode_selected = 1;
                mainFrame.this.CalculateLines();
                mainFrame.this.thisFrame.repaint();
            }
        });
        submenu_mode2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainFrame.this.mode_selected = 2;
                mainFrame.this.CalculateLines();
                mainFrame.this.thisFrame.repaint();
            }
        });
    }

    private void jbInit() throws Exception {
        this.thisFrame = this;
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(780, 650));
        this.setTitle("inGeno Viewer");
        this.statusBar.setToolTipText("");
        this.statusBar.setText("Welcome to inGeno...");
        this.initMenuThemes();
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setIcon(this.image15);
        this.jMenuFileExit.setMnemonic('X');
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        this.jMenuFileExit.addActionListener(new mainFrame_jMenuFileExit_ActionAdapter(this));
        this.jMenuHelp.setMnemonic('H');
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setIcon(this.image7);
        this.jMenuHelpAbout.setMnemonic('A');
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new mainFrame_jMenuHelpAbout_ActionAdapter(this));
        this.jMenuItemImportData.setIcon(this.image1);
        this.jMenuItemImportData.setMnemonic('I');
        this.jMenuItemImportData.setText("Import data from disk");
        this.jMenuItemImportData.setAccelerator(KeyStroke.getKeyStroke(73, 2, false));
        this.jMenuItemImportData.addActionListener(new mainFrame_jMenuItemImportData_actionAdapter(this));
        this.jButtonCharacter.addActionListener(new mainFrame_jButtonCharacter_actionAdapter(this));
        this.jMenuOptions.setMnemonic('O');
        this.jMenuOptions.setText("Options");
        this.jMenuItemCharacters.setToolTipText("Show function character of the genes");
        this.jMenuItemCharacters.setIcon(this.image3);
        this.jMenuItemCharacters.setMnemonic('F');
        this.jMenuItemCharacters.setText("Function");
        this.jMenuItemCharacters.addActionListener(new mainFrame_jMenuItemCharacters_actionAdapter(this));
        this.jSlider_hideThres.setOrientation(1);
        this.jSlider_hideThres.setMaximum(6);
        this.jSlider_hideThres.setPreferredSize(new Dimension(16, 70));
        this.jSlider_hideThres.setToolTipText("Threshold for hiding insignificant parts");
        this.jSlider_hideThres.setValue(4);
        this.jSlider_hideThres.addChangeListener(new mainFrame_jSlider_hideThres_changeAdapter(this));
        this.jLabelHideThres.setText("Hide");
        this.jCheckBoxEnrich.setSelected(true);
        this.jCheckBoxEnrich.setText("Enrichment");
        this.jCheckBoxEnrich.addChangeListener(new mainFrame_jCheckBoxEnrich_changeAdapter(this));
        this.jMenuItemGenomeEnrich.setIcon(this.image12);
        this.jMenuItemGenomeEnrich.setMnemonic('G');
        this.jMenuItemGenomeEnrich.setText("Genome Enrich.");
        this.jMenuItemGenomeEnrich.addActionListener(new mainFrame_jMenuItemGenomeEnrich_actionAdapter(this));
        this.jMenuItemResetOptions.setIcon(this.image14);
        this.jMenuItemResetOptions.setMnemonic('R');
        this.jMenuItemResetOptions.setText("Reset Options");
        this.jMenuItemResetOptions.addActionListener(new mainFrame_jMenuItemResetOptions_actionAdapter(this));
        this.jBu_Compare.setEnabled(false);
        this.jMenuItem2.setEnabled(false);
        this.jBu_Compare.setIcon(this.image5);
        this.jButtonReport.setEnabled(false);
        this.jButtonReport.setIcon(this.image6);
        this.jMenuItemMakeMirror.setIcon(this.image9);
        this.jMenuItemMakeMirror.setMnemonic('M');
        this.jMenuItemMakeMirror.setText("Make a memory snapshot");
        this.jMenuItemMakeMirror.setAccelerator(KeyStroke.getKeyStroke(77, 2, false));
        this.jMenuItemMakeMirror.addActionListener(new mainFrame_jMenuItemMakeMirror_actionAdapter(this));
        this.jMenuItemResoreMirror.setIcon(this.image10);
        this.jMenuItemResoreMirror.setMnemonic('R');
        this.jMenuItemResoreMirror.setText("Restore from a snapshot");
        this.jMenuItemResoreMirror.setAccelerator(KeyStroke.getKeyStroke(82, 2, false));
        this.jMenuItemResoreMirror.addActionListener(new mainFrame_jMenuItemResoreMirror_actionAdapter(this));
        this.jMenuItemClean.setIcon(this.image2);
        this.jMenuItemClean.setMnemonic('C');
        this.jMenuItemClean.setText("Clean");
        this.jMenuItemClean.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        this.jMenuItemClean.addActionListener(new mainFrame_jMenuItemClean_actionAdapter(this));
        this.jMenuTools.setMnemonic('T');
        this.jMenuTools.setText("Tools");
        this.jMenuItemGtoP.setIcon(this.image8);
        this.jMenuItemGtoP.setMnemonic('G');
        this.jMenuItemGtoP.setText("GenomeToProteome");
        this.jMenuItemGtoP.addActionListener(new mainFrame_jMenuItemGtoP_actionAdapter(this));
        this.jButtonCleanData.addActionListener(new mainFrame_jButtonCleanData_actionAdapter(this));
        this.contentPane.setPreferredSize(new Dimension(640, 480));
        this.jTP_viewer.setBackground(new Color(212, 212, 223));
        this.jP_analysis.setBackground(new Color(250, 250, 250));
        this.jP_analysis.setLayout(this.borderLayout_analysis);
        this.jP_compare.setBackground(new Color(204, 204, 248));
        this.jP_compare.setLayout(this.borderLayout_compare);
        this.jP_report.setBackground(new Color(231, 204, 204));
        this.jP_report.setLayout(this.borderLayout3);
        this.jButtonOpen.addActionListener(new mainFrame_jButton1_actionAdapter(this));
        this.jButtonDotAnalysis.setIcon(this.image4);
        this.jButtonDotAnalysis.setText("Dotplot");
        this.jButtonDotAnalysis.addActionListener(new mainFrame_jButtonDotAnalysis_actionAdapter(this));
        this.jPanel_DotA.setLayout(this.borderLayout2);
        this.jP_DotA_Upper.setLayout(this.borderLayout4);
        this.jSli_DotA_Zoom.setMaximum(300);
        this.jSli_DotA_Zoom.setMinimum(1);
        this.jSli_DotA_Zoom.setPaintTicks(true);
        this.jSli_DotA_Zoom.setToolTipText("zoom");
        this.jSli_DotA_Zoom.addChangeListener(new mainFrame_jSli_DotA_Zoom_changeAdapter(this));
        this.jBu_dotColor.setToolTipText("change the color of the dots");
        this.jBu_dotColor.setActionCommand("");
        this.jBu_dotColor.setText("Fgcol");
        this.jBu_dotColor.addActionListener(new mainFrame_jBu_dotColor_actionAdapter(this));
        this.jBu_dotBColor.setToolTipText("change the backgroud");
        this.jBu_dotBColor.setText("Bgcol");
        this.jBu_dotBColor.addActionListener(new mainFrame_jBu_dotBColor_actionAdapter(this));
        this.jSli_enrich.setMajorTickSpacing(1);
        this.jSli_enrich.setMaximum(5);
        this.jSli_enrich.setMinimum(1);
        this.jSli_enrich.setMinorTickSpacing(1);
        this.jSli_enrich.setPaintTicks(true);
        this.jSli_enrich.setMaximumSize(new Dimension(50, 27));
        this.jSli_enrich.setMinimumSize(new Dimension(20, 27));
        this.jSli_enrich.setPreferredSize(new Dimension(50, 27));
        this.jSli_enrich.setValue(3);
        this.jSli_enrich.addChangeListener(new mainFrame_jSli_enrich_changeAdapter(this));
        this.jLabel_Zoom.setText("Zoom");
        this.jLabel_enrich.setToolTipText("");
        this.jLabel_enrich.setText("BigDot");
        this.jBu_Compare.setText("Compare");
        this.jBu_Compare.addActionListener(new mainFrame_jBu_Compare_actionAdapter(this));
        this.jPanel_compare_main.setLayout(this.borderLayout_comare_main);
        this.jPanel_compare_control.setLayout(this.gridBagLayout_compare_control);
        this.jLabel_scroll_genome1.setText("Genome1");
        this.jLabel_scroll_genome2.setText("Genome2");
        this.jScrollBar_Cgenome1.setBlockIncrement(5);
        this.jScrollBar_Cgenome1.setOrientation(0);
        this.jScrollBar_Cgenome1.setPreferredSize(new Dimension(200, 17));
        this.jScrollBar_Cgenome1.setToolTipText("scroll the genome1");
        this.jScrollBar_Cgenome1.addAdjustmentListener(new mainFrame_jScrollBar_Cgenome1_adjustmentAdapter(this));
        this.jScrollBar_Cgenome2.setBlockIncrement(5);
        this.jScrollBar_Cgenome2.setMaximum(110);
        this.jScrollBar_Cgenome1.setMaximum(110);
        this.jScrollBar_Cgenome2.setOrientation(0);
        this.jScrollBar_Cgenome2.setPreferredSize(new Dimension(200, 17));
        this.jScrollBar_Cgenome2.setToolTipText("scroll the genome2");
        this.jScrollBar_Cgenome2.addAdjustmentListener(new mainFrame_jScrollBar_Cgenome2_adjustmentAdapter(this));
        this.jLabel_compareZoom.setText("Zoom In");
        this.jSlider_compareZoom.addChangeListener(new mainFrame_jSlider_compareZoom_changeAdapter(this));
        this.jSlider_compareZoom.setMinimum(1);
        this.jSlider_compareZoom.setPreferredSize(new Dimension(200, 17));
        this.jSlider_compareZoom.setValue(6);
        this.jLabel_row2_pos.setText("Distance");
        this.jSlider_Compare_row2D.setMaximum(300);
        this.jSlider_Compare_row2D.setValue(150);
        this.jSlider_Compare_row2D.addChangeListener(new mainFrame_jSlider_Compare_row2D_changeAdapter(this));
        this.jLabel_ColorPlan.setToolTipText("color the gene cluster");
        this.jLabel_ColorPlan.setText("Rainbow color for clusters");
        this.jRadioButtonColor1.setToolTipText("7 colors are used in lines, in order to show locus collinear blocks");
        this.jRadioButtonColor1.setMnemonic('0');
        this.jRadioButtonColor1.setText("Use 7 colors");
        this.jRadioButtonColor1.addItemListener(new mainFrame_jRadioButtonColor1_itemAdapter(this));
        this.jRadioButtonColor2.setToolTipText("2 colors are used to show gene rearrangement");
        this.jRadioButtonColor2.setText("Use 2 colors");
        this.jRadioButtonColor2.addItemListener(new mainFrame_jRadioButtonColor2_itemAdapter(this));
        this.jRadioButtonColor3.setToolTipText("2 colors are used to show gene rearrangement");
        this.jRadioButtonColor3.setText("Reversed 2 colors");
        this.jRadioButtonColor3.addItemListener(new mainFrame_jRadioButtonColor3_itemAdapter(this));
        this.jRadioButtonColor4.setToolTipText("7 colors are used in lines, in order to show locus collinear blocks");
        this.jRadioButtonColor4.setText("Reversed 7 colors");
        this.jRadioButtonColor4.addItemListener(new mainFrame_jRadioButtonColor4_itemAdapter(this));
        this.jSlider_colorThreshold.setOrientation(1);
        this.jSlider_colorThreshold.setMaximum(70);
        this.jSlider_colorThreshold.setMinimum(1);
        this.jSlider_colorThreshold.setPreferredSize(new Dimension(16, 70));
        this.jSlider_colorThreshold.setValue(20);
        this.jSlider_colorThreshold.addChangeListener(new mainFrame_jSlider1_changeAdapter(this));
        this.jTextField_Cthreshod.setEditable(false);
        this.jTextField_Cthreshod.setText("Threshold");
        this.jButton_colorPallet.setMinimumSize(new Dimension(68, 17));
        this.jButton_colorPallet.setPreferredSize(new Dimension(68, 17));
        this.jButton_colorPallet.setToolTipText("Set your favorite colors");
        this.jButton_colorPallet.setHorizontalAlignment(2);
        this.jButton_colorPallet.setHorizontalTextPosition(2);
        this.jButton_colorPallet.setText("Pallet");
        this.jButton_colorPallet.addActionListener(new mainFrame_jButton_colorPallet_actionAdapter(this));
        this.jButtonReport.setText("Report");
        this.jButtonReport.addActionListener(new mainFrame_jButtonReport_actionAdapter(this));
        this.jPanelReport.setLayout(this.borderLayoutReport);
        this.jEditorPane_report.setText("");
        this.jButton_CReset.setPreferredSize(new Dimension(73, 17));
        this.jButton_CReset.setToolTipText("Reset to basic");
        this.jButton_CReset.setText("Reset");
        this.jButton_CReset.addActionListener(new mainFrame_jButton_CGraphics_actionAdapter(this));
        this.jMenuItemSavePicture.setToolTipText("save the selected result picture as file");
        this.jMenuItemSavePicture.setIcon(this.image11);
        this.jMenuItemSavePicture.setMnemonic('S');
        this.jMenuItemSavePicture.setText("Save result picture as");
        this.jMenuItemSavePicture.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.jMenuItemSavePicture.addActionListener(new mainFrame_jMenuItemSavePicture_actionAdapter(this));
        this.jMenuItem1.setIcon(this.image4);
        this.jMenuItem1.setMnemonic('D');
        this.jMenuItem1.setText("Dotplot analysis");
        this.jMenuItem1.addActionListener(new mainFrame_jMenuItem1_actionAdapter(this));
        this.jMenuItem2.setEnabled(false);
        this.jMenuItem2.setIcon(this.image5);
        this.jMenuItem2.setMnemonic('C');
        this.jMenuItem2.setText("Correlation investigation");
        this.jMenuItem2.addActionListener(new mainFrame_jMenuItem2_actionAdapter(this));
        this.jButtonCharacter.setIcon(this.image3);
        this.jMenuItem_KeywordFilter.setToolTipText("");
        this.jMenuItem_KeywordFilter.setIcon(this.image6);
        this.jMenuItem_KeywordFilter.setMnemonic('A');
        this.jMenuItem_KeywordFilter.setText("Annotation Browser");
        this.jMenuItem_KeywordFilter.addActionListener(new mainFrame_jMenuItem_KeywordFilter_actionAdapter(this));
        this.jMenuItemEditor.setIcon(this.image16);
        this.jMenuItemEditor.setMnemonic('E');
        this.jMenuItemEditor.setText("Editor");
        this.jMenuItemEditor.addActionListener(new mainFrame_jMenuItemEditor_actionAdapter(this));
        this.jMenuLicense.setToolTipText("Show license information");
        this.jMenuLicense.setIcon(this.image18);
        this.jMenuLicense.setMnemonic('I');
        this.jMenuLicense.setText("License");
        this.jMenuLicense.addActionListener(new mainFrame_jMenuLicense_actionAdapter(this));
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuFile.add(this.jMenuItemImportData);
        this.jMenuFile.add(this.jMenuItemResoreMirror);
        this.jMenuFile.add(this.jMenuItemMakeMirror);
        this.jMenuFile.add(this.jMenuItemClean);
        this.jMenuFile.add(this.jMenuItemSavePicture);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuBar1.add(this.jMenuOptions);
        this.jMenuBar1.add(this.jMenuTools);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuHelp.add(this.jMenuLicense);
        this.setJMenuBar(this.jMenuBar1);
        this.jButtonOpen.setIcon(this.image1);
        this.jButtonOpen.setToolTipText("Open File");
        this.jButtonCleanData.setIcon(this.image2);
        this.jButtonCleanData.setToolTipText("Clean the data of this workspace");
        this.jButtonCharacter.setToolTipText("Character");
        this.jToolBar.add(this.jButtonOpen);
        this.jToolBar.add(this.jButtonCleanData);
        this.jToolBar.add(this.jButtonCharacter);
        this.jToolBar.add(this.jButtonDotAnalysis);
        this.jToolBar.add(this.jBu_Compare);
        this.jToolBar.add(this.jButtonReport);
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.jTP_viewer, "Center");
        this.jTP_viewer.add((Component)this.jP_analysis, "Analysis");
        this.jTP_viewer.add((Component)this.jP_compare, "Comparison");
        this.jTP_viewer.add((Component)this.jP_report, "Report");
        this.jPanelReport.add((Component)this.jScrollPane_reportPane, "Center");
        this.jScrollPane_reportPane.getViewport().add(this.jEditorPane_report);
        this.jP_analysis.add((Component)this.jP_DotA_Upper, "Center");
        this.jP_DotA_Upper.add((Component)this.jSP_DotA, "Center");
        this.jP_analysis.add((Component)this.jP_DotA_Unter, "South");
        this.jP_DotA_Unter.add(this.jLabel_Zoom);
        this.jP_DotA_Unter.add(this.jSli_DotA_Zoom);
        this.jP_DotA_Unter.add(this.jBu_dotColor);
        this.jP_DotA_Unter.add(this.jBu_dotBColor);
        this.jP_DotA_Unter.add(this.jSli_enrich);
        this.jP_DotA_Unter.add(this.jLabel_enrich);
        this.jP_compare.add((Component)this.jPanel_compare_control, "South");
        this.jPanel_compare_main.add((Component)this.jSP_compare, "Center");
        this.jP_compare.add((Component)this.jPanel_compare_main, "Center");
        this.jSli_DotA_Zoom.setMinorTickSpacing(20);
        this.jSli_DotA_Zoom.setValue(5);
        this.buttonGroup_colorCluster.add(this.jRadioButtonColor4);
        this.buttonGroup_colorCluster.add(this.jRadioButtonColor1);
        this.buttonGroup_colorCluster.add(this.jRadioButtonColor2);
        this.buttonGroup_colorCluster.add(this.jRadioButtonColor3);
        this.jP_report.add((Component)this.jPanelReport, "Center");
        this.jMenuOptions.add(this.jMenuItemGenomeEnrich);
        this.jMenuOptions.add(this.jMenuItemCharacters);
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(this.jMenuThemes);
        this.jMenuOptions.add(this.jMenuModes);
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(this.jMenuItemResetOptions);
        this.jPanel_compare_control.add((Component)this.jScrollBar_Cgenome1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jScrollBar_Cgenome2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jSlider_compareZoom, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jLabel_scroll_genome2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jLabel_scroll_genome1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jLabel_compareZoom, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jLabel_row2_pos, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jSlider_Compare_row2D, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jRadioButtonColor1, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jRadioButtonColor2, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jRadioButtonColor4, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jRadioButtonColor3, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jLabel_ColorPlan, new GridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jButton_colorPallet, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jButton_CReset, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jLabelHideThres, new GridBagConstraints(6, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jCheckBoxEnrich, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jTextField_Cthreshod, new GridBagConstraints(4, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jSlider_colorThreshold, new GridBagConstraints(5, 0, 1, 4, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_compare_control.add((Component)this.jSlider_hideThres, new GridBagConstraints(6, 0, 1, 4, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jMenuTools.add(this.jMenuItemGtoP);
        this.jMenuTools.addSeparator();
        this.jMenuTools.add(this.jMenuItem1);
        this.jMenuTools.add(this.jMenuItem2);
        this.jMenuTools.add(this.jMenuItem_KeywordFilter);
        this.jMenuTools.add(this.jMenuItemEditor);
        this.colorPlan[0] = Color.RED;
        this.colorPlan[1] = Color.PINK;
        this.colorPlan[2] = Color.ORANGE;
        this.colorPlan[3] = Color.GREEN;
        this.colorPlan[4] = Color.CYAN;
        this.colorPlan[5] = Color.BLUE;
        this.colorPlan[6] = Color.DARK_GRAY;
        this.DotenRich = this.jSli_enrich.getValue();
        this.colorName.add(Color.CYAN);
        this.colorDescription.add("chromosome-related");
        this.colorName.add(Color.BLACK);
        this.colorDescription.add("phage insertion");
        this.colorName.add(Color.GREEN);
        this.colorDescription.add("PTS or transporters");
        this.colorName.add(Color.MAGENTA);
        this.colorDescription.add("regulators");
        this.colorName.add(Color.BLUE);
        this.colorDescription.add("enzymes and metabolism related proteins ");
        this.jMenuThemes.setIcon(this.image13);
        this.jMenuModes.setIcon(this.image17);
    }

    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        mainFrame_AboutBox dlg = new mainFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void jButton1_actionPerformed(ActionEvent e) {
        this.openImportDataUI();
    }

    void openImportDataUI() {
        ReadFileUI rfUI = new ReadFileUI(this.jButtonDotAnalysis, this.jBu_Compare, this.jButtonReport);
        Dimension dlgSize = rfUI.getPreferredSize();
        Dimension frmSize = this.thisFrame.getSize();
        Point loc = this.getLocation();
        rfUI.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        rfUI.setVisible(true);
    }

    void clearAllVar() {
        if (this.s1 != null) {
            this.s1.clear();
        }
        if (this.s2 != null) {
            this.s2.clear();
        }
        if (this.lines != null) {
            this.lines.clear();
        }
        if (this.characters != null) {
            this.characters.clear();
        }
        if (this.hs1 != null) {
            this.hs1.clear();
        }
        if (this.hs2 != null) {
            this.hs2.clear();
        }
    }

    public void jButtonDotAnalysis_actionPerformed(ActionEvent e) {
        int j;
        int i;
        ToDB toDB = new ToDB();
        if (!toDB.connect()) {
            return;
        }
        this.clearAllVar();
        this.s1 = toDB.readContig("SELECT * FROM working WHERE species='" + this.org1 + "' ORDER BY locus_tag");
        this.s2 = toDB.readContig("SELECT * FROM working WHERE species='" + this.org2 + "' ORDER BY locus_tag");
        toDB.close();
        if (this.s1 == null || this.s2 == null || this.s1.size() == 0 || this.s2.size() == 0) {
            JOptionPane.showMessageDialog(this, "import sequence data or mirror file first please!");
            this.jBu_Compare.setEnabled(false);
            this.jButtonReport.setEnabled(false);
            this.jMenuItem2.setEnabled(false);
            return;
        }
        this.maxLen1 = 0;
        this.maxLen2 = 0;
        for (i = 0; i < this.s1.size(); ++i) {
            j = ((Contig)this.s1.get(i)).getEnd();
            this.maxLen1 = this.maxLen1 < j ? j : this.maxLen1;
        }
        for (i = 0; i < this.s2.size(); ++i) {
            j = ((Contig)this.s2.get(i)).getEnd();
            this.maxLen2 = this.maxLen2 < j ? j : this.maxLen2;
        }
        this.maxLen = this.maxLen1 > this.maxLen2 ? this.maxLen1 : this.maxLen2;
        this.ortholog_reprocess();
        DotAPane dotaPane = new DotAPane();
        this.jpDotP.removeAll();
        this.jpDotP.validate();
        this.jpDotP.setVisible(false);
        this.jpDotP.add((Component)dotaPane, "Center");
        this.jpDotP.setSize(dotaPane.getSize());
        this.jTP_viewer.setSelectedComponent(this.jP_analysis);
        this.jSP_DotA.setViewportView(this.jpDotP);
        this.jpDotP.setVisible(true);
        this.jSP_DotA.validate();
        this.jSP_DotA.repaint();
        this.jBu_Compare.setEnabled(true);
        this.jButtonReport.setEnabled(true);
        this.jMenuItem2.setEnabled(true);
    }

    void ortholog_reprocess() {
        Hashtable<String, Integer> dy = new Hashtable<String, Integer>(3500, 0.9f);
        for (int j = 0; j < this.s2.size(); ++j) {
            Contig con = (Contig)this.s2.get(j);
            dy.put(con.getName(), new Integer(j));
        }
        for (int i = 0; i < this.s1.size(); ++i) {
            Contig con1 = (Contig)this.s1.get(i);
            String orth = con1.getOrtholog();
            if (orth.equals("")) {
                con1.setColor(new Color(255, 0, 0));
                continue;
            }
            if (!dy.containsKey(orth)) continue;
            Contig con2 = (Contig)this.s2.get((Integer)dy.get(orth));
            if (!con2.getOrtholog().equalsIgnoreCase(con1.getName())) {
                con1.setOrtholog("");
                con1.setColor(new Color(255, 0, 0));
                this.s1.set(i, con1);
                continue;
            }
            con2.setColor(con1.getColor());
            LineElement le = new LineElement((con1.getEnd() + con1.getStart()) / 2, (con2.getStart() + con2.getEnd()) / 2);
            le.setGene1(con1);
            le.setGene2(con2);
            this.lines.add(le);
        }
        Hashtable<String, Integer> dx = new Hashtable<String, Integer>(3500, 0.9f);
        for (int j = 0; j < this.s1.size(); ++j) {
            Contig con = (Contig)this.s1.get(j);
            if (dx.containsKey(con.getName())) continue;
            dx.put(con.getName(), new Integer(j));
        }
        for (int i = 0; i < this.s2.size(); ++i) {
            Contig con2 = (Contig)this.s2.get(i);
            String orth = con2.getOrtholog();
            if (orth.equals("")) {
                con2.setColor(new Color(255, 0, 0));
                continue;
            }
            try {
                Contig con1 = (Contig)this.s1.get((Integer)dx.get(orth));
                if (con1.getOrtholog().equalsIgnoreCase(con2.getName())) continue;
                con2.setOrtholog("");
                con2.setColor(new Color(255, 0, 0));
                this.s2.set(i, con2);
                continue;
            }
            catch (Exception expt) {
                // empty catch block
            }
        }
        this.character_finder(1, this.s1);
        this.character_finder(2, this.s2);
    }

    void character_finder(int n, ArrayList s) {
        String[][] colorKeyD = new String[][]{{"chromosom", "dna"}, {"phage"}, {"pts", "port"}, {"regulator", "repressor", "terminator"}, {"ase", "ose", "tol"}};
        block0: for (int i = 0; i < s.size(); ++i) {
            Contig con1 = (Contig)s.get(i);
            String desc = con1.getDescription().toString().toLowerCase();
            for (int j = 0; j < this.colorName.size(); ++j) {
                boolean flag1 = false;
                for (int k = 0; k < colorKeyD[j].length; ++k) {
                    if (desc.indexOf(colorKeyD[j][k]) <= -1) continue;
                    flag1 = true;
                    break;
                }
                if (!flag1) continue;
                CharacterBlock cb = new CharacterBlock(n, con1.getStart(), con1.getEnd() - con1.getStart(), (Color)this.colorName.get(j));
                this.characters.add(cb);
                continue block0;
            }
        }
    }

    public void jSli_DotA_Zoom_stateChanged(ChangeEvent e) {
        this.DotARatio = 20 * this.jSli_DotA_Zoom.getValue();
        this.repaint();
    }

    public void jBu_dotColor_actionPerformed(ActionEvent e) {
        JFrame f2 = new JFrame();
        f2.setSize(new Dimension(420, 380));
        JPanel jpt = new JPanel();
        this.Dotc = new JColorChooser(this.DotColor);
        this.Dotc.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                mainFrame.this.DotColor = mainFrame.this.Dotc.getColor();
                mainFrame.this.repaint();
            }
        });
        jpt.add((Component)this.Dotc, "Center");
        f2.getContentPane().add(jpt);
        Dimension dlgSize = jpt.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        f2.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        f2.setVisible(true);
    }

    public void jBu_dotBColor_actionPerformed(ActionEvent e) {
        JFrame f2 = new JFrame();
        f2.setSize(new Dimension(420, 380));
        JPanel jpt = new JPanel();
        this.DotBc = new JColorChooser(this.DotBColor);
        this.DotBc.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                mainFrame.this.DotBColor = mainFrame.this.DotBc.getColor();
                mainFrame.this.jpDotP.getComponent(0).setBackground(mainFrame.this.DotBColor);
                mainFrame.this.repaint();
            }
        });
        jpt.add((Component)this.DotBc, "Center");
        f2.getContentPane().add(jpt);
        Dimension dlgSize = jpt.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        f2.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        f2.setVisible(true);
    }

    public void jSli_enrich_stateChanged(ChangeEvent e) {
        this.DotenRich = this.jSli_enrich.getValue();
        this.repaint();
    }

    public void jBu_Compare_actionPerformed(ActionEvent e) {
        int i;
        if (this.s1.size() == 0 || this.s2.size() == 0) {
            JOptionPane.showMessageDialog(this, "import sequence data or mirror file and perform Dot-analysis first please!");
            this.jBu_Compare.setEnabled(false);
            this.jButtonReport.setEnabled(false);
            this.jMenuItem2.setEnabled(false);
            return;
        }
        for (i = 0; i < this.s1.size(); ++i) {
            Contig con1 = (Contig)this.s1.get(i);
            if (con1.getOrtholog().equals("")) continue;
            this.hs1.put(con1.getName(), this.s1.get(i));
        }
        for (i = 0; i < this.s2.size(); ++i) {
            Contig con2 = (Contig)this.s2.get(i);
            if (con2.getOrtholog().equals("")) continue;
            this.hs2.put(con2.getName(), this.s2.get(i));
        }
        ArrayList<Integer> po = new ArrayList<Integer>(3000);
        for (int i2 = 0; i2 < this.lines.size(); ++i2) {
            LineElement le = (LineElement)this.lines.get(i2);
            po.add(new Integer(le.getX1()));
            po.add(new Integer(le.getX2()));
        }
        LinearRegression linearReg = new LinearRegression(po);
        linearReg.visualization(this.thisFrame);
        this.a = linearReg.getA();
        this.b = linearReg.getB();
        this.CalculateLines();
        this.comparePane.setEditable(false);
        this.comparePane.removeMouseListener(this.comparePane);
        this.comparePane.removeMouseMotionListener(this.comparePane);
        this.comparePane.addMouseMotionListener(this.comparePane);
        this.comparePane.addMouseListener(this.comparePane);
        this.comparePane.setSize(this.maxLen / this.visual_ratio + 120, 1024);
        this.jSP_compare.setViewportView(this.comparePane);
        this.jTP_viewer.setSelectedComponent(this.jP_compare);
        this.repaint();
    }

    private void CalculateLines() {
        for (int i = 0; i < this.lines.size(); ++i) {
            int g;
            LineElement le = (LineElement)this.lines.get(i);
            int px = le.getX1();
            int py = le.getX2();
            if (this.mode_selected == 1) {
                float disf = (this.b * (float)px - (float)py + this.a) / (float)Math.sqrt(this.b * this.b + 1.0f);
                g = (int)Math.log10(Math.abs(disf / this.threshold_colorCluster));
            } else {
                g = (int)Math.log10(Math.abs((float)(px - py) / this.threshold_colorCluster));
            }
            if (g < 0) {
                g = 0;
            }
            if (g >= 7) {
                g = 6;
            } else if (g >= 5) {
                g = 5;
            }
            le.setColor(g);
        }
    }

    public void jScrollBar_Cgenome2_adjustmentValueChanged(AdjustmentEvent e) {
        this.shiftG2 = this.jScrollBar_Cgenome2.getValue() * this.maxLen1 / 100;
        this.repaint();
    }

    public void jScrollBar_Cgenome1_adjustmentValueChanged(AdjustmentEvent e) {
        this.shiftG1 = this.jScrollBar_Cgenome1.getValue() * this.maxLen2 / 100;
        this.repaint();
    }

    public void jSlider_compareZoom_stateChanged(ChangeEvent e) {
        int g = this.jSP_compare.getHorizontalScrollBar().getValue() * this.visual_ratio;
        this.visual_ratio = 50 * this.jSlider_compareZoom.getValue();
        this.jSP_compare.getHorizontalScrollBar().setValue(g / this.visual_ratio);
        this.comparePane.setSize(this.maxLen / this.visual_ratio + 120, 1024);
        this.comparePane.repaint();
    }

    public void jSlider_Compare_row2D_stateChanged(ChangeEvent e) {
        this.row2 = this.row1 + this.jSlider_Compare_row2D.getValue() + 50;
        this.repaint();
    }

    public void jSlider1_stateChanged(ChangeEvent e) {
        this.threshold_colorCluster = (float)Math.pow(10.0, (double)this.jSlider_colorThreshold.getValue() / 10.0);
        this.jTextField_Cthreshod.setText((double)this.jSlider_colorThreshold.getValue() / 10.0 + "");
        this.CalculateLines();
        this.repaint();
    }

    public void jRadioButtonColor1_itemStateChanged(ItemEvent e) {
        this.colorPlan[0] = Color.RED;
        this.colorPlan[1] = Color.PINK;
        this.colorPlan[2] = Color.ORANGE;
        this.colorPlan[3] = Color.GREEN;
        this.colorPlan[4] = Color.CYAN;
        this.colorPlan[5] = Color.BLUE;
        this.colorPlan[6] = Color.DARK_GRAY;
        this.repaint();
    }

    public void jRadioButtonColor4_itemStateChanged(ItemEvent e) {
        this.colorPlan[6] = Color.RED;
        this.colorPlan[5] = Color.PINK;
        this.colorPlan[4] = Color.ORANGE;
        this.colorPlan[3] = Color.GREEN;
        this.colorPlan[2] = Color.CYAN;
        this.colorPlan[1] = Color.BLUE;
        this.colorPlan[0] = Color.DARK_GRAY;
        this.repaint();
    }

    public void jRadioButtonColor2_itemStateChanged(ItemEvent e) {
        this.colorPlan[0] = Color.BLUE;
        this.colorPlan[1] = Color.BLUE;
        this.colorPlan[2] = Color.BLUE;
        this.colorPlan[3] = Color.GREEN;
        this.colorPlan[4] = Color.GREEN;
        this.colorPlan[5] = Color.GREEN;
        this.colorPlan[6] = Color.GREEN;
        this.repaint();
    }

    public void jRadioButtonColor3_itemStateChanged(ItemEvent e) {
        this.colorPlan[6] = Color.BLUE;
        this.colorPlan[5] = Color.BLUE;
        this.colorPlan[4] = Color.BLUE;
        this.colorPlan[3] = Color.BLUE;
        this.colorPlan[2] = Color.GREEN;
        this.colorPlan[1] = Color.GREEN;
        this.colorPlan[0] = Color.GREEN;
        this.repaint();
    }

    public void jButton_colorPallet_actionPerformed(ActionEvent e) {
        JFrame f5 = new JFrame();
        JPanel p5 = new JPanel();
        for (int ki = 0; ki < 7; ++ki) {
            this.jBu[ki] = new JButton("Color" + ki);
            this.jBu[ki].setForeground(this.colorPlan[ki]);
            p5.add(this.jBu[ki]);
            this.jBu[ki].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrame f2 = new JFrame();
                    f2.setSize(new Dimension(420, 380));
                    JPanel jpt = new JPanel();
                    JColorChooser cc = new JColorChooser();
                    jpt.add((Component)cc, "Center");
                    f2.getContentPane().add(jpt);
                    f2.setVisible(true);
                }
            });
        }
        f5.getContentPane().add(p5);
        f5.setSize(100, 280);
        f5.setVisible(true);
    }

    public void jButtonReport_actionPerformed(ActionEvent e) {
        String desc;
        int i;
        this.jTP_viewer.setSelectedComponent(this.jP_report);
        ArrayList<String> arl1 = new ArrayList<String>();
        ArrayList<String> arl2 = new ArrayList<String>();
        String co = "";
        this.ct = this.ct + "Strain-specific Genes Report\n";
        this.ct = this.ct + "Genome1 specific genes\n";
        for (i = 0; i < this.s1.size(); ++i) {
            Contig con1 = (Contig)this.s1.get(i);
            if (!con1.getOrtholog().equals("")) continue;
            desc = con1.getDescription();
            arl1.add(desc);
            co = co + con1.getName() + " " + con1.getDescription() + "\n";
        }
        this.ct = this.ct + co;
        co = "";
        this.ct = this.ct + "= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =\n";
        this.ct = this.ct + "Genome2 specific genes\n";
        for (i = 0; i < this.s2.size(); ++i) {
            Contig con2 = (Contig)this.s2.get(i);
            if (!con2.getOrtholog().equals("")) continue;
            desc = con2.getDescription();
            arl2.add(desc);
            co = co + con2.getName() + " " + con2.getDescription() + "\n";
        }
        this.ct = this.ct + co;
        this.ct = this.ct + "=============================================================\n";
        this.ct = this.ct + "Keyword Frequencies\n";
        this.ct = this.ct + "genome1\n";
        this.ct = this.ct + this.showKeyWords(arl1, 70, 20);
        this.ct = this.ct + "= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =\n";
        this.ct = this.ct + "genome2\n";
        this.ct = this.ct + this.showKeyWords(arl2, 70, 20);
        this.ct = this.ct + "=============================================================\n";
        this.jEditorPane_report.setBackground(Color.BLACK);
        this.jEditorPane_report.setForeground(Color.LIGHT_GRAY);
        this.jEditorPane_report.setText(this.ct);
        this.jEditorPane_report.revalidate();
        this.jScrollPane_reportPane.getVerticalScrollBar().setValue(0);
        this.jScrollPane_reportPane.revalidate();
    }

    public String showKeyWords(ArrayList text, int percent, int maxNos) {
        HashMap<String, Integer> kwFreq = new HashMap<String, Integer>();
        String ct = "";
        for (int z = 0; z < text.size(); ++z) {
            ArrayList keyWords = new SplitToWords(text.get(z).toString()).getWords();
            for (int q = 0; q < keyWords.size(); ++q) {
                String thisKey = keyWords.get(q).toString().toUpperCase();
                if (kwFreq.containsKey(thisKey)) {
                    int f = (Integer)kwFreq.get(thisKey);
                    kwFreq.put(thisKey, new Integer(f + 1));
                    continue;
                }
                kwFreq.put(thisKey, new Integer(1));
            }
        }
        int maxFreq = 0;
        for (String id : kwFreq.keySet()) {
            int idFreq = (Integer)kwFreq.get(id);
            maxFreq = maxFreq < idFreq ? idFreq : maxFreq;
        }
        int n = 0;
        for (int f = maxFreq; f > maxFreq - maxFreq * percent / 100; --f) {
            for (String id : kwFreq.keySet()) {
                int idFreq = (Integer)kwFreq.get(id);
                if (idFreq != f) continue;
                if (++n > maxNos) {
                    return ct;
                }
                ct = ct + "  " + f + ")  " + id + "\n";
            }
        }
        return ct;
    }

    public void jButton_CReset_actionPerformed(ActionEvent e) {
        this.resetAllOptions();
    }

    public void resetAllOptions() {
        this.shiftG1 = 0;
        this.shiftG2 = 0;
        this.visual_ratio = 100;
        this.threshold_colorCluster = 100.0f;
        this.jSlider_Compare_row2D.setValue(150);
        this.jSlider_colorThreshold.setValue(20);
        this.jCheckBoxEnrich.setSelected(true);
        this.jSlider_hideThres.setValue(4);
        this.repaint();
    }

    public void jMenuItemImportData_actionPerformed(ActionEvent e) {
        this.openImportDataUI();
    }

    public void jButtonCharacter_actionPerformed(ActionEvent e) {
        this.sc_flag = !this.sc_flag;
        this.repaint();
    }

    public void jMenuItemCharacters_actionPerformed(ActionEvent e) {
        this.sc_flag = !this.sc_flag;
        this.repaint();
    }

    public void jSlider_hideThres_stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public void jCheckBoxEnrich_stateChanged(ChangeEvent e) {
        this.genome_enrich = this.jCheckBoxEnrich.isSelected() ? 1 : 0;
        this.repaint();
    }

    public void jMenuItemMakeMirror_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showSaveDialog(fc);
        if (result != 0) {
            return;
        }
        File file1 = fc.getSelectedFile();
        this.thisPath = file1.getPath();
        ToDB toDB = new ToDB();
        if (!toDB.connect()) {
            return;
        }
        if (!toDB.dumpDB("working", this.thisPath)) {
            JOptionPane.showMessageDialog(this, "can not dump this mirror file");
        }
        toDB.close();
    }

    public void jMenuItemResetOptions_actionPerformed(ActionEvent e) {
        this.resetAllOptions();
    }

    public void jMenuItemResoreMirror_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showOpenDialog(fc);
        if (result != 0) {
            return;
        }
        File file1 = fc.getSelectedFile();
        this.thisPath = file1.getPath();
        ToDB toDB = new ToDB();
        if (!toDB.connect()) {
            return;
        }
        toDB.emptyTable("working");
        if (!toDB.restoreDB(this.thisPath)) {
            JOptionPane.showMessageDialog(this, "can not restore this Mirror file!");
            toDB.close();
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Do you want to analyze the new input data now ? Program will be started with a Dot-analysis ", "Confirm", 0) == 0) {
            this.jButtonDotAnalysis_actionPerformed(null);
        }
        toDB.close();
    }

    public void jMenuItemClean_actionPerformed(ActionEvent e) {
        this.cleanAllData();
    }

    void cleanAllData() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure to eliminate all the data?", "Confirm", 0) == 1) {
            return;
        }
        ToDB toDB = new ToDB();
        if (!toDB.connect()) {
            return;
        }
        toDB.emptyTable("working");
        toDB.close();
        this.clearAllVar();
        this.jBu_Compare.setEnabled(false);
        this.jButtonReport.setEnabled(false);
        this.jMenuItem2.setEnabled(false);
        JOptionPane.showMessageDialog(this, "All the data has been eliminated, please import new sequences or a data mirror");
    }

    public void jMenuItemGtoP_actionPerformed(ActionEvent e) {
        JFrame jf9 = new JFrame();
        GenomeToProteomeUI gtop = new GenomeToProteomeUI(jf9);
        jf9.getContentPane().add((Component)gtop, "Center");
        Dimension dlgSize = jf9.getPreferredSize();
        Dimension frmSize = this.thisFrame.getSize();
        Point loc = this.getLocation();
        jf9.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        jf9.pack();
        jf9.setVisible(true);
    }

    public void jButtonCleanData_actionPerformed(ActionEvent e) {
        this.cleanAllData();
    }

    public void jMenuItemGenomeEnrich_actionPerformed(ActionEvent e) {
        this.jCheckBoxEnrich.setSelected(!this.jCheckBoxEnrich.isSelected());
        this.repaint();
    }

    public void jMenuItemSavePicture_actionPerformed(ActionEvent e) {
        Component picComp;
        String filename;
        JFileChooser fc = new JFileChooser(this.thisPath);
        int result = fc.showSaveDialog(fc);
        if (result == 0) {
            File file1 = fc.getSelectedFile();
            this.thisPath = file1.getPath();
            filename = file1.getPath();
            if (!filename.toLowerCase().endsWith(".jpg") && !filename.toLowerCase().endsWith(".jpeg")) {
                filename = filename + ".jpg";
            }
            if ((picComp = this.jTP_viewer.getSelectedComponent()) == this.jP_compare) {
                picComp = this.jSP_compare;
            }
            if (picComp == this.jP_analysis) {
                picComp = this.jpDotP;
            }
        } else {
            return;
        }
        this.saveComponentToJPEG(picComp, filename);
    }

    public void jMenuItem1_actionPerformed(ActionEvent e) {
        this.jButtonDotAnalysis_actionPerformed(e);
    }

    public void jMenuItem2_actionPerformed(ActionEvent e) {
        this.jBu_Compare_actionPerformed(e);
    }

    public void jMenuItem_KeywordFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.s1 == null || this.s2 == null || this.s1.size() == 0 || this.s2.size() == 0) {
            ToDB toDB = new ToDB();
            if (!toDB.connect()) {
                return;
            }
            this.clearAllVar();
            this.s1 = toDB.readContig("SELECT * FROM working WHERE species='" + this.org1 + "' ORDER BY locus_tag");
            this.s2 = toDB.readContig("SELECT * FROM working WHERE species='" + this.org2 + "' ORDER BY locus_tag");
            toDB.close();
            if (this.s1 == null || this.s2 == null || this.s1.size() == 0 || this.s2.size() == 0) {
                JOptionPane.showMessageDialog(this, "import sequence data or mirror file first please!");
                this.jBu_Compare.setEnabled(false);
                this.jButtonReport.setEnabled(false);
                this.jMenuItem2.setEnabled(false);
                return;
            }
        }
        JFrame jf_new = new JFrame();
        jf_new.setTitle("Annotation Browser");
        FilterPanel fp = new FilterPanel(this.s1, this.s2, this.thisFrame);
        jf_new.getContentPane().add((Component)fp, "Center");
        jf_new.setPreferredSize(new Dimension(780, 600));
        jf_new.pack();
        Dimension dlgSize = jf_new.getPreferredSize();
        Dimension frmSize = this.thisFrame.getSize();
        Point loc = this.getLocation();
        jf_new.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        jf_new.setVisible(true);
    }

    public void jMenuItemEditor_actionPerformed(ActionEvent actionEvent) {
        new jEdit();
    }

    public void jMenuLicense_actionPerformed(ActionEvent actionEvent) {
        new ShowLicenseInformation().actionPerformed(actionEvent);
    }

    class ComparePane
    extends JEditorPane
    implements MouseMotionListener,
    MouseListener {
        private boolean flag_batch_select = false;
        private int thisx;
        private int thisy;
        private int sy;
        private int sx;
        private int ex;
        private int ey;
        private int mouseBatchSelectMinX = 0;
        private int mouseBatchSelectMaxX = 0;
        private int mouseBatchSelectMinY = 0;
        private int mouseBatchSelectMaxY = 0;

        ComparePane() {
        }

        public MouseSelected check_which_select(int sx, int sy) {
            MouseSelected ms = new MouseSelected(0, 0);
            if (sy < mainFrame.this.row1 || sy > mainFrame.this.row2 + 20 || sy > mainFrame.this.row1 + 20 && sy < mainFrame.this.row2) {
                return ms;
            }
            if (sy >= mainFrame.this.row1 && sy <= mainFrame.this.row1 + 20) {
                for (int i = 0; i < mainFrame.this.s1.size(); ++i) {
                    Contig con = (Contig)mainFrame.this.s1.get(i);
                    if ((con.getEnd() + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio < sx || (con.getStart() + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio > sx) continue;
                    ms = new MouseSelected(1, i);
                    return ms;
                }
            } else {
                for (int i = 0; i < mainFrame.this.s2.size(); ++i) {
                    Contig con = (Contig)mainFrame.this.s2.get(i);
                    if ((mainFrame.this.shiftG2 + con.getEnd()) / mainFrame.this.visual_ratio < sx || (con.getStart() + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio > sx) continue;
                    ms = new MouseSelected(2, i);
                    return ms;
                }
            }
            return ms;
        }

        public void mouseMoved(MouseEvent e) {
            MouseSelected ms = this.check_which_select(e.getX(), e.getY());
            if (ms.getGenomeNo() != 0) {
                Contig thiscon = ms.getGenomeNo() == 1 ? (Contig)mainFrame.this.s1.get(ms.getLocusNo()) : (Contig)mainFrame.this.s2.get(ms.getLocusNo());
                mainFrame.this.statusBar.setText(thiscon.getName() + "--" + thiscon.getStart() + ".." + thiscon.getEnd() + "--" + thiscon.getAnnotation() + " | Description:" + thiscon.getDescription());
                String msg = "<html><font size=-1><b><font color=red>" + thiscon.getName() + "</font><br>" + thiscon.getStart() + ".." + thiscon.getEnd() + "(" + (thiscon.getStrand() == 1 ? "+" : "-") + ")<br>" + "<font color=blue size=-2>" + thiscon.getDescription().replaceAll("\\|", "</font><hr><font size=-1 color=black>") + "</font></b></font></html>";
                if (mainFrame.this.desList.size() > 0) {
                    for (int i = mainFrame.this.desList.size() - 1; i >= 0; --i) {
                        this.remove((JEditorPane)mainFrame.this.desList.get(i));
                        mainFrame.this.desList.remove(i);
                    }
                    this.repaint();
                }
                if (this.flag_batch_select) {
                    return;
                }
                JEditorPane je = new JEditorPane("text/html", msg);
                je.setForeground(Color.blue);
                je.setLocation(e.getX(), e.getY() + 10);
                je.setSize(100 + msg.length() / 80 * 20, (msg.length() / 30 + 4) * 12);
                je.setBackground(new Color(200, 200, 230));
                this.add(je);
                mainFrame.this.desList.add(je);
                Timer timer = new Timer();
                timer.schedule((TimerTask)new RemindTask(this, je), 2000L);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.flag_batch_select) {
                this.sx = e.getX();
                this.sy = e.getY();
                this.flag_batch_select = true;
            } else {
                this.thisx = e.getX();
                this.thisy = e.getY();
                this.repaint();
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            JFrame newF = new JFrame("Detail Information");
            newF.setSize(500, 300);
            JEditorPane infoP = new JEditorPane("text/html", "");
            infoP.setEditable(false);
            infoP.setPreferredSize(new Dimension(500, 300));
            JScrollPane jSPInfo = new JScrollPane(infoP);
            newF.getContentPane().add((Component)jSPInfo, "Center");
            MouseSelected ms = this.check_which_select(e.getX(), e.getY());
            int gn = ms.getGenomeNo();
            int ln = ms.getLocusNo();
            if (gn == 0) {
                return;
            }
            Contig con1 = gn == 1 ? (Contig)mainFrame.this.s1.get(ln) : (Contig)mainFrame.this.s2.get(ln);
            String textContent = "<html><body><table><tr><td>GeneName</td><td>" + con1.getName() + "</td></tr>" + "<tr><td>Annotation</td><td>" + con1.getAnnotation() + "</td></tr>" + "<tr><td>Location</td><td>" + con1.getStart() + ".." + con1.getEnd() + "(" + (con1.getStrand() == 1 ? "+" : "-") + ")</td></tr>" + "<tr><td>Description</td><td>" + con1.getDescription().replaceAll("\\|", "<br>") + "</td></tr>";
            textContent = textContent + "</table>";
            if (!con1.getOrtholog().equals("")) {
                textContent = textContent + "<hr>Ortholog<br>";
                Contig con2 = gn == 1 ? (Contig)mainFrame.this.hs2.get(con1.getOrtholog()) : (Contig)mainFrame.this.hs1.get(con1.getOrtholog());
                textContent = textContent + "<table><tr><td>GeneName</td><td>" + con2.getName() + "</td></tr>" + "<tr><td>Annotation</td><td>" + con2.getAnnotation() + "</td></tr>" + "<tr><td>Location</td><td>" + con2.getStart() + ".." + con2.getEnd() + "(" + (con2.getStrand() == 1 ? "+" : "-") + ")</td></tr>" + "<tr><td>Description</td><td>" + con2.getDescription().replaceAll("\\|", "<br>") + "</td></tr>";
                textContent = textContent + "</table>";
            } else {
                textContent = textContent + "<hr>Strain-specific gene";
            }
            infoP.setText(textContent);
            newF.setPreferredSize(new Dimension(500, 300));
            Point loc = this.getLocation();
            newF.setLocation(200 + loc.x, 100 + loc.y);
            newF.setVisible(true);
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.flag_batch_select) {
                return;
            }
            this.ex = e.getX();
            this.ey = e.getY();
            this.mouseBatchSelectMaxX = this.ex > this.sx ? this.ex : this.sx;
            this.mouseBatchSelectMinX = this.ex < this.sx ? this.ex : this.sx;
            this.mouseBatchSelectMinY = this.ey < this.sy ? this.ey : this.sy;
            this.mouseBatchSelectMaxY = this.ey > this.sy ? this.ey : this.sy;
            this.flag_batch_select = false;
            this.repaint();
            this.showAnnotationAbstract();
        }

        public void showAnnotationAbstract() {
            int i;
            ArrayList ss_ortho;
            ArrayList ss;
            int sy = (this.mouseBatchSelectMaxY + this.mouseBatchSelectMinY) / 2;
            if (sy < mainFrame.this.row1 || sy > mainFrame.this.row2 + 20 || sy > mainFrame.this.row1 + 20 && sy < mainFrame.this.row2) {
                return;
            }
            int shiftG = 0;
            if (sy >= mainFrame.this.row1 && sy <= mainFrame.this.row1 + 20) {
                ss = mainFrame.this.s1;
                ss_ortho = mainFrame.this.s2;
                shiftG = mainFrame.this.shiftG1;
            } else {
                ss = mainFrame.this.s2;
                ss_ortho = mainFrame.this.s1;
                shiftG = mainFrame.this.shiftG2;
            }
            ArrayList<String> tt = new ArrayList<String>();
            ArrayList<String> gl = new ArrayList<String>();
            ArrayList<String> gl_ortho = new ArrayList<String>();
            HashMap<String, Contig> hs = new HashMap<String, Contig>();
            for (int i2 = 0; i2 < ss_ortho.size(); ++i2) {
                Contig t_cont = (Contig)ss_ortho.get(i2);
                hs.put(t_cont.getName(), t_cont);
            }
            int as = -1;
            int ae = -1;
            int bs = -1;
            int be = -1;
            for (int i3 = 0; i3 < ss.size(); ++i3) {
                Contig con = (Contig)ss.get(i3);
                float lxs = (con.getStart() + shiftG) / mainFrame.this.visual_ratio;
                float lxe = (con.getEnd() + shiftG) / mainFrame.this.visual_ratio;
                if (!(lxs >= (float)this.mouseBatchSelectMinX && lxs <= (float)this.mouseBatchSelectMaxX) && (!(lxe >= (float)this.mouseBatchSelectMinX) || !(lxe <= (float)this.mouseBatchSelectMaxX))) continue;
                if (as == -1) {
                    as = con.getStart();
                }
                if (ae == -1) {
                    ae = con.getEnd();
                }
                as = as < con.getStart() ? as : con.getStart();
                as = as < con.getEnd() ? as : con.getEnd();
                ae = ae > con.getEnd() ? ae : con.getEnd();
                int n = ae = ae > con.getStart() ? ae : con.getStart();
                if (hs.containsKey(con.getOrtholog())) {
                    gl.add(" " + con.getName() + " " + con.getDescription() + "\n");
                } else {
                    gl.add("    (strain-specific) " + con.getName() + " " + con.getDescription() + "\n");
                }
                tt.add(con.getDescription());
                if (!hs.containsKey(con.getOrtholog())) continue;
                Contig cont_temp = (Contig)hs.get(con.getOrtholog());
                gl_ortho.add(" " + cont_temp.getName() + " " + cont_temp.getDescription() + "\n");
                if (bs == -1) {
                    bs = cont_temp.getStart();
                }
                if (be == -1) {
                    be = cont_temp.getEnd();
                }
                bs = bs < cont_temp.getStart() ? bs : cont_temp.getStart();
                bs = bs < cont_temp.getEnd() ? bs : cont_temp.getEnd();
                be = be > cont_temp.getEnd() ? be : cont_temp.getEnd();
                be = be > cont_temp.getStart() ? be : cont_temp.getStart();
            }
            String bss = "";
            if (bs != -1 && be != -1) {
                for (int i4 = 0; i4 < ss_ortho.size(); ++i4) {
                    Contig con = (Contig)ss_ortho.get(i4);
                    if (con.getStart() < bs || con.getEnd() > be || !con.getOrtholog().toString().equals("")) continue;
                    gl_ortho.add("    (strain-specific) " + con.getName() + " " + con.getDescription() + "\n");
                }
            }
            JFrame jf8 = new JFrame();
            jf8.setSize(600, 400);
            jf8.setPreferredSize(new Dimension(600, 400));
            JTextPane jtpa2 = new JTextPane();
            JScrollPane jspa2 = new JScrollPane();
            jspa2.setPreferredSize(new Dimension(600, 400));
            jf8.getContentPane().add(jspa2);
            String cont = ">Gene List (" + as + ".." + ae + ")\n";
            for (i = 0; i < gl.size(); ++i) {
                cont = cont + (String)gl.get(i);
            }
            cont = cont + "--------------------------------------------------------\n";
            cont = cont + ">Orthologous (" + bs + ".." + be + ")\n";
            for (i = 0; i < gl_ortho.size(); ++i) {
                cont = cont + (String)gl_ortho.get(i);
            }
            cont = cont + "--------------------------------------------------------\n";
            cont = cont + "Frequency) Key Words of your selection \n";
            cont = cont + mainFrame.this.showKeyWords(tt, 70, 20);
            jtpa2.setText(cont);
            jspa2.setViewportView(jtpa2);
            Dimension dlgSize = jf8.getPreferredSize();
            Dimension frmSize = mainFrame.this.thisFrame.getSize();
            Point loc = this.getLocation();
            jf8.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            jf8.validate();
            jf8.pack();
            jf8.setVisible(true);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void paintComponent(Graphics g) {
            int boxposX;
            int x;
            RoundRectangle2D.Double r;
            int thisEnd;
            int thisStart;
            Contig thisCon;
            int i;
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(Color.BLACK);
            g2.drawString("x10K", 3, mainFrame.this.row1 - 30);
            for (i = 0; i < mainFrame.this.s1.size(); ++i) {
                thisCon = (Contig)mainFrame.this.s1.get(i);
                thisStart = thisCon.getStart();
                thisEnd = thisCon.getEnd();
                r = new RoundRectangle2D.Double((thisStart + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1, (thisEnd - thisStart) / mainFrame.this.visual_ratio + mainFrame.this.genome_enrich, 20.0, 8.0, 10.0);
                g2.setPaint(thisCon.getColor());
                g2.fill(r);
            }
            for (i = 0; i < mainFrame.this.s2.size(); ++i) {
                thisCon = (Contig)mainFrame.this.s2.get(i);
                thisStart = thisCon.getStart();
                thisEnd = thisCon.getEnd();
                if (thisStart <= 0) continue;
                r = new RoundRectangle2D.Double((thisStart + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2, (thisEnd - thisStart) / mainFrame.this.visual_ratio + mainFrame.this.genome_enrich, 20.0, 8.0, 10.0);
                g2.setPaint(thisCon.getColor());
                g2.fill(r);
            }
            g2.setPaint(Color.black);
            g2.drawLine(mainFrame.this.shiftG1, mainFrame.this.row1 - 20, (mainFrame.this.maxLen1 + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1 - 20);
            g2.setFont(new Font("Serif", 0, 9));
            for (i = 0; i < mainFrame.this.maxLen1 + 500; i += 500) {
                if (i % (100 * mainFrame.this.visual_ratio) == 0) {
                    g2.drawString(i / 10000 + "", (i + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio - 3, mainFrame.this.row1 - 30);
                    g2.drawLine((i + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1 - 20, (i + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1 - 30);
                    continue;
                }
                g2.drawLine((i + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1 - 20, (i + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1 - 25);
            }
            g2.drawLine(mainFrame.this.shiftG2 / mainFrame.this.visual_ratio, mainFrame.this.row2 + 40, (mainFrame.this.maxLen2 + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2 + 40);
            for (i = 0; i < mainFrame.this.maxLen2 + 500; i += 500) {
                if (i % (100 * mainFrame.this.visual_ratio) == 0) {
                    g2.drawString(i / 10000 + "", (i + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio - 3, mainFrame.this.row2 + 60);
                    g2.drawLine((i + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2 + 40, (i + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2 + 50);
                    continue;
                }
                g2.drawLine((i + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2 + 40, (i + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2 + 45);
            }
            for (i = 0; i < mainFrame.this.lines.size(); ++i) {
                LineElement le = (LineElement)mainFrame.this.lines.get(i);
                int x1 = le.getX1();
                int x2 = le.getX2();
                int cn = le.getColor();
                if (cn > mainFrame.this.jSlider_hideThres.getValue()) continue;
                g2.setPaint(mainFrame.this.colorPlan[cn]);
                g2.drawLine((x1 + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1 + 20, (x2 + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2);
            }
            if (mainFrame.this.sc_flag) {
                for (i = 0; i < mainFrame.this.characters.size(); ++i) {
                    CharacterBlock cb = (CharacterBlock)mainFrame.this.characters.get(i);
                    int no = cb.getNo();
                    x = cb.getX();
                    int le = cb.getLen();
                    Color c = cb.getColor();
                    g2.setPaint(c);
                    if (no == 1) {
                        g2.fillRect((x + mainFrame.this.shiftG1) / mainFrame.this.visual_ratio, mainFrame.this.row1 - 10, le / mainFrame.this.visual_ratio + 1, 5);
                        continue;
                    }
                    g2.fillRect((x + mainFrame.this.shiftG2) / mainFrame.this.visual_ratio, mainFrame.this.row2 + 25, le / mainFrame.this.visual_ratio + 1, 5);
                }
                boxposX = 400;
                g2.setPaint(Color.BLACK);
                g2.drawRect(10 + boxposX, mainFrame.this.row2 + 66, 288, 100);
                g2.setFont(new Font("Serif", 0, 12));
                g2.setPaint(Color.WHITE);
                g2.fillRect(18 + boxposX, mainFrame.this.row2 + 60, 96, 20);
                g2.setPaint(Color.BLACK);
                g2.drawString("Tip-box legend", 20 + boxposX, mainFrame.this.row2 + 72);
                for (int i2 = 0; i2 < mainFrame.this.colorDescription.size(); ++i2) {
                    g2.setPaint((Color)mainFrame.this.colorName.get(i2));
                    g2.fillRect(20 + boxposX, mainFrame.this.row2 + 85 + i2 * 17, 15, 6);
                    g2.drawString(mainFrame.this.colorDescription.get(i2).toString(), 40 + boxposX, mainFrame.this.row2 + 90 + i2 * 17);
                }
            }
            boxposX = 0;
            g2.setPaint(Color.BLACK);
            g2.drawRect(10 + boxposX, mainFrame.this.row2 + 66, 395, 100);
            g2.setFont(new Font("Serif", 0, 12));
            g2.setPaint(Color.WHITE);
            g2.fillRect(18 + boxposX, mainFrame.this.row2 + 60, 83, 20);
            g2.setPaint(Color.BLACK);
            g2.drawString("Figure legend", 20 + boxposX, mainFrame.this.row2 + 72);
            g2.setPaint(Color.RED);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(20 + boxposX, mainFrame.this.row2 + 80, 25.0, 14.0, 10.0, 8.0);
            g2.fill(rr);
            g2.drawString("Strain-specific genes", 50 + boxposX, mainFrame.this.row2 + 90);
            g2.setPaint(Color.DARK_GRAY);
            RoundRectangle2D.Double rrr = new RoundRectangle2D.Double(20 + boxposX, mainFrame.this.row2 + 100, 25.0, 14.0, 10.0, 8.0);
            g2.fill(rrr);
            g2.drawString("Orthologues occurring in both genomes are connected by", 50 + boxposX, mainFrame.this.row2 + 110);
            g2.drawString("a thin line. According to the rainbox colors, the lines", 50 + boxposX, mainFrame.this.row2 + 125);
            g2.drawString("describe close synteny (red) up to distant genome re-", 50 + boxposX, mainFrame.this.row2 + 140);
            g2.drawString("arrangement (blue). ", 50 + boxposX, mainFrame.this.row2 + 155);
            if (this.flag_batch_select) {
                x = Math.min(this.sx, this.thisx);
                int y = Math.min(this.sy, this.thisy);
                int lx = Math.abs(this.thisx - this.sx);
                int ly = Math.abs(this.thisy - this.sy);
                g2.setXORMode(Color.YELLOW);
                g2.fillRect(x, y, lx, ly);
            }
        }

        class RemindTask
        extends TimerTask {
            private JEditorPane je;
            private ComparePane a;

            public RemindTask(ComparePane a, JEditorPane je) {
                this.je = je;
                this.a = a;
            }

            public void run() {
                this.a.remove(this.je);
            }
        }
    }

    class DotAPane
    extends JPanel {
        Hashtable hit = new Hashtable(3500, 0.9f);

        DotAPane() {
            for (int j = 0; j < mainFrame.this.s2.size(); ++j) {
                this.hit.put(((Contig)mainFrame.this.s2.get(j)).getName(), new Integer(j));
            }
        }

        public void paintComponent(Graphics g) {
            int i;
            Rectangle d;
            int i2;
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(mainFrame.this.DotBColor);
            Rectangle rect = this.getVisibleRect();
            g2.setColor(mainFrame.this.DotBColor);
            g2.fill(rect);
            for (i2 = 0; i2 < mainFrame.this.s1.size(); ++i2) {
                Contig con1 = (Contig)mainFrame.this.s1.get(i2);
                if (con1.getOrtholog().equals("")) {
                    d = new Rectangle(con1.getStart() / mainFrame.this.DotARatio, 0, (con1.getEnd() - con1.getStart()) / mainFrame.this.DotARatio + 1, 5);
                    g2.setPaint(Color.red);
                    g2.fill(d);
                    continue;
                }
                if (!this.hit.containsKey(con1.getOrtholog())) continue;
                Contig con2 = (Contig)mainFrame.this.s2.get((Integer)this.hit.get(con1.getOrtholog()));
                Rectangle d2 = new Rectangle(con1.getStart() / mainFrame.this.DotARatio, con2.getStart() / mainFrame.this.DotARatio, (con1.getEnd() - con1.getStart()) / mainFrame.this.DotARatio + mainFrame.this.DotenRich, (con2.getEnd() - con2.getStart()) / mainFrame.this.DotARatio + mainFrame.this.DotenRich);
                g2.setPaint(mainFrame.this.DotColor);
                g2.fill(d2);
            }
            for (i2 = 0; i2 < mainFrame.this.s2.size(); ++i2) {
                Contig con2 = (Contig)mainFrame.this.s2.get(i2);
                if (!con2.getOrtholog().equals("")) continue;
                d = new Rectangle(0, con2.getStart() / mainFrame.this.DotARatio, 5, (con2.getEnd() - con2.getStart()) / mainFrame.this.DotARatio + 1);
                g2.setPaint(Color.red);
                g2.fill(d);
            }
            g2.setPaint(Color.blue);
            g2.drawRect(0, 0, mainFrame.this.maxLen1 / mainFrame.this.DotARatio, 1);
            int h = mainFrame.this.jSli_DotA_Zoom.getValue() / 10 * 10 + 5;
            for (i = 0; i < mainFrame.this.maxLen1; i += 1000 * h) {
                g2.drawLine(i / mainFrame.this.DotARatio, 0, i / mainFrame.this.DotARatio, 5);
                g2.drawString(i / 1000 + "", i / mainFrame.this.DotARatio - 15, 15);
            }
            g2.drawRect(0, 0, 1, mainFrame.this.maxLen2 / mainFrame.this.DotARatio);
            for (i = 0; i < mainFrame.this.maxLen2; i += 1000 * h) {
                g2.drawLine(0, i / mainFrame.this.DotARatio, 5, i / mainFrame.this.DotARatio);
                g2.drawString(i / 1000 + "", 5, i / mainFrame.this.DotARatio + 5);
            }
            this.setPreferredSize(new Dimension(mainFrame.this.maxLen1 / mainFrame.this.DotARatio + 1, mainFrame.this.maxLen2 / mainFrame.this.DotARatio + 1));
        }
    }
}

