/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CharIndexedInputStream
implements CharIndexed {
    private static final int BUFFER_INCREMENT = 1024;
    private static final int UNKNOWN = Integer.MAX_VALUE;
    private BufferedInputStream br;
    private int index = -1;
    private int bufsize = 1024;
    private int end = Integer.MAX_VALUE;
    private char cached = (char)65535;
    private char[] lookBehind = new char[]{'\uffff', '\uffff'};

    CharIndexedInputStream(InputStream str, int index) {
        this.br = str instanceof BufferedInputStream ? (BufferedInputStream)str : new BufferedInputStream(str, 1024);
        this.next();
        if (index > 0) {
            this.move(index);
        }
    }

    private boolean next() {
        if (this.end == 1) {
            return false;
        }
        --this.end;
        try {
            if (this.index != -1) {
                this.br.reset();
            }
            int i = this.br.read();
            this.br.mark(this.bufsize);
            if (i == -1) {
                this.end = 1;
                this.cached = (char)65535;
                return false;
            }
            this.cached = (char)i;
            this.index = 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.cached = (char)65535;
            return false;
        }
        return true;
    }

    public char charAt(int index) {
        if (index == 0) {
            return this.cached;
        }
        if (index >= this.end) {
            return '\uffff';
        }
        if (index == -1) {
            return this.lookBehind[0];
        }
        if (index == -2) {
            return this.lookBehind[1];
        }
        if (index < -2) {
            return '\uffff';
        }
        if (index >= this.bufsize) {
            try {
                while (this.bufsize <= index) {
                    this.bufsize += 1024;
                }
                this.br.reset();
                this.br.mark(this.bufsize);
                this.br.skip(index - 1);
            }
            catch (IOException e) {}
        } else if (this.index != index) {
            try {
                this.br.reset();
                this.br.skip(index - 1);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        char ch = '\uffff';
        try {
            int i = this.br.read();
            this.index = index + 1;
            if (i == -1) {
                this.end = index;
                return ch;
            }
            ch = (char)i;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ch;
    }

    public boolean move(int index) {
        boolean retval = true;
        while (retval && index-- > 0) {
            retval = this.next();
        }
        return retval;
    }

    public boolean isValid() {
        return this.cached != '\uffff';
    }
}

