/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionListHandler;
import org.gjt.sp.jedit.BeanShellAction;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class ActionSet {
    ActionContext context;
    private String label = "<no label set; plugin bug>";
    private Hashtable actions = new Hashtable();
    private PluginJAR plugin;
    private URL uri;
    private boolean loaded = true;
    private static final Object placeholder = new Object();

    public ActionSet() {
    }

    public ActionSet(PluginJAR plugin, String[] cachedActionNames, boolean[] cachedActionToggleFlags, URL uri) {
        this();
        this.plugin = plugin;
        this.uri = uri;
        if (cachedActionNames != null) {
            for (int i = 0; i < cachedActionNames.length; ++i) {
                this.actions.put(cachedActionNames[i], placeholder);
                jEdit.setTemporaryProperty(cachedActionNames[i] + ".toggle", cachedActionToggleFlags[i] ? "true" : "false");
            }
        }
        this.loaded = false;
    }

    public ActionSet(String label) {
        this();
        this.setLabel(label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label == null) {
            throw new NullPointerException();
        }
        this.label = label;
    }

    public PluginJAR getPluginJAR() {
        return this.plugin;
    }

    public void addAction(EditAction action) {
        this.actions.put(action.getName(), action);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.put(action.getName(), this);
        }
    }

    public void removeAction(String name) {
        this.actions.remove(name);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.remove(name);
        }
    }

    public void removeAllActions() {
        if (this.context != null) {
            this.context.actionNames = null;
            String[] actions = this.getActionNames();
            for (int i = 0; i < actions.length; ++i) {
                this.context.actionHash.remove(actions[i]);
            }
        }
        this.actions.clear();
    }

    public EditAction getAction(String name) {
        Object obj = this.actions.get(name);
        if (obj == placeholder) {
            this.load();
            obj = this.actions.get(name);
            if (obj == placeholder) {
                Log.log(7, this, "Outdated cache");
                obj = null;
            }
        }
        return (EditAction)obj;
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public String[] getActionNames() {
        String[] retVal = new String[this.actions.size()];
        Enumeration e = this.actions.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            retVal[i++] = (String)e.nextElement();
        }
        return retVal;
    }

    public String[] getCacheableActionNames() {
        LinkedList<String> retVal = new LinkedList<String>();
        Enumeration e = this.actions.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj == placeholder) {
                Log.log(7, this, "Action set not up to date");
                continue;
            }
            if (!(obj instanceof BeanShellAction)) continue;
            retVal.add(((BeanShellAction)obj).getName());
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    public EditAction[] getActions() {
        this.load();
        EditAction[] retVal = new EditAction[this.actions.size()];
        Enumeration e = this.actions.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            retVal[i++] = (EditAction)e.nextElement();
        }
        return retVal;
    }

    public boolean contains(String action) {
        return this.actions.containsKey(action);
    }

    public int size() {
        return this.actions.size();
    }

    public String toString() {
        return this.label;
    }

    public void initKeyBindings() {
        InputHandler inputHandler = jEdit.getInputHandler();
        Iterator iter = this.actions.entrySet().iterator();
        while (iter.hasNext()) {
            String shortcut2;
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            String shortcut1 = jEdit.getProperty(name + ".shortcut");
            if (shortcut1 != null) {
                inputHandler.addKeyBinding(shortcut1, name);
            }
            if ((shortcut2 = jEdit.getProperty(name + ".shortcut2")) == null) continue;
            inputHandler.addKeyBinding(shortcut2, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        block15: {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            Reader stream = null;
            Log.log(1, this, "Loading actions from " + this.uri);
            ActionListHandler ah = new ActionListHandler(this.uri.toString(), this);
            stream = new BufferedReader(new InputStreamReader(this.uri.openStream()));
            XmlParser parser = new XmlParser();
            parser.setHandler(ah);
            parser.parse(null, null, stream);
            Object var6_7 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block15;
            }
            catch (IOException io) {
                Log.log(9, this, io);
            }
            break block15;
            {
                catch (XmlException xe) {
                    int line = xe.getLine();
                    String message = xe.getMessage();
                    Log.log(9, this, this.uri + ":" + line + ": " + message);
                    Object var6_8 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block15;
                    }
                    catch (IOException io) {
                        Log.log(9, this, io);
                    }
                    break block15;
                }
                catch (Exception e) {
                    Log.log(9, this.uri, e);
                    Object var6_9 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block15;
                    }
                    catch (IOException io) {
                        Log.log(9, this, io);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, this, io);
                }
                throw throwable;
            }
        }
    }

    void getActionNames(List vec) {
        Enumeration e = this.actions.keys();
        while (e.hasMoreElements()) {
            vec.add(e.nextElement());
        }
    }
}

