/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import bsh.BshMethod;
import bsh.NameSpace;
import bsh.UtilEvalError;
import java.awt.Component;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class BeanShellAction
extends EditAction {
    private boolean noRepeat;
    private boolean noRecord;
    private boolean noRememberLast;
    private String code;
    private String isSelected;
    private BshMethod cachedCode;
    private BshMethod cachedIsSelected;
    private String sanitizedName;

    public BeanShellAction(String name, String code, String isSelected, boolean noRepeat, boolean noRecord, boolean noRememberLast) {
        super(name);
        this.code = code;
        this.isSelected = isSelected;
        this.noRepeat = noRepeat;
        this.noRecord = noRecord;
        this.noRememberLast = noRememberLast;
        this.sanitizedName = name.replace('.', '_').replace('-', '_');
        jEdit.setTemporaryProperty(name + ".toggle", isSelected != null ? "true" : "false");
    }

    public void invoke(View view) {
        try {
            if (this.cachedCode == null) {
                String cachedCodeName = "action_" + this.sanitizedName;
                this.cachedCode = BeanShell.cacheBlock(cachedCodeName, this.code, true);
            }
            BeanShell.runCachedBlock(this.cachedCode, view, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.invoke()"));
        }
        catch (Throwable e) {
            Log.log(9, this, e);
            new BeanShellErrorDialog(view, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelected(Component comp) {
        boolean bl;
        if (this.isSelected == null) {
            return false;
        }
        NameSpace global = BeanShell.getNameSpace();
        try {
            try {
                if (this.cachedIsSelected == null) {
                    String cachedIsSelectedName = "selected_" + this.sanitizedName;
                    this.cachedIsSelected = BeanShell.cacheBlock(cachedIsSelectedName, this.isSelected, true);
                }
                View view = GUIUtilities.getView(comp);
                global.setVariable("_comp", comp);
                bl = Boolean.TRUE.equals(BeanShell.runCachedBlock(this.cachedIsSelected, view, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.isSelected()")));
                Object var6_7 = null;
            }
            catch (Throwable e) {
                Log.log(9, this, e);
                this.isSelected = null;
                boolean bl2 = false;
                Object var6_8 = null;
                try {
                    global.setVariable("_comp", null);
                    return bl2;
                }
                catch (UtilEvalError err) {
                    Log.log(9, this, err);
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {}
            catch (UtilEvalError err) {
                Log.log(9, this, err);
                throw throwable;
            }
            global.setVariable("_comp", null);
            throw throwable;
        }
        try {}
        catch (UtilEvalError err) {
            Log.log(9, this, err);
            return bl;
        }
        global.setVariable("_comp", null);
        return bl;
    }

    public boolean noRepeat() {
        return this.noRepeat;
    }

    public boolean noRecord() {
        return this.noRecord;
    }

    public boolean noRememberLast() {
        return this.noRememberLast;
    }

    public String getCode() {
        return this.code.trim();
    }
}

