/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.RESyntax;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeListener;
import org.gjt.sp.jedit.buffer.BufferIORequest;
import org.gjt.sp.jedit.buffer.ContentManager;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.LineElement;
import org.gjt.sp.jedit.buffer.LineManager;
import org.gjt.sp.jedit.buffer.PositionManager;
import org.gjt.sp.jedit.buffer.RootElement;
import org.gjt.sp.jedit.buffer.UndoManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.RESearchMatcher;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.DummyTokenHandler;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ReadWriteLock;

public class Buffer {
    public static final String LINESEP = "lineSeparator";
    public static final String BACKED_UP = "Buffer__backedUp";
    public static final String CARET = "Buffer__caret";
    public static final String SELECTION = "Buffer__selection";
    public static final String SCROLL_VERT = "Buffer__scrollVert";
    public static final String SCROLL_HORIZ = "Buffer__scrollHoriz";
    public static final String ENCODING = "encoding";
    public static final String ENCODING_AUTODETECT = "encodingAutodetect";
    public static final String TRAILING_EOL = "trailingEOL";
    public static final String GZIPPED = "gzipped";
    public static final int FILE_NOT_CHANGED = 0;
    public static final int FILE_CHANGED = 1;
    public static final int FILE_DELETED = 2;
    public static final int NORMAL_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    Buffer prev;
    Buffer next;
    private static final int CLOSED = 0;
    private static final int LOADING = 1;
    private static final int IO = 2;
    private static final int NEW_FILE = 3;
    private static final int UNTITLED = 4;
    private static final int AUTOSAVE_DIRTY = 5;
    private static final int DIRTY = 6;
    private static final int READ_ONLY = 7;
    private static final int READ_ONLY_OVERRIDE = 8;
    private static final int UNDO_IN_PROGRESS = 9;
    private static final int TEMPORARY = 10;
    private static final int TRANSACTION = 11;
    private int flags;
    private String path;
    private String symlinkPath;
    private String name;
    private String directory;
    private File file;
    private File autosaveFile;
    private long modTime;
    private Mode mode;
    private HashMap properties;
    private ReadWriteLock lock = new ReadWriteLock();
    private Object propertyLock = new Object();
    private ContentManager contentMgr = new ContentManager();
    private LineManager lineMgr = new LineManager();
    private PositionManager positionMgr = new PositionManager();
    private IntegerArray integerArray = new IntegerArray();
    private UndoManager undoMgr = new UndoManager(this);
    private Vector bufferListeners = new Vector();
    private Vector markers;
    private boolean textMode;
    private TokenMarker tokenMarker;
    private Segment seg = new Segment();
    private FoldHandler foldHandler;
    private Socket waitSocket;

    public void reload(View view) {
        Object[] args;
        int result;
        if (this.getFlag(6) && (result = GUIUtilities.confirm(view, "changedreload", args = new String[]{this.path}, 0, 2)) != 0) {
            return;
        }
        view.getEditPane().saveCaretInfo();
        this.load(view, true);
    }

    public boolean load(final View view, final boolean reload) {
        boolean loadAutosave;
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        this.setFlag(1, true);
        if (!this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, view, BufferUpdate.LOAD_STARTED));
        }
        if (reload || !this.getFlag(3)) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!reload && this.autosaveFile != null && this.autosaveFile.exists()) {
                loadAutosave = this.recoverAutosave(view);
            } else {
                if (this.autosaveFile != null) {
                    this.autosaveFile.delete();
                }
                loadAutosave = false;
            }
            if (!loadAutosave) {
                VFS vfs = VFSManager.getVFSForPath(this.path);
                if (!this.checkFileForLoad(view, vfs, this.path)) {
                    this.setFlag(1, false);
                    return false;
                }
                if (!(!reload && this.getFlag(3) || vfs.load(view, this, this.path))) {
                    this.setFlag(1, false);
                    return false;
                }
            }
        } else {
            loadAutosave = false;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String newPath = Buffer.this.getStringProperty("BufferIORequest__newPath");
                Segment seg = (Segment)Buffer.this.getProperty("BufferIORequest__loadData");
                IntegerArray endOffsets = (IntegerArray)Buffer.this.getProperty("BufferIORequest__endOffsets");
                if (seg == null) {
                    seg = new Segment(new char[1024], 0, 0);
                }
                if (endOffsets == null) {
                    endOffsets = new IntegerArray();
                    endOffsets.add(1);
                }
                try {
                    Buffer.this.writeLock();
                    Buffer.this.firePreContentRemoved(0, 0, Buffer.this.getLineCount() - 1, Buffer.this.getLength());
                    Buffer.this.contentMgr.remove(0, Buffer.this.getLength());
                    Buffer.this.lineMgr.contentRemoved(0, 0, Buffer.this.getLineCount() - 1, Buffer.this.getLength());
                    Buffer.this.positionMgr.contentRemoved(0, Buffer.this.getLength());
                    Buffer.this.fireContentRemoved(0, 0, Buffer.this.getLineCount() - 1, Buffer.this.getLength());
                    Buffer.this.contentMgr._setContent(seg.array, seg.count);
                    Buffer.this.lineMgr._contentInserted(endOffsets);
                    Buffer.this.positionMgr.contentInserted(0, seg.count);
                    Buffer.this.fireContentInserted(0, 0, endOffsets.getSize() - 1, seg.count - 1);
                }
                finally {
                    Buffer.this.writeUnlock();
                }
                Buffer.this.unsetProperty("BufferIORequest__loadData");
                Buffer.this.unsetProperty("BufferIORequest__endOffsets");
                Buffer.this.unsetProperty("BufferIORequest__newPath");
                Buffer.this.undoMgr.clear();
                Buffer.this.undoMgr.setLimit(jEdit.getIntegerProperty("buffer.undoCount", 100));
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.finishLoading();
                }
                Buffer.this.setFlag(1, false);
                if (reload) {
                    Buffer.this.setDirty(false);
                }
                if (!loadAutosave && newPath != null) {
                    Buffer.this.setPath(newPath);
                }
                if (loadAutosave) {
                    Buffer.this.setFlag(6, true);
                }
                if (!Buffer.this.getFlag(10)) {
                    EditBus.send(new BufferUpdate(Buffer.this, view, BufferUpdate.LOADED));
                }
            }
        };
        if (this.getFlag(10)) {
            runnable.run();
        } else {
            VFSManager.runInAWTThread(runnable);
        }
        return true;
    }

    public boolean insertFile(View view, String path) {
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        path = MiscUtilities.constructPath(this.path, path);
        Buffer buffer = jEdit.getBuffer(path);
        if (buffer != null) {
            view.getTextArea().setSelectedText(buffer.getText(0, buffer.getLength()));
            return true;
        }
        VFS vfs = VFSManager.getVFSForPath(path);
        return vfs.insert(view, this, path);
    }

    public void autosave() {
        if (this.autosaveFile == null || !this.getFlag(5) || !this.getFlag(6) || this.getFlag(1) || this.getFlag(2)) {
            return;
        }
        this.setFlag(5, false);
        VFSManager.runInWorkThread(new BufferIORequest(2, null, this, null, VFSManager.getFileVFS(), this.autosaveFile.getPath()));
    }

    public boolean saveAs(View view, boolean rename) {
        String[] files = GUIUtilities.showVFSFileDialog(view, this.path, 1, false);
        if (files == null) {
            return false;
        }
        return this.save(view, files[0], rename);
    }

    public boolean save(View view, String path) {
        return this.save(view, path, true);
    }

    public boolean save(final View view, String path, final boolean rename) {
        Object[] args;
        int result;
        long newModTime;
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        if (path == null && this.getFlag(3)) {
            return this.saveAs(view, rename);
        }
        if (path == null && this.file != null && (newModTime = this.file.lastModified()) != this.modTime && jEdit.getBooleanProperty("view.checkModStatus") && (result = GUIUtilities.confirm(view, "filechanged-save", args = new Object[]{this.path}, 0, 2)) != 0) {
            return false;
        }
        EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVING));
        this.setFlag(2, true);
        final String oldPath = this.path;
        final String oldSymlinkPath = this.symlinkPath;
        final String newPath = path == null ? this.path : path;
        VFS vfs = VFSManager.getVFSForPath(newPath);
        if (!this.checkFileForSave(view, vfs, newPath)) {
            this.setFlag(2, false);
            return false;
        }
        if (!vfs.save(view, this, newPath)) {
            this.setFlag(2, false);
            return false;
        }
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                Buffer.this.setFlag(2, false);
                Buffer.this.finishSaving(view, oldPath, oldSymlinkPath, newPath, rename, Buffer.this.getBooleanProperty("BufferIORequest__error"));
            }
        });
        return true;
    }

    public int checkFileStatus(View view) {
        if (!(this.getFlag(2) || this.getFlag(1) || this.file == null || this.getFlag(3))) {
            boolean newReadOnly;
            boolean bl = newReadOnly = this.file.exists() && !this.file.canWrite();
            if (newReadOnly != this.getFlag(7)) {
                this.setFlag(7, newReadOnly);
                EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
            }
            long oldModTime = this.modTime;
            long newModTime = this.file.lastModified();
            if (newModTime != oldModTime) {
                this.modTime = newModTime;
                if (!this.file.exists()) {
                    this.setFlag(3, true);
                    this.setDirty(true);
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    public long getLastModified() {
        return this.modTime;
    }

    public void setLastModified(long modTime) {
        this.modTime = modTime;
    }

    public VFS getVFS() {
        return VFSManager.getVFSForPath(this.path);
    }

    public File getAutosaveFile() {
        return this.autosaveFile;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getSymlinkPath() {
        return this.symlinkPath;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isClosed() {
        return this.getFlag(0);
    }

    public boolean isLoaded() {
        return !this.getFlag(1);
    }

    public boolean isPerformingIO() {
        return this.getFlag(1) || this.getFlag(2);
    }

    public boolean isNewFile() {
        return this.getFlag(3);
    }

    public void setNewFile(boolean newFile) {
        this.setFlag(3, newFile);
        if (!newFile) {
            this.setFlag(4, false);
        }
    }

    public boolean isUntitled() {
        return this.getFlag(4);
    }

    public boolean isDirty() {
        return this.getFlag(6);
    }

    public boolean isReadOnly() {
        return this.getFlag(7) || this.getFlag(8);
    }

    public boolean isEditable() {
        return !this.getFlag(7) && !this.getFlag(8) && !this.getFlag(2) && !this.getFlag(1);
    }

    public void setReadOnly(boolean readOnly) {
        this.setFlag(8, readOnly);
    }

    public void setDirty(boolean d) {
        boolean old_d = this.getFlag(6);
        boolean editable = this.isEditable();
        if (d) {
            if (editable) {
                this.setFlag(6, true);
                this.setFlag(5, true);
            }
        } else {
            this.setFlag(6, false);
            this.setFlag(5, false);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
            if (!this.getFlag(9)) {
                this.undoMgr.bufferSaved();
            }
        }
        if (d != old_d && editable) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
        }
    }

    public boolean isTemporary() {
        return this.getFlag(10);
    }

    public Icon getIcon() {
        if (this.getFlag(6)) {
            return GUIUtilities.loadIcon("dirty.gif");
        }
        if (this.getFlag(7) || this.getFlag(8)) {
            return GUIUtilities.loadIcon("readonly.gif");
        }
        if (this.getFlag(3)) {
            return GUIUtilities.loadIcon("new.gif");
        }
        return GUIUtilities.loadIcon("normal.gif");
    }

    public void readLock() {
        this.lock.readLock();
    }

    public void readUnlock() {
        this.lock.readUnlock();
    }

    public void writeLock() {
        this.lock.writeLock();
    }

    public void writeUnlock() {
        this.lock.writeUnlock();
    }

    public int getLength() {
        return this.contentMgr.getLength();
    }

    public int getLineCount() {
        return this.lineMgr.getLineCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineOfOffset(int offset) {
        try {
            this.readLock();
            if (offset < 0 || offset > this.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            int n = this.lineMgr.getLineOfOffset(offset);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineStartOffset(int line) {
        try {
            this.readLock();
            if (line < 0 || line >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(line);
            }
            if (line == 0) {
                int n = 0;
                return n;
            }
            int n = this.lineMgr.getLineEndOffset(line - 1);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineEndOffset(int line) {
        try {
            this.readLock();
            if (line < 0 || line >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(line);
            }
            int n = this.lineMgr.getLineEndOffset(line);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineLength(int line) {
        try {
            this.readLock();
            int n = this.getLineEndOffset(line) - this.getLineStartOffset(line) - 1;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public void invalidateCachedScreenLineCounts() {
        this.lineMgr.invalidateScreenLineCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineText(int line) {
        if (line < 0 || line >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        try {
            this.readLock();
            int start = line == 0 ? 0 : this.lineMgr.getLineEndOffset(line - 1);
            int end = this.lineMgr.getLineEndOffset(line);
            String string = this.getText(start, end - start - 1);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLineText(int line, Segment segment) {
        if (line < 0 || line >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        try {
            this.readLock();
            int start = line == 0 ? 0 : this.lineMgr.getLineEndOffset(line - 1);
            int end = this.lineMgr.getLineEndOffset(line);
            this.getText(start, end - start - 1, segment);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int start, int length) {
        try {
            this.readLock();
            if (start < 0 || length < 0 || start + length > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(start + ":" + length);
            }
            String string = this.contentMgr.getText(start, length);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(int start, int length, Segment seg) {
        try {
            this.readLock();
            if (start < 0 || length < 0 || start + length > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(start + ":" + length);
            }
            this.contentMgr.getText(start, length, seg);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int offset, String str) {
        if (str == null) {
            return;
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.writeLock();
            if (offset < 0 || offset > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            this.contentMgr.insert(offset, str);
            this.integerArray.clear();
            for (int i = 0; i < len; ++i) {
                if (str.charAt(i) != '\n') continue;
                this.integerArray.add(i + 1);
            }
            if (!this.getFlag(9)) {
                this.undoMgr.contentInserted(offset, len, str, !this.getFlag(6));
            }
            this.contentInserted(offset, len, this.integerArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int offset, Segment seg) {
        if (seg.count == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.writeLock();
            if (offset < 0 || offset > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            this.contentMgr.insert(offset, seg);
            this.integerArray.clear();
            for (int i = 0; i < seg.count; ++i) {
                if (seg.array[seg.offset + i] != '\n') continue;
                this.integerArray.add(i + 1);
            }
            if (!this.getFlag(9)) {
                this.undoMgr.contentInserted(offset, seg.count, seg.toString(), !this.getFlag(6));
            }
            this.contentInserted(offset, seg.count, this.integerArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int offset, int length) {
        if (length == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.setFlag(11, true);
            this.writeLock();
            if (offset < 0 || length < 0 || offset + length > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset + ":" + length);
            }
            int startLine = this.lineMgr.getLineOfOffset(offset);
            int endLine = this.lineMgr.getLineOfOffset(offset + length);
            int numLines = endLine - startLine;
            if (!this.getFlag(9) && !this.getFlag(1)) {
                this.undoMgr.contentRemoved(offset, length, this.getText(offset, length), !this.getFlag(6));
            }
            this.firePreContentRemoved(startLine, offset, numLines, length);
            this.contentMgr.remove(offset, length);
            this.lineMgr.contentRemoved(startLine, offset, numLines, length);
            this.positionMgr.contentRemoved(offset, length);
            this.fireContentRemoved(startLine, offset, numLines, length);
            if (!this.getFlag(9) && !this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
            this.setDirty(true);
        }
        finally {
            this.setFlag(11, false);
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo(JEditTextArea textArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        try {
            this.writeLock();
            this.setFlag(9, true);
            int caret = this.undoMgr.undo();
            if (caret == -1) {
                textArea.getToolkit().beep();
            } else {
                textArea.setCaretPosition(caret);
            }
            this.fireTransactionComplete();
        }
        finally {
            this.setFlag(9, false);
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo(JEditTextArea textArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            this.writeLock();
            this.setFlag(9, true);
            int caret = this.undoMgr.redo();
            if (caret == -1) {
                textArea.getToolkit().beep();
            } else {
                textArea.setCaretPosition(caret);
            }
            this.fireTransactionComplete();
        }
        finally {
            this.setFlag(9, false);
            this.writeUnlock();
        }
    }

    public boolean isTransactionInProgress() {
        return this.getFlag(11) || this.getFlag(9) || this.insideCompoundEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.beginCompoundEdit();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.endCompoundEdit();
            if (!this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean insideCompoundEdit() {
        return this.undoMgr.insideCompoundEdit();
    }

    public void addBufferChangeListener(BufferChangeListener listener, int priority) {
        Listener l = new Listener(listener, priority);
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            Listener _l = (Listener)this.bufferListeners.get(i);
            if (_l.priority >= priority) continue;
            this.bufferListeners.insertElementAt(l, i);
            return;
        }
        this.bufferListeners.addElement(l);
    }

    public void addBufferChangeListener(BufferChangeListener listener) {
        this.addBufferChangeListener(listener, 0);
    }

    public void removeBufferChangeListener(BufferChangeListener listener) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            if (((Listener)this.bufferListeners.get((int)i)).listener != listener) continue;
            this.bufferListeners.removeElementAt(i);
            return;
        }
    }

    public BufferChangeListener[] getBufferChangeListeners() {
        BufferChangeListener[] returnValue = new BufferChangeListener[this.bufferListeners.size()];
        for (int i = 0; i < returnValue.length; ++i) {
            returnValue[i] = ((Listener)this.bufferListeners.get((int)i)).listener;
        }
        return returnValue;
    }

    public void propertiesChanged() {
        String folding = this.getStringProperty("folding");
        FoldHandler handler = FoldHandler.getFoldHandler(folding);
        if (handler != null) {
            this.setFoldHandler(handler);
        } else {
            if (folding != null) {
                Log.log(7, this, this.path + ": invalid 'folding' property: " + folding);
            }
            this.setFoldHandler(new DummyFoldHandler());
        }
        EditBus.send(new BufferUpdate(this, null, BufferUpdate.PROPERTIES_CHANGED));
    }

    public int getTabSize() {
        int tabSize = this.getIntegerProperty("tabSize", 8);
        if (tabSize <= 0) {
            return 8;
        }
        return tabSize;
    }

    public int getIndentSize() {
        int indentSize = this.getIntegerProperty("indentSize", 8);
        if (indentSize <= 0) {
            return 8;
        }
        return indentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(Object name) {
        Object object = this.propertyLock;
        synchronized (object) {
            Object retVal;
            PropValue o = (PropValue)this.properties.get(name);
            if (o != null) {
                return o.value;
            }
            if (!(name instanceof String)) {
                return null;
            }
            if (this.mode != null) {
                Object retVal2 = this.mode.getProperty((String)name);
                if (retVal2 == null) {
                    return null;
                }
                this.properties.put(name, new PropValue(retVal2, true));
                return retVal2;
            }
            String value = jEdit.getProperty("buffer." + name);
            if (value == null) {
                return null;
            }
            try {
                retVal = new Integer(value);
            }
            catch (NumberFormatException nf) {
                retVal = value;
            }
            this.properties.put(name, new PropValue(retVal, true));
            return retVal;
        }
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            PropValue test = (PropValue)this.properties.get(name);
            if (test == null) {
                this.properties.put(name, new PropValue(value, false));
            } else if (!test.value.equals(value)) {
                test.value = value;
                test.defaultValue = false;
            }
        }
    }

    public void unsetProperty(String name) {
        this.properties.remove(name);
    }

    public String getStringProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setStringProperty(String name, String value) {
        this.setProperty(name, value);
    }

    public boolean getBooleanProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return "true".equals(obj) || "on".equals(obj) || "yes".equals(obj);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getIntegerProperty(String name, int defaultValue) {
        boolean defaultValueFlag;
        Object obj;
        PropValue value = (PropValue)this.properties.get(name);
        if (value != null) {
            obj = value.value;
            defaultValueFlag = value.defaultValue;
        } else {
            obj = this.getProperty(name);
            defaultValueFlag = true;
        }
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            int returnValue = Integer.parseInt(obj.toString().trim());
            this.properties.put(name, new PropValue(new Integer(returnValue), defaultValueFlag));
            return returnValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setIntegerProperty(String name, int value) {
        this.setProperty(name, new Integer(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RE getRegexpProperty(String name, int cflags, RESyntax syntax) throws REException {
        Object object = this.propertyLock;
        synchronized (object) {
            boolean defaultValueFlag;
            Object obj;
            PropValue value = (PropValue)this.properties.get(name);
            if (value != null) {
                obj = value.value;
                defaultValueFlag = value.defaultValue;
            } else {
                obj = this.getProperty(name);
                defaultValueFlag = true;
            }
            if (obj == null) {
                return null;
            }
            if (obj instanceof RE) {
                return (RE)obj;
            }
            RE re = new RE(obj.toString(), cflags, syntax);
            this.properties.put(name, new PropValue(re, defaultValueFlag));
            return re;
        }
    }

    public ParserRuleSet getRuleSetAtOffset(int offset) {
        int line;
        if ((offset -= this.getLineStartOffset(line = this.getLineOfOffset(offset))) != 0) {
            --offset;
        }
        DefaultTokenHandler tokens = new DefaultTokenHandler();
        this.markTokens(line, tokens);
        Token token = TextUtilities.getTokenAtOffset(tokens.getTokens(), offset);
        return token.rules;
    }

    public KeywordMap getKeywordMapAtOffset(int offset) {
        return this.getRuleSetAtOffset(offset).getKeywords();
    }

    public String getContextSensitiveProperty(int offset, String name) {
        ParserRuleSet rules = this.getRuleSetAtOffset(offset);
        Object value = null;
        Hashtable rulesetProps = rules.getProperties();
        if (rulesetProps != null) {
            value = rulesetProps.get(name);
        }
        if (value == null && (value = jEdit.getMode(rules.getModeName()).getProperty(name)) == null) {
            value = this.mode.getProperty(name);
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public void toggleWordWrap(View view) {
        String wrap = this.getStringProperty("wrap");
        if (wrap.equals("none")) {
            wrap = "soft";
        } else if (wrap.equals("soft")) {
            wrap = "hard";
        } else if (wrap.equals("hard")) {
            wrap = "none";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.wrap-changed", new String[]{wrap}));
        this.setProperty("wrap", wrap);
        this.propertiesChanged();
    }

    public void toggleLineSeparator(View view) {
        String status = null;
        String lineSep = this.getStringProperty(LINESEP);
        if ("\n".equals(lineSep)) {
            status = "windows";
            lineSep = "\r\n";
        } else if ("\r\n".equals(lineSep)) {
            status = "mac";
            lineSep = "\r";
        } else if ("\r".equals(lineSep)) {
            status = "unix";
            lineSep = "\n";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.linesep-changed", new String[]{jEdit.getProperty("lineSep." + status)}));
        this.setProperty(LINESEP, lineSep);
        this.setDirty(true);
        this.propertiesChanged();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.setMode(jEdit.getMode(mode));
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException("Mode must be non-null");
        }
        this.mode = mode;
        this.textMode = "text".equals(mode.getName());
        this.setTokenMarker(mode.getTokenMarker());
        this.resetCachedProperties();
        this.propertiesChanged();
    }

    public void setMode() {
        Mode m;
        String userMode = this.getStringProperty("mode");
        if (userMode != null && (m = jEdit.getMode(userMode)) != null) {
            this.setMode(m);
            return;
        }
        String nogzName = this.name.substring(0, this.name.length() - (this.name.endsWith(".gz") ? 3 : 0));
        Mode[] modes = jEdit.getModes();
        String firstLine = this.getLineText(0);
        for (int i = modes.length - 1; i >= 0; --i) {
            if (!modes[i].accept(nogzName, firstLine)) continue;
            this.setMode(modes[i]);
            return;
        }
        Mode defaultMode = jEdit.getMode(jEdit.getProperty("buffer.defaultMode"));
        if (defaultMode == null) {
            defaultMode = jEdit.getMode("text");
        }
        this.setMode(defaultMode);
    }

    public void markTokens(int lineIndex, TokenHandler tokenHandler) {
        Segment seg = SwingUtilities.isEventDispatchThread() ? this.seg : new Segment();
        if (lineIndex < 0 || lineIndex >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(lineIndex);
        }
        int firstInvalidLineContext = this.lineMgr.getFirstInvalidLineContext();
        int start = this.textMode || firstInvalidLineContext == -1 ? lineIndex : Math.min(firstInvalidLineContext, lineIndex);
        if (Debug.TOKEN_MARKER_DEBUG) {
            Log.log(1, this, "tokenize from " + start + " to " + lineIndex);
        }
        TokenMarker.LineContext oldContext = null;
        TokenMarker.LineContext context = null;
        for (int i = start; i <= lineIndex; ++i) {
            this.getLineText(i, seg);
            oldContext = this.lineMgr.getLineContext(i);
            TokenMarker.LineContext prevContext = i == 0 || this.textMode ? null : this.lineMgr.getLineContext(i - 1);
            context = this.tokenMarker.markTokens(prevContext, i == lineIndex ? tokenHandler : DummyTokenHandler.INSTANCE, seg);
            this.lineMgr.setLineContext(i, context);
        }
        int lineCount = this.lineMgr.getLineCount();
        if (lineCount - 1 == lineIndex) {
            this.lineMgr.setFirstInvalidLineContext(-1);
        } else if (oldContext != context) {
            this.lineMgr.setFirstInvalidLineContext(lineIndex + 1);
        } else if (firstInvalidLineContext != -1) {
            this.lineMgr.setFirstInvalidLineContext(Math.max(firstInvalidLineContext, lineIndex + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrailingWhiteSpace(int[] lines) {
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < lines.length; ++i) {
                int lineEnd;
                int pos;
                this.getLineText(lines[i], this.seg);
                if (this.seg.count == 0) continue;
                int lineStart = this.seg.offset;
                for (pos = lineEnd = this.seg.offset + this.seg.count - 1; pos >= lineStart && Character.isWhitespace(this.seg.array[pos]); --pos) {
                }
                int tail = lineEnd - pos;
                if (tail == 0) continue;
                this.remove(this.getLineEndOffset(lines[i]) - 1 - tail, tail);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentLeft(int[] lines) {
        int tabSize = this.getTabSize();
        int indentSize = this.getIndentSize();
        boolean noTabs = this.getBooleanProperty("noTabs");
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < lines.length; ++i) {
                int lineStart = this.getLineStartOffset(lines[i]);
                String line = this.getLineText(lines[i]);
                int whiteSpace = MiscUtilities.getLeadingWhiteSpace(line);
                if (whiteSpace == 0) continue;
                int whiteSpaceWidth = Math.max(0, MiscUtilities.getLeadingWhiteSpaceWidth(line, tabSize) - indentSize);
                this.insert(lineStart + whiteSpace, MiscUtilities.createWhiteSpace(whiteSpaceWidth, noTabs ? 0 : tabSize));
                this.remove(lineStart, whiteSpace);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentRight(int[] lines) {
        try {
            this.beginCompoundEdit();
            int tabSize = this.getTabSize();
            int indentSize = this.getIndentSize();
            boolean noTabs = this.getBooleanProperty("noTabs");
            for (int i = 0; i < lines.length; ++i) {
                int lineStart = this.getLineStartOffset(lines[i]);
                String line = this.getLineText(lines[i]);
                int whiteSpace = MiscUtilities.getLeadingWhiteSpace(line);
                int whiteSpaceWidth = MiscUtilities.getLeadingWhiteSpaceWidth(line, tabSize) + indentSize;
                this.insert(lineStart + whiteSpace, MiscUtilities.createWhiteSpace(whiteSpaceWidth, noTabs ? 0 : tabSize));
                this.remove(lineStart, whiteSpace);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int start, int end) {
        try {
            this.beginCompoundEdit();
            for (int i = start; i <= end; ++i) {
                this.indentLine(i, true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int[] lines) {
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < lines.length; ++i) {
                this.indentLine(lines[i], true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    public boolean indentLine(int lineIndex, boolean canIncreaseIndent, boolean canDecreaseIndent) {
        return this.indentLine(lineIndex, canDecreaseIndent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indentLine(int lineIndex, boolean canDecreaseIndent) {
        int[] whitespaceChars = new int[1];
        int currentIndent = this.getCurrentIndentForLine(lineIndex, whitespaceChars);
        int idealIndent = this.getIdealIndentForLine(lineIndex);
        if (idealIndent == -1 || idealIndent == currentIndent || !canDecreaseIndent && idealIndent < currentIndent) {
            return false;
        }
        try {
            this.beginCompoundEdit();
            int start = this.getLineStartOffset(lineIndex);
            this.remove(start, whitespaceChars[0]);
            this.insert(start, MiscUtilities.createWhiteSpace(idealIndent, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize()));
        }
        finally {
            this.endCompoundEdit();
        }
        return true;
    }

    public int getCurrentIndentForLine(int lineIndex, int[] whitespaceChars) {
        this.getLineText(lineIndex, this.seg);
        int tabSize = this.getTabSize();
        int currentIndent = 0;
        block4: for (int i = 0; i < this.seg.count; ++i) {
            char c = this.seg.array[this.seg.offset + i];
            switch (c) {
                case ' ': {
                    ++currentIndent;
                    if (whitespaceChars == null) continue block4;
                    whitespaceChars[0] = whitespaceChars[0] + 1;
                    continue block4;
                }
                case '\t': {
                    currentIndent += tabSize - currentIndent % tabSize;
                    if (whitespaceChars == null) continue block4;
                    whitespaceChars[0] = whitespaceChars[0] + 1;
                    continue block4;
                }
            }
        }
        return currentIndent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIdealIndentForLine(int lineIndex) {
        int i;
        RE indentNextLinesRE;
        RE indentNextLineRE;
        String closeBrackets;
        String EXPLICIT_START = "{{{";
        String EXPLICIT_END = "}}}";
        if (lineIndex == 0) {
            return -1;
        }
        String openBrackets = this.getStringProperty("indentOpenBrackets");
        if (openBrackets == null) {
            openBrackets = "";
        }
        if ((closeBrackets = this.getStringProperty("indentCloseBrackets")) == null) {
            closeBrackets = "";
        }
        try {
            indentNextLineRE = this.getRegexpProperty("indentNextLine", 2, RESearchMatcher.RE_SYNTAX_JEDIT);
        }
        catch (REException re) {
            indentNextLineRE = null;
            Log.log(9, this, "Invalid indentNextLine regexp");
            Log.log(9, this, re);
        }
        try {
            indentNextLinesRE = this.getRegexpProperty("indentNextLines", 2, RESearchMatcher.RE_SYNTAX_JEDIT);
        }
        catch (REException re) {
            indentNextLinesRE = null;
            Log.log(9, this, "Invalid indentNextLines regexp");
            Log.log(9, this, re);
        }
        boolean doubleBracketIndent = this.getBooleanProperty("doubleBracketIndent");
        boolean lineUpClosingBracket = this.getBooleanProperty("lineUpClosingBracket");
        int tabSize = this.getTabSize();
        int indentSize = this.getIndentSize();
        int prevLineIndex = this.getPriorNonEmptyLine(lineIndex);
        if (prevLineIndex == -1) {
            return -1;
        }
        String prevLine = this.getLineText(prevLineIndex);
        boolean prevLineStart = true;
        int indent = 0;
        int prevLineBrackets = 0;
        int prevLineCloseBracketIndex = -1;
        int prevLineUnclosedParenIndex = -1;
        int prevLineParenWeight = 0;
        Stack<Integer> openParens = new Stack<Integer>();
        block8: for (int i2 = 0; i2 < prevLine.length(); ++i2) {
            char c = prevLine.charAt(i2);
            switch (c) {
                case ' ': {
                    if (!prevLineStart) continue block8;
                    ++indent;
                    continue block8;
                }
                case '\t': {
                    if (!prevLineStart) continue block8;
                    indent += tabSize - indent % tabSize;
                    continue block8;
                }
                default: {
                    prevLineStart = false;
                    if (closeBrackets.indexOf(c) != -1) {
                        if (prevLine.regionMatches(false, i2, "}}}", 0, 3)) {
                            i2 += 2;
                            continue block8;
                        }
                        if (--prevLineBrackets >= 0) continue block8;
                        if (lineUpClosingBracket) {
                            prevLineBrackets = 0;
                        }
                        prevLineCloseBracketIndex = i2;
                        continue block8;
                    }
                    if (openBrackets.indexOf(c) != -1) {
                        if (prevLine.regionMatches(false, i2, "{{{", 0, 3)) {
                            i2 += 2;
                            continue block8;
                        }
                        ++prevLineBrackets;
                        continue block8;
                    }
                    if (c == '(') {
                        openParens.push(new Integer(i2));
                        ++prevLineParenWeight;
                        continue block8;
                    }
                    if (c != ')') continue block8;
                    if (openParens.size() > 0) {
                        openParens.pop();
                    }
                    --prevLineParenWeight;
                }
            }
        }
        if (openParens.size() > 0) {
            prevLineUnclosedParenIndex = (Integer)openParens.pop();
        }
        if (Debug.INDENT_DEBUG) {
            Log.log(1, this, "Determined previous line");
            Log.log(1, this, "indent=" + indent + ",prevLineBrackets=" + prevLineBrackets + ",prevLineCloseBracketIndex=" + prevLineCloseBracketIndex);
        }
        String line = this.getLineText(lineIndex);
        int lineBrackets = 0;
        int closeBracketIndex = -1;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (closeBrackets.indexOf(c) != -1) {
                if (line.regionMatches(false, i, "}}}", 0, 3)) {
                    i += 2;
                    continue;
                }
                closeBracketIndex = i;
                --lineBrackets;
                continue;
            }
            if (openBrackets.indexOf(c) == -1) continue;
            if (line.regionMatches(false, i, "{{{", 0, 3)) {
                i += 2;
                continue;
            }
            if (lineBrackets < 0) continue;
            ++lineBrackets;
        }
        if (Debug.INDENT_DEBUG) {
            Log.log(1, this, "Determined current line");
            Log.log(1, this, "lineBrackets=" + lineBrackets + ",closeBracketIndex=" + closeBracketIndex);
        }
        if (this.getBooleanProperty("deepIndent")) {
            int openParenOffset;
            if (prevLineParenWeight > 0) {
                indent = prevLineUnclosedParenIndex + 1;
                for (i = 0; i < prevLine.length(); ++i) {
                    if (prevLine.charAt(i) != '\t') continue;
                    indent += tabSize - 1;
                }
                return indent;
            }
            if (prevLineParenWeight < 0 && (openParenOffset = TextUtilities.findMatchingBracket(this, prevLineIndex, prevLine.lastIndexOf(")"))) >= 0) {
                int startLine = this.getLineOfOffset(openParenOffset);
                int startLineParenWeight = this.getLineParenWeight(startLine);
                indent = startLineParenWeight == 1 ? this.getCurrentIndentForLine(startLine, null) : this.getOpenParenIndent(startLine, lineIndex);
            }
        }
        if (prevLineBrackets > 0) {
            indent += indentSize * prevLineBrackets;
        }
        if (lineUpClosingBracket) {
            if (lineBrackets < 0) {
                int openBracketIndex = TextUtilities.findMatchingBracket(this, lineIndex, closeBracketIndex);
                if (openBracketIndex == -1) return -1;
                int openLineIndex = this.getLineOfOffset(openBracketIndex);
                String openLine = this.getLineText(openLineIndex);
                Log.log(1, this, "parenWeight of " + openLine + " is " + this.getLineParenWeight(openLineIndex));
                if (this.getLineParenWeight(openLineIndex) < 0) {
                    openBracketIndex = TextUtilities.findMatchingBracket(this, openLineIndex, openLine.indexOf(")"));
                    Log.log(1, this, "openBracketIndex: " + openBracketIndex);
                }
                openLine = this.getLineText(this.getLineOfOffset(openBracketIndex));
                Log.log(1, this, "openLine: " + openLine);
                indent = MiscUtilities.getLeadingWhiteSpaceWidth(openLine, tabSize);
                Log.log(1, this, "indent: " + indent);
            }
        } else if (prevLineBrackets < 0) {
            int offset = TextUtilities.findMatchingBracket(this, prevLineIndex, prevLineCloseBracketIndex);
            if (offset == -1) return -1;
            String closeLine = this.getLineText(this.getLineOfOffset(offset));
            indent = MiscUtilities.getLeadingWhiteSpaceWidth(closeLine, tabSize);
        }
        if (lineBrackets < 0) return indent;
        if ((lineBrackets == 0 || doubleBracketIndent) && indentNextLinesRE != null && indentNextLinesRE.isMatch(prevLine)) {
            if (Debug.INDENT_DEBUG) {
                Log.log(1, this, "Matches indentNextLines");
            }
            indent += indentSize;
            return indent;
        } else {
            if (indentNextLineRE == null) return indent;
            if ((lineBrackets == 0 || doubleBracketIndent) && indentNextLineRE.isMatch(prevLine)) {
                indent += indentSize;
                return indent;
            } else {
                if (prevLineBrackets != 0) return indent;
                int prevPrevLineIndex = this.getPriorNonEmptyLine(prevLineIndex);
                while (prevPrevLineIndex != -1 && indentNextLineRE.isMatch(this.getLineText(prevPrevLineIndex))) {
                    indent = this.getCurrentIndentForLine(prevPrevLineIndex, null);
                    if (Debug.INDENT_DEBUG) {
                        Log.log(1, this, prevPrevLineIndex + " matches " + "indentNextLine");
                    }
                    prevPrevLineIndex = this.getPriorNonEmptyLine(prevPrevLineIndex);
                }
            }
        }
        return indent;
    }

    private int getLineParenWeight(int line) {
        String lineText = this.getLineText(line);
        int parenWeight = 0;
        block4: for (int i = 0; i < lineText.length(); ++i) {
            char c = lineText.charAt(i);
            switch (c) {
                case '(': {
                    ++parenWeight;
                    continue block4;
                }
                case ')': {
                    --parenWeight;
                    continue block4;
                }
            }
        }
        return parenWeight;
    }

    private int getOpenParenIndent(int startLine, int targetLine) {
        Stack<Integer> openParens = new Stack<Integer>();
        for (int lineIndex = startLine; lineIndex < targetLine; ++lineIndex) {
            String lineText = this.getLineText(lineIndex);
            block5: for (int i = 0; i < lineText.length(); ++i) {
                char c = lineText.charAt(i);
                switch (c) {
                    case '(': {
                        openParens.push(new Integer(i));
                        continue block5;
                    }
                    case ')': {
                        if (openParens.size() <= 0) continue block5;
                        openParens.pop();
                        continue block5;
                    }
                }
            }
        }
        int indent = this.getCurrentIndentForLine(startLine, null);
        if (openParens.size() > 0) {
            indent += ((Integer)openParens.pop()).intValue();
        }
        return indent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVirtualWidth(int line, int column) {
        try {
            this.readLock();
            int start = this.getLineStartOffset(line);
            this.getText(start, column, this.seg);
            int n = MiscUtilities.getVirtualWidth(this.seg, this.getTabSize());
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffsetOfVirtualColumn(int line, int column, int[] totalVirtualWidth) {
        try {
            this.readLock();
            this.getLineText(line, this.seg);
            int n = MiscUtilities.getOffsetOfVirtualColumn(this.seg, this.getTabSize(), column, totalVirtualWidth);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAtColumn(int line, int col, String str) {
        try {
            this.writeLock();
            int[] total = new int[1];
            int offset = this.getOffsetOfVirtualColumn(line, col, total);
            if (offset == -1) {
                offset = this.getLineEndOffset(line) - 1;
                str = MiscUtilities.createWhiteSpace(col - total[0], 0) + str;
            } else {
                offset += this.getLineStartOffset(line);
            }
            this.insert(offset, str);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertIndented(int offset, String text) {
        try {
            this.beginCompoundEdit();
            int firstLine = this.getLineOfOffset(offset);
            String lineText = this.getLineText(firstLine);
            int leadingIndent = MiscUtilities.getLeadingWhiteSpaceWidth(lineText, this.getTabSize());
            String whiteSpace = MiscUtilities.createWhiteSpace(leadingIndent, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize());
            this.insert(offset, text);
            int lastLine = this.getLineOfOffset(offset + text.length());
            for (int i = firstLine + 1; i <= lastLine; ++i) {
                this.insert(this.getLineStartOffset(i), whiteSpace);
            }
            int n = whiteSpace.length();
            return n;
        }
        finally {
            this.endCompoundEdit();
        }
    }

    public void putProperty(Object name, Object value) {
        if (!(name instanceof String)) {
            return;
        }
        this.setProperty((String)name, value);
    }

    public void putBooleanProperty(String name, boolean value) {
        this.setBooleanProperty(name, value);
    }

    public TokenList markTokens(int lineIndex) {
        TokenList list = new TokenList();
        this.markTokens(lineIndex, list);
        return list;
    }

    public Element[] getRootElements() {
        return new Element[]{this.getDefaultRootElement()};
    }

    public Element getParagraphElement(int offset) {
        return new LineElement(this, this.getLineOfOffset(offset));
    }

    public Element getDefaultRootElement() {
        return new RootElement(this);
    }

    public void insertString(int offset, String str, AttributeSet attr) {
        this.insert(offset, str);
    }

    public File getFile() {
        return this.file;
    }

    public int getCurrentIdentForLine(int lineIndex, int[] whitespaceChars) {
        return this.getCurrentIndentForLine(lineIndex, whitespaceChars);
    }

    public boolean isFoldStart(int line) {
        return line != this.getLineCount() - 1 && this.getFoldLevel(line) < this.getFoldLevel(line + 1);
    }

    public boolean isFoldEnd(int line) {
        return line != this.getLineCount() - 1 && this.getFoldLevel(line) > this.getFoldLevel(line + 1);
    }

    public void invalidateCachedFoldLevels() {
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldLevelChanged(0, this.getLineCount());
    }

    public int getFoldLevel(int line) {
        if (line < 0 || line >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        if (this.foldHandler instanceof DummyFoldHandler) {
            return 0;
        }
        int firstInvalidFoldLevel = this.lineMgr.getFirstInvalidFoldLevel();
        if (firstInvalidFoldLevel == -1 || line < firstInvalidFoldLevel) {
            return this.lineMgr.getFoldLevel(line);
        }
        if (Debug.FOLD_DEBUG) {
            Log.log(1, this, "Invalid fold levels from " + firstInvalidFoldLevel + " to " + line);
        }
        int newFoldLevel = 0;
        boolean changed = false;
        for (int i = firstInvalidFoldLevel; i <= line; ++i) {
            newFoldLevel = this.foldHandler.getFoldLevel(this, i, this.seg);
            if (newFoldLevel != this.lineMgr.getFoldLevel(i)) {
                if (Debug.FOLD_DEBUG) {
                    Log.log(1, this, i + " fold level changed");
                }
                changed = true;
            }
            this.lineMgr.setFoldLevel(i, newFoldLevel);
        }
        if (line == this.lineMgr.getLineCount() - 1) {
            this.lineMgr.setFirstInvalidFoldLevel(-1);
        } else {
            this.lineMgr.setFirstInvalidFoldLevel(line + 1);
        }
        if (changed) {
            if (Debug.FOLD_DEBUG) {
                Log.log(1, this, "fold level changed: " + firstInvalidFoldLevel + "," + line);
            }
            this.fireFoldLevelChanged(firstInvalidFoldLevel, line);
        }
        return newFoldLevel;
    }

    public int[] getFoldAtLine(int line) {
        int end;
        int foldLevel;
        int start;
        if (this.isFoldStart(line)) {
            start = line;
            foldLevel = this.getFoldLevel(line);
            ++line;
            while (this.getFoldLevel(line) > foldLevel && ++line != this.getLineCount()) {
            }
            end = line - 1;
        } else {
            foldLevel = this.getFoldLevel(line);
            for (start = line; this.getFoldLevel(start) >= foldLevel && start != 0; --start) {
            }
            end = line;
            while (this.getFoldLevel(end) >= foldLevel && ++end != this.getLineCount()) {
            }
            --end;
        }
        while (this.getLineLength(end) == 0 && end > start) {
            --end;
        }
        return new int[]{start, end};
    }

    public FoldHandler getFoldHandler() {
        return this.foldHandler;
    }

    public void setFoldHandler(FoldHandler foldHandler) {
        FoldHandler oldFoldHandler = this.foldHandler;
        if (foldHandler.equals(oldFoldHandler)) {
            return;
        }
        this.foldHandler = foldHandler;
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldHandlerChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position createPosition(int offset) {
        try {
            this.readLock();
            if (offset < 0 || offset > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            Position position = this.positionMgr.createPosition(offset);
            return position;
        }
        finally {
            this.readUnlock();
        }
    }

    public Vector getMarkers() {
        return this.markers;
    }

    public String getMarkerStatusPrompt(String action) {
        return jEdit.getProperty("view.status." + action, new String[]{this.getMarkerNameString()});
    }

    public String getMarkerNameString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            if (marker.getShortcut() == '\u0000') continue;
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(marker.getShortcut());
        }
        if (buf.length() == 0) {
            return jEdit.getProperty("view.status.no-markers");
        }
        return buf.toString();
    }

    public void addOrRemoveMarker(char shortcut, int pos) {
        int line = this.getLineOfOffset(pos);
        if (this.getMarkerAtLine(line) != null) {
            this.removeMarker(line);
        } else {
            this.addMarker(shortcut, pos);
        }
    }

    public void addMarker(char shortcut, int pos) {
        Marker markerN = new Marker(this, shortcut, pos);
        boolean added = false;
        if (!this.getFlag(1)) {
            Marker marker;
            int i;
            if (jEdit.getBooleanProperty("persistentMarkers")) {
                this.setDirty(true);
            }
            markerN.createPosition();
            for (i = 0; i < this.markers.size(); ++i) {
                marker = (Marker)this.markers.elementAt(i);
                if (shortcut != '\u0000' && marker.getShortcut() == shortcut) {
                    marker.setShortcut('\u0000');
                }
                if (marker.getPosition() != pos) continue;
                this.markers.removeElementAt(i);
                --i;
            }
            for (i = 0; i < this.markers.size(); ++i) {
                marker = (Marker)this.markers.elementAt(i);
                if (marker.getPosition() <= pos) continue;
                this.markers.insertElementAt(markerN, i);
                added = true;
                break;
            }
        }
        if (!added) {
            this.markers.addElement(markerN);
        }
        if (!this.getFlag(1) && !this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarkerInRange(int start, int end) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            int pos = marker.getPosition();
            if (pos < start || pos >= end) continue;
            return marker;
        }
        return null;
    }

    public Marker getMarkerAtLine(int line) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            if (this.getLineOfOffset(marker.getPosition()) != line) continue;
            return marker;
        }
        return null;
    }

    public void removeMarker(int line) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            if (this.getLineOfOffset(marker.getPosition()) != line) continue;
            if (jEdit.getBooleanProperty("persistentMarkers")) {
                this.setDirty(true);
            }
            marker.removePosition();
            this.markers.removeElementAt(i);
            --i;
        }
        EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
    }

    public void removeAllMarkers() {
        if (jEdit.getBooleanProperty("persistentMarkers")) {
            this.setDirty(true);
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            ((Marker)this.markers.elementAt(i)).removePosition();
        }
        this.markers.removeAllElements();
        if (!this.getFlag(1)) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarker(char shortcut) {
        Enumeration e = this.markers.elements();
        while (e.hasMoreElements()) {
            Marker marker = (Marker)e.nextElement();
            if (marker.getShortcut() != shortcut) continue;
            return marker;
        }
        return null;
    }

    public void setWaitSocket(Socket waitSocket) {
        this.waitSocket = waitSocket;
    }

    public Buffer getNext() {
        return this.next;
    }

    public Buffer getPrev() {
        return this.prev;
    }

    public int getIndex() {
        int count = 0;
        Buffer buffer = this.prev;
        while (buffer != null) {
            ++count;
            buffer = buffer.prev;
        }
        return count;
    }

    public String toString() {
        return this.name + " (" + this.directory + ")";
    }

    public LineManager _getLineManager() {
        return this.lineMgr;
    }

    Buffer(String path, boolean newFile, boolean temp, Hashtable props) {
        this.markers = new Vector();
        this.properties = new HashMap();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = props.get(key);
            this.properties.put(key, new PropValue(value, false));
        }
        if (this.getProperty(ENCODING) == null) {
            this.properties.put(ENCODING, new PropValue(System.getProperty("file.encoding"), false));
        }
        if (this.getProperty(LINESEP) == null) {
            this.properties.put(LINESEP, new PropValue(System.getProperty("line.separator"), false));
        }
        this.setFlag(10, temp);
        this.setPath(path);
        this.setFlag(4, newFile);
        this.setFlag(3, newFile);
    }

    void commitTemporary() {
        this.setFlag(10, false);
        this.finishLoading();
    }

    void resetCachedProperties() {
        Iterator iter = this.properties.values().iterator();
        while (iter.hasNext()) {
            PropValue value = (PropValue)iter.next();
            if (!value.defaultValue) continue;
            iter.remove();
        }
    }

    void close() {
        this.setFlag(0, true);
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
        }
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= 1 << flag) : (this.flags &= ~(1 << flag));
    }

    private boolean getFlag(int flag) {
        int mask = 1 << flag;
        return (this.flags & mask) == mask;
    }

    private void setPath(String path) {
        this.path = path;
        VFS vfs = VFSManager.getVFSForPath(path);
        if ((vfs.getCapabilities() & 2) == 0) {
            this.setFlag(7, true);
        }
        this.name = vfs.getFileName(path);
        this.directory = vfs.getParentOfPath(path);
        if (vfs instanceof FileVFS) {
            this.file = new File(path);
            this.symlinkPath = MiscUtilities.resolveSymlinks(path);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
            this.autosaveFile = new File(this.file.getParent(), '#' + this.name + '#');
        } else {
            this.file = null;
            this.autosaveFile = null;
            this.symlinkPath = path;
        }
    }

    private boolean recoverAutosave(final View view) {
        if (!this.autosaveFile.canRead()) {
            return false;
        }
        GUIUtilities.hideSplashScreen();
        final Object[] args = new Object[]{this.autosaveFile.getPath()};
        int result = GUIUtilities.confirm(view, "autosave-found", args, 0, 2);
        if (result == 0) {
            VFSManager.getFileVFS().load(view, this, this.autosaveFile.getPath());
            VFSManager.runInAWTThread(new Runnable(){

                public void run() {
                    GUIUtilities.message(view, "autosave-loaded", args);
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFileForLoad(View view, VFS vfs, String path) {
        Object session;
        block16: {
            boolean bl;
            block17: {
                boolean bl2;
                block15: {
                    boolean bl3;
                    block14: {
                        if ((vfs.getCapabilities() & 0x40) == 0) return true;
                        session = vfs.createVFSSession(path, view);
                        if (session == null) {
                            return false;
                        }
                        try {
                            try {
                                VFS.DirectoryEntry file = vfs._getDirectoryEntry(session, path, view);
                                if (file == null) {
                                    this.setNewFile(true);
                                    bl3 = true;
                                    Object var8_11 = null;
                                    break block14;
                                }
                                if (!file.canRead) {
                                    VFSManager.error(view, path, "ioerror.no-read", null);
                                    this.setNewFile(false);
                                    bl2 = false;
                                    break block15;
                                }
                                this.setFlag(7, !file.canWrite);
                                if (file.type == 0) break block16;
                                VFSManager.error(view, path, "ioerror.open-directory", null);
                                this.setNewFile(false);
                                bl = false;
                                break block17;
                            }
                            catch (IOException io) {
                                VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                                boolean bl4 = false;
                                Object var8_15 = null;
                                try {
                                    vfs._endVFSSession(session, view);
                                    return bl4;
                                }
                                catch (IOException io2) {
                                    VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                                    return false;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_16 = null;
                            try {}
                            catch (IOException io2) {
                                VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                                return false;
                            }
                            vfs._endVFSSession(session, view);
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException io2) {
                        VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                        return false;
                    }
                    vfs._endVFSSession(session, view);
                    return bl3;
                }
                Object var8_12 = null;
                try {}
                catch (IOException io2) {
                    VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                    return false;
                }
                vfs._endVFSSession(session, view);
                return bl2;
            }
            Object var8_13 = null;
            try {}
            catch (IOException io2) {
                VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                return false;
            }
            vfs._endVFSSession(session, view);
            return bl;
        }
        Object var8_14 = null;
        try {}
        catch (IOException io2) {
            VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
            return false;
        }
        vfs._endVFSSession(session, view);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFileForSave(View view, VFS vfs, String path) {
        Object session;
        block13: {
            boolean bl;
            block14: {
                boolean bl2;
                block12: {
                    if ((vfs.getCapabilities() & 0x40) == 0) return true;
                    session = vfs.createVFSSession(path, view);
                    if (session == null) {
                        return false;
                    }
                    try {
                        try {
                            VFS.DirectoryEntry file = vfs._getDirectoryEntry(session, path, view);
                            if (file == null) {
                                bl2 = true;
                                Object var8_10 = null;
                                break block12;
                            }
                            if (file.type == 0) break block13;
                            VFSManager.error(view, path, "ioerror.save-directory", null);
                            bl = false;
                            break block14;
                        }
                        catch (IOException io) {
                            VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                            boolean bl3 = false;
                            Object var8_13 = null;
                            try {
                                vfs._endVFSSession(session, view);
                                return bl3;
                            }
                            catch (IOException io2) {
                                VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                                return false;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        try {}
                        catch (IOException io2) {
                            VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                            return false;
                        }
                        vfs._endVFSSession(session, view);
                        throw throwable;
                    }
                }
                try {}
                catch (IOException io2) {
                    VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                    return false;
                }
                vfs._endVFSSession(session, view);
                return bl2;
            }
            Object var8_11 = null;
            try {}
            catch (IOException io2) {
                VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                return false;
            }
            vfs._endVFSSession(session, view);
            return bl;
        }
        Object var8_12 = null;
        try {}
        catch (IOException io2) {
            VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
            return false;
        }
        vfs._endVFSSession(session, view);
        return true;
    }

    private void finishLoading() {
        this.parseBufferLocalProperties();
        FoldHandler oldFoldHandler = this.foldHandler;
        this.setMode();
        if (this.foldHandler == oldFoldHandler) {
            this.lineMgr.setFirstInvalidFoldLevel(0);
            this.fireFoldHandlerChanged();
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            marker.removePosition();
            int pos = marker.getPosition();
            if (pos > this.getLength()) {
                marker.setPosition(this.getLength());
            } else if (pos < 0) {
                marker.setPosition(0);
            }
            marker.createPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSaving(View view, String oldPath, String oldSymlinkPath, String path, boolean rename, boolean error) {
        if (!error && !path.equals(oldPath)) {
            Buffer buffer = jEdit.getBuffer(path);
            if (rename) {
                if (buffer != null && !buffer.getPath().equals(oldPath)) {
                    buffer.setDirty(false);
                    jEdit.closeBuffer(view, buffer);
                }
                this.setPath(path);
            } else if (buffer != null && !buffer.getPath().equals(oldPath)) {
                buffer.load(view, true);
            }
        }
        if (rename) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!error) {
                try {
                    this.writeLock();
                    if (this.autosaveFile != null) {
                        this.autosaveFile.delete();
                    }
                    this.setFlag(5, false);
                    this.setFlag(7, false);
                    this.setFlag(3, false);
                    this.setFlag(4, false);
                    this.setFlag(6, false);
                    this.undoMgr.bufferSaved();
                }
                finally {
                    this.writeUnlock();
                }
                this.parseBufferLocalProperties();
                if (!this.getPath().equals(oldPath)) {
                    jEdit.updatePosition(oldSymlinkPath, this);
                    this.setMode();
                } else {
                    String newMode = this.getStringProperty("mode");
                    if (newMode != null && !newMode.equals(this.getMode().getName())) {
                        this.setMode();
                    } else {
                        this.propertiesChanged();
                    }
                }
                EditBus.send(new BufferUpdate(this, view, BufferUpdate.DIRTY_CHANGED));
                EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVED));
            }
        }
    }

    private void parseBufferLocalProperties() {
        int lastLine = Math.min(9, this.getLineCount() - 1);
        this.parseBufferLocalProperties(this.getText(0, this.getLineEndOffset(lastLine) - 1));
        int firstLine = Math.max(lastLine + 1, this.getLineCount() - 10);
        if (firstLine < this.getLineCount()) {
            int length = this.getLineEndOffset(this.getLineCount() - 1) - (this.getLineStartOffset(firstLine) + 1);
            this.parseBufferLocalProperties(this.getText(this.getLineStartOffset(firstLine), length));
        }
    }

    private void parseBufferLocalProperties(String prop) {
        StringBuffer buf = new StringBuffer();
        String name = null;
        boolean escape = false;
        block8: for (int i = 0; i < prop.length(); ++i) {
            char c = prop.charAt(i);
            switch (c) {
                case ':': {
                    if (escape) {
                        escape = false;
                        buf.append(':');
                        continue block8;
                    }
                    if (name != null) {
                        this.properties.put(name, new PropValue(buf.toString(), false));
                        name = null;
                    }
                    buf.setLength(0);
                    continue block8;
                }
                case '=': {
                    if (escape) {
                        escape = false;
                        buf.append('=');
                        continue block8;
                    }
                    name = buf.toString();
                    buf.setLength(0);
                    continue block8;
                }
                case '\\': {
                    if (escape) {
                        buf.append('\\');
                    }
                    escape = !escape;
                    continue block8;
                }
                case 'n': {
                    if (escape) {
                        buf.append('\n');
                        escape = false;
                        continue block8;
                    }
                }
                case 'r': {
                    if (escape) {
                        buf.append('\r');
                        escape = false;
                        continue block8;
                    }
                }
                case 't': {
                    if (escape) {
                        buf.append('\t');
                        escape = false;
                        continue block8;
                    }
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    private void setTokenMarker(TokenMarker tokenMarker) {
        TokenMarker oldTokenMarker = this.tokenMarker;
        this.tokenMarker = tokenMarker;
        if (oldTokenMarker != null && tokenMarker != oldTokenMarker) {
            this.lineMgr.setFirstInvalidLineContext(0);
        }
    }

    private int getPriorNonEmptyLine(int lineIndex) {
        int returnValue = -1;
        for (int i = lineIndex - 1; i >= 0; --i) {
            this.getLineText(i, this.seg);
            if (this.seg.count != 0) {
                returnValue = i;
            }
            for (int j = 0; j < this.seg.count; ++j) {
                char ch = this.seg.array[this.seg.offset + j];
                if (Character.isWhitespace(ch)) continue;
                return i;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contentInserted(int offset, int length, IntegerArray endOffsets) {
        try {
            this.setFlag(11, true);
            int startLine = this.lineMgr.getLineOfOffset(offset);
            int numLines = endOffsets.getSize();
            this.lineMgr.contentInserted(startLine, offset, numLines, length, endOffsets);
            this.positionMgr.contentInserted(offset, length);
            this.setDirty(true);
            if (!this.getFlag(1)) {
                this.fireContentInserted(startLine, offset, numLines, length);
                if (!this.getFlag(9) && !this.insideCompoundEdit()) {
                    this.fireTransactionComplete();
                }
            }
        }
        finally {
            this.setFlag(11, false);
        }
    }

    private BufferChangeListener getListener(int index) {
        return ((Listener)this.bufferListeners.elementAt((int)index)).listener;
    }

    private void fireFoldLevelChanged(int start, int end) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).foldLevelChanged(this, start, end);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, t);
            }
        }
    }

    private void fireContentInserted(int startLine, int offset, int numLines, int length) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).contentInserted(this, startLine, offset, numLines, length);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, t);
            }
        }
    }

    private void fireContentRemoved(int startLine, int offset, int numLines, int length) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).contentRemoved(this, startLine, offset, numLines, length);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, t);
            }
        }
    }

    private void firePreContentRemoved(int startLine, int offset, int numLines, int length) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).preContentRemoved(this, startLine, offset, numLines, length);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, t);
            }
        }
    }

    private void fireTransactionComplete() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).transactionComplete(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, t);
            }
        }
    }

    private void fireFoldHandlerChanged() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).foldHandlerChanged(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, t);
            }
        }
    }

    public static class TokenList
    extends DefaultTokenHandler {
        public Token getFirstToken() {
            return this.getTokens();
        }
    }

    static class PropValue {
        Object value;
        boolean defaultValue;

        PropValue(Object value, boolean defaultValue) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static class Listener {
        BufferChangeListener listener;
        int priority;

        Listener(BufferChangeListener listener, int priority) {
            this.listener = listener;
            this.priority = priority;
        }
    }
}

