/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class BufferHistory {
    private static LinkedList history = new LinkedList();
    private static boolean pathsCaseInsensitive = OperatingSystem.isDOSDerived() || OperatingSystem.isMacOS();
    private static long recentModTime;
    static /* synthetic */ Class class$org$gjt$sp$jedit$BufferHistory;

    public static Entry getEntry(String path) {
        Iterator iter = history.iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (!(pathsCaseInsensitive ? entry.path.equalsIgnoreCase(path) : entry.path.equals(path))) continue;
            return entry;
        }
        return null;
    }

    public static void setEntry(String path, int caret, Selection[] selection, String encoding) {
        BufferHistory.removeEntry(path);
        BufferHistory.addEntry(new Entry(path, caret, BufferHistory.selectionToString(selection), encoding));
        EditBus.send(new DynamicMenuChanged("recent-files"));
    }

    public static List getHistory() {
        return history;
    }

    public static Vector getBufferHistory() {
        Vector retVal = new Vector(history.size());
        Iterator iter = history.iterator();
        while (iter.hasNext()) {
            retVal.add(iter.next());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void load() {
        block19: {
            String settingsDirectory = jEdit.getSettingsDirectory();
            if (settingsDirectory == null) {
                return;
            }
            File recent = new File(MiscUtilities.constructPath(settingsDirectory, "recent.xml"));
            if (!recent.exists()) {
                return;
            }
            recentModTime = recent.lastModified();
            Log.log(3, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, "Loading recent.xml");
            RecentHandler handler = new RecentHandler();
            XmlParser parser = new XmlParser();
            BufferedReader in = null;
            parser.setHandler(handler);
            in = new BufferedReader(new FileReader(recent));
            parser.parse(null, null, in);
            Object var9_5 = null;
            try {
                if (in != null) {
                    ((Reader)in).close();
                }
                break block19;
            }
            catch (IOException io) {
                Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, io);
            }
            break block19;
            {
                catch (XmlException xe) {
                    int line = xe.getLine();
                    String message = xe.getMessage();
                    Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, recent + ":" + line + ": " + message);
                    Object var9_6 = null;
                    try {
                        if (in != null) {
                            ((Reader)in).close();
                        }
                        break block19;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, io);
                    }
                    break block19;
                }
                catch (FileNotFoundException fnf) {
                    Object var9_7 = null;
                    try {
                        if (in != null) {
                            ((Reader)in).close();
                        }
                        break block19;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, io);
                    }
                    break block19;
                }
                catch (Exception e) {
                    Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, e);
                    Object var9_8 = null;
                    try {
                        if (in != null) {
                            ((Reader)in).close();
                        }
                        break block19;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, io);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (in != null) {
                        ((Reader)in).close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, io);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void save() {
        boolean ok;
        File file2;
        File file1;
        block17: {
            String settingsDirectory = jEdit.getSettingsDirectory();
            if (settingsDirectory == null) {
                return;
            }
            file1 = new File(MiscUtilities.constructPath(settingsDirectory, "#recent.xml#save#"));
            file2 = new File(MiscUtilities.constructPath(settingsDirectory, "recent.xml"));
            if (file2.exists() && file2.lastModified() != recentModTime) {
                Log.log(7, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, file2 + " changed on disk; will not save recent" + " files");
                return;
            }
            jEdit.backupSettingsFile(file2);
            Log.log(3, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, "Saving " + file1);
            String lineSep = System.getProperty("line.separator");
            ok = false;
            BufferedWriter out = null;
            out = new BufferedWriter(new FileWriter(file1));
            out.write("<?xml version=\"1.0\"?>");
            out.write(lineSep);
            out.write("<!DOCTYPE RECENT SYSTEM \"recent.dtd\">");
            out.write(lineSep);
            out.write("<RECENT>");
            out.write(lineSep);
            Iterator iter = history.iterator();
            while (iter.hasNext()) {
                out.write("<ENTRY>");
                out.write(lineSep);
                Entry entry = (Entry)iter.next();
                out.write("<PATH>");
                out.write(MiscUtilities.charsToEntities(entry.path));
                out.write("</PATH>");
                out.write(lineSep);
                out.write("<CARET>");
                out.write(String.valueOf(entry.caret));
                out.write("</CARET>");
                out.write(lineSep);
                if (entry.selection != null && entry.selection.length() > 0) {
                    out.write("<SELECTION>");
                    out.write(entry.selection);
                    out.write("</SELECTION>");
                    out.write(lineSep);
                }
                if (entry.encoding != null) {
                    out.write("<ENCODING>");
                    out.write(entry.encoding);
                    out.write("</ENCODING>");
                    out.write(lineSep);
                }
                out.write("</ENTRY>");
                out.write(lineSep);
            }
            out.write("</RECENT>");
            out.write(lineSep);
            out.close();
            ok = true;
            Object var9_9 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block17;
            }
            catch (IOException e2) {}
            break block17;
            {
                catch (Exception e) {
                    Log.log(9, class$org$gjt$sp$jedit$BufferHistory == null ? (class$org$gjt$sp$jedit$BufferHistory = BufferHistory.class$("org.gjt.sp.jedit.BufferHistory")) : class$org$gjt$sp$jedit$BufferHistory, e);
                    Object var9_10 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (ok) {
            file2.delete();
            file1.renameTo(file2);
        }
        recentModTime = file2.lastModified();
    }

    static void addEntry(Entry entry) {
        history.addFirst(entry);
        int max = jEdit.getIntegerProperty("recentFiles", 50);
        while (history.size() > max) {
            history.removeLast();
        }
    }

    static void removeEntry(String path) {
        Iterator iter = history.iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (pathsCaseInsensitive) {
                if (!entry.path.equalsIgnoreCase(path)) continue;
                iter.remove();
                return;
            }
            if (!entry.path.equals(path)) continue;
            iter.remove();
            return;
        }
    }

    private static String selectionToString(Selection[] s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            Selection sel;
            if (i != 0) {
                buf.append(' ');
            }
            if ((sel = s[i]) instanceof Selection.Range) {
                buf.append("range ");
            } else {
                buf.append("rect ");
            }
            buf.append(sel.getStart());
            buf.append(' ');
            buf.append(sel.getEnd());
        }
        return buf.toString();
    }

    private static Selection[] stringToSelection(String s) {
        if (s == null) {
            return null;
        }
        Vector<Selection.Range> selection = new Vector<Selection.Range>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String type = st.nextToken();
            int start = Integer.parseInt(st.nextToken());
            int end = Integer.parseInt(st.nextToken());
            if (end < start) continue;
            Selection sel = type.equals("range") ? new Selection.Range(start, end) : new Selection.Rect(start, end);
            selection.addElement((Selection.Range)sel);
        }
        Object[] returnValue = new Selection[selection.size()];
        selection.copyInto(returnValue);
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RecentHandler
    extends HandlerBase {
        private String path;
        private int caret;
        private String selection;
        private String encoding;
        private String charData;

        RecentHandler() {
        }

        public void endDocument() throws Exception {
            int max = jEdit.getIntegerProperty("recentFiles", 50);
            while (history.size() > max) {
                history.removeLast();
            }
        }

        public Object resolveEntity(String publicId, String systemId) {
            if ("recent.dtd".equals(systemId)) {
                return new StringReader("<!-- -->");
            }
            return null;
        }

        public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
            if ("RECENT".equals(name)) {
                return;
            }
            Log.log(9, this, "recent.xml: DOCTYPE must be RECENT");
        }

        public void endElement(String name) {
            if (name.equals("ENTRY")) {
                history.addLast(new Entry(this.path, this.caret, this.selection, this.encoding));
                this.path = null;
                this.caret = 0;
                this.selection = null;
                this.encoding = null;
            } else if (name.equals("PATH")) {
                this.path = this.charData;
            } else if (name.equals("CARET")) {
                this.caret = Integer.parseInt(this.charData);
            } else if (name.equals("SELECTION")) {
                this.selection = this.charData;
            } else if (name.equals("ENCODING")) {
                this.encoding = this.charData;
            }
        }

        public void charData(char[] ch, int start, int length) {
            this.charData = new String(ch, start, length);
        }
    }

    public static class Entry {
        public String path;
        public int caret;
        public String selection;
        public String encoding;

        public Selection[] getSelection() {
            return BufferHistory.stringToSelection(this.selection);
        }

        public Entry(String path, int caret, String selection, String encoding) {
            this.path = path;
            this.caret = caret;
            this.selection = selection;
            this.encoding = encoding;
        }

        public String toString() {
            return this.path + ": " + this.caret;
        }
    }
}

