/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSFileChooserDialog;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.SplashScreen;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedCheckBoxMenuItem;
import org.gjt.sp.jedit.menu.EnhancedMenu;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.Log;

public class GUIUtilities {
    public static Icon NEW_BUFFER_ICON;
    public static Icon DIRTY_BUFFER_ICON;
    public static Icon READ_ONLY_BUFFER_ICON;
    public static Icon NORMAL_BUFFER_ICON;
    public static Icon WINDOW_ICON;
    private static SplashScreen splash;
    private static Hashtable icons;
    private static String iconPath;
    private static String defaultIconPath;
    static /* synthetic */ Class class$org$gjt$sp$jedit$GUIUtilities;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$org$gjt$sp$jedit$View;

    public static void setIconPath(String iconPath) {
        GUIUtilities.iconPath = iconPath;
        if (icons != null) {
            icons.clear();
        }
    }

    public static Icon loadIcon(String iconName) {
        Icon icon;
        if (icons == null) {
            icons = new Hashtable();
        }
        if ((icon = (Icon)icons.get(iconName)) != null) {
            return icon;
        }
        if (MiscUtilities.isURL(iconName)) {
            icon = new ImageIcon(iconName.substring(5));
        } else {
            try {
                URL url = new URL(iconPath + iconName);
                icon = new ImageIcon(url);
            }
            catch (Exception e) {
                try {
                    URL url = new URL(defaultIconPath + iconName);
                    icon = new ImageIcon(url);
                }
                catch (Exception ex) {
                    Log.log(9, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, "Icon not found: " + iconName);
                    Log.log(9, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, ex);
                    return null;
                }
            }
        }
        icons.put(iconName, icon);
        return icon;
    }

    public static Image getEditorIcon() {
        return ((ImageIcon)GUIUtilities.loadIcon("jedit-icon.gif")).getImage();
    }

    public static Image getPluginIcon() {
        return GUIUtilities.getEditorIcon();
    }

    public static JMenuBar loadMenuBar(String name) {
        return GUIUtilities.loadMenuBar(jEdit.getActionContext(), name);
    }

    public static JMenuBar loadMenuBar(ActionContext context, String name) {
        String menus = jEdit.getProperty(name);
        StringTokenizer st = new StringTokenizer(menus);
        JMenuBar mbar = new JMenuBar();
        while (st.hasMoreTokens()) {
            mbar.add(GUIUtilities.loadMenu(context, st.nextToken()));
        }
        return mbar;
    }

    public static JMenu loadMenu(String name) {
        return GUIUtilities.loadMenu(jEdit.getActionContext(), name);
    }

    public static JMenu loadMenu(ActionContext context, String name) {
        return new EnhancedMenu(name, jEdit.getProperty(name.concat(".label")), context);
    }

    public static JPopupMenu loadPopupMenu(String name) {
        return GUIUtilities.loadPopupMenu(jEdit.getActionContext(), name);
    }

    public static JPopupMenu loadPopupMenu(ActionContext context, String name) {
        JPopupMenu menu = new JPopupMenu();
        String menuItems = jEdit.getProperty(name);
        if (menuItems != null) {
            StringTokenizer st = new StringTokenizer(menuItems);
            while (st.hasMoreTokens()) {
                String menuItemName = st.nextToken();
                if (menuItemName.equals("-")) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(GUIUtilities.loadMenuItem(context, menuItemName, false));
            }
        }
        return menu;
    }

    public static JMenuItem loadMenuItem(String name) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), name, true);
    }

    public static JMenuItem loadMenuItem(String name, boolean setMnemonic) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), name, setMnemonic);
    }

    public static JMenuItem loadMenuItem(ActionContext context, String name, boolean setMnemonic) {
        char mnemonic;
        int index;
        if (name.startsWith("%")) {
            return GUIUtilities.loadMenu(context, name.substring(1));
        }
        String label = jEdit.getProperty(name + ".label");
        if (label == null) {
            label = name;
        }
        if ((index = label.indexOf(36)) != -1 && label.length() - index > 1) {
            mnemonic = Character.toLowerCase(label.charAt(index + 1));
            label = label.substring(0, index).concat(label.substring(++index));
        } else {
            mnemonic = '\u0000';
        }
        JMenuItem mi = jEdit.getBooleanProperty(name + ".toggle") ? new EnhancedCheckBoxMenuItem(label, name, context) : new EnhancedMenuItem(label, name, context);
        if (!OperatingSystem.isMacOS() && setMnemonic && mnemonic != '\u0000') {
            mi.setMnemonic(mnemonic);
        }
        return mi;
    }

    public static Box loadToolBar(String name) {
        return GUIUtilities.loadToolBar(jEdit.getActionContext(), name);
    }

    public static Box loadToolBar(ActionContext context, String name) {
        Box toolBar = new Box(0);
        String buttons = jEdit.getProperty(name);
        if (buttons != null) {
            StringTokenizer st = new StringTokenizer(buttons);
            while (st.hasMoreTokens()) {
                String button = st.nextToken();
                if (button.equals("-")) {
                    toolBar.add(Box.createHorizontalStrut(12));
                    continue;
                }
                EnhancedButton b = GUIUtilities.loadToolButton(context, button);
                if (b == null) continue;
                toolBar.add(b);
            }
        }
        toolBar.add(Box.createGlue());
        return toolBar;
    }

    public static EnhancedButton loadToolButton(String name) {
        return GUIUtilities.loadToolButton(jEdit.getActionContext(), name);
    }

    public static EnhancedButton loadToolButton(ActionContext context, String name) {
        Icon icon;
        String iconName;
        String label = jEdit.getProperty(name + ".label");
        if (label == null) {
            label = name;
        }
        if ((iconName = jEdit.getProperty(name + ".icon")) == null) {
            icon = GUIUtilities.loadIcon("BrokenImage.png");
        } else {
            icon = GUIUtilities.loadIcon(iconName);
            if (icon == null) {
                icon = GUIUtilities.loadIcon("BrokenImage.png");
            }
        }
        String toolTip = GUIUtilities.prettifyMenuLabel(label);
        String shortcut1 = jEdit.getProperty(name + ".shortcut");
        String shortcut2 = jEdit.getProperty(name + ".shortcut2");
        if (shortcut1 != null || shortcut2 != null) {
            toolTip = toolTip + " (" + (shortcut1 != null ? shortcut1 : "") + (shortcut1 != null && shortcut2 != null ? " or " : "") + (shortcut2 != null ? shortcut2 : "") + ")";
        }
        return new EnhancedButton(icon, toolTip, name, context);
    }

    public static String prettifyMenuLabel(String label) {
        int index = label.indexOf(36);
        if (index != -1) {
            label = label.substring(0, index).concat(label.substring(index + 1));
        }
        return label;
    }

    public static void message(Component comp, String name, Object[] args) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title"), args), 1);
    }

    public static void error(Component comp, String name, Object[] args) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title"), args), 0);
    }

    public static String input(Component comp, String name, Object def) {
        return GUIUtilities.input(comp, name, null, def);
    }

    public static String inputProperty(Component comp, String name, String def) {
        return GUIUtilities.inputProperty(comp, name, null, def);
    }

    public static String input(Component comp, String name, Object[] args, Object def) {
        GUIUtilities.hideSplashScreen();
        String retVal = (String)JOptionPane.showInputDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title")), 3, null, null, def);
        return retVal;
    }

    public static String inputProperty(Component comp, String name, Object[] args, String def) {
        GUIUtilities.hideSplashScreen();
        String retVal = (String)JOptionPane.showInputDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title")), 3, null, null, jEdit.getProperty(def));
        if (retVal != null) {
            jEdit.setProperty(def, retVal);
        }
        return retVal;
    }

    public static int confirm(Component comp, String name, Object[] args, int buttons, int type) {
        GUIUtilities.hideSplashScreen();
        return JOptionPane.showConfirmDialog(comp, jEdit.getProperty(name + ".message", args), jEdit.getProperty(name + ".title"), buttons, type);
    }

    public static String[] showVFSFileDialog(View view, String path, int type, boolean multipleSelection) {
        if (view == null) {
            Log.log(7, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, "showVFSFileDialog(): given null view, assuming jEdit.getActiveView()");
            view = jEdit.getActiveView();
        }
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog fileChooser = new VFSFileChooserDialog(view, path, type, multipleSelection);
        String[] selectedFiles = fileChooser.getSelectedFiles();
        if (selectedFiles == null) {
            return null;
        }
        return selectedFiles;
    }

    public static Color parseColor(String name) {
        return GUIUtilities.parseColor(name, Color.black);
    }

    public static Color parseColor(String name, Color defaultColor) {
        if (name == null) {
            return defaultColor;
        }
        if (name.startsWith("#")) {
            try {
                return Color.decode(name);
            }
            catch (NumberFormatException nf) {
                return defaultColor;
            }
        }
        if ("red".equals(name)) {
            return Color.red;
        }
        if ("green".equals(name)) {
            return Color.green;
        }
        if ("blue".equals(name)) {
            return Color.blue;
        }
        if ("yellow".equals(name)) {
            return Color.yellow;
        }
        if ("orange".equals(name)) {
            return Color.orange;
        }
        if ("white".equals(name)) {
            return Color.white;
        }
        if ("lightGray".equals(name)) {
            return Color.lightGray;
        }
        if ("gray".equals(name)) {
            return Color.gray;
        }
        if ("darkGray".equals(name)) {
            return Color.darkGray;
        }
        if ("black".equals(name)) {
            return Color.black;
        }
        if ("cyan".equals(name)) {
            return Color.cyan;
        }
        if ("magenta".equals(name)) {
            return Color.magenta;
        }
        if ("pink".equals(name)) {
            return Color.pink;
        }
        return defaultColor;
    }

    public static String getColorHexString(Color c) {
        String colString = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - colString.length()).concat(colString);
    }

    public static SyntaxStyle parseStyle(String str, String family, int size) throws IllegalArgumentException {
        return GUIUtilities.parseStyle(str, family, size, true);
    }

    public static SyntaxStyle parseStyle(String str, String family, int size, boolean color) throws IllegalArgumentException {
        Color fgColor = Color.black;
        Color bgColor = null;
        boolean italic = false;
        boolean bold = false;
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("color:")) {
                if (!color) continue;
                fgColor = GUIUtilities.parseColor(s.substring(6), Color.black);
                continue;
            }
            if (s.startsWith("bgColor:")) {
                if (!color) continue;
                bgColor = GUIUtilities.parseColor(s.substring(8), null);
                continue;
            }
            if (s.startsWith("style:")) {
                for (int i = 6; i < s.length(); ++i) {
                    if (s.charAt(i) == 'i') {
                        italic = true;
                        continue;
                    }
                    if (s.charAt(i) == 'b') {
                        bold = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid style: " + s);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + s);
        }
        return new SyntaxStyle(fgColor, bgColor, new Font(family, (italic ? 2 : 0) | (bold ? 1 : 0), size));
    }

    public static String getStyleString(SyntaxStyle style) {
        StringBuffer buf = new StringBuffer();
        if (style.getForegroundColor() != null) {
            buf.append("color:" + GUIUtilities.getColorHexString(style.getForegroundColor()));
        }
        if (style.getBackgroundColor() != null) {
            buf.append(" bgColor:" + GUIUtilities.getColorHexString(style.getBackgroundColor()));
        }
        if (!style.getFont().isPlain()) {
            buf.append(" style:" + (style.getFont().isItalic() ? "i" : "") + (style.getFont().isBold() ? "b" : ""));
        }
        return buf.toString();
    }

    public static SyntaxStyle[] loadStyles(String family, int size) {
        return GUIUtilities.loadStyles(family, size, true);
    }

    public static SyntaxStyle[] loadStyles(String family, int size, boolean color) {
        SyntaxStyle[] styles = new SyntaxStyle[19];
        for (int i = 1; i < styles.length; ++i) {
            try {
                String styleName = "view.style." + Token.tokenToString((byte)i).toLowerCase();
                styles[i] = GUIUtilities.parseStyle(jEdit.getProperty(styleName), family, size, color);
                continue;
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$GUIUtilities == null ? GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities") : class$org$gjt$sp$jedit$GUIUtilities, e);
            }
        }
        return styles;
    }

    public static void loadGeometry(Window win, String name) {
        Dimension size = win.getSize();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle gcbounds = gd.getDefaultConfiguration().getBounds();
        int x = gcbounds.x;
        int y = gcbounds.y;
        int width = jEdit.getIntegerProperty(name + ".width", size.width);
        int height = jEdit.getIntegerProperty(name + ".height", size.height);
        Container parent = win.getParent();
        if (parent == null) {
            x += (gcbounds.width - width) / 2;
            y += (gcbounds.height - height) / 2;
        } else {
            Rectangle bounds = parent.getBounds();
            x += bounds.x + (bounds.width - width) / 2;
            y += bounds.y + (bounds.height - height) / 2;
        }
        x = jEdit.getIntegerProperty(name + ".x", x);
        y = jEdit.getIntegerProperty(name + ".y", y);
        int extState = jEdit.getIntegerProperty(name + ".extendedState", 0);
        Rectangle desired = new Rectangle(x, y, width, height);
        GUIUtilities.adjustForScreenBounds(desired);
        if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
            new UnixWorkaround(win, name, desired, extState);
        } else {
            win.setBounds(desired);
            if (win instanceof Frame) {
                GUIUtilities.setExtendedState((Frame)win, extState);
            }
        }
    }

    public static void adjustForScreenBounds(Rectangle desired) {
        Rectangle osbounds = OperatingSystem.getScreenBounds(desired);
        if (desired.x < osbounds.x || desired.x + desired.width > desired.x + osbounds.width) {
            if (desired.width > osbounds.width) {
                desired.width = osbounds.width;
            }
            desired.x = (osbounds.width - desired.width) / 2;
        }
        if (desired.y < osbounds.y || desired.y + desired.height > osbounds.y + osbounds.height) {
            if (desired.height >= osbounds.height) {
                desired.height = osbounds.height;
            }
            desired.y = (osbounds.height - desired.height) / 2;
        }
    }

    public static void saveGeometry(Window win, String name) {
        if (win instanceof Frame) {
            jEdit.setIntegerProperty(name + ".extendedState", GUIUtilities.getExtendedState((Frame)win));
        }
        Rectangle bounds = win.getBounds();
        jEdit.setIntegerProperty(name + ".x", bounds.x);
        jEdit.setIntegerProperty(name + ".y", bounds.y);
        jEdit.setIntegerProperty(name + ".width", bounds.width);
        jEdit.setIntegerProperty(name + ".height", bounds.height);
    }

    public static int getExtendedState(Frame frame) {
        if (OperatingSystem.hasJava14()) {
            try {
                Method meth = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIUtilities.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("getExtendedState", new Class[0]);
                Integer extState = (Integer)meth.invoke((Object)frame, new Object[0]);
                return extState;
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, e);
            }
        }
        return 0;
    }

    public static void setExtendedState(Frame frame, int extState) {
        if (OperatingSystem.hasJava14()) {
            try {
                Method meth = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIUtilities.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("setExtendedState", Integer.TYPE);
                meth.invoke((Object)frame, new Integer(extState));
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, e);
            }
        }
    }

    public static void centerOnScreen(Window win) {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle gcbounds = gd.getDefaultConfiguration().getBounds();
        int x = gcbounds.x + (gcbounds.width - win.getWidth()) / 2;
        int y = gcbounds.y + (gcbounds.height - win.getHeight()) / 2;
        win.setLocation(x, y);
    }

    public static void hideSplashScreen() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    public static JComponent createMultilineLabel(String str) {
        int index;
        JPanel panel = new JPanel(new VariableGridLayout(2, 1, 1, 1));
        int lastOffset = 0;
        while ((index = str.indexOf(10, lastOffset)) != -1) {
            panel.add(new JLabel(str.substring(lastOffset, index)));
            lastOffset = index + 1;
        }
        if (lastOffset != str.length()) {
            panel.add(new JLabel(str.substring(lastOffset)));
        }
        return panel;
    }

    public static void requestFocus(final Window win, final Component comp) {
        win.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        1.access$000(this.this$0).requestFocus();
                    }
                });
                win.removeWindowListener(this);
            }

            static /* synthetic */ Component access$000(1 x0) {
                return x0.comp;
            }
        });
    }

    public static boolean isPopupTrigger(MouseEvent evt) {
        return GUIUtilities.isRightButton(evt.getModifiers());
    }

    public static boolean isMiddleButton(int modifiers) {
        if (OperatingSystem.isMacOS()) {
            if ((modifiers & 0x10) != 0) {
                return (modifiers & 8) != 0;
            }
            if (!OperatingSystem.hasJava14()) {
                return (modifiers & 4) != 0;
            }
            return (modifiers & 8) != 0;
        }
        return (modifiers & 8) != 0;
    }

    public static boolean isRightButton(int modifiers) {
        if (OperatingSystem.isMacOS()) {
            if ((modifiers & 0x10) != 0) {
                return (modifiers & 2) != 0;
            }
            if (!OperatingSystem.hasJava14()) {
                return (modifiers & 8) != 0;
            }
            return (modifiers & 4) != 0;
        }
        return (modifiers & 4) != 0;
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y) {
        GUIUtilities.showPopupMenu(popup, comp, x, y, true);
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y, boolean point) {
        Component win;
        int offsetX = 0;
        int offsetY = 0;
        int extraOffset = point ? 1 : 0;
        for (win = comp; !(win instanceof Window) && win != null; win = win.getParent()) {
            offsetX += win.getX();
            offsetY += win.getY();
        }
        if (win != null) {
            Dimension size = popup.getPreferredSize();
            Rectangle screenSize = win.getGraphicsConfiguration().getBounds();
            x = x + offsetX + size.width + win.getX() > screenSize.width && x + offsetX + win.getX() >= size.width ? (point ? (x -= size.width + extraOffset) : win.getWidth() - size.width - offsetX + extraOffset) : (x += extraOffset);
            y = y + offsetY + size.height + win.getY() > screenSize.height && y + offsetY + win.getY() >= size.height ? (point ? win.getHeight() - size.height - offsetY + extraOffset : -size.height - 1) : (y += extraOffset);
            popup.show(comp, x, y);
        } else {
            popup.show(comp, x + extraOffset, y + extraOffset);
        }
    }

    public static boolean isAncestorOf(Component comp1, Component comp2) {
        while (comp2 != null) {
            if (comp1 == comp2) {
                return true;
            }
            comp2 = comp2.getParent();
        }
        return false;
    }

    public static JDialog getParentDialog(Component c) {
        Container p;
        for (p = c.getParent(); p != null && !(p instanceof JDialog); p = p.getParent()) {
        }
        return p instanceof JDialog ? (JDialog)p : null;
    }

    public static Component getComponentParent(Component comp, Class clazz) {
        while (comp != null) {
            Component real;
            if (comp instanceof JComponent && (real = (Component)((JComponent)comp).getClientProperty("KORTE_REAL_FRAME")) != null) {
                comp = real;
            }
            if (comp.getClass().equals(clazz)) {
                return comp;
            }
            if (comp instanceof JPopupMenu) {
                comp = ((JPopupMenu)comp).getInvoker();
                continue;
            }
            if (comp instanceof FloatingWindowContainer) {
                comp = ((FloatingWindowContainer)comp).getDockableWindowManager();
                continue;
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static View getView(Component comp) {
        return (View)GUIUtilities.getComponentParent(comp, class$org$gjt$sp$jedit$View == null ? (class$org$gjt$sp$jedit$View = GUIUtilities.class$("org.gjt.sp.jedit.View")) : class$org$gjt$sp$jedit$View);
    }

    static void init() {
        NEW_BUFFER_ICON = GUIUtilities.loadIcon("new.gif");
        DIRTY_BUFFER_ICON = GUIUtilities.loadIcon("dirty.gif");
        READ_ONLY_BUFFER_ICON = GUIUtilities.loadIcon("readonly.gif");
        NORMAL_BUFFER_ICON = GUIUtilities.loadIcon("normal.gif");
        WINDOW_ICON = GUIUtilities.loadIcon("jedit-icon.gif");
    }

    static void showSplashScreen() {
        splash = new SplashScreen();
    }

    static void advanceSplashProgress() {
        if (splash != null) {
            splash.advance();
        }
    }

    private GUIUtilities() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        iconPath = "jeditresource:/org/gjt/sp/jedit/icons/";
        defaultIconPath = "jeditresource:/org/gjt/sp/jedit/icons/";
    }

    static class UnixWorkaround {
        Window win;
        String name;
        Rectangle desired;
        Rectangle required;
        long start;
        boolean windowOpened;

        UnixWorkaround(Window win, String name, Rectangle desired, int extState) {
            this.win = win;
            this.name = name;
            this.desired = desired;
            int adjust_x = jEdit.getIntegerProperty(name + ".dx", 0);
            int adjust_y = jEdit.getIntegerProperty(name + ".dy", 0);
            int adjust_width = jEdit.getIntegerProperty(name + ".d-width", 0);
            int adjust_height = jEdit.getIntegerProperty(name + ".d-height", 0);
            this.required = new Rectangle(desired.x - adjust_x, desired.y - adjust_y, desired.width - adjust_width, desired.height - adjust_height);
            Log.log(1, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, "Window " + name + ": desired geometry is " + desired);
            Log.log(1, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, "Window " + name + ": setting geometry to " + this.required);
            this.start = System.currentTimeMillis();
            win.setBounds(this.required);
            if (win instanceof Frame) {
                GUIUtilities.setExtendedState((Frame)win, extState);
            }
            win.addComponentListener(new ComponentHandler());
            win.addWindowListener(new WindowHandler());
        }

        class WindowHandler
        extends WindowAdapter {
            WindowHandler() {
            }

            public void windowOpened(WindowEvent evt) {
                UnixWorkaround.this.windowOpened = true;
                Rectangle r = UnixWorkaround.this.win.getBounds();
                Log.log(1, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, "Window " + UnixWorkaround.this.name + ": bounds after opening: " + r);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dx", r.x - UnixWorkaround.this.required.x);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dy", r.y - UnixWorkaround.this.required.y);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-width", r.width - UnixWorkaround.this.required.width);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-height", r.height - UnixWorkaround.this.required.height);
                UnixWorkaround.this.win.removeWindowListener(this);
            }
        }

        class ComponentHandler
        extends ComponentAdapter {
            ComponentHandler() {
            }

            public void componentMoved(ComponentEvent evt) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle r = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && r.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!r.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }

            public void componentResized(ComponentEvent evt) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle r = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && r.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!r.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, class$org$gjt$sp$jedit$GUIUtilities == null ? (class$org$gjt$sp$jedit$GUIUtilities = GUIUtilities.class$("org.gjt.sp.jedit.GUIUtilities")) : class$org$gjt$sp$jedit$GUIUtilities, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }
        }
    }
}

