/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferSwitcher;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class Java14 {
    static /* synthetic */ Class class$org$gjt$sp$jedit$Java14;
    static /* synthetic */ Class class$org$gjt$sp$jedit$textarea$JEditTextArea;
    static /* synthetic */ Class class$java$awt$event$InputEvent;
    static /* synthetic */ Class class$org$gjt$sp$jedit$EditPane;

    public static void init() {
        JFrame.setDefaultLookAndFeelDecorated(jEdit.getBooleanProperty("decorate.frames"));
        JDialog.setDefaultLookAndFeelDecorated(jEdit.getBooleanProperty("decorate.dialogs"));
        KeyboardFocusManager.setCurrentKeyboardFocusManager(new MyFocusManager());
        EditBus.addToBus(new EBComponent(){

            public void handleMessage(EBMessage msg) {
                EditPaneUpdate eu;
                if (msg instanceof ViewUpdate) {
                    ViewUpdate vu = (ViewUpdate)msg;
                    if (vu.getWhat() == ViewUpdate.CREATED) {
                        vu.getView().setFocusTraversalPolicy(new MyFocusTraversalPolicy());
                    }
                } else if (msg instanceof EditPaneUpdate && (eu = (EditPaneUpdate)msg).getWhat() == EditPaneUpdate.CREATED) {
                    Java14.initTextArea(eu.getEditPane().getTextArea());
                }
            }
        });
        Clipboard selection = Toolkit.getDefaultToolkit().getSystemSelection();
        if (selection != null) {
            Log.log(1, class$org$gjt$sp$jedit$Java14 == null ? (class$org$gjt$sp$jedit$Java14 = Java14.class$("org.gjt.sp.jedit.Java14")) : class$org$gjt$sp$jedit$Java14, "Setting % register to system selection");
            Registers.setRegister('%', new Registers.ClipboardRegister(selection));
        }
    }

    public static void dragAndDropCallback(JEditTextArea textArea, InputEvent evt, boolean copy) {
        Log.log(1, class$org$gjt$sp$jedit$Java14 == null ? (class$org$gjt$sp$jedit$Java14 = Java14.class$("org.gjt.sp.jedit.Java14")) : class$org$gjt$sp$jedit$Java14, "Drag and drop callback");
        TransferHandler handler = textArea.getTransferHandler();
        handler.exportAsDrag(textArea, evt, copy ? 1 : 2);
    }

    static void initTextArea(JEditTextArea textArea) {
        textArea.addMouseWheelListener(new MouseWheelHandler());
        textArea.setTransferHandler(new TextAreaTransferHandler());
        try {
            textArea.getDropTarget().addDropTargetListener(new DropHandler(textArea));
            textArea.setDragAndDropCallback((class$org$gjt$sp$jedit$Java14 == null ? (class$org$gjt$sp$jedit$Java14 = Java14.class$("org.gjt.sp.jedit.Java14")) : class$org$gjt$sp$jedit$Java14).getMethod("dragAndDropCallback", class$org$gjt$sp$jedit$textarea$JEditTextArea == null ? (class$org$gjt$sp$jedit$textarea$JEditTextArea = Java14.class$("org.gjt.sp.jedit.textarea.JEditTextArea")) : class$org$gjt$sp$jedit$textarea$JEditTextArea, class$java$awt$event$InputEvent == null ? (class$java$awt$event$InputEvent = Java14.class$("java.awt.event.InputEvent")) : class$java$awt$event$InputEvent, Boolean.TYPE));
        }
        catch (Exception e) {
            Log.log(9, class$org$gjt$sp$jedit$Java14 == null ? (class$org$gjt$sp$jedit$Java14 = Java14.class$("org.gjt.sp.jedit.Java14")) : class$org$gjt$sp$jedit$Java14, e);
        }
    }

    public static void initBufferSwitcher(final EditPane pane, BufferSwitcher switcher) {
        switcher.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                pane.getTextArea().requestFocus();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                pane.getTextArea().requestFocus();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TextAreaSelection
    extends StringSelection {
        JEditTextArea textArea;

        TextAreaSelection(JEditTextArea textArea) {
            super(textArea.getSelectedText());
            this.textArea = textArea;
        }
    }

    static class DropHandler
    extends DropTargetAdapter {
        JEditTextArea textArea;
        Buffer savedBuffer;
        int savedCaret;

        DropHandler(JEditTextArea textArea) {
            this.textArea = textArea;
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            Log.log(1, this, "Drag enter");
            this.savedBuffer = this.textArea.getBuffer();
            this.textArea.setDragInProgress(true);
            this.savedCaret = this.textArea.getCaretPosition();
        }

        public void dragOver(DropTargetDragEvent dtde) {
            Point p = dtde.getLocation();
            p = SwingUtilities.convertPoint(this.textArea, p, this.textArea.getPainter());
            int pos = this.textArea.xyToOffset(p.x, p.y, !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
            if (pos != -1) {
                this.textArea.moveCaretPosition(pos, JEditTextArea.ELECTRIC_SCROLL);
            }
        }

        public void dragExit(DropTargetEvent dtde) {
            Log.log(1, this, "Drag exit");
            this.textArea.setDragInProgress(false);
            if (this.textArea.getBuffer() == this.savedBuffer) {
                this.textArea.moveCaretPosition(this.savedCaret, JEditTextArea.ELECTRIC_SCROLL);
            }
            this.savedBuffer = null;
        }

        public void drop(DropTargetDropEvent dtde) {
            Log.log(1, this, "Drop");
            this.textArea.setDragInProgress(false);
        }
    }

    static class TextAreaTransferHandler
    extends TransferHandler {
        private static JEditTextArea dragSource;
        private static boolean compoundEdit;

        TextAreaTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            Log.log(1, this, "createTransferable()");
            JEditTextArea textArea = (JEditTextArea)c;
            if (textArea.getSelectionCount() == 0) {
                return null;
            }
            dragSource = textArea;
            return new TextAreaSelection(textArea);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        public boolean importData(JComponent c, Transferable t) {
            boolean returnValue;
            Log.log(1, this, "Import data");
            if (!this.canImport(c, t.getTransferDataFlavors())) {
                return false;
            }
            try {
                returnValue = t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) ? this.importFile(c, t) : this.importText(c, t);
            }
            catch (Exception e) {
                Log.log(9, this, e);
                returnValue = false;
            }
            GUIUtilities.getView(c).toFront();
            GUIUtilities.getView(c).requestFocus();
            c.requestFocus();
            return returnValue;
        }

        private boolean importFile(JComponent c, Transferable t) throws Exception {
            Log.log(1, this, "=> File list");
            EditPane editPane = (EditPane)GUIUtilities.getComponentParent(c, class$org$gjt$sp$jedit$EditPane == null ? (class$org$gjt$sp$jedit$EditPane = Java14.class$("org.gjt.sp.jedit.EditPane")) : class$org$gjt$sp$jedit$EditPane);
            Buffer buffer = null;
            Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
            Iterator iterator = ((List)data).iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                Buffer _buffer = jEdit.openFile(null, file.getPath());
                if (_buffer == null) continue;
                buffer = _buffer;
            }
            if (buffer != null) {
                editPane.setBuffer(buffer);
            }
            editPane.getView().toFront();
            editPane.getView().requestFocus();
            editPane.requestFocus();
            return true;
        }

        private boolean importText(JComponent c, Transferable t) throws Exception {
            int caret;
            Selection s;
            Log.log(1, this, "=> String");
            String str = (String)t.getTransferData(DataFlavor.stringFlavor);
            JEditTextArea textArea = (JEditTextArea)c;
            if (dragSource != null && textArea.getBuffer() == dragSource.getBuffer()) {
                compoundEdit = true;
                textArea.getBuffer().beginCompoundEdit();
            }
            if ((s = textArea.getSelectionAtOffset(caret = textArea.getCaretPosition())) != null) {
                if (textArea == dragSource) {
                    return false;
                }
                textArea.setSelectedText(s, str);
            } else {
                textArea.getBuffer().insert(caret, str);
            }
            textArea.scrollToCaret(true);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exportDone(JComponent c, Transferable t, int action) {
            Log.log(1, this, "Export done");
            JEditTextArea textArea = (JEditTextArea)c;
            try {
                if (t == null) {
                    Log.log(1, this, "=> Null transferrable");
                    textArea.selectNone();
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Log.log(1, this, "=> String");
                    if (action == 2) {
                        textArea.setSelectedText(null, false);
                    } else {
                        textArea.selectNone();
                    }
                }
                Object var6_5 = null;
                if (compoundEdit) {
                    compoundEdit = false;
                    textArea.getBuffer().endCompoundEdit();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (compoundEdit) {
                    compoundEdit = false;
                    textArea.getBuffer().endCompoundEdit();
                }
                throw throwable;
            }
            dragSource = null;
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            JEditTextArea textArea = (JEditTextArea)c;
            boolean returnValue = false;
            for (int i = 0; i < flavors.length; ++i) {
                if (flavors[i].equals(DataFlavor.javaFileListFlavor)) {
                    returnValue = true;
                    continue;
                }
                if (!flavors[i].equals(DataFlavor.stringFlavor) || !textArea.isEditable()) continue;
                returnValue = true;
            }
            Log.log(1, this, "canImport() returning " + returnValue);
            return returnValue;
        }
    }

    static class MouseWheelHandler
    implements MouseWheelListener {
        MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            JEditTextArea textArea = (JEditTextArea)e.getSource();
            if (e.isAltDown()) {
                this.moveCaret(textArea, e.getWheelRotation(), e.isShiftDown() || e.isControlDown());
            } else if (e.isShiftDown()) {
                this.scrollPage(textArea, e.getWheelRotation());
            } else if (e.isControlDown()) {
                this.scrollLine(textArea, e.getWheelRotation());
            } else if (e.getScrollType() == 0) {
                this.scrollLine(textArea, e.getUnitsToScroll());
            } else {
                this.scrollLine(textArea, 3 * e.getWheelRotation());
            }
        }

        private void scrollLine(JEditTextArea textArea, int amt) {
            textArea.setFirstLine(textArea.getFirstLine() + amt);
        }

        private void scrollPage(JEditTextArea textArea, int amt) {
            if (amt > 0) {
                textArea.scrollDownPage();
            } else {
                textArea.scrollUpPage();
            }
        }

        private void moveCaret(JEditTextArea textArea, int amt, boolean select) {
            if (amt < 0) {
                textArea.goToPrevLine(select);
            } else {
                textArea.goToNextLine(select);
            }
        }
    }

    static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        MyFocusTraversalPolicy() {
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return GUIUtilities.getView(focusCycleRoot).getTextArea();
        }
    }

    static class MyFocusManager
    extends DefaultKeyboardFocusManager {
        MyFocusManager() {
            this.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }

        public boolean postProcessKeyEvent(KeyEvent evt) {
            if (!evt.isConsumed()) {
                Component comp = (Component)evt.getSource();
                if (!comp.isShowing()) {
                    return true;
                }
                while (true) {
                    if (comp instanceof View) {
                        ((View)comp).processKeyEvent(evt, 0);
                        return true;
                    }
                    if (comp == null || comp instanceof Window || comp instanceof JEditTextArea) break;
                    comp = comp.getParent();
                }
            }
            return super.postProcessKeyEvent(evt);
        }
    }
}

