/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.util.Hashtable;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;

public class Mode {
    private String name;
    private Hashtable props;
    private RE firstlineRE;
    private RE filenameRE;
    private TokenMarker marker;

    public Mode(String name) {
        this.name = name;
        this.props = new Hashtable();
    }

    public void init() {
        try {
            String firstlineGlob;
            String filenameGlob = (String)this.getProperty("filenameGlob");
            if (filenameGlob != null && filenameGlob.length() != 0) {
                this.filenameRE = new RE(MiscUtilities.globToRE(filenameGlob), 2);
            }
            if ((firstlineGlob = (String)this.getProperty("firstlineGlob")) != null && firstlineGlob.length() != 0) {
                this.firstlineRE = new RE(MiscUtilities.globToRE(firstlineGlob), 2);
            }
        }
        catch (REException re) {
            Log.log(9, this, "Invalid filename/firstline globs in mode " + this.name);
            Log.log(9, this, re);
        }
        this.marker = null;
    }

    public TokenMarker getTokenMarker() {
        this.loadIfNecessary();
        return this.marker;
    }

    public void setTokenMarker(TokenMarker marker) {
        this.marker = marker;
    }

    public void loadIfNecessary() {
        if (this.marker == null) {
            jEdit.loadMode(this);
        }
    }

    public Object getProperty(String key) {
        String prefix = "mode." + this.name + ".";
        String property = jEdit.getProperty(prefix + key);
        if (property != null) {
            Object value;
            try {
                value = new Integer(property);
            }
            catch (NumberFormatException nf) {
                value = property;
            }
            return value;
        }
        Object value = this.props.get(key);
        if (value != null) {
            return value;
        }
        String global = jEdit.getProperty("buffer." + key);
        if (global != null) {
            try {
                return new Integer(global);
            }
            catch (NumberFormatException nf) {
                return global;
            }
        }
        return null;
    }

    public boolean getBooleanProperty(String key) {
        Object value = this.getProperty(key);
        return "true".equals(value) || "on".equals(value) || "yes".equals(value);
    }

    public void setProperty(String key, Object value) {
        this.props.put(key, value);
    }

    public void unsetProperty(String key) {
        this.props.remove(key);
    }

    public void setProperties(Hashtable props) {
        if (props == null) {
            props = new Hashtable<String, String>();
        }
        String filenameGlob = (String)this.props.get("filenameGlob");
        String firstlineGlob = (String)this.props.get("firstlineGlob");
        String filename = (String)this.props.get("file");
        this.props = props;
        if (filenameGlob != null) {
            props.put("filenameGlob", filenameGlob);
        }
        if (firstlineGlob != null) {
            props.put("firstlineGlob", firstlineGlob);
        }
        if (filename != null) {
            props.put("file", filename);
        }
    }

    public boolean accept(String fileName, String firstLine) {
        if (this.filenameRE != null && this.filenameRE.isMatch(fileName)) {
            return true;
        }
        return this.firstlineRE != null && this.firstlineRE.isMatch(firstLine);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

