/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.gui.ToolBarManager;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchBar;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.util.Log;

public class View
extends JFrame
implements EBComponent {
    public static final int TOP_GROUP = 0;
    public static final int BOTTOM_GROUP = 1;
    public static final int DEFAULT_GROUP = 0;
    public static final int TOP_LAYER = Integer.MAX_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int BOTTOM_LAYER = Integer.MIN_VALUE;
    public static final int ABOVE_SYSTEM_BAR_LAYER = 150;
    public static final int SYSTEM_BAR_LAYER = 100;
    public static final int BELOW_SYSTEM_BAR_LAYER = 75;
    public static final int SEARCH_BAR_LAYER = 75;
    public static final int BELOW_SEARCH_BAR_LAYER = 50;
    public static final int ABOVE_ACTION_BAR_LAYER = -50;
    public static final int ACTION_BAR_LAYER = -75;
    public static final int STATUS_BAR_LAYER = -100;
    public static final int BELOW_STATUS_BAR_LAYER = -150;
    public static final int VIEW = 0;
    public static final int TEXT_AREA = 1;
    public static final int ACTION_BAR = 2;
    View prev;
    View next;
    private boolean closed;
    private DockableWindowManager dockableWindowManager;
    private JPanel topToolBars;
    private JPanel bottomToolBars;
    private ToolBarManager toolBarManager;
    private Box toolBar;
    private SearchBar searchBar;
    private ActionBar actionBar;
    private EditPane editPane;
    private JSplitPane splitPane;
    private StatusBar status;
    private KeyListener keyEventInterceptor;
    private InputHandler inputHandler;
    private Macros.Recorder recorder;
    private Component prefixFocusOwner;
    private int waitCount;
    private boolean showFullPath;
    private boolean plainView;
    private Socket waitSocket;

    public DockableWindowManager getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public Box getToolBar() {
        return this.toolBar;
    }

    public void addToolBar(Component toolBar) {
        this.addToolBar(0, 0, toolBar);
    }

    public void addToolBar(int group, Component toolBar) {
        this.addToolBar(group, 0, toolBar);
    }

    public void addToolBar(int group, int layer, Component toolBar) {
        this.toolBarManager.addToolBar(group, layer, toolBar);
        this.getRootPane().revalidate();
    }

    public void removeToolBar(Component toolBar) {
        this.toolBarManager.removeToolBar(toolBar);
        this.getRootPane().revalidate();
    }

    public synchronized void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane editPane = editPanes[i];
                editPane.getTextArea().getPainter().setCursor(cursor);
            }
        }
    }

    public synchronized void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            cursor = Cursor.getPredefinedCursor(2);
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane editPane = editPanes[i];
                editPane.getTextArea().getPainter().setCursor(cursor);
            }
        }
    }

    public final SearchBar getSearchBar() {
        return this.searchBar;
    }

    public final ActionBar getActionBar() {
        return this.actionBar;
    }

    public StatusBar getStatus() {
        return this.status;
    }

    public void quickIncrementalSearch(boolean word) {
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(false);
        JEditTextArea textArea = this.getTextArea();
        if (word) {
            String text = textArea.getSelectedText();
            if (text == null) {
                textArea.selectWord();
                text = textArea.getSelectedText();
            } else if (text.indexOf(10) != -1) {
                text = null;
            }
            this.searchBar.getField().setText(text);
        }
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void quickHyperSearch(boolean word) {
        JEditTextArea textArea = this.getTextArea();
        if (word) {
            String text = textArea.getSelectedText();
            if (text == null) {
                textArea.selectWord();
                text = textArea.getSelectedText();
            }
            if (text != null && text.indexOf(10) == -1) {
                HistoryModel.getModel("find").addItem(text);
                SearchAndReplace.setSearchString(text);
                SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
                SearchAndReplace.hyperSearch(this);
                return;
            }
        }
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(true);
        this.searchBar.getField().setText(null);
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void actionBar() {
        if (this.actionBar == null) {
            this.actionBar = new ActionBar(this, true);
        }
        if (this.actionBar.getParent() == null) {
            this.addToolBar(1, -75, this.actionBar);
        }
        this.actionBar.goToActionBar();
    }

    public KeyListener getKeyEventInterceptor() {
        return this.keyEventInterceptor;
    }

    public void setKeyEventInterceptor(KeyListener listener) {
        this.keyEventInterceptor = listener;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public Macros.Recorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(Macros.Recorder recorder) {
        this.recorder = recorder;
    }

    public void processKeyEvent(KeyEvent evt) {
        this.processKeyEvent(evt, 0);
    }

    public void processKeyEvent(KeyEvent evt, boolean calledFromTextArea) {
        this.processKeyEvent(evt, calledFromTextArea ? 1 : 0);
    }

    public void processKeyEvent(KeyEvent evt, int from) {
        if (Debug.DUMP_KEY_EVENTS && from != 0) {
            Log.log(1, this, "Key event: " + GrabKeyDialog.toString(evt));
        }
        if (this.getTextArea().hasFocus() && from == 0) {
            return;
        }
        if ((evt = this._preprocessKeyEvent(evt)) == null) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS && from != 0) {
            Log.log(1, this, "Key event after workaround: " + GrabKeyDialog.toString(evt));
        }
        switch (evt.getID()) {
            case 400: {
                KeyEventTranslator.Key keyStroke;
                boolean focusOnTextArea = false;
                if (this.prefixFocusOwner != null && this.prefixFocusOwner.isShowing()) {
                    this.prefixFocusOwner.requestFocus();
                    focusOnTextArea = true;
                }
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyTyped(evt);
                } else if ((from == 2 || this.inputHandler.isPrefixActive() || this.getTextArea().hasFocus()) && (keyStroke = KeyEventTranslator.translateKeyEvent(evt)) != null) {
                    if (Debug.DUMP_KEY_EVENTS && from != 0) {
                        Log.log(1, this, "Translated: " + keyStroke);
                    }
                    if (this.inputHandler.handleKey(keyStroke)) {
                        evt.consume();
                    }
                }
                if (this.isClosed()) {
                    return;
                }
                if (this.inputHandler.isPrefixActive()) {
                    if (this.getFocusOwner() instanceof JTextComponent) {
                        this.prefixFocusOwner = this.getFocusOwner();
                        this.getTextArea().requestFocus();
                        break;
                    }
                    if (focusOnTextArea) {
                        this.getTextArea().requestFocus();
                        break;
                    }
                    this.prefixFocusOwner = null;
                    break;
                }
                this.prefixFocusOwner = null;
                break;
            }
            case 401: {
                KeyEventTranslator.Key keyStroke;
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyPressed(evt);
                    break;
                }
                boolean focusOnTextArea = false;
                if (this.prefixFocusOwner != null) {
                    if (this.prefixFocusOwner.isShowing()) {
                        this.prefixFocusOwner.requestFocus();
                        focusOnTextArea = true;
                    }
                    this.prefixFocusOwner = null;
                }
                if ((keyStroke = KeyEventTranslator.translateKeyEvent(evt)) != null) {
                    if (Debug.DUMP_KEY_EVENTS && from != 0) {
                        Log.log(1, this, "Translated: " + keyStroke);
                    }
                    if (this.inputHandler.handleKey(keyStroke)) {
                        evt.consume();
                    }
                }
                if (this.isClosed()) {
                    return;
                }
                if (this.inputHandler.isPrefixActive()) {
                    if (this.getFocusOwner() instanceof JTextComponent) {
                        this.prefixFocusOwner = this.getFocusOwner();
                        this.getTextArea().requestFocus();
                        break;
                    }
                    if (focusOnTextArea) {
                        this.getTextArea().requestFocus();
                        break;
                    }
                    this.prefixFocusOwner = null;
                    break;
                }
                this.prefixFocusOwner = null;
                break;
            }
            case 402: {
                if (this.keyEventInterceptor == null) break;
                this.keyEventInterceptor.keyReleased(evt);
            }
        }
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public EditPane splitHorizontally() {
        return this.split(0);
    }

    public EditPane splitVertically() {
        return this.split(1);
    }

    public EditPane split(int orientation) {
        PerspectiveManager.setPerspectiveDirty(true);
        this.editPane.saveCaretInfo();
        EditPane oldEditPane = this.editPane;
        this.setEditPane(this.createEditPane(oldEditPane.getBuffer()));
        this.editPane.loadCaretInfo();
        JComponent oldParent = (JComponent)oldEditPane.getParent();
        final JSplitPane newSplitPane = new JSplitPane(orientation);
        newSplitPane.setOneTouchExpandable(true);
        newSplitPane.setBorder(null);
        newSplitPane.setMinimumSize(new Dimension(0, 0));
        int parentSize = orientation == 0 ? oldEditPane.getHeight() : oldEditPane.getWidth();
        final int dividerPosition = (int)((double)(parentSize - newSplitPane.getDividerSize()) * 0.5);
        newSplitPane.setDividerLocation(dividerPosition);
        if (oldParent instanceof JSplitPane) {
            JSplitPane oldSplitPane = (JSplitPane)oldParent;
            int dividerPos = oldSplitPane.getDividerLocation();
            Component left = oldSplitPane.getLeftComponent();
            if (left == oldEditPane) {
                oldSplitPane.setLeftComponent(newSplitPane);
            } else {
                oldSplitPane.setRightComponent(newSplitPane);
            }
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(this.editPane);
            oldSplitPane.setDividerLocation(dividerPos);
        } else {
            this.splitPane = newSplitPane;
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(this.editPane);
            oldParent.add((Component)newSplitPane, 0);
            oldParent.revalidate();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                newSplitPane.setDividerLocation(dividerPosition);
            }
        });
        this.editPane.focusOnTextArea();
        return this.editPane;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            PerspectiveManager.setPerspectiveDirty(true);
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane _editPane = editPanes[i];
                if (this.editPane == _editPane) continue;
                _editPane.close();
            }
            JComponent parent = (JComponent)this.splitPane.getParent();
            parent.remove(this.splitPane);
            parent.add((Component)this.editPane, 0);
            parent.revalidate();
            this.splitPane = null;
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            PerspectiveManager.setPerspectiveDirty(true);
            Container comp = this.editPane;
            while (!(comp instanceof JSplitPane)) {
                comp = comp.getParent();
            }
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane _editPane = editPanes[i];
                if (!GUIUtilities.isAncestorOf(comp, _editPane) || _editPane == this.editPane) continue;
                _editPane.close();
            }
            JComponent parent = (JComponent)comp.getParent();
            if (parent instanceof JSplitPane) {
                JSplitPane parentSplit = (JSplitPane)parent;
                int pos = parentSplit.getDividerLocation();
                if (parentSplit.getLeftComponent() == comp) {
                    parentSplit.setLeftComponent(this.editPane);
                } else {
                    parentSplit.setRightComponent(this.editPane);
                }
                parentSplit.setDividerLocation(pos);
            } else {
                parent.remove(comp);
                parent.add((Component)this.editPane, 0);
                this.splitPane = null;
            }
            parent.revalidate();
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void nextTextArea() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            if (this.editPane != editPanes[i]) continue;
            if (i == editPanes.length - 1) {
                editPanes[0].focusOnTextArea();
                break;
            }
            editPanes[i + 1].focusOnTextArea();
            break;
        }
    }

    public void prevTextArea() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            if (this.editPane != editPanes[i]) continue;
            if (i == 0) {
                editPanes[editPanes.length - 1].focusOnTextArea();
                break;
            }
            editPanes[i - 1].focusOnTextArea();
            break;
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public Buffer getBuffer() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getBuffer();
    }

    public void setBuffer(Buffer buffer) {
        this.editPane.setBuffer(buffer);
    }

    public EditPane goToBuffer(Buffer buffer) {
        if (this.editPane.getBuffer() == buffer) {
            this.editPane.focusOnTextArea();
            return this.editPane;
        }
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            EditPane ep = editPanes[i];
            if (ep.getBuffer() != buffer || ep.getTextArea().getVisibleLines() <= 1) continue;
            this.setEditPane(ep);
            ep.focusOnTextArea();
            return ep;
        }
        this.setBuffer(buffer);
        return this.editPane;
    }

    public JEditTextArea getTextArea() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getTextArea();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    public EditPane[] getEditPanes() {
        if (this.splitPane == null) {
            EditPane[] ep = new EditPane[]{this.editPane};
            return ep;
        }
        Vector vec = new Vector();
        this.getEditPanes(vec, this.splitPane);
        Object[] ep = new EditPane[vec.size()];
        vec.copyInto(ep);
        return ep;
    }

    public ViewConfig getViewConfig() {
        StringBuffer splitConfig = new StringBuffer();
        if (this.splitPane != null) {
            this.getSplitConfig(this.splitPane, splitConfig);
        } else {
            splitConfig.append('\"');
            splitConfig.append(MiscUtilities.charsToEscapes(this.getBuffer().getPath()));
            splitConfig.append("\" buffer");
        }
        ViewConfig config = new ViewConfig();
        config.plainView = this.isPlainView();
        config.splitConfig = splitConfig.toString();
        config.x = this.getX();
        config.y = this.getY();
        config.width = this.getWidth();
        config.height = this.getHeight();
        config.extState = GUIUtilities.getExtendedState(this);
        config.top = this.dockableWindowManager.getTopDockingArea().getCurrent();
        config.left = this.dockableWindowManager.getLeftDockingArea().getCurrent();
        config.bottom = this.dockableWindowManager.getBottomDockingArea().getCurrent();
        config.right = this.dockableWindowManager.getRightDockingArea().getCurrent();
        config.topPos = this.dockableWindowManager.getTopDockingArea().getDimension();
        config.leftPos = this.dockableWindowManager.getLeftDockingArea().getDimension();
        config.bottomPos = this.dockableWindowManager.getBottomDockingArea().getDimension();
        config.rightPos = this.dockableWindowManager.getRightDockingArea().getDimension();
        return config;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPlainView() {
        return this.plainView;
    }

    public View getNext() {
        return this.next;
    }

    public View getPrev() {
        return this.prev;
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (msg instanceof SearchSettingsChanged) {
            if (this.searchBar != null) {
                this.searchBar.update();
            }
        } else if (msg instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)msg);
        } else if (msg instanceof EditPaneUpdate) {
            this.handleEditPaneUpdate((EditPaneUpdate)msg);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setWaitSocket(Socket waitSocket) {
        this.waitSocket = waitSocket;
    }

    public String toString() {
        return this.getClass().getName() + "[" + (jEdit.getActiveView() == this ? "active" : "inactive") + "]";
    }

    View(Buffer buffer, ViewConfig config) {
        this.plainView = config.plainView;
        this.enableEvents(8L);
        this.setIconImage(GUIUtilities.getEditorIcon());
        this.dockableWindowManager = new DockableWindowManager(this, config);
        this.topToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.bottomToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.toolBarManager = new ToolBarManager(this.topToolBars, this.bottomToolBars);
        this.status = new StatusBar(this);
        this.inputHandler = new DefaultInputHandler(this, (DefaultInputHandler)jEdit.getInputHandler());
        try {
            Component comp = this.restoreSplitConfig(buffer, config.splitConfig);
            this.dockableWindowManager.add(comp, 0);
        }
        catch (IOException e) {
            throw new InternalError();
        }
        this.getContentPane().add("Center", this.dockableWindowManager);
        this.dockableWindowManager.init();
        this.propertiesChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        EditBus.addToBus(this);
        SearchDialog.preloadSearchDialog(this);
    }

    void close() {
        GUIUtilities.saveGeometry(this, this.plainView ? "plain-view" : "view");
        this.closed = true;
        this.dockableWindowManager.close();
        EditBus.removeFromBus(this);
        this.dispose();
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            editPanes[i].close();
        }
        this.toolBarManager = null;
        this.toolBar = null;
        this.searchBar = null;
        this.splitPane = null;
        this.inputHandler = null;
        this.recorder = null;
        this.getContentPane().removeAll();
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void updateTitle() {
        Vector<Buffer> buffers = new Vector<Buffer>();
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            Buffer buffer = editPanes[i].getBuffer();
            if (buffers.indexOf(buffer) != -1) continue;
            buffers.addElement(buffer);
        }
        StringBuffer title = new StringBuffer(jEdit.getProperty("view.title"));
        for (int i = 0; i < buffers.size(); ++i) {
            if (i != 0) {
                title.append(", ");
            }
            Buffer buffer = (Buffer)buffers.elementAt(i);
            title.append(this.showFullPath && !buffer.isNewFile() ? buffer.getPath() : buffer.getName());
            if (!buffer.isDirty()) continue;
            title.append(jEdit.getProperty("view.title.dirty"));
        }
        this.setTitle(title.toString());
    }

    private void getEditPanes(Vector vec, Component comp) {
        if (comp instanceof EditPane) {
            vec.addElement(comp);
        } else if (comp instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)comp;
            this.getEditPanes(vec, split.getLeftComponent());
            this.getEditPanes(vec, split.getRightComponent());
        }
    }

    private void getSplitConfig(JSplitPane splitPane, StringBuffer splitConfig) {
        Component right = splitPane.getRightComponent();
        if (right instanceof JSplitPane) {
            this.getSplitConfig((JSplitPane)right, splitConfig);
        } else {
            splitConfig.append('\"');
            splitConfig.append(MiscUtilities.charsToEscapes(((EditPane)right).getBuffer().getPath()));
            splitConfig.append("\" buffer");
        }
        splitConfig.append(' ');
        Component left = splitPane.getLeftComponent();
        if (left instanceof JSplitPane) {
            this.getSplitConfig((JSplitPane)left, splitConfig);
        } else {
            splitConfig.append('\"');
            splitConfig.append(MiscUtilities.charsToEscapes(((EditPane)left).getBuffer().getPath()));
            splitConfig.append("\" buffer");
        }
        splitConfig.append(' ');
        splitConfig.append(splitPane.getDividerLocation());
        splitConfig.append(' ');
        splitConfig.append(splitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Component restoreSplitConfig(Buffer buffer, String splitConfig) throws IOException {
        if (buffer != null) {
            this.editPane = this.createEditPane(buffer);
            return this.editPane;
        }
        if (splitConfig == null) {
            this.editPane = this.createEditPane(jEdit.getFirstBuffer());
            return this.editPane;
        }
        Buffer[] buffers = jEdit.getBuffers();
        Stack<Object> stack = new Stack<Object>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(splitConfig));
        st.whitespaceChars(0, 32);
        st.wordChars(35, 126);
        st.commentChar(33);
        st.quoteChar(34);
        st.eolIsSignificant(false);
        block6: while (true) {
            switch (st.nextToken()) {
                case -1: {
                    break block6;
                }
                case -3: {
                    if (st.sval.equals("vertical") || st.sval.equals("horizontal")) {
                        int orientation = st.sval.equals("vertical") ? 0 : 1;
                        int divider = (Integer)stack.pop();
                        this.splitPane = new JSplitPane(orientation, (Component)stack.pop(), (Component)stack.pop());
                        stack.push(this.splitPane);
                        this.splitPane.setOneTouchExpandable(true);
                        this.splitPane.setBorder(null);
                        this.splitPane.setMinimumSize(new Dimension(0, 0));
                        this.splitPane.setDividerLocation(divider);
                        break;
                    }
                    if (!st.sval.equals("buffer")) break;
                    Object obj = stack.pop();
                    if (obj instanceof Integer) {
                        int index = (Integer)obj;
                        if (index >= 0 && index < buffers.length) {
                            buffer = buffers[index];
                        }
                    } else if (obj instanceof String) {
                        String path = (String)obj;
                        buffer = jEdit.getBuffer(path);
                    }
                    if (buffer == null) {
                        buffer = jEdit.getFirstBuffer();
                    }
                    this.editPane = this.createEditPane(buffer);
                    stack.push(this.editPane);
                    break;
                }
                case -2: {
                    stack.push(new Integer((int)st.nval));
                    break;
                }
                case 34: {
                    stack.push(st.sval);
                }
            }
        }
        this.updateGutterBorders();
        return (Component)stack.peek();
    }

    private void propertiesChanged() {
        this.setJMenuBar(GUIUtilities.loadMenuBar("view.mbar"));
        this.loadToolBars();
        this.showFullPath = jEdit.getBooleanProperty("view.showFullPath");
        this.updateTitle();
        this.status.propertiesChanged();
        this.removeToolBar(this.status);
        this.getContentPane().remove(this.status);
        if (jEdit.getBooleanProperty("view.toolbar.alternateLayout")) {
            this.getContentPane().add("North", this.topToolBars);
            this.getContentPane().add("South", this.bottomToolBars);
            if (!this.plainView && jEdit.getBooleanProperty("view.status.visible")) {
                this.addToolBar(1, -100, this.status);
            }
        } else {
            this.dockableWindowManager.add(this.topToolBars, "top-toolbars", 0);
            this.dockableWindowManager.add(this.bottomToolBars, "bottom-toolbars", 0);
            if (!this.plainView && jEdit.getBooleanProperty("view.status.visible")) {
                this.getContentPane().add("South", this.status);
            }
        }
        this.getRootPane().revalidate();
    }

    private void loadToolBars() {
        if (jEdit.getBooleanProperty("view.showToolbar") && !this.plainView) {
            if (this.toolBar != null) {
                this.toolBarManager.removeToolBar(this.toolBar);
            }
            this.toolBar = GUIUtilities.loadToolBar("view.toolbar");
            this.addToolBar(0, 100, this.toolBar);
        } else if (this.toolBar != null) {
            this.removeToolBar(this.toolBar);
            this.toolBar = null;
        }
        if (this.searchBar != null) {
            this.removeToolBar(this.searchBar);
        }
        if (jEdit.getBooleanProperty("view.showSearchbar") && !this.plainView) {
            if (this.searchBar == null) {
                this.searchBar = new SearchBar(this, false);
            }
            this.searchBar.propertiesChanged();
            this.addToolBar(0, 75, this.searchBar);
        }
    }

    private EditPane createEditPane(Buffer buffer) {
        EditPane editPane = new EditPane(this, buffer);
        JEditTextArea textArea = editPane.getTextArea();
        textArea.addFocusListener(new FocusHandler());
        textArea.addCaretListener(new CaretHandler());
        textArea.addScrollListener(new ScrollHandler());
        EditBus.send(new EditPaneUpdate(editPane, EditPaneUpdate.CREATED));
        return editPane;
    }

    private void setEditPane(EditPane editPane) {
        this.editPane = editPane;
        this.status.updateCaretStatus();
        this.status.updateBufferStatus();
        this.status.updateMiscStatus();
        this.updateGutterBorders();
        EditBus.send(new ViewUpdate(this, ViewUpdate.EDIT_PANE_CHANGED));
    }

    private void handleBufferUpdate(BufferUpdate msg) {
        Buffer buffer = msg.getBuffer();
        if (msg.getWhat() == BufferUpdate.DIRTY_CHANGED || msg.getWhat() == BufferUpdate.LOADED) {
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                if (editPanes[i].getBuffer() != buffer) continue;
                this.updateTitle();
                break;
            }
        }
    }

    private void handleEditPaneUpdate(EditPaneUpdate msg) {
        EditPane editPane = msg.getEditPane();
        if (editPane.getView() == this && msg.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane.getBuffer().isLoaded()) {
            this.status.updateCaretStatus();
            this.status.updateBufferStatus();
            this.status.updateMiscStatus();
        }
    }

    private void updateGutterBorders() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            editPanes[i].getTextArea().getGutter().updateBorder();
        }
    }

    private KeyEvent _preprocessKeyEvent(KeyEvent evt) {
        if (this.isClosed()) {
            return null;
        }
        if (this.getFocusOwner() instanceof JComponent) {
            Object binding;
            JComponent comp = (JComponent)this.getFocusOwner();
            InputMap map = comp.getInputMap();
            ActionMap am = comp.getActionMap();
            if (map != null && am != null && comp.isEnabled() && (binding = map.get(KeyStroke.getKeyStrokeForEvent(evt))) != null && am.get(binding) != null) {
                return null;
            }
        }
        if (this.getFocusOwner() instanceof JTextComponent && evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 8: 
                case 9: 
                case 10: 
                case 32: {
                    return null;
                }
            }
        }
        if (evt.isConsumed()) {
            return null;
        }
        return KeyEventWorkaround.processKeyEvent(evt);
    }

    public static class ViewConfig {
        public boolean plainView;
        public String splitConfig;
        public int x;
        public int y;
        public int width;
        public int height;
        public int extState;
        public String top;
        public String left;
        public String bottom;
        public String right;
        public int topPos;
        public int leftPos;
        public int bottomPos;
        public int rightPos;

        public ViewConfig() {
        }

        public ViewConfig(boolean plainView) {
            this.plainView = plainView;
            String prefix = plainView ? "plain-view" : "view";
            this.x = jEdit.getIntegerProperty(prefix + ".x", 0);
            this.y = jEdit.getIntegerProperty(prefix + ".y", 0);
            this.width = jEdit.getIntegerProperty(prefix + ".width", 0);
            this.height = jEdit.getIntegerProperty(prefix + ".height", 0);
        }

        public ViewConfig(boolean plainView, String splitConfig, int x, int y, int width, int height, int extState) {
            this.plainView = plainView;
            this.splitConfig = splitConfig;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.extState = extState;
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowActivated(WindowEvent evt) {
            jEdit.setActiveView(View.this);
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ WindowHandler this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    jEdit.checkBufferStatus(WindowHandler.access$400(this.this$1));
                }
            });
        }

        public void windowClosing(WindowEvent evt) {
            jEdit.closeView(View.this);
        }

        static /* synthetic */ View access$400(WindowHandler x0) {
            return x0.View.this;
        }
    }

    class ScrollHandler
    implements ScrollListener {
        ScrollHandler() {
        }

        public void scrolledVertically(JEditTextArea textArea) {
            if (View.this.getTextArea() == textArea) {
                View.this.status.updateCaretStatus();
            }
        }

        public void scrolledHorizontally(JEditTextArea textArea) {
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusGained(FocusEvent evt) {
            Component comp = (Component)evt.getSource();
            while (!(comp instanceof EditPane)) {
                if (comp == null) {
                    return;
                }
                comp = comp.getParent();
            }
            if (comp != View.this.editPane) {
                View.this.setEditPane((EditPane)comp);
            } else {
                View.this.updateGutterBorders();
            }
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        public void caretUpdate(CaretEvent evt) {
            if (evt.getSource() == View.this.getTextArea()) {
                View.this.status.updateCaretStatus();
            }
        }
    }
}

